$ovflcheck off$
$range off$
(*
     COMPARE -- Compare two text files.
 
     Copyright (C) 1988
          A. V. Le Blanc
          University of Manchester Regional Computer Centre
 
     COMPARE displays on OUTPUT the differences between two text files,
FILEA and FILEB.   It is also able to generate a set of UPDATEPL direc-
tives.  COMPARE was written to provide a compatible replacement for the
University of Minnesota's utility COMPARE written by James F. Miner.
 
     Modification History:
Version   Name      Programmer                    yy/mm/dd  Site
 
4.0       COMPARE   A. V. Le Blanc                88/05/03  UMRCC
   1.  COMPARE utility almost completely rewritten.
   2.  IBM UPDATE option completed.               88/05/06
   3.  CDC version CDCCMPU completed.             88/05/07
   4.  Prime version PRICMPU completed.           88/05/08
   5.  VM/CMS version CMSCMPU completed.          88/05/11
   6.  HP UNIX version HPUCMPU completed.         89/04/25
 
4.1       COMLASTN  A. V. Le Blanc                89/05/03  MCC
   1.  Inaccurate total length corrected.
   2.  Copyright changed from UMRCC to MCC.
 
                                                                     *)
 
PROGRAM compare (filea, fileb, output);
 
CONST
    compiled = '94/07/01';
  alfalength = 8;
   maxlength = 150;
    maxidnum = 65535;
    idlength = 8;
       blank = '        '          (* Idlength blanks *);
       nines = '99999999'          (* 8 nines; idlength string *);
       arrow = '$';
     optchar = '-';
      cssize = 160;
  defaultpad = 42;
  filenameln = 150;
      system = 'UNIX';
     version = '4.1';
 
TYPE
     command = PACKED ARRAY [1..cssize] OF char;
    filename = PACKED ARRAY [1..filenameln] OF char;
        alfa = PACKED ARRAY [1..alfalength] OF char;
          id = PACKED ARRAY [1..idlength] OF char;
 
      lineid = PACKED RECORD
                 name   : id;
                 number : 0..maxidnum
               END;
 
       linep = ^ line;
        line = PACKED RECORD
                 next   : linep;
                 length : 0..maxlength;
                 data   : PACKED ARRAY [1..maxlength] OF char;
                 ident  : lineid
               END;
 
VAR
     filea                         (* Older comparand file *),
     fileb                         (* Newer comparand file *),
      mods : text                  (* UPDATEPL modification file *);
    infile : ARRAY [boolean] OF RECORD
               name   : filename   (* Name of file *);
               nameln : 1..filenameln;
               pad    : 0..255     (* For proper alignment *);
               here                (* Current position in file *),
               former              (* Line before current run *),
               first               (* First line being examined *),
               last   : linep      (* Last line being examined *);
               hereno              (* Number of here in file *),
               firstno             (* Number of first *),
               lastno : integer    (* Number of last *);
               erst   : lineid     (* ID of previous line *);
               ended  : boolean    (* This file has terminated *)
             END;
       sid : alfa                  (* CMS update date code *);
    action : (update               (* Write UPDATEPL modification *),
              default              (* Compare and list differences *),
              pairs                (* Print lines in pairs and flag *),
              merge                (* Show additions and deletions *));
      free : linep                 (* List of unused lines *);
    digits : SET OF '0'..'9'       (* Avoids multiple set constants *);
  follower : id                    (* CMS identity of next line *);
      temp : ARRAY [0..maxlength] OF char    (* Temporary buffer *);
  templast                         (* Index temporary input line *),
      skip                         (* Blank lines before next data *),
pagelength                         (* Lines per page *),
  pagesize                         (* Minus lines left this page *),
 pagewidth                         (* Length of output lines *),
   pagepad                         (* Blanks in centre of header *),
      page                         (* Page number *),
 criterion                         (* Matching lines after mismatch *),
linelength : integer               (* Length of input lines *);
     today                         (* Current date *),
       now : alfa                  (* Current time *);
    longer                         (* Ends of lines were ignored *),
reportlong                         (* Print longer warning *),
      same                         (* Files are the same *),
     match                         (* Lines match at this point *),
   endboth                         (* Both files have ended *),
         b                         (* Local FOR variable *),
 ibmupdate                         (* Produce CMS update directives *),
blanklines                         (* Ignore blank lines in comp *),
markcolumn : boolean               (* Mark differing columns *);
 
 
IMPORT arg;
 
PROCEDURE datetime (VAR da, ti: alfa);
 
  TYPE dptr = ^ drecord;
    drecord = PACKED RECORD
                sec,min,hour,day,mon,year,wday,jday,dst : integer
              END;
 
  VAR c : char;
      i : integer;
      d : dptr;
 
$warn off$
FUNCTION $alias '_time'$ cctime (VAR t : integer) : integer;
  external;
FUNCTION localtime (VAR t : integer) : dptr; external;
$warn on$
 
  FUNCTION dig (i : integer) : char;
 
    BEGIN   (* dig *)
      c := chr (i DIV 10 + ord ('0'));
      dig := chr (i MOD 10 + ord ('0'))
    END   (* dig *);
 
  BEGIN   (* datetime *)
    i := 0;
    i := cctime (i);
    d := localtime (i);
    WITH d ^ DO
    BEGIN
      ti [8] := dig (sec); ti [7] := c;
      ti [6] := ':';
      ti [5] := dig (min); ti [4] := c;
      ti [3] := ':';
      ti [2] := dig (hour); ti [1] := c;
      da [8] := dig (day); da [7] := c;
      da [6] := '/';
      da [5] := dig (mon + 1); da [4] := c;
      da [3] := '/';
      da [2] := dig (year); da [1] := c
    END
  END   (* datetime *);
 
PROCEDURE csimage (VAR c : command);
 
  VAR i : integer;
    cls : string [cssize];
 
  BEGIN   (* csimage *)
    cls := argn (0);
    FOR i := 1 TO argc - 1 DO
    BEGIN
      strappend (cls, ' ');
      strappend (cls, argn (i))
    END;
    FOR i := 1 TO strlen (cls) DO c [i] := cls [i];
    FOR i := strlen (cls) + 1 TO cssize DO c [i] := ' '
  END   (* csimage *);
 
FUNCTION fexists (n : filename) : boolean;
 
  VAR i : integer;
 
$warn off$
FUNCTION $alias '_open'$ copen (VAR n : filename; f : integer)
  : integer; external;
PROCEDURE $alias '_close'$ cclose (f : integer); external;
$warn on$
 
  BEGIN   (* fexists *)
    i := pred (filenameln);
    WHILE n [i] = ' ' DO i := pred (i);
    n [succ (i)] := chr (0);
    i := copen (n, 0);
    IF i > 0
    THEN BEGIN
      cclose (i);
      fexists := true
    END
    ELSE fexists := false
  END   (* fexists *);
 
PROCEDURE header;
 
  BEGIN   (* header *)
    skip := 0;
    page := page + 1;
    IF (page = 10) OR (page = 100) OR (page = 1000)
    THEN pagepad := pagepad - 1;
    writeln ('1COMPARE  ', system:10, ' Version ', version,
             ' ':pagepad, today:9, ' ', now:9, '  Page ', page:1)
  END   (* header *);
 
PROCEDURE ensure (data : integer);
 
  BEGIN   (* ensure *)
    writeln;
    IF pagesize < 0
    THEN IF pagesize + skip + data > 0
      THEN pagesize := 0;
    IF pagesize = 0
    THEN BEGIN
      header;
      writeln;
      pagesize := 3 - pagelength
    END   (* then *)
    ELSE BEGIN
      pagesize := pagesize + skip;
      WHILE skip > 0 DO
      BEGIN
        writeln;
        skip := skip - 1
      END   (* while *)
    END   (* else *);
    pagesize := pagesize + 1;
    write (' ')
  END   (* ensure *);
 
PROCEDURE initialise;
 
  TYPE fatalerror = (extratext, missingdata, badoption, badnumber,
                     doesnotexist);
        whichfile = (fila, filb, outp, modf);
 
  VAR inch,
   cmdsize : 0..cssize;
      comd : command;
         c : char;
   options,
     legit : SET OF char;
 
  PROCEDURE sidcode;
 
    VAR year, month, day : 0..2000;
 
    BEGIN   (* sidcode *)
      sid [1] := 'S';
      sid [2] := 'C';
      sid [3] := today [1];
      sid [4] := today [2];
      year := 10 * (ord (today [1]) - ord ('0')) + ord (today [2])
        - ord ('0');
      month := 10 * (ord (today [4]) - ord ('0')) + ord (today [5])
        - ord ('0');
      day := 10 * (ord (today [7]) - ord ('0')) + ord (today [8])
        - ord ('0');
      year := ord (year MOD 4 = 0);
      IF month > 2
      THEN day := day + year + (153 * month + 3) DIV 5 - 33
      ELSE IF month = 2 THEN day := day + 31;
      sid [5] := chr (day DIV 100 + ord ('0'));
      day := day MOD 100;
      sid [6] := chr (day DIV 10 + ord ('0'));
      sid [7] := chr (day MOD 10 + ord ('0'));
      FOR day := 8 TO alfalength DO sid [day] := ' '
    END   (* sidcode *);
 
  PROCEDURE error (e : fatalerror);
 
    VAR r, s : integer;
 
    BEGIN   (* error *)
      write (' ***** ');
      CASE e OF
         extratext : BEGIN
                       writeln ('Unexpected data on command line:');
                       inch := inch + 1
                     END;
       missingdata : writeln ('Data is expected at this point:');
         badoption : writeln ('This is not a legal option:');
         badnumber : writeln ('This value is not legitimate:');
      doesnotexist : writeln ('This file does not exist.')
      END   (* case *);
      IF pagewidth > 78 THEN pagewidth := 78;
      IF inch > pagewidth THEN r := inch + 10 - pagewidth
      ELSE r := 1;
      IF cmdsize - r >= pagewidth THEN cmdsize := r + pagewidth - 1;
      write (' ');
      FOR s := r TO cmdsize DO write (comd [s]);
      writeln;
      IF r >= inch THEN r := inch - 1;
      writeln (' ':inch - r, arrow);
      IF e = doesnotexist THEN halt (32) ELSE halt (24)
    END   (* error *);
 
  FUNCTION lnumber (min, max : integer) : integer;
 
    VAR i : integer;
 
    BEGIN   (* lnumber *)
      i := 0;
      WHILE comd [inch] = ' ' DO inch := inch + 1;
      WHILE comd [inch] IN digits DO
      BEGIN
        i := i * 10 + ord (comd [inch]) - ord ('0');
        IF i > max THEN error (badnumber);
        inch := inch + 1
      END;
      IF i < min
      THEN IF i = 0
        THEN error (missingdata)
        ELSE error (badnumber);
      lnumber := i
    END   (* lnumber *);
 
  PROCEDURE getfname (fi : whichfile);
 
    VAR wlength : integer;
           word : filename;
 
    PROCEDURE getlword;
 
      VAR i : 0..filenameln;
          c : char;
 
      BEGIN   (* getlword *)
        wlength := 0;
        WHILE comd [inch] = ' ' DO inch := inch + 1;
        c := comd [inch];
        IF c = optchar THEN c := ' ';
        FOR i := 1 TO filenameln DO
        IF c IN legit
        THEN BEGIN
          word [i] := c;
          wlength := i;
          inch := inch + 1;
          c := comd [inch]
        END
        ELSE word [i] := ' ';
        IF (c <> ' ') AND (c <> optchar)
        THEN error (extratext)
      END   (* getlword *);
 
    BEGIN   (* getfname *)
      WHILE comd [inch] = ' ' DO inch := inch + 1;
      getlword;
      CASE fi OF
        fila, filb : BEGIN
                       IF wlength = 0
                       THEN BEGIN
                         IF fi = fila THEN word := 'FILEA   '
                         ELSE word := 'FILEB   ';
                         wlength := 5
                       END;
                       WITH infile [fi = filb] DO
                       BEGIN
                         name := word; nameln := wlength
                       END
                     END;
              modf : BEGIN
                       IF wlength = 0
                       THEN word := 'mods';
                       rewrite (mods, word)
                     END;
              outp : IF wlength > 0
                     THEN rewrite (output, word)
                     ELSE rewrite (output, 'output')
      END   (* case *)
    END   (* getfname *);
 
  PROCEDURE initfile (fi : whichfile; VAR f : text);
 
    VAR i : integer;
 
    BEGIN   (* initfile *)
      IF comd [inch] = ',' THEN inch := inch + 1;
      WITH infile [fi = filb] DO
      BEGIN
        getfname (fi);
        IF defaultpad > nameln
        THEN pad := defaultpad - nameln
        ELSE pad := 1;
        here := NIL;
        former := NIL;
        first := NIL;
        last := NIL;
        hereno := 1;
        firstno := 1;
        lastno := 1;
        WITH erst DO BEGIN name := blank; number := 0 END;
        ended := false;
        IF fi = filb
        THEN BEGIN
          i := infile [false].pad;
          IF i > pad THEN i := pad - 4
          ELSE i := i - 4;
          pad := pad - i;
          WITH infile [false] DO pad := pad - i
        END;
        IF fexists (name) THEN reset (f, name)
        ELSE error (doesnotexist)
      END   (* with *);
      IF eof (f)
      THEN error (doesnotexist)
    END   (* initfile *);
 
  PROCEDURE cline;
 
    VAR i : integer;
 
    BEGIN   (* cline *)
      datetime (today, now);
      cmdsize := cssize - 2;
      legit := [chr(33)..chr(126)];
      csimage (comd);
      WHILE comd [cmdsize] = ' ' DO cmdsize := cmdsize - 1;
      cmdsize := cmdsize + 1;
      comd [cmdsize] := ' ';
      comd [cmdsize + 1] := optchar
    END   (* cline *);
 
  BEGIN   (* initialise *)
    action := default;
    free := NIL;
    digits := ['0'..'9'];
    follower := nines;
    temp [0] := 'A';
    templast := maxlength;
    pagelength := 0;
    pagewidth := 78;
    page := 0;
    criterion := 6;
    linelength := maxlength;
    longer := false;
    reportlong := true;
    same := true;
    match := true;
    endboth := false;
    blanklines := true;
    ibmupdate := false;
    markcolumn := false;
    options := ['B', 'C', 'D', 'F', 'I', 'L', 'M', 'O', 'P', 'S', 'T',
      'W'];
    cline;
    inch := 2;
    WHILE comd [inch] IN legit DO inch := inch + 1;
    initfile (fila, filea);
    initfile (filb, fileb);
    WHILE comd [inch] = ' ' DO inch := inch + 1;
    IF comd [inch] <> optchar
    THEN error (extratext);
    WHILE inch < cmdsize DO
    BEGIN
      WHILE comd [inch] = ' '
      DO inch := inch + 1;
      IF comd [inch] = optchar
      THEN inch := inch + 1
      ELSE error (extratext);
      IF inch <= cmdsize
      THEN BEGIN
        c := comd [inch];
        inch := inch + 1;
        IF c IN ['a'..'i','j'..'r','s'..'z']
        THEN c := chr (ord (c) + ord ('A') - ord ('a'));
        IF c IN options
        THEN CASE c OF
        'B' : BEGIN
                options := options - ['B', 'F', 'I', 'M'];
                blanklines := false
              END;
        'C' : BEGIN
                options := options - ['C'];
                criterion := lnumber (1, 100)
              END;
        'D' : options := options - ['D', 'F', 'I', 'M'];
        'F' : BEGIN
                options := options - ['B', 'D', 'F', 'I', 'M', 'P'];
                action := merge
              END;
        'I' : BEGIN
                sidcode;
                ibmupdate := true;
                getfname (modf);
                options := options -
                  ['B', 'D', 'F', 'I', 'M', 'P', 'W'];
                linelength := 72;
                IF 'C' IN options THEN criterion := 8;
                reportlong := false;
                action := update
              END;
   'L', 'O' : BEGIN
                getfname (outp);
                options := options - ['L', 'O'];
                IF 'S' IN options THEN pagewidth := 132;
                IF 'T' IN options THEN pagelength := 62
              END;
        'M' : BEGIN
                getfname (modf);
                options := options - ['B', 'D', 'F', 'I', 'M', 'P'];
                IF 'W' IN options THEN linelength := 72;
                IF 'C' IN options THEN criterion := 8;
                reportlong := false;
                action := update
              END;
        'P' : BEGIN
                options := options - ['F', 'I', 'M', 'P'];
                markcolumn := true
              END;
        'S' : BEGIN
                options := options - ['S'];
                pagewidth := lnumber (62, 164)
              END;
        'T' : BEGIN
                options := options - ['T'];
                pagelength := lnumber (15, 255)
              END;
        'W' : BEGIN
                options := options - ['I', 'W'];
                linelength := lnumber (10, maxlength)
              END
        END   (* case *)
        ELSE IF c IN ['A'..'I','J'..'R','S'..'Z']
        THEN error (badoption)
        ELSE
          error (extratext)
      END   (* then *)
    END   (* while *);
    pagepad := pagewidth - 58;
    header;
    IF cmdsize > pagewidth THEN cmdsize := pagewidth;
    writeln (' ', comd:cmdsize);
    writeln (' Copyright (C) MCC (', compiled, ')');
    pagesize := 5 - pagelength;
    IF action <> update
    THEN pagewidth := pagewidth - 10 - 3 * ord (action = merge);
    ensure (1);
    write ('       Output Option = ');
    CASE action OF
     update : write ('Modifications.');
    default : write ('Differences.');
      merge : write ('Flags.')
    END   (* case *);
    ensure (2);
    write ('    Input Line Width = ', linelength:1, ' characters.');
    ensure (1);
    write ('     Match Criterion = ', criterion:1,
           ' lines':6 - ord (criterion = 1), '.');
    skip := 1;
    ensure (2);
    WITH infile [false] DO write ('    File A: ', name:nameln);
    ensure (1);
    WITH infile [true] DO write ('    File B: ', name:nameln);
    skip := 2
  END   (* initialise *);
 
PROCEDURE list (f : boolean; c : char);
 
  VAR n : integer;
      l : linep;
 
  PROCEDURE listone;
 
    VAR i, low, high : integer;
 
    BEGIN   (* listone *)
      WITH l ^ DO
      BEGIN
        IF length > 0
        THEN IF length <= pagewidth
          THEN write (data:length)
          ELSE BEGIN
            write (data:pagewidth);
            low := pagewidth;
            REPEAT
              high := low + pagewidth;
              IF high > length THEN high := length;
              ensure (1);
              write (' ':10 + 3 * ord (action = merge));
              FOR i := low + 1 TO high DO write (data [i]);
              low := high
            UNTIL low = length
          END   (* else *);
        l := next
      END   (* with *);
      n := n + 1
    END   (* listone *);
 
  PROCEDURE listpairs;
 
    VAR b : boolean;
       hi : integer;
 i, j, lo : 0..maxlength;
   l1, l2 : ARRAY [0..maxlength] OF char;
        t : ARRAY [boolean] OF RECORD
               line : linep;
              locus : integer
            END;
     term : linep;
 
    BEGIN   (* listpairs *)
      l1 [0] := 'A';
      l2 [0] := 'B';
      FOR b := false TO true DO WITH infile [b], t [b] DO
      BEGIN
        line := first;
        locus := firstno;
        term := here
      END;
      REPEAT
        j := 0;
        FOR b := false TO true DO WITH t [b] DO
        BEGIN
          l := line;
          WITH l ^ DO
          BEGIN
            IF length > j THEN j := length;
            ensure ((length + ord (length = 0) - 1) DIV pagewidth + 1);
            IF b THEN
              FOR i := 1 TO length DO l2 [i] := data [i]
            ELSE
              FOR i := 1 TO length DO l1 [i] := data [i];
            line := next
          END   (* with *);
          IF b THEN write ('  B') ELSE write ('  A');
          write (locus:5, '. ');
          locus := locus + 1;
          listone
        END   (* with *);
        WHILE l1 [j] = l2 [j] DO j := j - 1;
        lo := 0;
        WHILE lo < j DO
        BEGIN
          hi := lo + pagewidth;
          IF hi > j THEN hi := j;
          ensure (1);
          write (' ':10);
          FOR i := lo + 1 TO hi DO
            IF l1 [i] = l2 [i] THEN write (' ') ELSE write (arrow);
          lo := hi
        END   (* while *)
      UNTIL l = term;
      skip := 1;
      action := default
    END   (* listpairs *);
 
  BEGIN   (* list *)
    WITH infile [f] DO
    BEGIN
      l := first;
      n := firstno;
      CASE action OF
       update : WHILE (l <> NIL) AND (l <> here) DO WITH l ^ DO
                BEGIN
                  IF length > 0 THEN write (mods, data:length);
                  IF ibmupdate
                  THEN IF length < 63
                    THEN write (mods, '@':64 - length, sid:7);
                  writeln (mods);
                  l := next
                END   (* while *);
      default : BEGIN
                  WHILE (l <> NIL) AND (l <> here) DO
                  BEGIN
                    WITH l ^ DO ensure ((length + ord (length = 0) - 1)
                      DIV pagewidth + 1);
                    IF f THEN write ('  B')
                    ELSE write ('  A');
                    write (n:5, '. ');
                    listone
                  END   (* while *);
                  IF l = NIL
                  THEN BEGIN
                    ensure (1);
                    write ('    *** End-of-file ***')
                  END   (* then *);
                  skip := 1
                END   (* default *);
        pairs : listpairs;
        merge : WHILE (l <> NIL) AND (l <> here) DO
                BEGIN
                  WITH l ^ DO ensure ((length + ord (length = 0) - 1)
                    DIV pagewidth + 1);
                  IF c = 'D'
                  THEN write ('    D        ')
                  ELSE write (c:5, n:6, '. ');
                  listone
                END   (* while *)
      END   (* case *)
    END   (* with *)
  END   (* list *);
 
PROCEDURE comparefiles;
 
  PROCEDURE setup;
 
    VAR f : boolean;
        l : linep;
 
    BEGIN   (* setup *)
      FOR f := false TO true DO WITH infile [f] DO
        IF first <> NIL
          THEN BEGIN
            WHILE first <> here DO WITH first ^ DO
            BEGIN
              erst := ident;
              l := next;
              next := free;
              free := first;
              first := l
            END   (* with *);
            former := NIL;
            firstno := hereno;
            IF here = NIL
            THEN last := NIL
          END   (* then *)
    END   (* setup *);
 
  PROCEDURE comparelines;
 
    BEGIN   (* comparelines *)
      WITH infile [false] DO
        IF here = NIL
        THEN match := ended AND infile [true].ended
          AND (infile [true].here = NIL)
        ELSE IF infile [true].here = NIL
        THEN match := false
        ELSE WITH infile [true].here ^ DO
        BEGIN
          match := length = here ^.length;
          IF match THEN match := data = here ^.data
        END   (* with *)
    END   (* comparelines *);
 
  PROCEDURE advance (w : boolean);
 
    LABEL 1;
 
    PROCEDURE nextline (VAR f : text);
 
      VAR n : linep;
          i,
     l1, l2 : integer;
 
      BEGIN   (* nextline *)
        WITH infile [w] DO
          IF NOT ended
          THEN BEGIN
            IF free = NIL THEN new (n)
            ELSE BEGIN
              n := free; free := n ^.next
            END;
            l1 := 0;
            WHILE NOT eoln (f) AND (l1 < linelength) DO
            BEGIN
              l1 := l1 + 1;
              read (f, temp [l1])
            END;
            l2 := l1;
            WHILE temp [l2] = ' ' DO l2 := l2 - 1;
            FOR l1 := l1 + 1 TO templast DO temp [l1] := ' ';
            templast := l2;
            WITH n ^, ident DO
            BEGIN
              next := NIL;
              length := templast;
              FOR i := 1 TO maxlength DO data [i] := temp [i];
              IF (action = update) AND NOT w
              THEN BEGIN
                WHILE NOT eoln (f) AND (f ^ = ' ') DO get (f);
                FOR l1 := 1 TO idlength DO
                BEGIN
                  name [l1] := f ^;
                  IF f ^ <> ' ' THEN get (f)
                END;
                WHILE NOT eoln (f) AND (f ^ = ' ') DO get (f);
                i := 0;
                WHILE f ^ IN digits DO
                BEGIN
                  IF i < maxidnum
                  THEN i := i * 10 + ord (f ^) - ord ('0');
                  get (f)
                END;
                IF i < maxidnum THEN number := i ELSE number := 0
              END   (* then *)
              ELSE BEGIN
                name := blank; number := 0;
                IF reportlong
                THEN BEGIN
                  WHILE NOT eoln (f) AND (f ^ = ' ') DO get (f);
                  reportlong := eoln (f); longer := NOT reportlong
                END
              END
            END   (* with *);
            IF last = NIL
            THEN BEGIN
              first := n; here := first
            END
            ELSE BEGIN
              last ^.next := n;
              lastno := lastno + 1
            END;
            last := n;
            readln (f);
            ended := eof (f)
          END   (* then *)
      END   (* nextline *);
 
    BEGIN   (* advance *)
      WITH infile [w] DO
      BEGIN
1:      IF here = NIL
        THEN IF ended
          THEN endboth := true
          ELSE IF w
          THEN nextline (fileb)
          ELSE nextline (filea)
        ELSE BEGIN
          IF here = last
          THEN IF w
            THEN nextline (fileb)
            ELSE nextline (filea);
          former := here;
          here := here ^.next;
          ended := ended OR (here = NIL);
          hereno := hereno + 1
        END   (* else *);
        IF NOT blanklines
        THEN IF here <> NIL
          THEN IF here ^.length = 0 THEN GOTO 1
      END   (* with *)
    END   (* advance *);
 
  PROCEDURE findmatch (cri : integer);
 
    VAR which : boolean;
        newcr : integer;
        limit : linep;
        tfoll : id;
        tfile : ARRAY [boolean] OF PACKED RECORD
                  there, tlast : linep;
                         terst : lineid;
                       thereno : integer;
                        tended : boolean
                END;
 
    PROCEDURE writeid (id : lineid);
 
      VAR i : 1..idlength;
 
      BEGIN   (* writeid *)
        WITH id DO
        BEGIN
          IF name [idlength] = ' '
          THEN BEGIN
            i := 1;
            WHILE name [i] <> ' ' DO
            BEGIN
              write (mods, name [i]);
              i := i + 1
            END   (* while *)
          END   (* then *)
          ELSE write (mods, name);
          write (mods, '.', number:1)
        END   (* with *)
      END   (* writeid *);
 
    PROCEDURE ibmdirect (insert : boolean);
 
      VAR inserted : integer;
            signif : 1..4;
                 i : 1..8;
              a, b : id;
        pos1, pos2 : 0..99999999;
 
      BEGIN   (* ibmdirect *)
        WITH infile [true] DO inserted := hereno - firstno;
        write (mods, './ ');
        IF insert THEN write (mods, 'I ')
        ELSE IF inserted = 0 THEN write (mods, 'D ')
        ELSE write (mods, 'R ');
        WITH infile [false] DO
          IF insert
          THEN BEGIN
            a := erst.name;
            b := a
          END   (* then *)
          ELSE BEGIN
            a := first ^.ident.name;
            IF former = NIL THEN b := a
            ELSE b := former ^.ident.name
          END   (* else *);
        signif := 1;
        FOR i := 1 TO 3 DO
          IF NOT (a [i] IN digits) THEN signif := 4;
        FOR i := 1 TO signif - 1 DO
        BEGIN
          a [i] := '0'; b [i] := '0'
        END;
        IF a = b THEN b := blank;
        write (mods, a:8, ' ', b:8, ' $');
        IF inserted = 0
        THEN write (mods, ' ':30)
        ELSE BEGIN
          WITH infile [false] DO
          BEGIN
            IF NOT insert THEN a := erst.name;
            IF here = NIL THEN b := follower
            ELSE b := here ^.ident.name
          END   (* with *);
          pos1 := 0; pos2 := pos1;
          FOR i := signif TO 8 DO
            IF a [i] IN digits
            THEN pos1 := pos1 * 10 + ord (a [i]) - ord ('0');
          FOR i := signif TO 8 DO
            pos2 := pos2 * 10 + ord (b [i]) - ord ('0');
          pos2 := (pos2 - pos1) DIV (inserted + 1);
          IF pos2 > 500 THEN pos2 := 500
          ELSE IF pos2 >= 100 THEN pos2 := 100 * (pos2 DIV 100)
          ELSE IF pos2 >= 10 THEN pos2 := 10 * (pos2 DIV 10)
          ELSE IF pos2 = 0 THEN pos2 := 1;
          pos1 := pos1 + pos2;
          FOR i := 8 DOWNTO 1 DO
          BEGIN
            a [i] := chr (pos1 MOD 10 + ord ('0'));
            pos1 := pos1 DIV 10
          END;
          write (mods, ' ', a:8, pos2:4, ' ':17)
        END   (* else *);
        write (mods, today:8, ' ', now:8)
      END   (* ibmdirect *);
 
    PROCEDURE differences;
 
      VAR l : integer;
 
      PROCEDURE add (inc : integer);
 
        BEGIN   (* add *)
          l := l + inc + 1;
          IF l >= 0
          THEN BEGIN
            ensure (1);
            write (' ':10);
            l := inc - pagewidth
          END   (* then *)
          ELSE write (' ')
        END   (* add *);
 
      PROCEDURE where (w : boolean);
 
        VAR i : integer;
 
        BEGIN   (* where *)
          WITH infile [w] DO
          BEGIN
            i := hereno - 1;
            add (5);
            write ('lines':5 - ord (i = firstno));
            add (4);
            write (firstno:1);
            IF i > firstno
            THEN BEGIN
              add (7);
              write ('through');
              add (4);
              write (i:1)
            END   (* then *);
            IF here = NIL
            THEN BEGIN
              add (7);
              write ('(before');
              add (12);
              write ('end-of-file)')
            END   (* then *)
          END   (* with *)
        END   (* where *);
 
      PROCEDURE extra (w : boolean);
 
        BEGIN   (* extra *)
          WITH infile [w] DO
          BEGIN
            write ('    Extra text on ',
                   name:nameln);
            l := nameln + 8 - pagewidth
          END;
          WITH infile [NOT w] DO
          BEGIN
            IF first = NIL
            THEN BEGIN
              add (7);
              write ('before');
              add (11);
              write ('end-of-file');
              add (2);
              write ('on')
            END
            ELSE BEGIN
              add (13);
              write ('between lines');
              add (4);
              write (firstno-1:1);
              add (3);
              write ('and');
              add (4);
              write (firstno:1);
              add (2);
              write ('of')
            END;
            add (nameln);
            write (name:nameln)
          END;
          skip := 1;
          list (w, ' ')
        END   (* extra *);
 
      BEGIN   (* differences *)
        ensure (1);
        write ('***********************************':45);
        ensure (3);
        WITH infile [false] DO
          IF first = here THEN extra (true)
          ELSE IF infile [true].first = infile [true].here
          THEN extra (false)
          ELSE BEGIN
            write ('    Mismatch: ',
                   name:nameln);
            l := nameln + 4 - pagewidth;
            where (false);
            add (12);
            write ('not equal to');
            WITH infile [true] DO
            BEGIN
              add (nameln);
              write (name:nameln)
            END;
            where (true);
            skip := 1;
            IF markcolumn AND (hereno - firstno =
              infile [true].hereno - infile [true].firstno)
            THEN BEGIN
              action := pairs;
              list (false, ' ')
            END
            ELSE BEGIN
              list (false, ' ');
              list (true, ' ')
            END   (* else *)
          END   (* else *)
      END   (* differences *);
 
    PROCEDURE check;
 
      VAR i : integer;
          w : boolean;
          t : ARRAY [boolean] OF RECORD
                there, tform : linep;
                     thereno : integer
 
              END;
 
      BEGIN   (* check *)
        FOR w := false TO true DO WITH infile [w], t [w] DO
        BEGIN
          there := here;
          tform := former;
          thereno := hereno
        END   (* with *);
        w := endboth;
        comparelines;
        i := cri - 1;
        WHILE match AND (i <> 0) DO
        BEGIN
          advance (false);
          advance (true);
          comparelines;
          i := i - 1
        END   (* while *);
        IF (action = update) AND ((i <> 0) OR NOT match)
        THEN BEGIN
          i := cri - (i + 1);
          IF i > newcr THEN newcr := i
        END;
        endboth := w;
        FOR w := false TO true DO WITH infile [w], t [w] DO
        BEGIN
          here := there;
          former := tform;
          hereno := thereno
        END   (* with *)
      END   (* check *);
 
    BEGIN   (* findmatch *)
      same := false;
      newcr := 0;
      which := true;
      REPEAT
        IF endboth
        THEN WITH infile [false] DO which := ended AND (here = NIL)
        ELSE which := NOT which;
        advance (which);
        WITH infile [NOT which] DO
        BEGIN
          limit := here;
          here := first;
          former := NIL;
          hereno := firstno;
          endboth := ended AND (here = NIL)
        END;
        IF NOT endboth
        THEN WITH infile [which] DO
          endboth := ended AND (here = NIL);
        check;
        WHILE NOT match AND (infile [NOT which].here <> limit) DO
        BEGIN
          advance (NOT which);
          check
        END
      UNTIL match;
      CASE action OF
       update : WITH infile [false] DO
                  IF first = here
                  THEN BEGIN
                    IF ibmupdate
                    THEN ibmdirect (true)
                    ELSE BEGIN
                      write (mods, '*I ');
                      writeid (erst)
                    END;
                    writeln (mods);
                    list (true, ' ')
                  END   (* then *)
                  ELSE IF (newcr = 0) OR
                    (infile [true].first = infile [true].here)
                  THEN BEGIN
                    IF ibmupdate
                    THEN ibmdirect (false)
                    ELSE BEGIN
                      write (mods, '*D ');
                      writeid (first ^.ident);
                      IF former <> NIL
                      THEN WITH former ^.ident DO
                        IF name <> first ^.ident.name
                        THEN BEGIN
                          write (mods, ',');
                          writeid (former ^.ident)
                        END
                        ELSE IF number <> first ^.ident.number
                        THEN write (mods, ',', number:1)
                    END   (* else *);
                    writeln (mods);
                    list (true, ' ')
                  END   (* then *)
                  ELSE BEGIN
                    tfoll := follower;
                    FOR which := false TO true DO
                      WITH infile [which], tfile [which] DO
                      BEGIN
                        tlast := last; last := former;
                        WITH last ^ DO
                        BEGIN
                          next := NIL; terst := ident
                        END;
                        former := NIL;
                        IF NOT which
                        THEN IF here <> NIL
                          THEN follower := here ^.ident.name;
                        there := here; here := first;
                        thereno := hereno; hereno := firstno;
                        tended := ended; ended := true
                      END   (* with *);
                    which := endboth;
                    REPEAT
                      findmatch (newcr);
                      IF NOT endboth
                      THEN REPEAT
                        advance (false);
                        advance (true);
                        setup;
                        comparelines
                      UNTIL endboth OR NOT match
                    UNTIL match;
                    follower := tfoll;
                    endboth := which;
                    FOR which := false TO true DO
                      WITH infile [which], tfile [which] DO
                      BEGIN
                        first := there; here := first;
                        last := tlast; former := NIL;
                        erst := terst;
                        firstno := thereno; hereno := firstno;
                        ended := tended
                      END   (* with *)
                  END   (* else *);
      default : differences;
        merge : BEGIN
                  WITH infile [false] DO
                    IF first <> here
                    THEN BEGIN
                      IF pagesize <> 0 THEN skip := 1;
                      list (false, 'D');
                      IF pagesize <> 0 THEN skip := 1
                    END;
                  WITH infile [true] DO
                    IF first <> here THEN list (true, 'A')
                END   (* merge *)
      END   (* case *)
    END   (* findmatch *);
 
  BEGIN   (* comparefiles *)
    REPEAT
      setup;
      REPEAT
        advance (false);
        advance (true);
        IF action = merge THEN list (true, ' ');
        setup;
        comparelines
      UNTIL endboth OR NOT match;
      IF NOT match THEN findmatch (criterion)
    UNTIL endboth
  END   (* comparefiles *);
 
BEGIN   (* compare *)
  initialise;
  comparefiles;
  IF same
  THEN BEGIN
    ensure (1);
    write ('    No differences.')
  END;
  skip := 1;
  ensure (3);
  write ('    File Sizes:');
  FOR b := false TO true DO WITH infile [b] DO
  BEGIN
    ensure (1);
    write (' ':pad, name:nameln,
           ': ', lastno:1, ' lines':6 - ord (lastno = 1), '.')
  END;
  IF longer
  THEN BEGIN
    skip := 1;
    ensure (2);
    write ('Warning:  Some lines were longer than ',
            linelength:1, ' characters.');
    ensure (1);
    write ('          They were not checked past that point.')
  END;
  writeln;
  IF action = update THEN close (mods, 'SAVE')
END   (* compare *).
