$ovflcheck off$
$range off$
PROGRAM updatepl (input, output);
 
     (* 0.1   A. V. Le Blanc, UMRCC, 1987-06-29  First release.
        0.2   A. V. Le Blanc, UMRCC, 1987-07-01  Second release.
              *CHANGE directive added, and support for ALTPLs.
        0.3   A. V. Le Blanc, UMRCC, 1987-07-06  Third release.
              *YANK, *YANKDECK, and miscellaneous improvements.
        0.4   A. V. Le Blanc, UMRCC, 1987-07-20  Fourth release.
              List option 2, '@' and '^' options.  Reseq source.
        0.5   A. V. Le Blanc, UMRCC, 1987-07-27  Fifth release.
              Miscellaneous bugs.  List options.
        0.6   A. V. Le Blanc, UMRCC, 1987-08-17  Sixth release.
              *PULLMOD, *INWIDTH.  Q, R options.
        0.7   A. V. Le Blanc, UMRCC, 1987-10-15  Seventh release.
              U, Z options.  *L, *NL, *PO, *UP.  Miscellaneous bugs.
        1.0   A. V. Le Blanc, UMRCC, 1987-12-08  Eighth release.
              *DO, *DT, *SY.  B, T options.  Better error messages.
        1.1   A. V. Le Blanc, UMRCC, 1988-05-30  Ninth release.
              Better error messages.  Deleted *YANKS and *SELYANKS.
              Prime version.  No Cyber version.  Source resequenced.
 
     Modification History:
Version   Name      Programmer                    yy/mm/dd  Site
 
1.1       HPUCMPU   A. V. Le Blanc                89/05/17  MCC
   1.  HP-UNIX version completed.
   2.  Site name changed from UMRCC to MCC.
 
        Copyright (C) UMRCC 1987, 1988                               *)
 
CONST maxfilerec = 65535;
        mfrplus1 = 65536;
        mfrdiv10 = 6553;
        maxident = 32767;
     highordchar = 255;
     maxprintwid = 136;
        bytesize = 255;
          bytep1 = 256;
        halfbyte = 128;
     bitsperbyte = 8;
    byteoverflow = 8;
(*    byteoverflow = 2 ** (bitsperbyte - 5) 2 ** (bitsperbyte - 5) *)
         bufmult = 2;
    comdoverflow = 31;
        defcompw = 87;
        deflistw = 79;
          cssize = 160;
       filnamlen = 150;
      filenameln = filnamlen;
         optchar = '-';
 
        bufbytes = 511                    (* Upper bound of a buffer *);
       bufbytep1 = 512                               (* bufbytes + 1 *);
     defpagesize = 57                (* Default page length in lines *);
         remmask = 16         (* Largest remainder: 2 ** ((b-1)+5-b) *);
      directives = 79        (* Number of recognised directive forms *);
    directivesp1 = 80                           (* Directives plus 1 *);
      yankoffset = 32           (* Yank flag in CD descriptor in dir *);
        alfaleng = 8                   (* Number of bytes in an alfa *);
      lowordchar = 0                    (* Lower bound of ord (char) *);
        defdataw = 72      (* Default width of data on COMPILE files *);
        maxdline = 99999                (* Maximum five-digit number *);
     defmasterch = '*'              (* Default master directive char *);
    defcommentch = '/'                  (* Default char for comments *);
         version = '1.1';
        compdate = '94/07/01'                 (* Date of compilation *);
       blankword = '        '                     (* Alfaleng blanks *);
 
(* Internal character set *)
 
             blk = 0;
             lcz = 26;
             ucz = 52;
             com = 58;
             per = 60;
             zer = 69;
             nin = 78;
             tld = 94;
             bin = 95      (* Temp corresponding to all binary chars *);
 
(* Directive values *)
 
    endk = 0;      definek = 15;     pouplitk = 28;      nolistk = 42;
commentk = 1;       ifdefk = 16;     deleterk = 29;     inwidthk = 43;
  blankk = 2;      ifdeckk = 17;       uplitk = 29;      changek = 44;
   datak = 3;     ifidentk = 18;     restorek = 30;        movek = 45;
specialk = 4;      ifndefk = 19;     restorrk = 31;       purgek = 46;
   datek = 5;     ifndeckk = 20;      insertk = 32;     purdeckk = 47;
   timek = 6;     ifnidntk = 21;       identk = 33;     sequenck = 48;
endtextk = 7;     comdeckk = 22;     declarek = 34;     compilek = 49;
compfilk = 8;        deckk = 23;     pointatk = 35;     pullmodk = 50;
  widthk = 9;     yankdckk = 24;     pointupk = 36;        filek = 51;
   elsek = 10;       yankk = 25;       upperk = 37;        nullk = 52;
  endifk = 11;    selyankk = 26;        textk = 38;        lowmk = 54;
     dok = 12;     beforek = 27;      removek = 39;         maxk = 59;
   dontk = 13;    poatlitk = 27;        readk = 40;
   callk = 14;     deletek = 28;        listk = 41;
  dopins = 44;    dontpins = 45;
 
TYPE byte = 0..bytesize                 (* Requires bitsperbyte bits *);
  bytep1r = 0..bytep1;
 idnumber = 0..maxident        (* Requires 2 * bitsperbyte - 1 bytes *);
 bufrange = 0..bufbytes               (* Size of library I/O buffers *);
linerange = 1..bytep1                      (* Maximum size of a line *);
 fivebits = 0..31                                   (* Miscellaneous *);
   ccount = -1..comdoverflow             (* Used for number of calls *);
 keyrange = endk..maxk                     (* Used for key variables *);
  intchar = blk..bin                       (* Internal character set *);
 bitvaltp = 0..4095         (* Requires at most 4 + bitsperbyte bits *);
bignumber = 0..maxfilerec                        (* Requires 2 bytes *);
   idkind = 1..3                     (* Possible kinds of identities *);
 
    files = (altfile, nplfile, oplfile, tpyfile, tpzfile, outfile,
             comfile, modfile, srcfile, inpfile, in2file, dummy);
fileindex = altfile..in2file;
 filemode = (closed, opread, opwrite);
changetyp = (before, delete, restore, insert, listd, nolist, selyank);
errortype = (badcline, baddirect, badopl, bigfile, badmasterch,
             toomanyids, doesnotexist, alreadyexists, noparenth,
             notadeck, inappropriate, ignoretherest, toomanyifs,
             toomanylines, notanident, doesnotfollow, noabbreviate,
             nofilename, badfilename, lineexpected, badlinenumber,
             declareerror, twodecks, noreadfile, notfiledes,
             notaname, comma, illegitimate, notifparm,
             badvalue, novalue, nopointer);
 
 listtype = PACKED SET OF endk..upperk;
 
 csstring = PACKED ARRAY [1..cssize] OF char;
  command = csstring;
 filename = PACKED ARRAY [1..filnamlen] OF char;
 
   buffer = PACKED ARRAY [bufrange] OF char;
     alfa = PACKED ARRAY [1..alfaleng] OF char;
inttoloct = ARRAY [blk..tld] OF char;
   blinet = PACKED ARRAY [linerange] OF char;
 
  buffile = FILE OF buffer;
 
  modlist = @ modtype;
  modtype = PACKED RECORD        (* Describes one change for PULLMOD *)
              ctype : changetyp;
              befid, locat : idnumber;
              befno, recor : bignumber;
              nextm : modlist
            END;
 
 namelist = @ nltype;
   nltype = PACKED RECORD              (* Lists of calls and defines *)
              nname : alfa;
              nnumb : byte;
              nnext : namelist
            END;
 
    ident = @ identity;
 
  beflist = @ beftype;
  beftype = PACKED RECORD          (* To decide INSERT versus BEFORE *)
              mline, bline : bignumber;
              biden : ident;
              bnext : beflist
            END;
 
 yanklist = @ yanktype;
 yanktype = PACKED RECORD                (* Describes selective yank *)
              yank : ident;
              real,
              curr : boolean;
              ynxt : yanklist
            END;
 
 decklist = @ deckltype;
deckltype = PACKED RECORD                 (* Describes deck modified *)
              adeck : ident;
              where : bignumber              (* Mod line up to which *);
              anext : decklist
            END;
 
  changes = @ chglist;
  chglist = PACKED RECORD                    (* Describes one change *)
              startid : idnumber;
              startno : bignumber;
                cnext : changes;
                ckind : changetyp;
                where : idnumber;
                locus : bignumber;
                mdwho : idnumber
              END;
 
 identity = PACKED RECORD     (* Describes a deck, comdeck, or ident *)
              name : alfa;
              idno : idnumber;
              kind : 0..5;
              data : 0..15
       (* bit 0 = compile, 1 = yank, 2 = purge, 3 = sequence or pull *);
            CASE boolean OF false : (); true : (
              strc : bignumber;
              stlo : bufrange;
              mxrc : bignumber;
              next : ident;
              ofil : altfile..tpzfile;
            CASE idkind OF
              1, 2 : (dlst : namelist;
                      chgs : changes;
                    CASE boolean OF false : (); true : (
                      strb : bignumber   (* common decks *);
                      stlb : bufrange));
                 3 : (afct : decklist;
                      bfor : beflist;
                      lstn : bignumber))
            END;
 
     node = @ avltree;
  avltree = PACKED RECORD             (* For name and idnumber trees *)
              arm : ARRAY [boolean] OF node;
              who : ident;
              bal : 0..2                           (* Balance factor *)
            END;
 
VAR     input2                               (* Secondary INPUT file *),
       compile                                       (* COMPILE file *),
        getmod                                        (* GETMOD file *),
        source : text                                 (* SOURCE file *);
         oldpl                                         (* OLDPL file *),
         newpl                                         (* NEWPL file *),
         altpl                                         (* ALTPL file *),
            z1                      (* Scratch file for common decks *),
            z2 : buffile          (* Scratch file for ordinary decks *);
      dlinenum : 0..maxdline               (* Number of output lines *);
      pagesize                        (* Maximum length of each page *),
    pagelength : -bytesize..0       (* Actual length of current page *);
          page                             (* Current page of output *),
      binchars               (* Number of binary characters in INPUT *),
     activeifs                      (* Number of nested active *IF's *),
    skippedifs                    (* Number of nested inactive *IF's *),
      writerec                     (* Record currently being written *),
       readrec                        (* Record currently being read *),
       readloc                      (* Index of next byte to be read *),
      oldmaxid                     (* Test mods not to be renumbered *),
         curid                         (* Number of current identity *),
     firstline                 (* Line number of first line modified *),
    secondline : bignumber       (* Line number of 2nd line modified *);
       linenum : 0..mfrplus1                  (* Line number written *);
    thisdeckid                     (* Deck being modified or written *),
         maxid : idnumber              (* Highest existing id number *);
      writeloc : bufrange        (* Index of next byte to be written *);
     listwidth                           (* Width of the OUTPUT file *),
  listwidthm15                                     (* Listwidth - 15 *),
       inwidth                 (* Maximum significant width of INPUT *),
       newdwid                                     (* New data width *),
       newswid                           (* New sequence-field width *),
        longth                                (* Length of line read *),
           key : byte                              (* Directive code *);
       datawid                      (* Default data width on COMPILE *),
       compwid                           (* Default width of COMPILE *),
     curseqwid                    (* Sequence-field width on COMPILE *),
    curdatawid                      (* Current data width on COMPILE *),
    curcompwid : bytep1r                 (* Current width of COMPILE *);
      nextword                            (* Start of last word read *),
        nextin : linerange          (* Index of next INPUT character *);
       curkind : 0..5           (* Current kind of element to insert *);
       wlength : 0..alfaleng                          (* Word length *);
      readfile                                    (* File being read *),
     writefile : fileindex                     (* File being written *);
         found                              (* Was the element found *),
       newflag                       (* Is the element being created *),
       addflag                      (* Is the element to be inserted *),
        bigger                        (* Has the tree height changed *),
      idsearch                      (* Are we searching for a number *),
     secondary              (* Are we searching for an ALTPL element *),
     textinput                (* Have we processed a *TEXT directive *),
    terminalio               (* Suppress carriage control characters *),
  printerchars                (* Write control chars to OUTPUT files *),
 suppressnewpl                                  (* Delete NEWPL file *),
       seqflag                              (* Count lines in OUTPUT *),
  fullrestruct            (* Reconstruct original decks and all mods *),
 listdirectory                            (* Write directory listing *),
listdirectives               (* List encountered directives in decks *),
    listcounts                           (* Count lines in each deck *),
    lineactive                                (* This line is active *),
    listactive                                  (* List active lines *),
  listinactive                                (* List inactive lines *),
         audit                          (* List modification history *),
    nowlisting                          (* Listing currently enabled *),
      fullmode                   (* Select all decks for compilation *),
      skipflag                      (* Skip lines before next output *),
   deleteinput                        (* Delete input file when done *),
     uppercase                        (* Convert lower to upper case *),
      pascflag : boolean                    (* Check Pascal pointers *);
        newpch                            (* Accepted Pascal pointer *),
        oldpch                        (* Unacceptable Pascal pointer *),
     commentch                                  (* Comment character *),
      masterch : char                    (* Master control character *);
  thisdeckname                               (* Name of current deck *),
     identword                         (* Interface with tree search *),
          word                               (* General-purpose alfa *),
        blanks                         (* Eight internal code blanks *),
    today, now : alfa                       (* Current date and time *);
        idtree                        (* Entries sorted by id number *),
        nmtree : node                      (* Entries sorted by name *);
   oldmaxident               (* Points to last previous modification *),
   altyankdeck                           (* Yank deck for ALTPL file *),
      yankdeck                          (* Yank deck for other files *),
      declared                                      (* Declared deck *),
      lastdeck                         (* Deck last named explicitly *),
      lastname                (* Deck or ident last named explicitly *),
      thisdeck                   (* Deck being processed or modified *),
      firstref                          (* First element referred to *),
     secondref                         (* Second element referred to *),
       curdesc : ident                        (* Interface to search *);
     datatypes                (* Keys allowed in decks and inertions *),
      expected                                   (* Keys allowed now *),
      commands : PACKED SET OF endk..nullk   (* Minimal allowed keys *);
     compiling                           (* Keys written to COMPFILE *),
    sourcelist                             (* Keys written to SOURCE *),
   pullingmods                             (* Keys written to GETMOD *),
       listing : listtype                  (* Keys written to OUTPUT *);
      keywords : ARRAY [1..directives] OF alfa         (* Recognised *);
          keys : ARRAY [1..directives] OF keyrange  (* Matching keys *);
         first                          (* Start of DK, CD, ID lists *),
          last : ARRAY [1..3] OF ident              (* Ends of lists *);
         fname : ARRAY [fileindex] OF filename;
       factive : ARRAY [fileindex] OF boolean      (* Is file active *);
       fstatus : ARRAY [fileindex] OF filemode    (* Op, clo, rd, wr *);
         fsize : ARRAY [altfile..tpzfile] OF bignumber       (* Size *);
        fwhere                                      (* Record number *),
        findex : ARRAY [altfile..outfile] OF bignumber     (* Offest *);
       filebuf : ARRAY [altfile..tpzfile] OF buffer   (* I/O buffers *);
       offsets : ARRAY [0..3] OF 0..68           (* Internal charset *);
          line : ARRAY [linerange] OF intchar   (* Int. charset line *);
         iline : ARRAY [linerange] OF char   (* Internal format line *);
         bline : blinet               (* External form of input line *);
      loctoint : ARRAY [char] OF intchar    (* Host to internal cset *);
      inttoloc : inttoloct                  (* Internal to host cset *);
 
IMPORT arg;
 
PROCEDURE datetime (VAR da, ti: alfa);
 
  TYPE dptr = ^ drecord;
    drecord = PACKED RECORD
                sec,min,hour,day,mon,year,wday,jday,dst : integer
              END;
 
  VAR c : char;
      i : integer;
      d : dptr;
 
$warn off$
FUNCTION $alias '_time'$ cctime (VAR t : integer) : integer;
  external;
FUNCTION localtime (VAR t : integer) : dptr; external;
$warn on$
 
  FUNCTION dig (i : integer) : char;
 
    BEGIN   (* dig *)
      c := chr (i DIV 10 + ord ('0'));
      dig := chr (i MOD 10 + ord ('0'))
    END   (* dig *);
 
  BEGIN   (* datetime *)
    i := 0;
    i := cctime (i);
    d := localtime (i);
    WITH d ^ DO
    BEGIN
      ti [8] := dig (sec); ti [7] := c;
      ti [6] := ':';
      ti [5] := dig (min); ti [4] := c;
      ti [3] := ':';
      ti [2] := dig (hour); ti [1] := c;
      da [8] := dig (day); da [7] := c;
      da [6] := '/';
      da [5] := dig (mon + 1); da [4] := c;
      da [3] := '/';
      da [2] := dig (year); da [1] := c
    END
  END   (* datetime *);
 
PROCEDURE csimage (VAR c : command);
 
  VAR i : integer;
    cls : string [cssize];
 
  BEGIN   (* csimage *)
    cls := argn (0);
    FOR i := 1 TO argc - 1 DO
    BEGIN
      strappend (cls, ' ');
      strappend (cls, argn (i))
    END;
    FOR i := 1 TO strlen (cls) DO c [i] := cls [i];
    FOR i := strlen (cls) + 1 TO cssize DO c [i] := ' '
  END   (* csimage *);
 
FUNCTION fexists (n : filename) : boolean;
 
  VAR i : integer;
 
$warn off$
FUNCTION $alias '_open'$ copen (VAR n : filename; f : integer)
  : integer; external;
PROCEDURE $alias '_close'$ cclose (f : integer); external;
$warn on$
 
  BEGIN   (* fexists *)
    i := pred (filenameln);
    WHILE n [i] = ' ' DO i := pred (i);
    n [succ (i)] := chr (0);
    i := copen (n, 0);
    IF i > 0
    THEN BEGIN
      cclose (i);
      fexists := true
    END
    ELSE fexists := false
  END   (* fexists *);
 
FUNCTION validfilename (n : filename) : boolean;
 
  BEGIN   (* validfilename *)
    validfilename := true
  END   (* validfilename *);
 
 
PROCEDURE value;
 
  TYPE ch19 = PACKED ARRAY [1..19] OF char;
 
  VAR i : -1..bin;
 
  PROCEDURE add19 (s : ch19);
 
    VAR j : 1..19;
 
    BEGIN   (* add19 *)
      FOR j := 1 TO 19 DO inttoloc [i + j] := s [j];
      i := i + 19
    END   (* add19 *);
 
  BEGIN   (* value *)
    i := blk - 1;
    add19 (' abcdefghijklmnopqr');
    add19 ('stuvwxyzABCDEFGHIJK');
    add19 ('LMNOPQRSTUVWXYZ''()*');
    add19 ('+,-.:;<=>[/]0123456');
    add19 ('789!"#$%&?@\^_`{|}~')
  END   (* value *);
 
 
PROCEDURE erase (VAR f : buffile; fi : fileindex);
 
  BEGIN   (* erase *)
    IF fi <> inpfile THEN
    BEGIN
      rewrite (f);
      close (f, 'PURGE')
    END
    ELSE close (input, 'PURGE');
    fstatus [fi] := closed;
    factive [fi] := false
  END   (* erase *);
 
PROCEDURE closefiles;
 
  VAR f : fileindex;
 
  BEGIN   (* closefiles *)
    FOR f := altfile TO in2file DO
      IF fstatus [f] <> closed THEN
      CASE f OF
        outfile : close (output, 'SAVE');
        comfile : BEGIN
                    writeln (compile); close (compile, 'SAVE')
                  END;
        modfile : BEGIN
                    writeln (getmod); close (getmod, 'SAVE')
                  END;
        srcfile : BEGIN
                    writeln (source); close (source, 'SAVE')
                  END;
        altfile : close (altpl);
        nplfile : close (newpl, 'SAVE');
        oplfile : close (oldpl);
        inpfile : close (input);
        in2file : close (input2);
        tpyfile : erase (z1, tpyfile);
        tpzfile : erase (z2, tpzfile)
      END   (* case *);
    IF suppressnewpl THEN halt (19)
  END   (* closefiles *);
 
PROCEDURE rwfile (fi : fileindex);
 
  BEGIN   (* rwfile *)
    CASE fi OF
      outfile : BEGIN
                  terminalio := NOT printerchars;
                  page := 0; pagelength := 0;
                  rewrite (output, fname [outfile])
                END;
      nplfile : rewrite (newpl, fname [nplfile]);
      tpyfile : open (z1);
      tpzfile : open (z2);
      comfile : rewrite (compile, fname [comfile]);
      srcfile : rewrite (source, fname [srcfile]);
      modfile : rewrite (getmod, fname [modfile])
    END   (* case *);
    fstatus [fi] := opwrite
  END   (* rwfile *);
 
PROCEDURE position (VAR f : buffile; i : bignumber);
 
  VAR j : 0..bufbytes;
 
  BEGIN   (* position *)
    IF readrec + 1 <> i THEN
      seek (f, i);
    readrec := i;
    IF eof (f) THEN
      FOR j := 0 TO bufbytes DO filebuf [readfile, j] := chr (0)
    ELSE BEGIN
      get (f);
      filebuf [readfile] := f @
    END
  END   (* position *);
 
PROCEDURE setreadfile (f : fileindex; i, j : bignumber);
 
  BEGIN   (* setreadfile *)
    IF readfile <> f THEN
    BEGIN
      IF readfile <> inpfile THEN
      BEGIN
        fwhere [readfile] := readrec;
        findex [readfile] := readloc
      END;
      readfile := f;
      readrec := fwhere [f]
    END;
    IF readrec <> i THEN
      CASE f OF
        altfile : position (altpl, i);
        nplfile : position (newpl, i);
        oplfile : position (oldpl, i);
        tpyfile : position (z1, i);
        tpzfile : position (z2, i)
      END;
    readloc := j
  END   (* setreadfile *);
 
FUNCTION getbyte : byte;
 
  BEGIN   (* getbyte *)
    IF readloc > bufbytes THEN
      setreadfile (readfile, readrec + readloc DIV bufbytep1,
        readloc MOD bufbytep1);
    getbyte := ord (filebuf [readfile, readloc]);
    readloc := readloc + 1
  END   (* getbyte *);
 
PROCEDURE getname (a : fivebits);
 
  VAR i : 1..alfaleng;
 
  BEGIN   (* getname *)
    word := blanks;
    FOR i := 1 TO a DO
      word [i] := chr (getbyte)
  END   (* getname *);
 
PROCEDURE ensure (skip, data : fivebits);
 
  VAR i : linerange;
 
  BEGIN   (* ensure *)
    IF terminalio THEN IF page <> 0 THEN pagelength := pagesize;
    IF skipflag THEN
    BEGIN
      skipflag := false;
      IF skip = 0 THEN skip := 1
    END;
    IF pagelength + skip + data > 0 THEN
    BEGIN
      IF page > 9999 THEN page := 1
      ELSE page := page + 1;
      IF listwidth < 57 THEN i := 1
      ELSE i := listwidth - 56;
      IF page < 10 THEN i := i + 3
      ELSE IF page < 100 THEN i := i + 2
      ELSE IF page < 1000 THEN i := i + 1;
      IF i < 9 THEN i := 9;
      IF NOT terminalio THEN write ('1');
      writeln ('UPDATEPL  (', version, ' -- (C) MCC ', compdate:8,
        ')', today:i, now:10, 'Page ':7, page:1);
      IF terminalio THEN
      BEGIN
        writeln; writeln
      END
      ELSE writeln ('0');
      pagelength := pagesize
    END
    ELSE BEGIN
      pagelength := pagelength + skip + ord (data > 0);
      WHILE skip > 1 DO
      BEGIN
        IF terminalio THEN
        BEGIN
          writeln; writeln
        END
        ELSE writeln ('0');
        skip := skip - 2
      END;
      IF skip > 0 THEN writeln
    END;
    IF NOT terminalio THEN write (' ')
  END   (* ensure *);
 
PROCEDURE fwwrite (w : alfa; skip : boolean);
 
  VAR i : 1..alfaleng;
     ch : intchar;
 
  BEGIN   (* fwwrite *)
    FOR i := 1 TO alfaleng DO
    BEGIN
      ch := ord (w [i]);
      IF ch = blk THEN
      BEGIN
        IF NOT skip THEN write (' ')
      END
      ELSE write (inttoloc [ch + lcz])
    END
  END   (* fwwrite *);
 
PROCEDURE error;
 
  BEGIN   (* error *)
    ensure (0, 2);
    write ('***** ')
  END   (* error *);
 
PROCEDURE flagline (e : errortype);
 
  VAR r, s : linerange;
 
  BEGIN   (* flagline *)
    key := nullk;
    error;
    IF nextin > listwidth - 5 THEN r := nextin + 5 - listwidth
    ELSE r := 1;
    IF longth - r > listwidth THEN longth := listwidth + r;
 
    CASE e OF
       badcline : write ('Unknown, repeated, or inconsistent ',
                    'option on the command line.');
      baddirect : write ('A blank or comma must follow a number.');
  alreadyexists : write ('An element with this name already exists.');
   doesnotexist : write ('No element with this name exists.');
       notadeck : write ('This is not the name of a deck.');
  inappropriate : write ('This line is not expected at this point ',
                    'in the INPUT file:');
  ignoretherest : write ('This directive is not processed after ',
                    'this point on the line:');
     notanident : write ('This is not the name of a ',
                    'modification.');
  doesnotfollow : write ('This does not follow the first element ',
                    'of the series.');
     nofilename : write ('A file name is expected at this point.');
    badfilename : write ('You have not specified a valid file name.');
   lineexpected : write ('This is not the correct format for a ',
                    'line reference.');
   noabbreviate : write ('A reference cannot be abbreviated at this ',
                    'point.');
      noparenth : write ('A hyphen ''-'' is expected here.');
  badlinenumber : write ('This is not a legitimate line number.');
   declareerror : write ('This does not belong to the declared deck.');
       twodecks : write ('The two lines belong to different decks.');
     noreadfile : write ('No such file exists.');
     notfiledes : write ('This is not a correct file designator.');
       notaname : write ('A legitimate name is expected here.');
          comma : write ('This directive is not completely ',
                    'specified.');
   illegitimate : write ('This is illegitimate in the present ',
                    'context.');
      notifparm : write ('DEF, DECK, or IDENT is expected.');
       badvalue : write ('You must specify an argument in the ',
                    'appropriate range.');
        novalue : write ('You must specify a number.');
      nopointer : write ('The argument must be ''@'' or ''^''.')
    END   (* case *);
 
    writeln;
    ensure (0, 2);
    IF terminalio THEN write (' ');
    FOR s := r TO longth DO write (bline [s]);
    IF e <> inappropriate THEN
    BEGIN
      writeln;
      IF r >= nextin THEN r := nextin - 1;
      write (' ':nextin - r, '$');
      pagelength := pagelength + 1
    END;
    writeln
  END   (* flagline *);
 
PROCEDURE fatal (e : errortype);
 
  VAR r : integer;
 
  BEGIN   (* fatal *)
    IF NOT (e IN [badcline, badfilename, badvalue, noparenth]) THEN
      error
    ELSE IF key <> nullk THEN flagline (e);
    CASE e OF
            badopl : BEGIN
                       write ('An old program library file ',
                         'does not have the correct format.');
                       r := 32
                     END;
           bigfile : BEGIN
                       write ('The new program library requires ',
                         'too many records.');
                       r := 22
                     END;
       badmasterch : BEGIN
                     write ('The ALTPL file requires the parameter ''',
                         '-* ',
                         inttoloc [ord (filebuf [altfile, 1]) + lcz],
                         '''.');
                       r := 31
                     END;
        toomanyifs : BEGIN
                       write ('Too many nested *IF blocks.');
                       r := 21
                     END;
        toomanyids : BEGIN
                       write ('Too many decks, common decks, and ',
                         'modifications.');
                       r := 23
                     END;
      toomanylines : BEGIN
                       r := 25;
                       write ('Too many numbered lines ',
                         'in deck or modification ');
                       fwwrite (thisdeckname, true);
                       write ('.')
                     END
           OTHERWISE r := 24
    END   (* case *);
    writeln;
    closefiles;
    halt (r)
  END   (* fatal *);
 
PROCEDURE setwritefile (f : fileindex);
 
  VAR i : 0..7;
 
  BEGIN   (* setwritefile *)
    IF writefile <> f THEN
    BEGIN
      fwhere [writefile] := writerec;
      findex [writefile] := writeloc;
      writefile := f;
      IF fstatus [f] <> opwrite THEN
      BEGIN
        rwfile (f);
        fwhere [f] := 1;
        IF f = nplfile THEN
        BEGIN
          findex [nplfile] := 8;
          FOR i := 0 TO 7 DO filebuf [nplfile, i] := chr (0)
        END
        ELSE findex [f] := 0
      END;
      writerec := fwhere [f];
      writeloc := findex [f]
    END
  END   (* setwritefile *);
 
PROCEDURE putbyte (b : byte);
 
  BEGIN   (* putbyte *)
    filebuf [writefile, writeloc] := chr (b);
    IF writeloc < bufbytes THEN writeloc := writeloc + 1
    ELSE BEGIN
      writeloc := 0;
      IF writerec = maxfilerec THEN fatal (bigfile);
      writerec := writerec + 1;
      fstatus [writefile] := opwrite;
      CASE writefile OF
        nplfile : BEGIN
                    newpl @ := filebuf [nplfile];
                    put (newpl)
                  END;
        tpyfile : BEGIN
                    z1 @ := filebuf [tpyfile];
                    put (z1)
                  END;
        tpzfile : BEGIN
                    z2 @ := filebuf [tpzfile];
                    put (z2)
                  END
      END   (* case *)
    END
  END   (* putbyte *);
 
PROCEDURE flush (fi : fileindex);
 
  BEGIN   (* flush *)
    setwritefile (fi);
    IF writeloc > 0 THEN
    BEGIN
      writeloc := bufbytes;
      putbyte (0)
    END;
    writerec := writerec - 1;
    fsize [fi] := writerec;
    setwritefile (outfile);
    fwhere [fi] := 2;
    fstatus [fi] := opread;
    setreadfile (fi, 1, 0)
  END   (* flush *);
 
PROCEDURE putdouble (i : bignumber);
 
  BEGIN   (* putdouble *)
    putbyte (i DIV bytep1);
    putbyte (i MOD bytep1)
  END   (* putdouble *);
 
PROCEDURE putname (w : alfa; l : fivebits);
 
  VAR i : 0..alfaleng;
 
  BEGIN   (* putname *)
    i := 0;
    WHILE l > i DO
    BEGIN
      i := i + 1;
      putbyte (ord (w [i]))
    END
  END   (* putname *);
 
PROCEDURE copyline;
 
  VAR i, j : bytep1r;
 
  BEGIN   (* copyline *)
    i := ord (iline [1]); putbyte (i);
    FOR j := 2 TO i + 1 DO putbyte (ord (iline [j]))
  END   (* copyline *);
 
PROCEDURE createyankdeck;
 
  BEGIN   (* createyankdeck *)
    setwritefile (tpzfile);
    putbyte (deckk);
    putdouble (1);
    putbyte (0);
    WITH yankdeck @ DO
    BEGIN
      stlo := 0;
      ofil := tpzfile
    END
  END   (* createyankdeck *);
 
PROCEDURE list;
 
  VAR bits : 0..12;
    bitval : bitvaltp;
       val : fivebits;
   i, bloc : bytep1r;
         j : bignumber;
     count : idnumber;
     shift : 0..3;
   ch1, ch : char;
         c : intchar;
   strflag : boolean;
 
  PROCEDURE getval;
 
    VAR j : bitvaltp;
        k : 0..7;
 
    BEGIN   (* getval *)
      IF bits < 5 THEN
      BEGIN
        bloc := bloc + 1;
        IF bloc <= i THEN
          bitval := (bitval MOD 16) * bytep1 + ord (iline [bloc])
        ELSE bitval := (bitval MOD 16) * bytep1;
        bits := bits + bitsperbyte
      END;
      j := bitval; bitval := bitval MOD halfbyte;
      bits := bits - 5; k := bits;
      WHILE k > 0 DO
      BEGIN
        k := k - 1; j := j DIV 2
      END;
      val := j MOD 32
    END   (* getval *);
 
  PROCEDURE transfer (s : PACKED ARRAY [j..k : fivebits] OF char);
 
    VAR i, l : fivebits;
 
    BEGIN   (* transfer *)
      l := k - j + 1;
      FOR i := 1 TO l DO
        bline [longth + i] := s [i];
      longth := longth + l
    END   (* transfer *);
 
  PROCEDURE wtransfer (word : alfa);
 
    LABEL 1;
 
    VAR i : 1..alfaleng;
       ch : char;
 
    BEGIN   (* wtransfer *)
      FOR i := 1 TO alfaleng DO
      BEGIN
        ch := word [i];
        IF ord (ch) = 0 THEN GOTO 1;
        longth := longth + 1;
        bline [longth] := inttoloc [ord (ch) + lcz]
      END;
1:   END   (* wtransfer *);
 
  PROCEDURE putnumber (n : bignumber);
 
    VAR i : 0..5;
        d : ARRAY [1..5] OF char;
 
    BEGIN   (* putnumber *)
      i := 0;
      REPEAT
        i := i + 1; d [i] := chr (n MOD 10 + ord ('0'));
        n := n DIV 10
      UNTIL n = 0;
      REPEAT
        longth := longth + 1;
        bline [longth] := d [i]; i := i - 1
      UNTIL i = 0
    END   (* putnumber *);
 
  BEGIN   (* list *)
    longth := 1;
    bline [1] := masterch;
    CASE key OF
           nullk : BEGIN
                     longth := 2;
                     bline [longth] := commentch;
                     transfer (' End of modification ')
                   END;
        commentk : BEGIN
                     longth := 3;
                     bline [2] := commentch;
                     bline [3] := ' '
                   END;
   blankk, datak : longth := 0;
endtextk, specialk : ;
           datek : transfer ('DATE ');
           timek : transfer ('TIME ');
          widthk : BEGIN
                     transfer ('WIDTH ');
                     IF newdwid <> 1 THEN putnumber (newdwid);
                     IF newswid <> 1 THEN
                     BEGIN
                       longth := longth + 1; bline [longth] := ',';
                       putnumber (newswid)
                     END
                   END;
           elsek : transfer ('ELSE');
          endifk : transfer ('ENDIF');
        compfilk : transfer ('COMPFILE ');
             dok : transfer ('DO ');
           dontk : transfer ('DONT ');
           callk : transfer ('CALL ');
         definek : transfer ('DEFINE ');
          ifdefk : transfer ('IF DEF,');
         ifdeckk : transfer ('IF DECK,');
        ifidentk : transfer ('IF IDENT,');
         ifndefk : transfer ('IF -DEF,');
        ifndeckk : transfer ('IF -DECK,');
        ifnidntk : transfer ('IF -IDENT,');
        comdeckk : transfer ('COMDECK ');
           deckk : transfer ('DECK ');
        yankdckk : transfer ('YANKDECK ');
           yankk : transfer ('YANK ');
        selyankk : transfer ('SELYANK ');
         beforek : transfer ('B ');
         deletek : transfer ('D ');
        restorek : transfer ('R ');
         insertk : transfer ('I ');
          identk : transfer ('IDENT ');
        declarek : transfer ('DECLARE ');
        pointatk : transfer ('POINTER @');
        pointupk : transfer ('POINTER ^');
          upperk : transfer ('UPPER')
    END   (* case *);
    IF key IN [beforek..insertk] THEN
    BEGIN
      wtransfer (firstref @.name);
      longth := longth + 1; bline [longth] := '.';
      putnumber (firstline);
      IF (key = deletek) OR (key = restorek) THEN
        IF (firstline <> secondline) OR (firstref <> secondref) THEN
        BEGIN
          longth := longth + 1; bline [longth] := ',';
          IF firstref <> secondref THEN
          BEGIN
            wtransfer (secondref @.name);
            longth := longth + 1; bline [longth] := '.'
          END;
          putnumber (secondline)
        END;
      IF ord (iline [1]) > 0 THEN
      BEGIN
        transfer ('   ');
        key := commentk
      END
    END
    ELSE IF key IN [dok..declarek, nullk]
    THEN BEGIN
      wtransfer (word);
      IF key = selyankk
      THEN BEGIN
        longth := longth + 1; bline [longth] := '.';
        wtransfer (thisdeckname)
      END
      ELSE IF key = nullk
      THEN BEGIN
        longth := longth + 1; bline [longth] := '.';
        key := callk
      END
    END;
 
    IF key < widthk THEN IF key <> blankk THEN
    BEGIN
      bits := 0;
      bitval := 0;
      bloc := 1;
      shift := 1;
      count := 0;
      ch := ' ';
      i := ord (iline [1]) + 1;
      REPEAT
        getval;
        IF val = 0 THEN
        BEGIN
          getval; ch := ' ';
          IF val > 15 THEN
          BEGIN
            j := val MOD byteoverflow; count := 1;
            getval;
            ch := chr (j * 32 + val)
          END
        END   (* val = 0 *)
        ELSE IF val > 26 THEN
          CASE val OF
            27 : BEGIN ch := ' '; count := 1 END;
            28 : BEGIN
                   count := count + 2;
                   REPEAT
                     getval;
                     count := count + val
                   UNTIL val < 31
                 END;
            29 : shift := (shift + 1) MOD 4;
            30 : shift := (shift + 2) MOD 4;
            31 : shift := (shift + 3) MOD 4
          END   (* case *)
        ELSE BEGIN
          ch := inttoloc [val + offsets [shift]]; count := 1
        END;
        WHILE count > 0 DO
        BEGIN
          count := count - 1;
          longth := longth + 1;
          bline [longth] := ch;
          IF longth = bytesize THEN
            count := 0
        END
      UNTIL (bloc > i) AND (bitval = 0)
    END;
    IF longth = 0 THEN
    BEGIN
      longth := 1; bline [1] := ' '
    END;
 
    IF key IN sourcelist THEN IF lineactive THEN
    BEGIN
      IF fstatus [srcfile] = closed THEN
        rwfile (srcfile)
      ELSE writeln (source);
      IF key = specialk THEN
      BEGIN
        IF NOT textinput THEN
        BEGIN
          textinput := true;
          writeln (source, masterch, 'TEXT')
        END
      END
      ELSE IF key <> datak THEN
        IF textinput THEN
        BEGIN
          textinput := false;
          writeln (source, masterch, 'ENDTEXT')
        END;
      write (source, bline : longth)
    END   (* source file *);
 
    IF key IN listing THEN
      IF (listinactive AND NOT lineactive) OR
        (lineactive AND (listactive OR
        listdirectives AND (key >= compfilk) AND
        ((skippedifs = 0) OR
          (skippedifs = 1) AND ((key = elsek) OR (key = endifk)) OR
          (key = dok) OR (key = dontk))))
      THEN BEGIN
        ensure (0, 1);
        IF seqflag THEN
          IF lineactive THEN
          BEGIN
            IF dlinenum = maxdline THEN dlinenum := 0
            ELSE dlinenum := dlinenum + 1;
            write (dlinenum:5, ' ')
          END
          ELSE write (' ':6);
        IF longth < listwidthm15 THEN
          write (bline:longth, ' ':listwidthm15 - longth, ' ')
        ELSE write (bline:listwidthm15, ' ');
        FOR i := 1 TO alfaleng DO
        BEGIN
          c := ord (identword [i]);
          IF c = blk THEN write (' ')
          ELSE write (inttoloc [c + lcz])
        END;
        write (linenum : 6);
        IF listinactive THEN
          IF lineactive THEN write (' A')
          ELSE write (' I');
        writeln
      END   (* list output file *);
 
    IF key IN pullingmods THEN BEGIN
      IF fstatus [modfile] = closed THEN
        rwfile (modfile)
      ELSE writeln (getmod);
      IF key = specialk THEN
      BEGIN
        IF NOT textinput THEN
        BEGIN
          textinput := true;
          writeln (getmod, masterch, 'TEXT')
        END
      END
      ELSE IF key <> datak THEN
        IF textinput THEN
        BEGIN
          textinput := false;
          writeln (getmod, masterch, 'ENDTEXT')
        END;
      write (getmod, bline : longth)
    END   (* pullmod file *);
 
    IF key IN compiling THEN IF lineactive THEN
      IF skippedifs = 0 THEN
      BEGIN
        IF fstatus [comfile] = closed THEN
          rwfile (comfile)
        ELSE writeln (compile);
 
        IF (key = datek) OR (key = timek) THEN
        BEGIN
          i := 7;
          IF i <= longth THEN
          BEGIN
            ch1 := bline [i];
            REPEAT
              i := i + 1;
              IF i > longth THEN
              BEGIN
                ch := ch1; longth := i
              END
              ELSE BEGIN
                ch := bline [i];
                bline [i - 7] := ch
              END
            UNTIL ch = ch1;
            i := i - alfaleng
          END
          ELSE BEGIN
            i := 0; longth := alfaleng
          END;
          IF key = datek THEN word := today
          ELSE word := now;
          FOR j := 1 TO alfaleng DO
            bline [j + i] := word [j]
        END   (* key = datek or timek *);
 
        IF longth > curdatawid THEN longth := curdatawid;
          IF uppercase THEN
            FOR i := 1 TO longth DO
              IF bline [i] IN ['a'..'i', 'j'..'r', 's'..'z'] THEN
                bline [i] :=
                  chr (ord (bline [i]) + ord ('A') - ord ('a'));
        IF pascflag THEN
        BEGIN
          strflag := false;
          FOR i := 1 TO longth DO
            IF bline [i] = '''' THEN strflag := NOT strflag
            ELSE IF NOT strflag THEN
              IF bline [i] = oldpch
              THEN bline [i] := newpch
        END;
        IF curseqwid >= 5 THEN
        BEGIN
          FOR i := longth + 1 TO curcompwid DO
            bline [i] := ' ';
          IF curseqwid > 5 THEN
          BEGIN
            IF curseqwid > 14 THEN
              longth := curcompwid - 14
            ELSE longth := curdatawid;
            wtransfer (identword)
          END;
          j := linenum;
          i := curcompwid; longth := i;
          REPEAT
            bline [i] := chr (j MOD 10 + ord ('0'));
            j := j DIV 10; i := i - 1
          UNTIL j = 0;
          IF i > curdatawid THEN bline [i] := ' '
        END;
        write (compile, bline:longth)
      END   (* compile file *)
  END   (* list *);
 
PROCEDURE directorylisting;
 
  VAR wi : bytep1r;
   group : 1..3;
    head : boolean;
      id : ident;
 
  PROCEDURE traverse (nd : node);
 
    BEGIN   (* traverse *)
      WHILE nd <> NIL DO WITH nd @, who @ DO
      BEGIN
        IF arm [false] <> NIL THEN traverse (arm [false]);
        IF idno <> 1 THEN
          IF kind < 5 THEN
          BEGIN
            IF wi > listwidth - (alfaleng + 2) THEN
            BEGIN
              wi := alfaleng;
              IF head THEN
              BEGIN
                writeln;
                ensure (0, 1)
              END
              ELSE BEGIN
                ensure (2, 6);
                writeln ('Common decks, decks, and ',
                  'modifications:');
                IF terminalio THEN
                  writeln
                ELSE write ('0');
                pagelength := pagelength + 2;
                head := true
              END
            END
            ELSE BEGIN
              write ('  '); wi := wi + alfaleng + 2
            END;
            fwwrite (name, false)
          END;
        nd := arm [true]
      END
    END   (* traverse *);
 
  BEGIN   (* directorylisting *)
    wi := listwidth; head := false;
    traverse (nmtree);
 
    FOR group := 1 TO 3 DO
    BEGIN
      wi := listwidth; head := false;
      id := first [group];
      WHILE id <> NIL DO WITH id @ DO
      BEGIN
        IF odd (data) THEN IF NOT odd (data DIV 4) THEN
        BEGIN
          IF wi > listwidth - (alfaleng + 2) THEN
          BEGIN
            wi := alfaleng;
            IF head THEN
            BEGIN
              writeln;
              ensure (0, 1)
            END
            ELSE BEGIN
              writeln;
              ensure (2, 6);
              IF group = 1 THEN writeln
                ('Common decks:')
              ELSE IF group = 2 THEN writeln
                ('Decks in order of compilation:')
              ELSE writeln
                ('Modifications in historical order:');
              IF terminalio THEN
                writeln
              ELSE write ('0');
              pagelength := pagelength + 2;
              head := true
            END
          END
          ELSE BEGIN
            write ('  '); wi := wi + alfaleng + 2
          END;
          fwwrite (name, false)
        END;
        id := next
      END
    END;
    writeln;
    skipflag := true
  END   (* directorylisting *);
 
PROCEDURE search (no : node);
 
(* Call with found := false; idsearch := (true or false).
   Make secondary true to insert or to search for ALTPL mods *)
 
  VAR br : boolean;
      id : ident;
      nd : node;
 
  BEGIN   (* search *)
    WITH no @, who @ DO
    BEGIN
      IF idsearch THEN
        IF idno > curid THEN br := false
        ELSE IF idno < curid THEN br := true
        ELSE IF secondary AND (kind < 4) THEN
          br := false
        ELSE found := true
      ELSE IF name > identword THEN br := false
      ELSE IF name < identword THEN br := true
      ELSE found := true;
 
      IF found THEN
      BEGIN
        bigger := false; curdesc := who
      END
      ELSE IF arm [br] = NIL THEN
        IF addflag THEN
        BEGIN
          IF idsearch = (curkind = 5) THEN
          BEGIN
            CASE curkind OF
              1 : new (curdesc, true, 1, true);
              2 : new (curdesc, true, 2, false);
              3 : new (curdesc, true, 3);
              4 : new (curdesc, true, 1, false);
              5 : new (curdesc, false)
            END   (* case *);
            IF newflag THEN
              IF maxid = maxident THEN fatal (toomanyids)
              ELSE BEGIN
                maxid := maxid + 1;
                curid := maxid
              END;
            IF curkind < 4 THEN
            BEGIN
              IF first [curkind] = NIL THEN
                first [curkind] := curdesc
              ELSE last [curkind] @.next := curdesc;
              last [curkind] := curdesc
            END;
            WITH curdesc @ DO
            BEGIN
              name := identword;
              idno := curid;
              kind := curkind;
              data := ord (fullmode AND (curkind < 3));
              IF fullrestruct THEN IF curkind = 3 THEN data := 10;
              IF kind <> 5 THEN
              BEGIN
                strc := 0;
                stlo := 0;
                IF kind = 4 THEN chgs := NIL
                ELSE BEGIN
                  mxrc := 0;
                  next := NIL;
                  ofil := oplfile;
                  IF kind = 3 THEN
                  BEGIN
                    bfor := NIL;
                    afct := NIL
                  END
                  ELSE BEGIN
                    dlst := NIL;
                    chgs := NIL;
                    IF kind = 1 THEN
                    BEGIN
                      strb := 0;
                      stlb := 0
                    END
                  END
                END
              END
            END   (* with curdesc *);
            IF curkind <> 5 THEN
            BEGIN
              idsearch := true; secondary := curkind = 4;
              search (idtree); idsearch := false
            END
          END;
          bigger := true;
          new (nd);
          arm [br] := nd;
          WITH nd @ DO
          BEGIN
            arm [false] := NIL; arm [true] := NIL;
            who := curdesc;
            bal := 1
          END
        END   (* addflag *)
        ELSE bigger := false
      ELSE search (arm [br]);
 
      IF bigger THEN
        IF bal = 1 THEN
          bal := 2 * ord (br)
        ELSE IF bal = 2 * ord (NOT br) THEN
        BEGIN
          bigger := false; bal := 1
        END
        ELSE BEGIN
          bigger := false;
          bal := 1;
          IF arm [br] @.bal = 2 * ord (br) THEN    (* single rotation *)
          BEGIN
            WITH arm [br] @ DO
            BEGIN
              bal := 1;
              nd := arm [br];
              arm [br] := arm [NOT br];
              arm [NOT br] := no @.arm [NOT br];
              id := who;
              who := no @.who
            END;
            who := id;
            arm [NOT br] := arm [br];
            arm [br] := nd
          END
          ELSE BEGIN                               (* double rotation *)
            nd := arm [NOT br];
            arm [NOT br] := arm [br] @.arm [NOT br];
            WITH arm [br] @ DO
            BEGIN
              IF arm [NOT br] @.bal = 2 * ord (NOT br)
              THEN bal := 2 * ord (br)
              ELSE bal := 1;
              arm [NOT br] := arm [NOT br] @.arm [br]
            END;
            WITH arm [NOT br] @ DO
            BEGIN
              IF bal = 2 * ord (br) THEN bal := 2 - bal
              ELSE bal := 1;
              arm [br] := arm [NOT br];
              arm [NOT br] := nd;
              id := who;
              who := no @.who
            END;
            who := id
          END   (* double rotation *)
        END   (* else *)
    END   (* with *)
  END   (* search *);
 
PROCEDURE addcall (id : ident; dn : alfa; count : ccount);
 
  LABEL 1;
 
  VAR n1, n2 : namelist;
           i : -1..maxfilerec;
 
  BEGIN   (* addcall *)
    i := count;
    n2 := NIL;
    WITH id @ DO
    BEGIN
      n1 := dlst;
      WHILE n1 <> NIL DO WITH n1 @ DO
        IF nname > dn THEN n1 := NIL
        ELSE BEGIN
          n2 := n1; n1 := nnext
        END;
      IF n2 <> NIL THEN
1:      WITH n2 @ DO
          IF nname = dn THEN
          BEGIN
            i := nnumb + count;
            IF i <= 0 THEN
            BEGIN
              IF nnext <> NIL THEN
              BEGIN
                n1 := nnext; nname := nnext @.nname;
                nnumb := nnext @.nnumb;
                nnext := nnext @.nnext; dispose (n1);
                n1 := NIL;
                IF nname = dn THEN GOTO 1
              END
            END
            ELSE IF i <= bytesize THEN
            BEGIN
              nnumb := i; i := 0
            END
            ELSE BEGIN
              nnumb := bytesize;
              i := i - bytesize
            END
          END   (* if nname = dn *);
 
      WHILE i > 0 DO
      BEGIN
        new (n1);
        WITH n1 @ DO
        BEGIN
          nname := dn;
          IF n2 = NIL THEN
          BEGIN
            nnext := dlst; dlst := n1
          END
          ELSE BEGIN
            nnext := n2 @.nnext; n2 @.nnext := n1
          END;
          IF i <= bytesize THEN
          BEGIN
            nnumb := i; i := 0
          END
          ELSE BEGIN
            nnumb := bytesize; i := i - bytesize
          END
        END
      END   (* while i <> 0 *)
    END
  END   (* addcall *);
 
PROCEDURE addmodtodeck (dk : ident; ct : changetyp; fi : idnumber;
    fn : bignumber; si : idnumber; sn : bignumber; id : idnumber);
 
  VAR c1, c2 : changes;
    cta, ctb : changetyp;
 
  BEGIN   (* addmodtodeck *)
    c2 := NIL;
    IF ct = restore THEN cta := delete
    ELSE cta := ct;
    WITH dk @ DO
    BEGIN
      c1 := chgs;
      WHILE c1 <> NIL DO WITH c1 @ DO
      BEGIN
        IF ckind = restore THEN ctb := delete
        ELSE ctb := ckind;
        IF cta < ctb THEN c1 := NIL
        ELSE IF cta > ctb THEN
        BEGIN
          c2 := c1; c1 := cnext
        END
        ELSE IF fi < startid THEN c1 := NIL
        ELSE IF fi > startid THEN
        BEGIN
          c2 := c1; c1 := cnext
        END
        ELSE IF fn < startno THEN c1 := NIL
        ELSE IF fn > startno THEN
        BEGIN
          c2 := c1; c1 := cnext
        END
        ELSE IF (cta = insert) AND (id <> mdwho) THEN c1 := NIL
        ELSE BEGIN
          c2 := c1; c1 := cnext
        END
      END;
      new (c1);
      WITH c1 @ DO
      BEGIN
        startid := fi;
        startno := fn;
        ckind := ct;
        locus := sn;
        where := si;
        mdwho := id;
        IF c2 = NIL THEN
        BEGIN
          cnext := chgs; chgs := c1
        END
        ELSE BEGIN
          cnext := c2 @.cnext; c2 @.cnext := c1
        END
      END
    END
  END   (* addmodtodeck *);
 
PROCEDURE addmodtomod (id, dk : ident; lin : bignumber);
 
  VAR m1, m2, m3, m4 : decklist;
                   l : bignumber;
 newflag, createflag : boolean;
 
  BEGIN   (* addmodtomod *)
    m3 := NIL; m4 := m3; l := 0;
    createflag := false;
    newflag := true;
    WITH id @ DO
    BEGIN
      m2 := afct; m1 := m2;
      WHILE m1 <> NIL DO WITH m1 @ DO
        IF lin < where THEN
          IF factive [nplfile] THEN
          BEGIN
            suppressnewpl := true;
            error;
            writeln ('NEWPL file suppressed.');
            erase (newpl, nplfile);
            writeln (' Your old program library was created by ',
              'an early version of UPDATEPL');
            writeln (' and is partly in a format which is no ',
              'longer supported.   Please use');
            writeln (' the  ''R''  option  on  the command line to ',
              'recover the source of this');
            writeln (' program library, then use UPDATEPL to ',
              'rewrite the library.');
            fatal (badopl)
          END
          ELSE m1 := NIL
        ELSE IF (adeck = dk) AND (dk <> NIL) THEN
        BEGIN
          newflag := false;
          lin := lin - mxrc;
          mxrc := mxrc + lin;
          IF lin = 0 THEN m1 := NIL
          ELSE REPEAT
            WITH m1 @ DO
            BEGIN
              where := where + lin;
              m1 := anext
            END
          UNTIL m1 = NIL
        END
        ELSE BEGIN
          m4 := m3; m3 := m2;
          m2 := anext; m1 := m2
        END;
      IF m4 <> NIL THEN l := m4 @.where;
 
      IF newflag THEN IF m3 = NIL THEN createflag := true
      ELSE WITH m3 @ DO
        IF m2 = NIL THEN
          IF adeck = dk THEN where := lin
          ELSE createflag := true
        ELSE IF lin = l + 1 THEN
          IF adeck = dk THEN
          BEGIN
            where := lin;
            IF m2 @.where = lin THEN
            BEGIN
              anext := m2 @.anext;
              dispose (m2)
            END
          END
          ELSE WITH m2 @ DO
            IF where = lin THEN adeck := dk
            ELSE createflag := true
        ELSE IF m2 @.where = lin THEN
        BEGIN
          m3 := m2;
          m2 @.where := lin - 1;
          m2 := m2 @.anext;
          createflag := true
        END
        ELSE BEGIN
          new (m4);
          WITH m4 @ DO
          BEGIN
            adeck := m2 @.adeck;
            where := lin - 1
          END;
          IF m3 = NIL THEN afct := m4
          ELSE m3 @.anext := m4;
          m3 := m4;
          createflag := true
        END;
 
      IF createflag THEN
      BEGIN
        IF lin > mxrc THEN mxrc := lin;
        new (m4);
        WITH m4 @ DO
        BEGIN
          adeck := dk;
          where := lin;
          anext := m2
        END;
        IF m3 = NIL THEN afct := m4
        ELSE m3 @.anext := m4
      END   (* createflag *)
    END   (* with id *)
  END   (* addmodtomod *);
 
PROCEDURE setcompilebits;
 
  VAR id : ident;
 
  PROCEDURE addcbittocdecks (dl : namelist);
 
    BEGIN   (* addcbittocdecks *)
      WHILE dl <> NIL DO WITH dl @ DO
      BEGIN
        IF nname <> identword THEN
        BEGIN
          identword := nname;
          found := false; search (nmtree);
          IF found THEN WITH curdesc @ DO
            IF kind = 1 THEN IF odd (data DIV 4) THEN
              data := 4
            ELSE IF NOT odd (data) THEN
            BEGIN
              data := data + 1;
              IF dlst <> NIL THEN
                addcbittocdecks (dlst)
            END
        END;
        dl := nnext
      END
    END   (* addcbittocdecks *);
 
  BEGIN   (* setcompilebits *)
    yankdeck @.data := 1;
    identword := blanks; idsearch := false;
    id := first [2];
    WHILE id <> NIL DO WITH id @ DO
    BEGIN
      IF odd (data DIV 4) THEN data := 4
      ELSE IF chgs <> NIL THEN IF NOT odd (data) THEN
        IF chgs @.ckind < listd THEN data := data + 1;
      IF odd (data) THEN IF dlst <> NIL THEN
        addcbittocdecks (dlst);
      id := next
    END;
 
    id := first [1];
    WHILE id <> NIL DO WITH id @ DO
    BEGIN
      IF odd (data DIV 4) THEN data := 4
      ELSE IF chgs <> NIL THEN
        IF NOT odd (data) THEN
        BEGIN
          data := data + 1;
          IF dlst <> NIL THEN addcbittocdecks (dlst)
        END;
      id := next
    END
  END   (* setcompilebits *);
 
PROCEDURE writedirectory;
 
  LABEL 1;
 
  VAR group : 1..3;
      i, st : bignumber;
        stl : bufrange;
          j : 0..alfaleng;
         nd : ident;
         af : decklist;
         nl : namelist;
 
  FUNCTION wlen (w : alfa) : fivebits;
 
    LABEL 1;
 
    VAR i : 0..alfaleng;
 
    BEGIN   (* wlen *)
      i := alfaleng;
      REPEAT
        IF w [i] = chr (blk) THEN i := i - 1
        ELSE GOTO 1
      UNTIL i = 0;
1:    wlen := i
    END   (* wlen *);
 
  BEGIN   (* writedirectory *)
    setwritefile (nplfile);
    WHILE writeloc MOD bufmult <> 0 DO putbyte (0);
    st := writerec; stl := writeloc;
    FOR group := 1 TO 3 DO
    BEGIN
      nd := first [group];
      WHILE nd <> NIL DO WITH nd @ DO
      BEGIN
        IF odd (data) THEN IF NOT odd (data DIV 4) THEN
        BEGIN
          j := wlen (name);
          i := j + alfaleng * group - 1;
          IF group = 1 THEN IF odd (data DIV 2) THEN
            i := i + yankoffset;
          putbyte (i);
          putname (name, j);
          IF group = 1 THEN
          BEGIN
            strc := strb;
            stlo := stlb;
            ofil := nplfile
          END;
          putdouble (idno);
          putdouble (strc);
          putbyte (stlo DIV bufmult);
          IF group = 3 THEN
          BEGIN
            af := afct;
            WHILE af <> NIL DO WITH af @ DO
            BEGIN
              IF adeck = NIL THEN i := 0
              ELSE i := adeck @.idno;
              IF i > 1 THEN
              BEGIN
                curid := i; idsearch := true; found := false;
                search (idtree);
                IF found THEN WITH curdesc @ DO
                  IF NOT odd (data) THEN i := 0
                  ELSE IF odd (data DIV 4) THEN i := 0
                  ELSE BEGIN
                    IF odd (data DIV 8) THEN i := 0
                  END
                ELSE i := 0
              END;
              putbyte (i DIV bytep1 + halfbyte);
              putbyte (i MOD bytep1);
              putdouble (where);
              af := anext
            END
          END
          ELSE BEGIN
            putdouble (mxrc);
            nl := dlst;
            WHILE nl <> NIL DO WITH nl @ DO
            BEGIN
              j := wlen (nname) - 1; i := nnumb;
              WHILE i > 0 DO
                IF i >= comdoverflow THEN
                BEGIN
                  putbyte (j + comdoverflow * alfaleng);
                  putname (nname, j + 1);
                  i := i - comdoverflow
                END
                ELSE BEGIN
                  putbyte (j + i * alfaleng);
                  putname (nname, j + 1);
                  i := 0
                END;
              nl := nnext
            END
          END;
          putbyte (0)
        END   (* compile and do not purge *);
        nd := next
      END   (* while nd <> nil do with nd @ *)
    END   (* for group := 1 to 3 *);
 
    WHILE writeloc > 0 DO
    BEGIN
      IF filebuf [nplfile, writeloc - 1] <> chr (0) THEN GOTO 1;
      writeloc := writeloc - 1
    END;
1:  IF writeloc > 0 THEN
    BEGIN
      WHILE writeloc < bufbytes DO putbyte (0);
      filebuf [nplfile, bufbytes] := chr (0);
      newpl @ := filebuf [nplfile];
      put (newpl)
    END
    ELSE writerec := writerec - 1;
    fsize [nplfile] := writerec; fwhere [nplfile] := 1;
    fstatus [nplfile] := opread;
    open (newpl);
    seek (newpl, 1);
    get (newpl);
    newpl @ [0] := chr (loctoint [defmasterch] - lcz);
    newpl @ [1] := chr (loctoint [masterch] - lcz);
    newpl @ [2] := chr (loctoint [commentch] - lcz);
    newpl @ [3] := chr (writerec DIV bytep1);
    newpl @ [4] := chr (writerec MOD bytep1);
    newpl @ [5] := chr (st DIV bytep1);
    newpl @ [6] := chr (st MOD bytep1);
    newpl @ [7] := chr (stl DIV bufmult);
    filebuf [nplfile] := newpl @;
    seek (newpl, 1);
    write (newpl, filebuf [nplfile]);
    fwhere [nplfile] := 2;
    setreadfile (nplfile, 1, 0)
  END   (* writedirectory *);
 
FUNCTION lnumber (min, max : byte) : bytep1r;
 
  VAR i : idnumber;
 
  BEGIN   (* lnumber *)
    i := 0;
    WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
    WHILE bline [nextin] IN ['0'..'9'] DO
      BEGIN
        i := i * 10 + ord (bline [nextin]) - ord ('0');
        IF i > max THEN i := bytep1;
        nextin := nextin + 1
      END;
    IF i < min THEN lnumber := bytep1
    ELSE lnumber := i;
    word [1] := ' '
  END   (* lnumber *);
 
PROCEDURE getword;
 
  VAR i : 0..alfaleng;
      j : 1..bytep1;
     ch : intchar;
 
  BEGIN   (* getword *)
    word := blanks;
    i := 0;
    j := nextin;
    REPEAT
      IF j <= longth THEN
      BEGIN
        ch := line [j]; j := j + 1;
        IF ch IN [com, per, bin] THEN   (* ',', '.', binary *)
          ch := blk
        ELSE IF ch > lcz THEN
          ch := ch - lcz;
        IF ch <> blk THEN
        BEGIN
          i := i + 1; word [i] := chr (ch);
          IF i = alfaleng THEN ch := blk
        END
      END
      ELSE ch := blk
    UNTIL ch = blk;
    nextin := nextin + i;
    wlength := i
  END   (* getword *);
 
PROCEDURE getlword;
 
  VAR i : 0..alfaleng;
     ch : char;
 
  BEGIN   (* getlword *)
    word := blankword;
    i := 0;
    IF nextin > longth THEN nextin := longth + 1
    ELSE WHILE bline [nextin] = ' ' DO
      nextin := nextin + 1;
    nextword := nextin;
    REPEAT
      ch := bline [nextin];
      IF ch IN ['a'..'i', 'j'..'r', 's'..'z'] THEN
        ch := chr (ord (ch) + ord ('A') - ord ('a'))
      ELSE IF NOT (ch IN [
        'A'..'I', 'J'..'R', 'S'..'Z']) THEN ch := ' ';
      IF ch <> ' ' THEN
      BEGIN
        i := i + 1; word [i] := ch;
        IF nextin > longth THEN ch := ' '
        ELSE BEGIN
          nextin := nextin + 1;
          IF nextin > longth THEN ch := ' '
          ELSE IF i = alfaleng THEN ch := ' '
          ELSE ch := bline [nextin]
        END
      END
    UNTIL ch = ' ';
    wlength := i
  END   (* getlword *);
 
PROCEDURE getfname (f : files; rdmode, noequals : boolean);
 
  LABEL 1;
 
  VAR name : filename;
   wlength : bytep1r;
 
  PROCEDURE getlword;
 
    VAR i : 0..filnamlen;
        c : char;
        s : filename;
 
    BEGIN   (* getlword *)
      wlength := 0;
      IF nextin > longth THEN nextin := longth + 1
      ELSE WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
      nextword := nextin;
      c := bline [nextin];
      IF c = '-' THEN IF key <> compfilk THEN c := ' ';
      FOR i := 1 TO filnamlen DO
        IF c IN [chr (33)..pred (','), succ (',')..chr (126)]
        THEN BEGIN
          s [i] := c;
          wlength := i;
          nextin := nextin + 1;
          c := bline [nextin];
          IF c = ' ' THEN IF key = compfilk THEN c := '.'
        END
        ELSE s [i] := ' ';
      name := s
    END   (* getlword *);
 
  BEGIN   (* getfname *)
    WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
    getlword;
    IF wlength = 0 THEN
      IF f > inpfile THEN
      BEGIN
        flagline (nofilename); GOTO 1
      END
      ELSE BEGIN
        IF key = compfilk THEN flagline (badfilename)
        ELSE IF rdmode AND NOT fexists (fname [f])
        THEN flagline (noreadfile) ELSE
        factive [f] := true; GOTO 1
      END
    ELSE IF wlength = 1
    THEN IF (bline [nextword] = '0') AND (f = inpfile)
      THEN BEGIN
        fstatus [inpfile] := closed; factive [inpfile] := false;
        GOTO 1
      END;
    IF rdmode
    THEN BEGIN
      IF NOT fexists (name)
      THEN BEGIN
        flagline (noreadfile); GOTO 1
      END
    END
    ELSE IF NOT validfilename (name)
    THEN BEGIN
      flagline (badfilename); GOTO 1
    END
    ELSE IF f = dummy THEN GOTO 1;
    IF fstatus [f] <> closed
    THEN CASE f OF
      altfile : close (altpl);
      oplfile : close (oldpl);
      outfile : BEGIN
                  close (output, 'SAVE');
                  pagelength := 0; page := 0
                END;
      comfile : BEGIN
                  writeln (compile); close (compile, 'SAVE')
                END;
      inpfile : close (input);
      in2file : close (input2)
    END;
    IF f = inpfile THEN fstatus [f] := opread
    ELSE fstatus [f] := closed;
    fname [f] := name;
    factive [f] := true;
1:  IF f <> dummy THEN name := fname [f];
    IF key <> nullk
    THEN CASE f OF
        altfile : BEGIN
                    open (altpl, name);
                    fstatus [altfile] := opread
                  END;
        oplfile : BEGIN
                    open (oldpl, name);
                    fstatus [oplfile] := opread
                  END;
        outfile : BEGIN
                    rewrite (output, name);
                    fstatus [outfile] := opwrite
                  END;
        nplfile : ;
        comfile : ;
        modfile : ;
        srcfile : ;
        inpfile : ;
        in2file : fstatus [in2file] := opread;
          dummy :
      END   (* case *)
  END   (* getfname *);
 
PROCEDURE getlineid (isrange : boolean);
 
  VAR dl : decklist;
       i : bytep1r;
       j : bignumber;
       k : 0..10;
id, deck : ident;
 
  BEGIN   (* getlineid *)
    id := NIL; deck := NIL; i := nextin;
    WHILE bline [i] IN ['0'..'9'] DO i := i + 1;
    IF bline [i] = '.' THEN i := nextin;
    IF bline [i] IN ['.', ',', ' '] THEN
    BEGIN
      IF bline [i] = '.' THEN
      BEGIN
        id := lastdeck; i := i + 1
      END
      ELSE BEGIN
        id := lastname; i := nextin
      END;
      IF NOT (bline [i] IN ['0'..'9']) THEN
      BEGIN
        id := nil; flagline (lineexpected)
      END
      ELSE IF id = NIL THEN flagline (noabbreviate)
    END
    ELSE BEGIN
      getword;
      IF wlength > 0 THEN
      BEGIN
        identword := word; found := false; search (nmtree);
        IF found THEN WITH curdesc @ DO IF idno < maxid THEN
          IF NOT odd (data DIV 4) THEN
          BEGIN
            id := curdesc; lastname := id;
            IF kind < 3 THEN lastdeck := lastname
          END;
        IF bline [nextin] <> '.' THEN
        BEGIN
          id := NIL;
          flagline (lineexpected)
        END
        ELSE IF id = NIL THEN flagline (doesnotexist)
      END
      ELSE flagline (lineexpected)
    END;
 
    IF id <> NIL THEN
    BEGIN
      IF bline [nextin] = '.' THEN nextin := nextin + 1;
      IF NOT (bline [nextin] IN ['0'..'9']) THEN
      BEGIN
        id := NIL;
        flagline (lineexpected)
      END
    END;
 
    IF id <> NIL THEN
    BEGIN
      j := 0;
      REPEAT
        IF j < mfrdiv10 THEN j := j * 10
        ELSE id := NIL;
        k := ord (bline [nextin]) - ord ('0');
        nextin := nextin + 1;
        IF j <= maxfilerec - k THEN j := j + k
        ELSE id := NIL
      UNTIL NOT (bline [nextin] IN ['0'..'9']);
      IF bline [nextin] <> ' ' THEN IF bline [nextin] <> ',' THEN
      BEGIN
        id := NIL; flagline (baddirect)
      END
    END;
 
    IF id <> NIL THEN
    BEGIN
      IF j = 0 THEN id := NIL
      ELSE IF id <> NIL THEN WITH id @ DO
        IF kind = 3 THEN
          IF j > mxrc THEN id := NIL
          ELSE BEGIN
            dl := afct;
            WHILE dl <> NIL DO WITH dl @ DO
            BEGIN
              deck := adeck;
              IF where >= j THEN dl := NIL
              ELSE dl := anext
            END;
            IF deck = NIL THEN id := NIL
          END
        ELSE BEGIN
          IF j > mxrc THEN
          BEGIN
            IF j - 1 > mxrc THEN id := NIL
            ELSE IF key <> beforek THEN id := NIL
          END
          ELSE IF j = 1 THEN
            IF key < insertk THEN id := NIL;
          deck := id
        END;
      IF id = NIL THEN flagline (badlinenumber)
    END;
 
    IF id <> NIL THEN
      IF declared = NIL THEN
      BEGIN
        IF deck = yankdeck THEN
          IF (key = beforek) OR (key = insertk) THEN
            flagline (badlinenumber)
      END
      ELSE IF deck <> declared THEN
      BEGIN
        id := NIL; flagline (declareerror)
      END;
 
    IF id <> NIL THEN
      IF NOT isrange THEN thisdeck := deck
      ELSE IF deck <> thisdeck THEN
      BEGIN
        id := NIL; flagline (twodecks)
      END;
 
    IF id <> NIL THEN IF isrange THEN
    BEGIN
      key := key + 1;
      secondref := id; secondline := j
    END
    ELSE BEGIN
      firstref := id; firstline := j
    END
  END   (* getlineid *);
 
PROCEDURE readlist;
 
  VAR dc, ld, ln, td : ident;
                  ct : changetyp;
 
  BEGIN   (* readlist *)
    IF nextin > longth THEN nextin := longth + 1
    ELSE IF (bline [nextin] = ',') OR (bline [nextin] = ' ') THEN
      nextin := longth + 1;
    IF NOT (listactive OR listinactive) THEN
    BEGIN
      nextin := 3;
      flagline (inappropriate)
    END
    ELSE IF nextin > longth THEN
      IF nowlisting = (key = nolistk) THEN
      BEGIN
        key := nullk;
        nowlisting := NOT nowlisting
      END
      ELSE flagline (inappropriate)
    ELSE BEGIN
      td := thisdeck;
      ln := lastname;
      ld := lastdeck;
      dc := declared;
      IF key = listk THEN ct := listd
      ELSE ct := nolist;
      REPEAT
        declared := NIL;
        getlineid (false);
        IF key <> nullk THEN WITH firstref @ DO
          addmodtodeck (thisdeck, ct, idno, firstline, idno,
            firstline, 1);
        IF nextin > longth THEN key := nullk
        ELSE IF bline [nextin] <> ',' THEN key := nullk
        ELSE BEGIN
          nextin := nextin + 1;
          IF (bline [nextin] = ' ') OR (bline [nextin] = ',') THEN
            key := nullk
        END
      UNTIL key = nullk;
      declared := dc;
      lastdeck := ld;
      lastname := ln;
      thisdeck := td
    END
  END   (* readlist *);
 
PROCEDURE readline (VAR f : text);
 
  LABEL 1, 2, 3;
 
  VAR i, j, k, count, bloc : bytep1r;
      low, mid, max : 0..directivesp1;
                 ch : char;
          c, lastch : intchar;
          truncflag : boolean;
               bits : 0..12;
             bitval : bitvaltp;
              shift : 0..3;
 
  PROCEDURE putval (v : bitvaltp);
 
    VAR i : 0..15;
 
    BEGIN   (* putval *)
      bits := bits + 5;
      bitval := (bitval MOD halfbyte) * 32 + v;
      WHILE bits >= bitsperbyte DO
      BEGIN
        v := bitval; bitval := bitval MOD remmask;
        bits := bits - bitsperbyte; i := bits;
        WHILE i > 0 DO
        BEGIN
          i := i - 1; v := v DIV 2
        END;
        IF bloc = bytesize THEN truncflag := true
        ELSE BEGIN
          bloc := bloc + 1; iline [bloc] := chr (v MOD bytep1)
        END
      END
    END   (* putval *);
 
  FUNCTION cfnprocess : bytep1r;
 
    VAR c : char;
     j, k : 0..bytep1;
        s : blinet;
 
    BEGIN   (* cfnprocess *)
      IF bline [nextin] = ',' THEN
        nextin := nextin + 1
      ELSE WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
      nextword := nextin; k := nextword;
      j := 0;
      WHILE bline [nextin] <> ',' DO
        IF nextin > longth THEN bline [nextin] := ','
        ELSE BEGIN
          c := bline [nextin]; nextin := nextin + 1;
          IF c <> ' ' THEN BEGIN
            j := j + 1;
            s [j] := c
          END
          ELSE IF j <> 0 THEN IF nextin <= longth
          THEN IF s [j] <> ' ' THEN BEGIN
            j := j + 1; s [j] := ' '
          END
        END;
      nextin := nextword;
      IF j = 0 THEN BEGIN
        flagline (nofilename);
        cfnprocess := longth + 1
      END
      ELSE BEGIN
        nextin := k;
        getfname (dummy, false, true);
        key := compfilk;
        longth := j;
        FOR j := 1 TO longth DO
        BEGIN
          c := s [j]; bline [j] := c;
          line [j] := loctoint [c]
        END;
        cfnprocess := 0
      END
    END   (* cfnprocess *);
 
  FUNCTION mdlprocess : bytep1r;
 
    BEGIN   (* mdlprocess *)
      getlineid (false);
      IF (key = deletek) OR (key = restorek) THEN
        IF nextin <= longth THEN
          IF bline [nextin] = ',' THEN
          BEGIN
            nextin := nextin + 1;
            IF bline [nextin] <> ',' THEN IF bline [nextin] <> ' '
            THEN getlineid (true)
          END
          ELSE IF bline [nextin] <> ' ' THEN
            flagline (baddirect);
      IF key = nullk THEN mdlprocess := longth + 1
      ELSE BEGIN
        WHILE (bline [nextin] = ' ') OR
          (bline [nextin] = ',') AND (nextin <= longth) DO
          nextin := nextin + 1;
        mdlprocess := nextin
      END
    END   (* mdlprocess *);
 
  BEGIN   (* readline *)
    i := 0;
    truncflag := false;
    IF readfile = inpfile THEN
    IF NOT eof (f) THEN IF eoln (f) THEN get (f);
    IF eof (f) THEN
    BEGIN
      key := endk;
      longth := 0;
      GOTO 1
    END;
    WHILE NOT eoln (f) DO
      IF i < inwidth THEN
      BEGIN
        read (f, ch);
        i := i + 1; bline [i] := ch;
        line [i] := loctoint [ch]
      END
      ELSE REPEAT get (f) UNTIL eoln (f);
    IF ch = ' ' THEN IF i > 0 THEN
      REPEAT
        i := i - 1;
        IF i = 0 THEN ch := '.'
        ELSE ch := bline [i]
      UNTIL ch <> ' ';
    IF readfile = in2file THEN get (f);
    longth := i;
    IF longth = 0 THEN key := blankk
    ELSE key := datak;
    REPEAT
      i := i + 1; line [i] := blk
    UNTIL i > 3;
    bline [longth + 1] := ',';
    IF bline [1] = masterch THEN
      IF bline [2] = commentch THEN
        IF (line [3] = blk) OR (line [3] = com) THEN
          IF textinput THEN key := specialk
          ELSE key := commentk
        ELSE key := datak
      ELSE IF (line [2] <> blk) AND (line [2] <= ucz) THEN
      BEGIN
        nextin := 2;
        getword;
        IF nextin <= longth THEN
          IF line [nextin] <> blk THEN
            IF line [nextin] <> com THEN GOTO 1;
        max := directives;
        low := 1;
        REPEAT
          mid := (low + max) DIV 2;
          IF keywords [mid] < word THEN low := mid + 1
          ELSE IF keywords [mid] > word THEN max := mid - 1
          ELSE BEGIN
            key := keys [mid];
            IF textinput THEN
              IF key = endtextk THEN key := removek
              ELSE key := specialk;
            GOTO 1
          END
        UNTIL max < low
      END;
    bline [longth + 1] := ',';
1:  IF NOT (key IN expected) THEN flagline (inappropriate);
    IF key < dok THEN
      CASE key OF
endk, blankk, endifk, elsek :
           i := longth + 1;
commentk : i := 3;
   datak : i := 0;
specialk : i := 1;
datek, timek :
           BEGIN
             i := nextin;
             IF i < longth THEN
               REPEAT
                 c := line [i + 1];
                 IF c = blk THEN i := i + 1
               UNTIL (c <> blk) OR (i >= longth);
             IF i = longth THEN i := i + 1
             ELSE IF i + 1 = longth THEN
               IF line [i] = line [longth] THEN
                 i := longth + 1
           END;
  widthk : BEGIN
             IF bline [nextin] = ',' THEN nextin := nextin + 1
             ELSE WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
             newdwid := 1; newswid := 1;
             IF bline [nextin] <> ',' THEN
             BEGIN
               count := lnumber (10, bytesize);
               IF count > bytesize THEN flagline (badvalue)
               ELSE newdwid := count
             END;
             IF key <> nullk THEN IF bline [nextin] = ',' THEN
             IF nextin < longth THEN
             IF bline [nextin + 1] IN ['0'..'9'] THEN
             BEGIN
               nextin := nextin + 1;
               count := lnumber (0, bytesize - 10);
               IF count > bytesize THEN flagline (badvalue)
               ELSE IF (count < 5) AND (count > 0) THEN
                 flagline (badvalue)
               ELSE IF newdwid + count > bytesize THEN
                 flagline (badvalue)
               ELSE newswid := count
             END
             ELSE nextin := nextin + 1;
             IF newswid = 1 THEN IF newdwid = 1 THEN
               IF key <> nullk THEN flagline (novalue);
             IF bline [nextin] <> ',' THEN IF bline [nextin] <> ' '
             THEN IF nextin <= longth THEN IF key <> nullk THEN
               flagline (baddirect)
           END;
endtextk : i := 1;
compfilk : i := cfnprocess
      END   (* case *)
    ELSE BEGIN
      i := longth + 1;
      IF bline [nextin] = ','
      THEN BEGIN
        IF nextin < longth THEN nextin := nextin + 1
      END
      ELSE WHILE bline [nextin] = ' ' DO
        nextin := nextin + 1;
      IF key = ifdefk THEN
      BEGIN
        IF bline [nextin] = '-' THEN
        BEGIN
          nextin := nextin + 1;
          key := key + 3
        END;
        getlword;
        IF word = 'DECK    ' THEN key := key + 1
        ELSE IF word = 'IDENT   ' THEN key := key + 2
        ELSE IF word <> 'DEF     ' THEN flagline (notifparm);
        IF key <> nullk THEN
          IF bline [nextin - 1] = ' ' THEN flagline (comma)
          ELSE IF bline [nextin] <> ',' THEN flagline (comma)
          ELSE IF nextin < longth THEN nextin := nextin + 1
          ELSE flagline (comma)
      END   (* key = ifdefk *)
      ELSE IF key = inwidthk THEN
      BEGIN
        IF nextin > longth THEN inwidth := bytesize
        ELSE IF (bline [nextin] = ',') OR (bline [nextin] = ' ') THEN
          inwidth := bytesize
        ELSE IF bline [nextin] IN ['0'..'9'] THEN
        BEGIN
          count := lnumber (5, bytesize);
          IF (bline [nextin] = ',') OR (bline [nextin] = ' ') THEN
            IF count > bytesize THEN flagline (badvalue)
            ELSE inwidth := count
          ELSE flagline (baddirect)
        END
        ELSE flagline (novalue);
        key := nullk
      END;
 
      IF key IN [callk..deckk, identk, declarek]
      THEN BEGIN
        getword;
        IF wlength = 0 THEN
        BEGIN
          IF key <> declarek THEN flagline (notaname)
        END
        ELSE IF nextin <= longth THEN
          IF bline [nextin] <> ' ' THEN
            IF bline [nextin] <> ',' THEN flagline (notaname)
      END
      ELSE IF key IN [beforek..insertk] THEN i := mdlprocess - 1
      ELSE IF (key = listk) OR (key = nolistk) THEN i := longth + 1
      ELSE IF key = pointatk THEN
      BEGIN
        IF bline [nextin] = '^' THEN key := pointupk
        ELSE IF bline [nextin] <> '@' THEN
        BEGIN
          nextin := nextin + 1;
          flagline (nopointer)
        END;
        IF key <> nullk THEN
        BEGIN
          nextin := nextin + 1;
          IF bline [nextin] <> ',' THEN IF bline [nextin] <> ' ' THEN
            IF nextin <= longth THEN flagline (nopointer)
        END
      END
    END;
    IF key = nullk THEN i := longth + 1;
    bits := 0; bitval := 0; count := 0;
    bloc := 1; shift := 1;
    lastch := blk;
 
2:  WHILE i <= longth DO
    BEGIN
      i := i + 1;
      IF i <= longth THEN c := line [i]
      ELSE IF lastch = blk THEN GOTO 2
      ELSE c := blk;
      IF c = lastch THEN
        IF c <> bin THEN
        BEGIN
          count := count + 1; GOTO 2
        END
        ELSE IF bline [i] = bline [i - 1] THEN
        BEGIN
          count := count + 1; GOTO 2
        END;
      IF lastch = blk THEN
        IF count > 2 THEN
        BEGIN
          IF bloc > 1 THEN putval (27)
          ELSE IF bits > 0 THEN putval (27)
          ELSE count := count + 1;
          count := count - 1
        END
        ELSE WHILE count > 0 DO
        BEGIN
          putval (27); count := count - 1
        END   (* lastch = blk *)
      ELSE IF lastch = bin THEN
        IF (bytep1 - bloc) * bitsperbyte - bits < 15 THEN
          truncflag := true
        ELSE BEGIN
          IF binchars < maxfilerec THEN binchars := binchars + 1;
          putval (0);
          k := ord (bline [i - 1]);
          j := k DIV 32 + 16; k := k MOD 32;
          putval (j); putval (k);
          count := count - 1;
          IF count = 1 THEN
          BEGIN
            count := 0;
            putval (0); putval (j); putval (k)
          END
        END   (* lastch = bin and fits in the buffer *)
      ELSE BEGIN
        j := lastch - offsets [shift];
        putval (j); count := count - 1;
        IF count = 1 THEN
        BEGIN
          count := 0;
          putval (j)
        END
      END   (* else *);
 
      IF count <> 0 THEN
      BEGIN
        count := count - 2;
        putval (28);
        WHILE count > 30 DO
        BEGIN
          count := count - 31; putval (31)
        END;
        putval (count); count := 0
      END;
 
      count := 1;
      lastch := c;
      IF c <= ucz THEN
        IF c > lcz THEN j := 1
        ELSE IF c = blk THEN j := shift
        ELSE j := 0
      ELSE IF c > nin THEN
        IF c = bin THEN j := shift
        ELSE j := 3
      ELSE IF c < zer THEN j := 2
      ELSE IF shift > 1 THEN j := shift
      ELSE BEGIN
        k := i; j := 2;
        REPEAT
          k := k + 1;
          IF k <= longth THEN
          BEGIN
            c := line [k];
            IF c < zer THEN
            BEGIN
              IF c <> blk THEN GOTO 3
            END
            ELSE IF c > nin THEN
              IF c <> bin THEN
              BEGIN
                j := 3; GOTO 3
              END
          END
        UNTIL k > longth
      END   (* else *);
 
3:    IF j <> shift THEN
      BEGIN
        k := (j - shift) MOD 4;
        shift := j;
        putval (28 + k)
      END
    END   (* while i <= longth *);
    bline [longth + 1] := ',';
 
    IF bits > 0 THEN IF bitval <> 0 THEN
      IF bloc = bytesize THEN truncflag := true
      ELSE BEGIN
        WHILE bits < bitsperbyte DO
        BEGIN
          bits := bits + 1; bitval := bitval * 2
        END;
        bloc := bloc + 1; iline [bloc] := chr (bitval MOD bytep1)
      END;
    iline [1] := chr (0);
    REPEAT
      IF iline [bloc] = chr (0) THEN bloc := bloc - 1
      ELSE BEGIN
        iline [1] := chr (bloc - 1); bloc := 0
      END
    UNTIL bloc = 0;
 
    IF truncflag THEN
    BEGIN
      error;
      writeln ('The following line has been truncated:');
      IF longth > 73 THEN longth := 73;
      write (' ':1, bline:longth);
      writeln;
      pagelength := pagelength + 1
    END
  END   (* readline *);
 
PROCEDURE secondaryinput (VAR f : text; fi : fileindex);
 
  BEGIN   (* secondaryinput *)
    key := readk;
    getfname (fi, true, true);
    IF key <> nullk THEN IF fstatus [fi] <> closed
      THEN close (f);
    IF fi = inpfile THEN
      IF fstatus [inpfile] = closed THEN
      BEGIN
        fstatus [inpfile] := opread;
        key := endk
      END;
    IF key <> nullk THEN
    BEGIN
      key := nullk; readfile := fi;
      reset (f, fname [fi])
    END
  END   (* secondaryinput *);
 
PROCEDURE getline;
 
  BEGIN   (* getline *)
    REPEAT
      IF readfile = inpfile THEN readline (input)
      ELSE readline (input2);
      IF key = readk THEN
        IF readfile = in2file THEN flagline (inappropriate)
        ELSE secondaryinput (input2, in2file)
      ELSE IF key = textk THEN
      BEGIN
        textinput := true; key := nullk
      END
      ELSE IF key = removek THEN
      BEGIN
        textinput := false; key := nullk
      END
      ELSE IF (key = listk) OR (key = nolistk) THEN readlist
      ELSE IF key = endk THEN
        IF readfile = in2file THEN
        BEGIN
          readfile := inpfile; key := nullk
        END
        ELSE IF textinput THEN
        BEGIN
          error; textinput := false;
          writeln ('End of file was reached without finding ',
            'an *ENDTEXT directive.')
        END
    UNTIL key <> nullk
  END   (* getline *);
 
PROCEDURE getseries (amod : boolean);
 
  VAR id : ident;
 
  BEGIN   (* getseries *)
    getword;
    firstref := NIL;
    secondref := NIL;
    IF wlength = 0 THEN flagline (notaname)
    ELSE BEGIN
      identword := word; idsearch := false; found := false;
      search (nmtree);
      IF NOT found THEN flagline (doesnotexist)
      ELSE WITH curdesc @ DO
      BEGIN
        IF amod THEN
          IF kind = 3 THEN firstref := curdesc
          ELSE flagline (notanident)
        ELSE IF kind = 3 THEN flagline (notadeck)
        ELSE firstref := curdesc;
        IF key <> nullk THEN
          IF bline [nextin] = '.' THEN
          BEGIN
            nextin := nextin + 1; getword;
            IF wlength = 0 THEN flagline (notaname)
            ELSE BEGIN
              identword := word; found := false; search (nmtree);
              IF NOT found THEN flagline (doesnotexist)
              ELSE WITH curdesc @ DO
                IF amod THEN
                  IF kind = 3 THEN secondref := curdesc
                  ELSE flagline (notanident)
                ELSE IF kind = 3 THEN flagline (notadeck)
                ELSE secondref := curdesc;
 
              id := firstref;
              WHILE id <> secondref DO WITH id @ DO
                IF next = NIL THEN
                BEGIN
                  flagline (doesnotfollow);
                  id := secondref
                END
                ELSE id := next
            END
          END
          ELSE secondref := firstref
      END
    END
  END   (* getseries *);
 
PROCEDURE addseries (idnum : idnumber; VAR lin : bignumber);
 
  BEGIN   (* addseries *)
    REPEAT
      IF lin = maxfilerec THEN fatal (toomanylines);
      lin := lin + 1;
      IF idnum = 0 THEN putbyte (key)
      ELSE putbyte (key + insertk);
      putdouble (lin);
      IF idnum <> 0 THEN putdouble (idnum);
      putdouble (0);
      putbyte (wlength);
      putname (word, wlength);
      IF nextin <= longth THEN
        IF bline [nextin] = ','
        THEN BEGIN
          nextin := nextin + 1;
          IF (bline [nextin] = ',') OR (bline [nextin] = ' ')
          THEN key := nullk
        END
        ELSE IF bline [nextin] = ' ' THEN key := nullk
        ELSE flagline (ignoretherest)
      ELSE key := nullk;
      IF key = nullk THEN wlength := 0
      ELSE BEGIN
        getword;
        IF bline [nextin] <> ',' THEN
        IF bline [nextin] <> ' ' THEN
        IF nextin <= longth THEN
        BEGIN
          wlength := 0;
          flagline (ignoretherest)
        END
      END
    UNTIL wlength = 0
  END   (* addseries *);
 
PROCEDURE newmodset;
 
  VAR lineno, idnum, str, stl : bignumber;
                        added : boolean;
             lastdeckmodified : idnumber;
                      idp, id : ident;
 
  FUNCTION affects (m : ident) : boolean;
 
    LABEL 1;
 
    VAR t1 : decklist; i : idnumber;
 
    BEGIN   (* affects *)
      t1 := m @.afct;
      IF key = selyankk THEN i := idp @.idno
      ELSE i := lastdeckmodified;
      WHILE t1 <> NIL DO WITH t1 @ DO
        IF adeck @.idno = i
        THEN BEGIN
          affects := true; GOTO 1
        END
        ELSE t1 := anext;
      affects := false;
      error;
      write (masterch);
      CASE key OF
           dok : write ('DO ');
         dontk : write ('DONT ');
      selyankk : BEGIN
                   write ('SELYANK ');
                   fwwrite (idp @.name, true);
                   write ('.')
                 END
      END;
      fwwrite (m @.name, true);
      writeln;
      ensure (0, 1);
      writeln ('      This modification does not affect the deck.');
1:  END   (* affects *);
 
  PROCEDURE newchange;
 
    LABEL 1;
 
    VAR    fi, si : idnumber;
       sr, fn, sn : bignumber;
               sl : bufrange;
               ct : changetyp;
              idp,
               dk : ident;
            added : boolean;
 
    BEGIN   (* newchange *)
      added := false;
      dk := thisdeck;
      fi := firstref @.idno; fn := firstline;
      IF (key = deleterk) OR (key = restorrk) THEN
      BEGIN
        si := secondref @.idno; sn := secondline;
        IF key = deleterk THEN ct := delete
        ELSE ct := restore
      END
      ELSE BEGIN
        si := fi; sn := fn;
        CASE key OF
           beforek : ct := before;
           deletek : ct := delete;
          restorek : ct := restore;
           insertk : ct := insert
        END
      END;
      key := nullk;
      IF dk = yankdeck THEN GOTO 1;
      setwritefile (tpzfile);
      sr := writerec;
      sl := writeloc;
      expected := expected + datatypes + [dok, dontk];
      REPEAT
        IF key = commentk THEN key := nullk
        ELSE IF key < nullk THEN
        BEGIN
          added := true;
          setwritefile (tpzfile);
          IF key = definek THEN addseries (idnum, lineno)
          ELSE IF (key = dok) OR (key = dontk)
          THEN BEGIN
            getseries (true);
            WHILE key <> nullk DO
            BEGIN
              idp := firstref;
              REPEAT
                IF idp = id
                THEN BEGIN
                  flagline (illegitimate); idp := NIL
                END
                ELSE WITH idp @ DO
                BEGIN
                  IF odd (data DIV 4) THEN data := 4
                  ELSE IF affects (idp)
                  THEN BEGIN
                    IF lineno = maxfilerec THEN fatal (toomanylines);
                    lineno := lineno + 1;
                    putbyte (key + insertk);
                    putdouble (lineno);
                    putdouble (idno);
                    putdouble (idnum);
                    putdouble (0)
                  END;
                  IF idp = secondref THEN idp := NIL
                  ELSE idp := next
                END
              UNTIL idp = NIL;
              IF key <> nullk THEN IF nextin <= longth THEN
                IF bline [nextin] = ','
                THEN BEGIN
                  nextin := nextin + 1;
                  IF (bline [nextin] = ',') OR (bline [nextin] = ' ')
                  THEN key := nullk
                  ELSE getseries (true)
                END
                ELSE IF bline [nextin] = ' ' THEN key := nullk
                ELSE flagline (ignoretherest)
              ELSE key := nullk
            END
          END
          ELSE BEGIN
            IF lineno = maxfilerec THEN fatal (toomanylines);
            lineno := lineno + 1;
            IF key < pointatk THEN putbyte (key + insertk)
            ELSE putbyte (key + beforek - 8);
            putdouble (lineno);
            putdouble (idnum);
            putdouble (0);
            IF key < widthk THEN
            BEGIN
              IF (key <> blankk) THEN copyline
            END
            ELSE IF key = widthk THEN
            BEGIN
              putbyte (newdwid); putbyte (newswid)
            END
            ELSE IF key >= callk THEN IF key < pointatk
            THEN BEGIN
              IF key = callk THEN
                addcall (dk, word, 1);
              putbyte (wlength);
              putname (word, wlength)
            END
          END
        END;
        getline
      UNTIL key IN [endk, comdeckk..declarek, readk..pullmodk];
 
      expected := commands + [yankdckk..declarek];
1:    IF added THEN
      BEGIN
        setwritefile (tpzfile);
        putbyte (0);
        addmodtomod (id, dk, lineno);
        IF ct = before THEN
          addmodtodeck (dk, before, fi, fn, sl, sr, idnum)
        ELSE BEGIN
          addmodtodeck (dk, insert, si, sn, sl, sr, idnum);
          IF ct <> insert THEN
            addmodtodeck (dk, ct, fi, fn, si, sn, idnum)
        END
      END
      ELSE IF (ct = insert) OR (ct = before) THEN
      BEGIN
        error;
        writeln
          ('Data missing after an *INSERT or *BEFORE directive.')
      END
      ELSE addmodtodeck (dk, ct, fi, fn, si, sn, idnum);
 
      setwritefile (tpyfile)
    END   (* newchange *);
 
  BEGIN   (* newmodset *)
    lastdeckmodified := 0;
    setwritefile (tpyfile);
    added := false;
    declared := NIL; lastname := NIL; lastdeck := NIL;
    lineno := 0; idnum := curid; id := curdesc;
    WITH id @ DO
    BEGIN
      strc := writerec;
      stlo := writeloc;
      ofil := tpyfile;
      putbyte (key);
      putdouble (idnum);
      key := nullk;
      expected := expected + [yankdckk..declarek];
      REPEAT
        CASE key OF
          commentk : IF added THEN key := nullk
                     ELSE BEGIN
                       putbyte (commentk); copyline; key := nullk
                     END;
            blankk : key := nullk;
          selyankk : BEGIN
                       added := false;
                       setwritefile (tpzfile);
                       str := writerec; stl := writeloc;
                       REPEAT
                         getword;
                         IF wlength = 0 THEN flagline (notaname)
                         ELSE BEGIN
                           identword := word; idsearch := false;
                           found := false; search (nmtree);
                           IF NOT found THEN flagline (doesnotexist)
                           ELSE WITH curdesc @ DO
                             IF odd (data DIV 4) THEN
                               flagline (doesnotexist)
                             ELSE IF kind = 3 THEN
                               flagline (doesnotexist)
                             ELSE IF (declared <> NIL) AND
                               (declared <> curdesc) THEN
                               flagline (declareerror)
                             ELSE IF bline [nextin] <> '.' THEN
                               flagline (comma)
                             ELSE BEGIN
                               nextin := nextin + 1;
                               idp := curdesc;
                               getword;
                               IF wlength = 0 THEN
                                 flagline (notaname)
                             END
                         END;
                         IF key <> nullk
                         THEN BEGIN
                           identword := word;
                           found := false;
                           search (nmtree);
                           IF NOT found THEN flagline (doesnotexist)
                           ELSE IF curdesc = id THEN
                             flagline (illegitimate)
                           ELSE WITH curdesc @ DO
                             IF odd (data DIV 4) THEN
                               flagline (doesnotexist)
                             ELSE IF kind <> 3 THEN
                               flagline (notanident)
                             ELSE IF affects (curdesc)
                             THEN BEGIN
                               added := true;
                               IF lineno = maxfilerec THEN
                                 fatal (toomanylines);
                               lineno := lineno + 1;
                               putbyte (key);
                               putdouble (lineno);
                               putdouble (idp @.idno);
                               putdouble (idno);
                               putdouble (idnum);
                               putdouble (0);
                               IF nextin <= longth THEN
                                 IF bline [nextin] = ','
                                 THEN BEGIN
                                   nextin := nextin + 1;
                                   IF (bline [nextin] = ',') OR
                                     (bline [nextin] = ' ') THEN
                                     key := nullk
                                 END
                                 ELSE IF bline [nextin] = ' ' THEN
                                   key := nullk
                                 ELSE flagline (ignoretherest)
                               ELSE key := nullk
                             END
                             ELSE key := nullk
                         END
                       UNTIL key = nullk;
                       IF added
                       THEN BEGIN
                         putbyte (0);
                         addmodtodeck (yankdeck, insert, 1, 1, stl,
                           str, idnum);
                         addmodtomod (id, yankdeck, lineno)
                       END;
                       added := true;
                       setwritefile (tpyfile)
                     END;
   yankk, yankdckk : BEGIN
                       IF key = yankk THEN IF declared <> NIL THEN
                         flagline (declareerror);
                       IF key <> nullk THEN
                       BEGIN
                         getseries (key = yankk);
                         IF key <> nullk THEN
                         BEGIN
                           added := false;
                           setwritefile (tpzfile);
                           str := writerec; stl := writeloc
                         END
                       END;
                       WHILE key <> nullk DO
                       BEGIN
                         idp := firstref;
                         IF key = yankdckk THEN
                           IF declared <> NIL THEN
                             IF (declared <> firstref) OR
                               (declared <> secondref) THEN
                                  flagline (declareerror);
                         IF key <> nullk THEN
                         REPEAT
                           IF idp = id
                           THEN BEGIN
                             flagline (illegitimate); idp := NIL
                           END
                           ELSE WITH idp @ DO
                           BEGIN
                             IF odd (data DIV 4) THEN data := 4
                             ELSE BEGIN
                               added := true;
                               IF lineno = maxfilerec THEN
                                 fatal (toomanylines);
                               lineno := lineno + 1;
                               putbyte (key);
                               putdouble (lineno);
                               putdouble (idno);
                               putdouble (idnum);
                               putdouble (0)
                             END;
                             IF idp = secondref THEN idp := NIL
                             ELSE IF key = nullk THEN idp := NIL
                             ELSE idp := next
                           END
                         UNTIL idp = NIL;
                         IF key <> nullk THEN IF nextin <= longth THEN
                           IF bline [nextin] = ',' THEN
                           BEGIN
                             nextin := nextin + 1;
                             IF (bline [nextin] = ',') OR
                               (bline [nextin] = ' ') THEN
                               key := nullk
                             ELSE getseries (key = yankk)
                           END
                           ELSE IF bline [nextin] = ' ' THEN
                             key := nullk
                           ELSE flagline (ignoretherest)
                         ELSE key := nullk
                       END   (* while key <> nullk *);
                       IF added THEN
                       BEGIN
                         putbyte (0);
                         addmodtodeck (yankdeck, insert, 1, 1,
                           stl, str, idnum);
                         addmodtomod (id, yankdeck, lineno)
                       END;
                       added := true;
                       setwritefile (tpyfile)
                     END;
          declarek : BEGIN
                       key := nullk;
                       IF wlength = 0 THEN declared := NIL
                       ELSE BEGIN
                         identword := word; idsearch := false;
                         found := false; search (nmtree);
                         IF found THEN
                           IF curdesc @.kind = 3 THEN
                             flagline (notadeck)
                           ELSE BEGIN
                             declared := curdesc;
                             lastdeck := declared;
                             lastname := lastdeck
                           END
                         ELSE flagline (doesnotexist)
                       END
                     END;
deleterk, restorrk : BEGIN
                       added := true;
                       IF thisdeck @.idno <> lastdeckmodified THEN
                       BEGIN
                         lastdeckmodified := thisdeck @.idno;
                         addmodtomod (id, thisdeck, lineno)
                       END;
                       IF ord (iline [1]) > 0 THEN
                       BEGIN
                         putbyte (key);
                         putdouble (firstref @.idno);
                         putdouble (firstline);
                         putdouble (secondref @.idno);
                         putdouble (secondline);
                         copyline
                       END;
                       newchange
                     END;
beforek, deletek, restorek, insertk :
                     BEGIN
                       added := true;
                       IF thisdeck @.idno <> lastdeckmodified THEN
                       BEGIN
                         lastdeckmodified := thisdeck @.idno;
                         addmodtomod (id, thisdeck, lineno)
                       END;
                       IF ord (iline [1]) > 0 THEN
                       BEGIN
                         putbyte (key);
                         putdouble (firstref @.idno);
                         putdouble (firstline);
                         copyline
                       END;
                       newchange
                     END;
             nullk :
        END;
 
        IF key = nullk THEN getline
      UNTIL key IN [endk, comdeckk, deckk, identk, changek..pullmodk];
      putbyte (0)
    END
  END   (* newmodset *);
 
PROCEDURE newelement (ck : idkind);
 
  VAR      id : ident;
lineno, idnum : bignumber;
 
  BEGIN   (* newelement *)
    identword := word;
    thisdeckname := identword;
    addflag := true; idsearch := false; newflag := true;
    found := false; curkind := ck; search (nmtree);
    addflag := false; newflag := false;
    IF found THEN flagline (alreadyexists)
    ELSE IF ck = 3 THEN newmodset
    ELSE WITH curdesc @ DO
    BEGIN
      data := 1;
      id := curdesc;
      setwritefile (tpzfile);
      lineno := 1; idnum := curid;
      strc := writerec;
      stlo := writeloc;
      ofil := tpzfile;
      putbyte (key); putdouble (idnum);
      key := nullk;
      expected := expected + datatypes;
      REPEAT
        IF key = commentk THEN
        BEGIN
          putbyte (commentk); copyline
        END
        ELSE IF key = definek THEN addseries (0, lineno)
        ELSE IF key <> nullk THEN
        BEGIN
          IF lineno = maxfilerec THEN fatal (toomanylines);
          lineno := lineno + 1;
          IF key < pointatk THEN putbyte (key)
          ELSE putbyte (key - 8);
          putdouble (lineno);
          putdouble (0);
          IF key = widthk THEN
          BEGIN
            putbyte (newdwid); putbyte (newswid)
          END
          ELSE IF (key > dontk) AND (key < pointatk) THEN
          BEGIN
            IF key = callk THEN
              addcall (id, word, 1);
            putbyte (wlength);
            putname (word, wlength)
          END
          ELSE IF key < widthk THEN
            IF (key <> blankk) THEN copyline
        END;
        getline
      UNTIL key IN [endk, deckk, comdeckk, identk, changek..pullmodk];
      mxrc := lineno;
      putbyte (0)
    END;
    expected := commands
  END   (* newelement *);
 
PROCEDURE processinput;
 
  PROCEDURE changenames;
 
    VAR w : alfa;
  smaller : boolean;
 
    FUNCTION deletenode (no : node) : node;
 
      LABEL 1;
 
      VAR br : boolean;
      id, n1 : node;
          bf : 0..2;
 
      BEGIN   (* deletenode *)
        WITH no @, who @ DO
        BEGIN
          IF name > w THEN br := false
          ELSE IF name < w THEN br := true
          ELSE found := true;
 
          IF found THEN
          BEGIN
            br := bal = 2;
            IF arm [br] = NIL THEN
            BEGIN
              dispose (no);
              deletenode := NIL; smaller := true;
              GOTO 1
            END
            ELSE BEGIN
              id := arm [br];
              REPEAT
                n1 := id; id := n1 @.arm [NOT br]
              UNTIL id = NIL;
              who := n1 @.who; w := who @.name;
              found := false
            END
          END;
          arm [br] := deletenode (arm [br]);
          bf := 2 * ord (br);
          IF smaller THEN
            IF bal = 1 THEN
            BEGIN
              bal := 2 - bf; smaller := false;
              deletenode := no
            END
            ELSE IF bal = bf THEN
            BEGIN
              bal := 1;
              deletenode := no
            END
            ELSE IF arm [NOT br] @.bal = bf THEN
            BEGIN
              id := arm [NOT br];
              WITH id @ DO
              BEGIN
                IF arm [br] @.bal = bf THEN bal := 2 - bf
                ELSE bal := 1;
                id := arm [br];
                arm [br] := id @.arm [NOT br]
              END;
              id @.arm [NOT br] := arm [NOT br];
              arm [NOT br] := id @.arm [br];
              WITH id @ DO
              BEGIN
                arm [br] := no;
                IF bal = 2 - bf THEN no @.bal := bf
                ELSE no @.bal := 1;
                bal := 1
              END;
              deletenode := id
            END
            ELSE BEGIN
              smaller := arm [NOT br] @.bal <> 1;
              IF smaller THEN bal := 1
              ELSE bal := 2 - bf;
              id := arm [NOT br];
              arm [NOT br] := id @.arm [br];
              id @.arm [br] := no;
              id @.bal := 2 - bal;
              deletenode := id
            END
          ELSE deletenode := no
        END;
1:    END   (* deletenode *);
 
    BEGIN   (* changenames *)
      REPEAT
        getword;
        IF wlength = 0 THEN flagline (notaname)
        ELSE BEGIN
          w := word; identword := w;
          found := false; idsearch := false; search (nmtree);
          IF NOT found THEN flagline (doesnotexist)
          ELSE IF bline [nextin] <> ',' THEN flagline (comma)
          ELSE BEGIN
            nextin := nextin + 1;
            getword;
            IF wlength = 0 THEN flagline (notaname)
            ELSE BEGIN
              identword := word; found := false;
              idsearch := false; search (nmtree);
              IF found THEN flagline (alreadyexists)
              ELSE BEGIN
                nmtree := deletenode (nmtree);
                found := false; addflag := true; curkind := 5;
                curdesc @.name := identword;
                search (nmtree); addflag := false;
                IF nextin <= longth THEN
                  IF bline [nextin] = ','
                  THEN BEGIN
                    nextin := nextin + 1;
                    IF (bline [nextin] = ',') OR (bline [nextin] = ' ')
                    THEN key := nullk
                  END
                  ELSE IF bline [nextin] = ' ' THEN key := nullk
                  ELSE flagline (ignoretherest)
                ELSE key := nullk
              END
            END
          END
        END
      UNTIL key = nullk
    END   (* changenames *);
 
  PROCEDURE series (amod : boolean);
 
    VAR id : ident;
 
    BEGIN   (* series *)
      getseries (amod);
      WHILE key <> nullk DO
      BEGIN
        id := firstref;
        REPEAT
          WITH id @ DO
          BEGIN
            CASE key OF
purgek, purdeckk : data := 4;
        sequenck : IF odd (data DIV 4) THEN data := 4
                   ELSE BEGIN
                     IF NOT odd (data) THEN data := data + 1;
                     IF NOT odd (data DIV 8) THEN data := data + 8
                   END;
        compilek : IF odd (data DIV 4) THEN data := 4
                   ELSE IF NOT odd (data) THEN data := data + 1;
        pullmodk : IF odd (data DIV 4) THEN data := 4
                   ELSE IF NOT odd (data DIV 8) THEN data := data + 8
            END   (* case *);
            IF id = secondref THEN id := NIL
            ELSE id := next
          END
        UNTIL id = NIL;
        IF nextin <= longth THEN
          IF bline [nextin] = ',' THEN
          BEGIN
            nextin := nextin + 1;
            IF (bline [nextin] = ',') OR (bline [nextin] = ' ') THEN
              key := nullk
            ELSE getseries (amod)
          END
          ELSE IF bline [nextin] = ' ' THEN key := nullk
          ELSE flagline (ignoretherest)
        ELSE key := nullk
      END   (* while key <> nullk *)
    END   (* series *);
 
  PROCEDURE movedecks;
 
    VAR d1, d2, d3 : ident;
 
    PROCEDURE decklocate (last : boolean);
 
      BEGIN   (* decklocate *)
        getword;
        IF wlength = 0 THEN flagline (notadeck)
        ELSE BEGIN
          identword := word; idsearch := false; found := false;
          search (nmtree);
          IF NOT found THEN flagline (notadeck)
          ELSE IF curdesc @.kind <> 2 THEN flagline (notadeck)
        END;
        IF key <> nullk THEN
          IF last THEN d3 := curdesc
          ELSE BEGIN
            d1 := curdesc;
            IF first [2] = d1 THEN d2 := NIL
            ELSE BEGIN
              d2 := first [2];
              WHILE d2 @.next <> curdesc DO
                d2 := d2 @.next
            END
          END
      END   (* decklocate *);
 
    BEGIN   (* movedecks *)
      REPEAT
        decklocate (false);
        IF key <> nullk THEN
          IF bline [nextin] = ',' THEN nextin := nextin + 1
          ELSE flagline (comma);
        IF key <> nullk THEN decklocate (true);
        IF key <> nullk THEN
          IF d1 = d3 THEN flagline (illegitimate)
          ELSE IF d1 = d3 @.next THEN flagline (illegitimate)
          ELSE BEGIN
            IF d2 = NIL THEN first [2] := d1 @.next
            ELSE d2 @.next := d1 @.next;
            d1 @.next := d3 @.next;
            d3 @.next := d1;
            IF nextin <= longth THEN
              IF bline [nextin] = ' ' THEN key := nullk
              ELSE IF bline [nextin] = ','
              THEN BEGIN
                nextin := nextin + 1;
                IF (bline [nextin] = ',') OR (bline [nextin] = ' ')
                THEN key := nullk
              END
              ELSE flagline (ignoretherest)
            ELSE key := nullk
          END
      UNTIL key = nullk
    END   (* movedecks *);
 
  BEGIN   (* processinput *)
    IF readfile <> inpfile THEN
    BEGIN
      fwhere [readfile] := readrec;
      findex [readfile] := readloc;
      readfile := inpfile
    END;
    REPEAT
      CASE key OF
           nullk : ;
blankk, commentk : key := nullk;
        comdeckk : newelement (1);
           deckk : newelement (2);
          identk : newelement (3);
           readk : secondaryinput (input2, in2file);
  listk, nolistk : readlist;
         changek : changenames;
           movek : movedecks;
purgek, pullmodk : series (true);
purdeckk, sequenck,
        compilek : series (false)
      END   (* case *);
      IF key = nullk THEN getline
    UNTIL key = endk
  END   (* processinput *);
 
PROCEDURE initialise;
 
  VAR i : integer;
      j : intchar;
      f : fileindex;
     ch : char;
 
  PROCEDURE cline;
 
    VAR image : csstring;
            i : integer;
            j : linerange;
        zchar,
           ch : char;
        valid : SET OF char;
         temp : text;
 
    PROCEDURE updchar (VAR c : char);
 
      VAR ch : intchar;
 
      BEGIN   (* updchar *)
        WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
        IF nextin <= longth THEN ch := loctoint [bline [nextin]]
        ELSE fatal (badvalue);
        IF ch = bin THEN fatal (badvalue)
        ELSE nextin := nextin + 1;
        IF ch > lcz THEN c := inttoloc [ch]
        ELSE c := inttoloc [ch + lcz]
      END   (* updchar *);
 
    BEGIN   (* cline *)
      csimage (image);
      i := cssize - 2;
      WHILE image [i] = ' ' DO i := i - 1;
      longth := i;
      FOR j := 1 TO i DO bline [j] := image [j];
      bline [longth + 2] := optchar;
      bline [longth + 1] := ' ';
      valid := ['A'..'D','F','G','I','L','N'..'R','S'..'U','W',
        'Z', '@', '^', '*', '/'];
      nextin := 1;
      WHILE (bline [nextin] <> ' ') AND (bline [nextin] <> optchar)
      DO nextin := nextin + 1;
      WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
      IF nextin <= longth THEN IF bline [nextin] <> optchar THEN
      BEGIN
        valid := valid - ['I'];
        getfname (inpfile, true, true);
        IF key = nullk THEN fatal (badcline);
        WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
        IF bline [nextin] <> optchar THEN fatal (noparenth)
      END;
      WHILE nextin <= longth DO
      BEGIN
        WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
        IF bline [nextin] <> optchar THEN fatal (noparenth);
        IF nextin <= longth THEN nextin := nextin + 1;
        getlword;
        IF wlength > 1
          THEN BEGIN
            ch := word [1];
            nextin := nextword + 1
          END
        ELSE IF wlength = 0 THEN
          IF nextin <= longth THEN
          BEGIN
            ch := bline [nextin]; nextin := nextin + 1
          END
          ELSE ch := ' '
        ELSE ch := word [1];
        IF ch IN valid THEN
        BEGIN
          valid := valid - [ch];
          CASE ch OF
           'A' : getfname (altfile, true, false);
           'B' : BEGIN
                   i := lnumber (10, bytesize);
                   IF i > bytesize THEN fatal (badvalue);
                   pagesize := 4 - i
                 END;
           'C' : getfname (comfile, false, false);
           'D' : BEGIN
                   datawid := lnumber (10, bytesize);
                   IF datawid > bytesize THEN fatal (badvalue)
                 END;
           'F' : fullmode := true;
           'G' : getfname (modfile, false, false);
           'I' : getfname (inpfile, true, false);
           'L' : BEGIN
                   i := lnumber (0, 63);
                   IF i > 63 THEN fatal (badvalue);
                   audit := odd (i DIV 32);
                   listinactive := odd (i DIV 16) OR audit;
                   listactive := odd (i DIV 8) OR audit;
                   listdirectives := odd (i DIV 4);
                   listcounts := odd (i DIV 2);
                   listdirectory := odd (i)
                 END;
           'N' : getfname (nplfile, false, false);
           'O' : getfname (outfile, false, false);
           'P' : getfname (oplfile, true, false);
           'Q' : BEGIN
                   seqflag := true; word [1] := ' '
                 END;
           'R' : BEGIN
                   IF factive [nplfile] THEN fatal (badcline);
                   valid := valid - ['N'];
                   fullrestruct := true;
                   fullmode := true;
                   factive [srcfile] := true;
                   commands := [endk..blankk, readk..pullmodk, nullk]
                 END;
           'S' : getfname (srcfile, false, false);
           'T' : printerchars := false;
           'U' : uppercase := true;
           'W' : BEGIN
                   WHILE bline [nextin] = ' ' DO
                     nextin := nextin + 1;
                   IF bline [nextin] <> ',' THEN
                     compwid := lnumber (10, bytesize);
                   IF compwid > bytesize THEN fatal (badvalue);
                   WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
                   IF bline [nextin] = ',' THEN
                     IF bline [nextin + 1] IN ['0'..'9'] THEN
                     BEGIN
                       nextin := nextin + 1;
                       listwidth := lnumber (0, maxprintwid);
                       IF listwidth > bytesize THEN
                         listwidth := maxprintwid
                       ELSE IF listwidth < 47 THEN listwidth := 47
                     END
                 END;
           'Z' : BEGIN
                   IF 'I' IN valid THEN valid := valid - ['I']
                   ELSE fatal (badcline);
                   word [1] := ' ';
                   deleteinput := true;
                   fname [inpfile] := 'ZZZZTMPZ';
                   rewrite (temp, fname [inpfile]);
                   writeln (temp, masterch, commentch);
                   WHILE bline [nextin] = ' ' DO nextin := nextin + 1;
                   zchar := bline [nextin];
                   bline [longth + 1] := zchar;
                   WHILE nextin <= longth DO
                   BEGIN
                     nextin := nextin + 1;
                     IF bline [nextin] = zchar THEN writeln (temp)
                     ELSE write (temp, bline [nextin])
                   END;
                   close (temp, 'SAVE');
                   factive [inpfile] := true;
                   fstatus [inpfile] := opread
                 END;
      '@', '^' : BEGIN
                   newpch := ch;
                   IF ch = '@' THEN oldpch := '^'
                   ELSE oldpch := '@';
                   valid := valid - [oldpch, newpch];
                   pascflag := true
                 END;
           '*' : updchar (masterch);
           '/' : updchar (commentch)
          END   (* case *)
        END
        ELSE IF ch <> ' '
        THEN fatal (badcline);
        IF key = nullk THEN fatal (badcline)
      END;
      IF factive [outfile] THEN
        rwfile (outfile)
      ELSE BEGIN
        factive [outfile] := true;
        fstatus [outfile] := opwrite
      END;
      IF fstatus [inpfile] <> closed THEN
        IF factive [inpfile] THEN
          reset (input, fname [inpfile])
        ELSE
          factive [inpfile] := true
    END   (* cline *);
 
  PROCEDURE kprocess (kst : alfa; key : keyrange);
 
    VAR j : 1..alfaleng;
 
    BEGIN   (* kprocess *)
      FOR j := 1 TO alfaleng DO
        word [j] := chr (loctoint [kst [j]]);
      keywords [i] := word;
      keys [i] := key; i := i + 1
    END   (* kprocess *);
 
  BEGIN   (* initialise *)
    value;
    datetime (today, now);
    dlinenum := 0;
    maxid := 1;
    pagesize := - defpagesize;
    pagelength := 0;
    page := 0;
    binchars := 0;
    key := commentk;
    datawid := defdataw;
    compwid := defcompw;
    writerec := 1;
    writeloc := 0;
    readrec := 1;
    readloc := 0;
    skippedifs := 0;
    listwidth := deflistw;
    inwidth := bytesize;
    addflag := false;
    secondary := false;
    textinput := false;
    terminalio := true;
    printerchars := true;
    suppressnewpl := false;
    seqflag := false;
    fullrestruct := false;
    listdirectory := true;
    listdirectives := false;
    listcounts := false;
    listactive := false;
    listinactive := false;
    audit := false;
    nowlisting := true;
    fullmode := false;
    skipflag := false;
    deleteinput := false;
    uppercase := false;
    pascflag := false;
    offsets [0] := blk; offsets [1] := lcz;
    offsets [2] := ucz; offsets [3] := zer - 1;
    FOR j := 1 TO 3 DO
    BEGIN
      first [j] := NIL; last [j] := NIL
    END;
    FOR j := 1 TO alfaleng DO blanks [j] := chr (blk);
    FOR ch := chr (lowordchar) TO chr (highordchar) DO
      loctoint [ch] := bin;
    FOR j := blk TO pred (bin) DO
      loctoint [inttoloc [j]] := j;
    oldpch := ' ';
    newpch := ' ';
    commentch := defcommentch;
    masterch := defmasterch;
    commands := [endk..blankk, comdeckk, deckk, identk,
                 readk..pullmodk, nullk];
    datatypes := [datak..endifk,callk..ifnidntk,pointatk..removek];
    oldmaxident := NIL;
    new (yankdeck, true, 2, false);
    WITH yankdeck @ DO
    BEGIN
      name := blanks;
      idno := 1;
      kind := 0;
      strc := 1;
      stlo := 8;
      mxrc := 1;
      next := NIL;
      data := 1;
      ofil := oplfile;
      dlst := NIL;
      chgs := NIL
    END;
    declared := NIL;
    lastdeck := NIL;
    lastname := NIL;
    thisdeck := NIL;
    new (idtree);
    WITH idtree @ DO
    BEGIN
      arm [true] := NIL; arm [false] := NIL;
      who := yankdeck; bal := 1
    END;
    new (nmtree);
    WITH nmtree @ DO
    BEGIN
      arm [true] := NIL; arm [false] := NIL;
      who := yankdeck; bal := 1
    END;
    sourcelist := [ ];
    pullingmods := [ ];
    listing := [ ];
    FOR f := altfile TO in2file DO
    BEGIN
      factive [f] := false;
      fstatus [f] := closed
    END;
    fname [altfile] :='alt.pl';
    fname [nplfile] :='new.pl';
    fname [oplfile] :='old.pl';
    fname [tpyfile] :='ZZZZTMPX';
    fname [tpzfile] :='ZZZZTMPY';
    fname [outfile] :='output';
    fname [comfile] :='compile';
    fname [modfile] :='getmod';
    fname [srcfile] :='source';
    fname [inpfile] :='input';
    fstatus [inpfile] := opread;
    readfile := inpfile;
    writefile := outfile;
    cline;
    i := 1;
    kprocess ('addfile ', readk);    kprocess ('af      ', readk);
    kprocess ('b       ', beforek);  kprocess ('before  ', beforek);
    kprocess ('c       ', compilek); kprocess ('ca      ', callk);
    kprocess ('call    ', callk);    kprocess ('cd      ', comdeckk);
    kprocess ('cf      ', compfilk); kprocess ('ch      ', changek);
    kprocess ('change  ', changek);  kprocess ('comdeck ', comdeckk);
    kprocess ('compfile', compfilk); kprocess ('compile ', compilek);
    kprocess ('d       ', deletek);  kprocess ('da      ', datek);
    kprocess ('date    ', datek);    kprocess ('dc      ', declarek);
    kprocess ('deck    ', deckk);    kprocess ('declare ', declarek);
    kprocess ('define  ', definek);  kprocess ('delete  ', deletek);
    kprocess ('df      ', definek);  kprocess ('dk      ', deckk);
    kprocess ('do      ', dok);      kprocess ('dont    ', dontk);
    kprocess ('dt      ', dontk);    kprocess ('ei      ', endifk);
    kprocess ('else    ', elsek);    kprocess ('end     ', endk);
    kprocess ('endif   ', endifk);   kprocess ('endtext ', endtextk);
    kprocess ('et      ', endtextk); kprocess ('f       ', filek);
    kprocess ('file    ', filek);    kprocess ('i       ', insertk);
    kprocess ('id      ', identk);   kprocess ('ident   ', identk);
    kprocess ('if      ', ifdefk);   kprocess ('insert  ', insertk);
    kprocess ('inwidth ', inwidthk); kprocess ('iw      ', inwidthk);
    kprocess ('l       ', listk);    kprocess ('list    ', listk);
    kprocess ('m       ', movek);    kprocess ('move    ', movek);
    kprocess ('nl      ', nolistk);  kprocess ('nolist  ', nolistk);
    kprocess ('p       ', purgek);   kprocess ('pd      ', purdeckk);
    kprocess ('pm      ', pullmodk); kprocess ('po      ', pointatk);
    kprocess ('pointer ', pointatk); kprocess ('pullmod ', pullmodk);
    kprocess ('purdeck ', purdeckk); kprocess ('purge   ', purgek);
    kprocess ('q       ', endk);     kprocess ('quit    ', endk);
    kprocess ('r       ', restorek); kprocess ('rd      ', readk);
    kprocess ('read    ', readk);    kprocess ('restore ', restorek);
    kprocess ('s       ', sequenck); kprocess ('selyank ', selyankk);
    kprocess ('sequence', sequenck); kprocess ('stop    ', endk);
    kprocess ('sy      ', selyankk); kprocess ('t       ', textk);
    kprocess ('text    ', textk);    kprocess ('ti      ', timek);
    kprocess ('time    ', timek);    kprocess ('up      ', upperk);
    kprocess ('upper   ', upperk);   kprocess ('wi      ', widthk);
    kprocess ('width   ', widthk);   kprocess ('y       ', yankk);
    kprocess ('yank    ', yankk);    kprocess ('yankdeck', yankdckk);
    kprocess ('yd      ', yankdckk);
 
    listwidthm15 := listwidth - (15 +
      2 * ord (listinactive) + 6 * ord (seqflag));
    expected := commands + [filek];
    IF datawid > compwid THEN compwid := datawid
  END   (* initialise *);
 
PROCEDURE processdeck (id : ident; listit, cdrw : boolean);
 
  VAR bef, dur, aft, cur, t1, t2 : changes;
ldi, counting, deckyanked, audflag,
       lst, secflag, reseq, copy : boolean;
                         tlk, lk : listtype;
                          lineno : bignumber;
                               i : 1..5;
                           count : ARRAY [1..5] OF bignumber;
                        olddline : 0..maxdline;
                         befores : beflist;
                          sylist : yanklist;
 
  PROCEDURE setupmod (m : ident);
 
    VAR af : decklist;
 
    BEGIN   (* setupmod *)
      REPEAT
        WITH m @ DO
        BEGIN
          lstn := 0;
          af := afct;
          WHILE af <> NIL DO WITH af @ DO
            IF adeck = id THEN af := NIL
            ELSE BEGIN
              lstn := where;
              af := anext
            END;
          m := next
        END
      UNTIL m = NIL
    END   (* setupmod *);
 
  PROCEDURE printid (id : idnumber);
 
    BEGIN   (* printid *)
      curid := id;
      idsearch := true; found := false; search (idtree);
      IF found THEN fwwrite (curdesc @.name, true)
    END   (* printid *);
 
  PROCEDURE printmodline (t : changes);
 
    BEGIN   (* printmodline *)
      ensure (0, 1);
      write (masterch);
      WITH t @ DO
      BEGIN
        IF ckind = delete THEN write ('DELETE ')
        ELSE write ('RESTORE ');
        printid (startid);
        write ('.', startno:1);
        IF (where <> startid) OR (locus <> startno) THEN
        BEGIN
          write (',');
          printid (where);
          write ('.', locus:1)
        END;
        writeln
      END
    END   (* printmodline *);
 
  PROCEDURE addmodtocur (t : changes);
 
    VAR t1, t2 : changes;
            id : idnumber;
      warnflag : boolean;
 
    BEGIN   (* addmodtocur *)
      warnflag := false;
      t1 := cur; t2 := NIL; id := t @.mdwho;
      WHILE t1 <> NIL DO WITH t1 @ DO
        IF mdwho > id THEN
          t1 := NIL
        ELSE IF mdwho < id THEN
        BEGIN
          t2 := t1; t1 := cnext
        END
        ELSE BEGIN
          warnflag := true;
          t2 := t1; t1 := cnext
        END;
      IF warnflag THEN
      BEGIN
        error;
        write ('Modification ');
        printid (t @.mdwho);
        writeln (' changed one or more lines more than once ',
          'with this directive:');
        printmodline (t)
      END;
 
      IF t2 = NIL THEN
        IF cur = NIL THEN
        BEGIN
          cur := t; cur @.cnext := NIL
        END
        ELSE BEGIN
          t @.cnext := cur;
          cur := t
        END
      ELSE BEGIN
        t @.cnext := t2 @.cnext;
        t2 @.cnext := t
      END
    END   (* addmodtocur *);
 
  PROCEDURE addbefore (lid : ident);
 
    LABEL 1;
 
    VAR b, b1, b2 : beflist;
             lidn : idnumber;
                d : ident;
 
    BEGIN   (* addbefore *)
      lidn := lid @.idno;
      REPEAT
        b := befores;
        IF b <> NIL THEN WITH b @ DO
          IF bline < lidn THEN b := NIL
          ELSE IF bline = lidn THEN GOTO 1
          ELSE BEGIN
            bline := linenum;
            d := biden;
            biden := lid;
            befores := bnext;
            WITH d @ DO
            BEGIN
              b1 := bfor; b2 := NIL;
              WHILE b1 <> NIL DO
                IF mline < b1 @.mline THEN b1 := NIL
                ELSE BEGIN
                  b2 := b1; b1 := b2 @.bnext
                END;
              IF b2 = NIL THEN
              BEGIN
                bnext := bfor; bfor := b
              END
              ELSE BEGIN
                bnext := b2 @.bnext; b2 @.bnext := b
              END
            END
          END
      UNTIL b = NIL;
      WITH lid @ DO IF idno <> thisdeckid THEN
        IF data > 7 THEN
        BEGIN
          new (b);
          WITH b@ DO
          BEGIN
            mline := linenum; bline := lidn;
            biden := lid; bnext := befores;
            befores := b
          END
        END;
1:  END   (* addbefore *);
 
  PROCEDURE switchwarn (t : changes);
 
    BEGIN   (* switchwarn *)
      error;
      write ('Modification ');
      printid (t @.mdwho);
      writeln (' gave lines in the wrong order on this directive:');
      printmodline (t)
    END   (* switchwarn *);
 
  PROCEDURE addlist (islist : boolean);
 
    VAR t1, t3 : changes;
 
    BEGIN   (* addlist *)
      WITH t2 @ DO
        IF islist AND (startno = 1) AND (startid = id @.idno) THEN
        BEGIN
          nowlisting := true; dispose (t2)
        END
        ELSE BEGIN
          IF islist THEN t1 := bef
          ELSE t1 := aft;
          cnext := t1;
          t3 := NIL;
          WHILE t1 <> NIL DO WITH t1 @ DO
            IF startid > t2 @.startid THEN t1 := NIL
            ELSE IF startid < t2 @.startid THEN
            BEGIN
              t3 := t1; t1 := cnext
            END
            ELSE IF startno > t2 @.startno THEN t1 := NIL
            ELSE IF startno < t2 @.startno THEN
            BEGIN
              t3 := t1; t1 := cnext
            END
            ELSE IF islist THEN t1 := NIL
            ELSE BEGIN
              t3 := t1; t1 := cnext
            END;
          IF t3 = NIL THEN
            IF islist THEN bef := t2
            ELSE aft := t2
          ELSE BEGIN
            cnext := t3 @.cnext; t3 @.cnext := t2
          END
        END
    END   (* addlist *);
 
  PROCEDURE addselyank (id : idnumber; deact, warn : boolean);
 
    VAR t1, t2, t3 : yanklist;
              flag : boolean;
 
    BEGIN   (* addselyank *)
      curid := id; flag := true;
      secondary := secflag; idsearch := true; found := false;
      search (idtree); secondary := false;
      IF found THEN WITH curdesc @ DO
        IF NOT odd (data DIV 4)
        THEN BEGIN
          t1 := sylist; t2 := NIL;
          WHILE t1 <> NIL DO WITH t1 @ DO
            IF idno < id
            THEN BEGIN
              t2 := t1; t1 := ynxt
            END
            ELSE IF idno > id THEN t1 := NIL
            ELSE BEGIN
              t3 := t1; t1 := NIL; flag := false
            END;
          IF flag
          THEN BEGIN
            new (t3);
            WITH t3 @ DO
            BEGIN
              yank := curdesc;
              IF t2 = NIL
              THEN BEGIN
                ynxt := sylist; sylist := t3
              END
              ELSE BEGIN
                ynxt := t2 @.ynxt; t2 @.ynxt := t3
              END;
              real := odd (data DIV 2);
              curr := real
            END
          END;
          WITH t3 @ DO
            IF deact <> curr
            THEN BEGIN
              curr := deact;
              IF curr THEN data := data + 2
              ELSE data := data - 2
            END
            ELSE IF warn
            THEN BEGIN
              error;
              write (masterch);
              IF deact THEN write ('DONT ')
              ELSE write ('DO ');
              fwwrite (name, true);
              writeln;
              ensure (0, 1);
              write ('      This modification is ');
              IF NOT deact THEN write ('not ');
              writeln ('currently yanked.')
            END
        END
    END   (* addselyank *);
 
  PROCEDURE clearselyanks (disp : boolean);
 
    VAR t1, t2 : yanklist;
 
    BEGIN   (* clearselyanks *)
      t1 := sylist;
      WHILE t1 <> NIL DO
      BEGIN
        t2 := t1;
        WITH t1 @, yank @ DO
        BEGIN
          IF real <> curr THEN
            IF real THEN data := data + 2
            ELSE data := data - 2;
          t1 := ynxt
        END;
        IF disp THEN dispose (t2)
      END
    END   (* clearselyanks *);
 
  PROCEDURE idprocess;
 
    LABEL 1, 2;
 
    VAR purgeit : boolean;
            idn : idnumber;
   lin, i, j, k : bignumber;
 
    BEGIN   (* idprocess *)
      REPEAT
        IF key = identk THEN
        BEGIN
          idn := getbyte;
          IF idn >= halfbyte THEN GOTO 2;
          idn := idn * bytep1 + getbyte;
          IF idn <> thisdeckid THEN GOTO 2;
          putbyte (identk);
          putdouble (idn)
        END
        ELSE IF key = commentk THEN
        BEGIN
          putbyte (commentk);
          i := getbyte;
          putbyte (i);
          FOR j := 1 TO i DO putbyte (getbyte)
        END
        ELSE IF key IN [beforek..insertk, lowmk..maxk] THEN
        BEGIN
          purgeit := false;
          IF key > insertk THEN
          BEGIN
            key := key - beforek;
            i := getbyte;
            IF i < halfbyte THEN
            BEGIN
              curid := i * bytep1 + getbyte;
              idsearch := true; found := false;
              search (idtree);
              IF found THEN WITH curdesc @ DO
                IF kind < 3 THEN IF data < 4 THEN IF odd (data) THEN
                  addmodtomod (id, curdesc, id @.mxrc)
            END
          END;
          k := key;
1:        i := getbyte;
          IF i >= halfbyte THEN i := 0
          ELSE i := i * bytep1 + getbyte;
          IF i = 0 THEN found := false
          ELSE IF i = 1 THEN found := true
          ELSE BEGIN
            curid := i; idsearch := true; found := false;
            search (idtree);
            IF found THEN WITH curdesc @ DO
              IF odd (data DIV 4) THEN found := false
              ELSE IF data > 4 THEN
                IF kind <> 3 THEN found := false;
            IF NOT found THEN readloc := readloc + 2
          END;
          IF found THEN
          BEGIN
            lin := getbyte;
            lin := lin * bytep1 + getbyte;
            IF lin = 0 THEN purgeit := true
          END
          ELSE purgeit := true;
          IF (k = deleterk) OR (k = restorrk) THEN
          BEGIN
            k := k - 1; idn := i; j := lin;
            GOTO 1
          END;
          k := getbyte;
          IF k = 0 THEN purgeit := true;
          IF NOT purgeit THEN
 
          BEGIN
            putbyte (key);
            IF (key = deleterk) OR (key = restorrk) THEN
            BEGIN
              putdouble (idn);
              putdouble (j)
            END;
            putdouble (i);
            putdouble (lin);
            putbyte (k);
            FOR j := 1 TO k DO putbyte (getbyte)
          END
          ELSE readloc := readloc + k
        END
        ELSE GOTO 2;
        key := getbyte;
        IF key > maxk THEN key := endk
      UNTIL key = endk;
2:  END   (* idprocess *);
 
  PROCEDURE processline;
 
    VAR                   k : keyrange;
                        idn : idnumber;
                        idq,
                  idnp, idp : ident;
                 t1, t2, t3 : changes;
        lin, rec, loc, i, j : bignumber;
                        fil : fileindex;
thisactive, yanked, purgeit : boolean;
 
    PROCEDURE writehistory;
 
      BEGIN   (* writehistory *)
        IF longth + 10 > listwidthm15 THEN
        BEGIN
          IF longth <= listwidthm15 THEN writeln;
          ensure (0, 2);
          IF seqflag THEN write (' ':6);
          longth := 9
        END
        ELSE BEGIN
          longth := longth + 10;
          write (' ')
        END;
        IF thisactive THEN write ('+')
        ELSE write ('-');
        fwwrite (curdesc @.name, false)
      END   (* writehistory *);
 
    PROCEDURE condprocess (k : keyrange);
 
      VAR nl : namelist;
 
      BEGIN   (* condprocess *)
        IF skippedifs > 0 THEN
          IF k = endifk THEN skippedifs := skippedifs - 1
          ELSE IF k <> elsek THEN
            IF skippedifs = maxfilerec THEN fatal (toomanyifs)
            ELSE skippedifs := skippedifs + 1
          ELSE BEGIN
            IF skippedifs = 1 THEN
            BEGIN
              skippedifs := 0;
              IF activeifs = maxfilerec THEN fatal (toomanyifs)
              ELSE activeifs := activeifs + 1
            END
          END
        ELSE CASE k OF
      elsek : IF activeifs > 0 THEN
              BEGIN
                activeifs := activeifs - 1; skippedifs := 1
              END
              ELSE BEGIN
                error;
                write ('An *ELSE directive matches no *IF; ',
                  '*ELSE is on line ');
                fwwrite (identword, true);
                writeln ('.', linenum:1, '.')
              END;
     endifk : IF activeifs > 0 THEN activeifs := activeifs - 1
              ELSE BEGIN
                error;
                write ('An *ENDIF directive matches no *IF; ',
                  '*ENDIF is on line ');
                fwwrite (identword, true);
                writeln ('.', linenum:1, '.')
              END;
ifdefk, ifndefk :
              BEGIN
                found := false;
                nl := yankdeck @.dlst;
                WHILE nl <> NIL DO WITH nl @ DO
                  IF nname > word THEN nl := NIL
                  ELSE IF nname < word THEN nl := nnext
                  ELSE BEGIN
                    found := true; nl := NIL
                  END;
                IF found = (k = ifdefk) THEN
                  IF activeifs = maxfilerec THEN fatal (toomanyifs)
                  ELSE activeifs := activeifs + 1
                ELSE skippedifs := 1
              END;
ifdeckk, ifndeckk :
              BEGIN
                identword := word; idsearch := false;
                found := false; search (nmtree);
                IF found THEN WITH curdesc @ DO
                  IF kind = 3 THEN found := false
                  ELSE IF odd (data DIV 4) THEN found := false;
                IF found = (k = ifdeckk) THEN
                  IF activeifs = maxfilerec THEN fatal (toomanyifs)
                  ELSE activeifs := activeifs + 1
                ELSE skippedifs := 1
              END;
ifidentk, ifnidntk :
              BEGIN
                identword := word; idsearch := false;
                found := false; search (nmtree);
                IF found THEN WITH curdesc @ DO
                  IF kind <> 3 THEN found := false
                  ELSE IF odd (data DIV 4) THEN found := false;
                IF found = (k = ifidentk) THEN
                  IF activeifs = maxfilerec THEN fatal (toomanyifs)
                  ELSE activeifs := activeifs + 1
                ELSE skippedifs := 1
              END
        END   (* case *)
      END   (* condprocess *);
 
    PROCEDURE calldeck;
 
      VAR oldmxid : idnumber;
               t1 : yanklist;
 
      BEGIN   (* calldeck *)
        identword := word;
        idsearch := false; found := false;
        search (nmtree);
        IF found THEN WITH curdesc @ DO
          IF (kind <> 1) AND (kind <> 4) THEN found := false
          ELSE IF odd (data DIV 4) THEN found := false
          ELSE IF odd (data DIV 2) THEN found := false;
        IF found THEN WITH curdesc @ DO
        BEGIN
          oldmxid := oldmaxid;
          rec := readrec; loc := readloc;
          IF sylist <> NIL THEN clearselyanks (false);
          processdeck (curdesc, true, false);
          t1 := sylist;
          WHILE t1 <> NIL DO WITH t1 @, yank @ DO
          BEGIN
            IF real <> curr THEN
              IF curr THEN data := data + 2
              ELSE data := data - 2;
            t1 := ynxt
          END;
          IF listdirectives THEN
            listing := [compfilk..ifnidntk, pointatk..upperk]
          ELSE listing := [ ];
          IF id @.kind = 2 THEN
            IF listactive OR listinactive THEN IF nowlisting THEN
              listing := [blankk..deckk, pointatk..upperk];
          thisdeck := id;
          WITH thisdeck @ DO
          BEGIN
            thisdeckname := name; thisdeckid := idno
          END;
          oldmaxid := oldmxid;
          setreadfile (fil, rec, loc)
        END
        ELSE BEGIN
          error;
          write ('Common deck ');
          fwwrite (identword, true);
          writeln (' called but not found.')
        END
      END   (* calldeck *);
 
    PROCEDURE kprocess;
 
      VAR i : byte;
 
      BEGIN   (* kprocess *)
        CASE key OF
          widthk : BEGIN
                     newdwid := getbyte;
                     newswid := getbyte;
                     IF lineactive THEN IF skippedifs = 0 THEN
                     BEGIN
                       IF newdwid <> 1 THEN curdatawid := newdwid;
                       IF newswid <> 1 THEN curseqwid := newswid;
                       i := curdatawid + curseqwid;
                       IF i > bytesize THEN i := bytesize;
                       curcompwid := i;
                       curseqwid := curcompwid - curdatawid;
                       IF curseqwid < 5 THEN
                       BEGIN
                         curseqwid := 0; curcompwid := curdatawid
                       END
                     END;
                     IF copy THEN
                     BEGIN
                       putbyte (newdwid); putbyte (newswid)
                     END
                   END   (* widthk *);
        elsek, endifk, pointatk, pointupk, upperk :;
      dok, dontk : word := idp @.name;
        callk, definek, ifdefk, ifdeckk, ifidentk, ifndefk, ifndeckk,
        ifnidntk : BEGIN
                     i := getbyte;
                     IF i > alfaleng THEN fatal (badopl);
                     getname (i);
                     IF copy THEN
                     BEGIN
                       putbyte (i);
                       putname (word, i)
                     END
                   END   (* callk *);
 comdeckk, deckk : word := identword;
 yankdckk, yankk : WITH idp @ DO
                   BEGIN
                     word := name;
                     IF lineactive THEN IF NOT cdrw OR secflag THEN
                       IF NOT odd (data DIV 2) THEN data := data + 2
                   END   (* yankdckk, yankk *);
        selyankk : WITH idq @ DO
                   BEGIN
                     word := idp @.name;
                     thisdeckname := name;
                     IF lineactive THEN IF NOT cdrw OR secflag THEN
                       addmodtodeck (idp, selyank, idno, 0, 0, 0, idn)
                   END   (* selyankk *)
        END   (* case *)
      END   (* kprocess *);
 
    PROCEDURE testselyank;
 
      VAR t1 : decklist;
 
      BEGIN   (* testselyank *)
        idq := NIL;
        curid := getbyte;
        IF curid >= halfbyte THEN fatal (badopl);
        curid := curid * bytep1 + getbyte;
        idsearch := true; secondary := secflag; found := false;
        IF NOT purgeit THEN search (idtree);
        secondary := false;
        IF found THEN WITH curdesc @ DO
          IF NOT odd (data DIV 4) THEN
          IF kind = 5 THEN idq := curdesc
          ELSE IF kind = 3
          THEN BEGIN
            t1 := curdesc @.afct;
            WHILE t1 <> NIL DO WITH t1 @, idp @ DO
              IF adeck @.idno = idno
              THEN BEGIN
                t1 := NIL; idq := curdesc
              END
              ELSE t1 := anext
          END;
        IF idq = NIL THEN purgeit := true
      END   (* testselyank *);
 
    BEGIN   (* processline *)
      REPEAT
        k := key; yanked := false;
        purgeit := yanked;
        lineactive := true;
        fil := readfile;
        IF (k = deckk) OR (k = comdeckk) THEN
        BEGIN
          lin := 1;
          lineno := 0;
          idn := getbyte;
          IF idn >= halfbyte THEN fatal (badopl);
          idn := idn * bytep1 + getbyte;
          IF idn <> thisdeckid THEN fatal (badopl);
          IF copy THEN IF NOT reseq THEN
          BEGIN
            putbyte (k); putdouble (idn)
          END
        END
        ELSE IF k = commentk THEN
        BEGIN
          IF copy THEN putbyte (commentk)
        END
        ELSE BEGIN
          lin := getbyte; lin := lin * bytep1 + getbyte;
          IF k < comdeckk THEN idn := thisdeckid
          ELSE IF (k > selyankk) AND (k <= insertk) THEN
            idn := thisdeckid
          ELSE BEGIN
            IF (k = dopins) OR (k = dontpins) THEN
              k := k - insertk;
            IF k >= lowmk THEN k := k - beforek
            ELSE IF k > insertk THEN k := k - insertk
            ELSE BEGIN
              idp := NIL;
              curid := getbyte;
              IF curid >= halfbyte THEN fatal (badopl);
              curid := curid * bytep1 + getbyte;
              idsearch := true; secondary := secflag; found := false;
              search (idtree); secondary := false;
              IF found THEN
                IF NOT odd (curdesc @.data DIV 4) THEN idp := curdesc;
              IF idp = NIL THEN purgeit := true;
              IF k = selyankk THEN testselyank
            END;
            idn := getbyte;
            IF idn >= halfbyte THEN fatal (badopl);
            idn := idn * bytep1 + getbyte;
            curid := idn;
            secondary := secflag; idsearch := true;
            found := false; search (idtree); secondary := false;
            idnp := NIL;
            IF found THEN WITH curdesc @ DO
            BEGIN
              idnp := curdesc;
              IF idn > oldmaxid THEN IF NOT secflag THEN
              BEGIN
                lstn := lstn + 1; lin := lstn
              END
            END
          END;
          IF k > uplitk THEN fatal (badopl);
          rec := readrec; loc := readloc;
 
          IF bef <> NIL THEN
          BEGIN
            t1 := bef; t2 := NIL;
            WHILE t1 <> NIL DO WITH t1 @ DO
              IF startid > idn THEN t1 := NIL
              ELSE IF startid < idn THEN
              BEGIN
                t2 := t1; t1 := cnext
              END
              ELSE IF startno > lin THEN t1 := NIL
              ELSE IF startno < lin THEN
              BEGIN
                t2 := t1; t1 := cnext
              END
              ELSE BEGIN
                IF t2 = NIL THEN bef := cnext
                ELSE t2 @.cnext := cnext;
                IF ckind = listd THEN
                BEGIN
                  skipflag := skipflag OR NOT nowlisting;
                  nowlisting := true;
                  listing := [blankk..selyankk, pointatk..upperk]
                END
                ELSE BEGIN
                  setreadfile (tpzfile, locus, where);
                  key := getbyte;
                  IF key > maxk THEN fatal (badopl);
                  IF key <> endk THEN processline
                END;
                dispose (t1);
                IF t2 = NIL THEN t1 := bef
                ELSE t1 := t2 @.cnext
              END   (* before is found *);
            setreadfile (fil, rec, loc); key := k
          END   (* bef <> nil *);
 
          IF idn = thisdeckid THEN identword := thisdeckname
          ELSE IF idnp = NIL THEN purgeit := true
          ELSE WITH idnp @ DO
              IF odd (data DIV 4) THEN purgeit := true
              ELSE BEGIN
                yanked := odd (data DIV 2);
                IF reseq THEN purgeit := yanked OR purgeit
                ELSE BEGIN
                  IF NOT odd (data) THEN data := data + 1;
                  identword := name
                END
              END;
          IF NOT reseq THEN IF copy THEN IF NOT purgeit THEN
            IF idn = thisdeckid THEN
            BEGIN
              putbyte (k); putdouble (lin)
            END
            ELSE IF k < comdeckk THEN
            BEGIN
              putbyte (k + insertk);
              putdouble (lin);
              IF (k = dok) OR (k = dontk) THEN putdouble (idp @.idno);
              putdouble (idn)
            END
            ELSE IF k > selyankk THEN
            BEGIN
              putbyte (k + beforek);
              putdouble (lin)
            END
            ELSE BEGIN
              putbyte (k);
              putdouble (lin); putdouble (idp @.idno);
              IF (k = selyankk) THEN putdouble (idq @.idno);
              putdouble (idn)
            END;
          lineactive := NOT purgeit;
 
          longth := listwidth + 1;
          REPEAT
            i := getbyte;
            j := getbyte;
            curid := (i MOD halfbyte) * bytep1 + j;
            IF curid > 0 THEN
            BEGIN
              secondary := secflag; idsearch := true;
              found := false; search (idtree);
              secondary := false;
              IF found THEN WITH curdesc @ DO
                IF odd (data DIV 4) THEN found := false
                ELSE IF NOT reseq THEN
                  IF NOT odd (data) THEN data := data + 1;
              IF found THEN
              BEGIN
                IF purgeit THEN thisactive := false
                ELSE BEGIN
                  thisactive := NOT (i >= halfbyte);
                  IF audflag THEN IF NOT reseq THEN IF nowlisting THEN
                    writehistory
                END;
                IF NOT odd (curdesc @.data DIV 2) THEN
                  lineactive := thisactive;
                IF NOT reseq THEN
                  IF copy THEN IF NOT purgeit THEN
                  BEGIN
                    putbyte (i); putbyte (j)
                  END
              END
            END
          UNTIL curid = 0;
 
          t1 := dur; t2 := NIL;
          WHILE t1 <> NIL DO WITH t1 @ DO
            IF (startid = idn) AND (startno = lin) THEN
            BEGIN
              IF t2 <> NIL THEN t2 @.cnext := cnext
              ELSE dur := cnext;
              t3 := t1; t1 := cnext;
              addmodtocur (t3)
            END
            ELSE IF (where = idn) AND (locus = lin) THEN
            BEGIN
              switchwarn (t1);
              where := startid; locus := startno;
              IF t2 <> NIL THEN t2 @.cnext := cnext
              ELSE dur := cnext;
              t3 := t1; t1 := cnext;
              addmodtocur (t3)
            END
            ELSE BEGIN
              t2 := t1; t1 := cnext
            END;
 
          t1 := cur; t2 := NIL;
          WHILE t1 <> NIL DO WITH t1 @ DO
          IF idn < mdwho THEN
          BEGIN
            curid := mdwho;
            idsearch := true; found := false;
            search (idtree);
            IF found THEN WITH curdesc @ DO
              IF odd (data DIV 4) THEN found := false
              ELSE IF NOT reseq THEN
                IF NOT odd (data) THEN data := data + 1;
            IF found THEN
            BEGIN
              IF NOT purgeit THEN
              BEGIN
                thisactive := ckind = restore;
                IF audflag THEN IF NOT reseq THEN IF nowlisting THEN
                  writehistory;
                IF NOT odd (curdesc @.data DIV 2) THEN
                  lineactive := thisactive
              END;
              IF NOT reseq THEN IF copy THEN IF NOT purgeit THEN
              BEGIN
                i := mdwho DIV bytep1; j := mdwho MOD bytep1;
                IF thisactive THEN putbyte (i)
                ELSE putbyte (i + halfbyte);
                putbyte (j)
              END
            END;
            IF (where = idn) AND (locus = lin) THEN
            BEGIN
              IF t2 = NIL THEN cur := cnext
              ELSE t2 @.cnext := cnext;
              t3 := t1;
              t1 := cnext;
              dispose (t3)
            END
            ELSE BEGIN
              t2 := t1; t1 := cnext
            END
          END   (* idn < mdwho *)
          ELSE t1 := NIL;
 
          IF audflag THEN
            IF longth <= listwidth THEN writeln;
          IF copy THEN IF NOT purgeit THEN
            IF NOT reseq THEN putdouble (0)
        END   (* k in blankk..selyankk *);
 
        lineactive := lineactive AND NOT yanked;
        IF reseq THEN purgeit := purgeit OR NOT lineactive;
 
        IF counting THEN
        BEGIN
          IF k = commentk THEN i := 1
          ELSE IF purgeit THEN i := 5
          ELSE IF deckyanked OR NOT lineactive THEN i := 4
          ELSE IF (k = dok) OR (k = dontk) THEN i := 2
          ELSE IF skippedifs > 1 THEN i := 3
          ELSE IF (skippedifs = 1) AND (k <> elsek) AND (k <> endifk)
            THEN i := 3
          ELSE i := 2;
          IF count [i] < maxfilerec THEN count [i] := count [i] + 1
        END;
 
        IF NOT purgeit THEN
        BEGIN
          IF k > selyankk THEN
            key := k + 8
          ELSE key := k;
          IF key <> commentk THEN
          BEGIN
            IF (key = dok) OR (key = dontk)
            THEN BEGIN
              IF lineactive THEN
                addselyank (idp @.idno, key = dontk,
                  (idn > oldmaxid) AND NOT secflag);
              IF reseq THEN lineactive := false
            END;
            IF reseq THEN
            BEGIN
              IF lineactive THEN
              BEGIN
                IF lineno < maxfilerec THEN lineno := lineno + 1
                ELSE fatal (toomanylines);
                linenum := lineno; identword := thisdeckname;
                IF copy THEN
                BEGIN
                  putbyte (k);
                  IF (k = comdeckk) OR (k = deckk) THEN
                    putdouble (thisdeckid)
                  ELSE BEGIN
                    putdouble (linenum);
                    putdouble (0)
                  END
                END
              END
            END   (* reseq *)
            ELSE BEGIN
              linenum := lin;
              IF befores <> NIL THEN
                IF idn = thisdeckid THEN addbefore (id)
                ELSE addbefore (idnp)
              ELSE IF idn <> thisdeckid THEN IF thisdeckid <> 1 THEN
                IF idnp @.data > 7 THEN addbefore (idnp)
            END
          END;
 
          IF key IN lk THEN
          BEGIN
            lineactive := lineactive AND NOT deckyanked;
            IF k IN [commentk, datak..compfilk] THEN
            BEGIN
              iline [1] := chr (getbyte);
              IF copy THEN
              BEGIN
                putbyte (ord (iline [1]));
                FOR i := 2 TO ord (iline [1]) + 1 DO
                BEGIN
                  j := getbyte;
                  iline [i] := chr (j);
                  putbyte (j)
                END
              END
              ELSE FOR i := 2 TO ord (iline [1]) + 1 DO
                iline [i] := chr (getbyte)
            END   (* k in commentk..compfilk *)
            ELSE IF k > blankk THEN kprocess;
            list;
            IF lineactive THEN
              IF listit THEN IF factive [comfile] THEN
              IF k IN [elsek, endifk, ifdefk..ifnidntk] THEN
                condprocess (k)
              ELSE IF k >= compfilk THEN IF skippedifs = 0 THEN
              CASE k OF
                compfilk : IF factive [comfile] THEN
                           BEGIN
                             bline [longth + 1] := ',';
                             nextin := 11;
                             getfname (comfile, false, true)
                           END;
                   callk : calldeck;
                 definek : addcall (yankdeck, word, 1);
                poatlitk : BEGIN
                             newpch := '@'; oldpch := '^';
                             pascflag := true
                           END;
                pouplitk : BEGIN
                             newpch := '^'; oldpch := '@';
                             pascflag := true
                           END;
                  uplitk : uppercase := true
                OTHERWISE
                END   (* case *)
          END   (* k in lk *)
          ELSE IF k IN [commentk, datak..compfilk, callk..ifnidntk]
          THEN BEGIN
            i := getbyte;
            IF copy THEN BEGIN
              putbyte (i);
              FOR j := 1 TO i DO putbyte (getbyte)
            END
            ELSE readloc := readloc + i
          END
          ELSE IF (k = yankk) OR (k = yankdckk) THEN
          BEGIN
            IF lineactive THEN IF NOT cdrw OR secflag THEN
              WITH idp @ DO
                IF NOT odd (data DIV 2) THEN data := data + 2
          END
          ELSE IF k = selyankk
          THEN BEGIN
            IF lineactive THEN IF NOT cdrw OR secflag THEN
              addmodtodeck (idp, selyank, idq @.idno, 0, 0, 0, idn)
          END
          ELSE IF k = widthk THEN
            IF copy THEN
            BEGIN
              putbyte (getbyte); putbyte (getbyte)
            END
            ELSE readloc := readloc + 2
        END   (* not purgeit *)
        ELSE IF k IN [commentk, datak..compfilk,
          definek..ifnidntk] THEN
        BEGIN
          i := getbyte;
          readloc := readloc + i
        END
        ELSE IF k = widthk THEN readloc := readloc + 2
        ELSE IF k = callk THEN
        BEGIN
          i := getbyte;
          getname (i);
          addcall (thisdeck, word, -1)
        END;
        t1 := aft; t2 := NIL;
        WHILE t1 <> NIL DO WITH t1 @ DO
          IF startid > idn THEN t1 := NIL
          ELSE IF startid < idn THEN
          BEGIN
            t2 := t1; t1 := cnext
          END
          ELSE IF startno > lin THEN t1 := NIL
          ELSE IF startno < lin THEN
          BEGIN
            t2 := t1; t1 := cnext
          END
          ELSE BEGIN
            IF t2 = NIL THEN aft := cnext
            ELSE t2 @.cnext := cnext;
            IF ckind = nolist THEN
            BEGIN
              skipflag := skipflag OR nowlisting;
              nowlisting := false;
              IF listdirectives THEN
                listing := [compfilk..selyankk, pointatk..upperk]
              ELSE listing := [ ]
            END
            ELSE BEGIN
              rec := readrec; loc := readloc;
              setreadfile (tpzfile, locus, where);
              key := getbyte;
              IF key > maxk THEN fatal (badopl);
              IF key <> endk THEN processline;
              setreadfile (fil, rec, loc)
            END;
            dispose (t1);
            IF t2 = NIL THEN t1 := aft
            ELSE t1 := t2 @.cnext
          END;
        key := getbyte;
        IF key > maxk THEN fatal (badopl)
      UNTIL key = endk
    END   (* processline *);
 
  BEGIN   (* processdeck *)
    olddline := dlinenum; dlinenum := 0;
    ldi := listdirectives;
    audflag := false; counting := false;
    sylist := NIL;
    bef := NIL; dur := NIL; aft := NIL; cur := NIL; t2 := NIL;
    befores := NIL;
    listing := [ ];
    WITH id @ DO
    BEGIN
      deckyanked := (kind < 3) AND odd (data DIV 2);
      secflag := kind > 3;
      IF kind < 3 THEN t1 := chgs
      ELSE t1 := NIL;
      IF t1 <> NIL THEN
      BEGIN
        chgs := NIL;
        IF t1 @.ckind = before THEN
        BEGIN
          bef := t1; t2 := bef; t1 := t1 @.cnext;
          WHILE t1 <> NIL DO WITH t1 @ DO
            IF ckind = before THEN
            BEGIN
              t2 := t1; t1 := cnext
            END
            ELSE t1 := NIL;
          IF t2 <> NIL THEN WITH t2 @ DO
          BEGIN
            t1 := cnext; cnext := NIL; t2 := NIL
          END
        END;
 
        IF t1 <> NIL THEN IF t1 @.ckind < insert THEN
        BEGIN
          dur := t1; t2 := dur; t1 := t1 @.cnext;
          WHILE t1 <> NIL DO WITH t1 @ DO
            IF ckind >= insert THEN t1 := NIL
            ELSE BEGIN
              t2 := t1; t1 := cnext
            END;
          IF t2 <> NIL THEN WITH t2 @ DO
          BEGIN
            t1 := cnext; cnext := NIL; t2 := NIL
          END
        END;
 
        IF t1 <> NIL THEN IF t1 @.ckind = insert THEN
        BEGIN
          aft := t1; t2 := aft; t1 := t1 @.cnext;
          WHILE t1 <> NIL DO WITH t1 @ DO
            IF ckind = insert THEN
            BEGIN
              t2 := t1; t1 := cnext
            END
            ELSE t1 := NIL;
          IF t2 <> NIL THEN WITH t2 @ DO
          BEGIN
            t1 := cnext; cnext := NIL; t2 := NIL
          END
        END;
 
        WHILE t1 <> NIL DO WITH t1 @ DO
        BEGIN
          t2 := t1; t1 := cnext;
          IF ckind < selyank THEN
            IF (kind = 1) AND (listit OR cdrw) THEN
            BEGIN
              cnext := chgs; chgs := t2
            END
            ELSE IF ckind = listd THEN addlist (true)
            ELSE addlist (false)
          ELSE BEGIN
            cnext := chgs; chgs := t2;
            addselyank (startid, true, false)
          END
        END
      END   (* t1 <> nil *);
 
      IF secflag THEN setreadfile (altfile, strc, stlo)
      ELSE setreadfile (ofil, strc, stlo);
      copy := true; lst := false;
      IF NOT cdrw THEN
      BEGIN
        IF factive [nplfile] AND
          ((kind = 2) OR NOT listit) THEN
        BEGIN
          setwritefile (nplfile);
          WHILE writeloc MOD bufmult <> 0 DO putbyte (0);
          IF kind = 1 THEN
          BEGIN
            strb := writerec; stlb := writeloc
          END
          ELSE BEGIN
            ofil := nplfile; strc := writerec; stlo := writeloc
          END
        END
        ELSE copy := kind = 3;
        IF (kind = 1) OR (kind = 4) THEN
          IF listit THEN
          BEGIN
            lst := true;
            tlk := sourcelist; sourcelist := [ ];
            IF listdirectives THEN
              listing := [compfilk..deckk, pointatk..upperk]
          END
          ELSE BEGIN
            audflag := audit;
            counting := listcounts;
            IF factive [comfile] THEN listdirectives := false;
            lst := factive [srcfile] OR listdirectives OR
              listactive OR listinactive;
            IF lst THEN
            BEGIN
              IF listactive OR listinactive THEN
                listing := [blankk..deckk, pointatk..upperk]
              ELSE IF listdirectives THEN
                listing := [compfilk..deckk, pointatk..upperk];
              tlk := compiling; compiling := [ ]
            END
          END
        ELSE IF kind = 0 THEN
        BEGIN
          audflag := audit;
          counting := listcounts;
          lst := listdirectives OR listactive OR listinactive;
          IF lst THEN listing := [yankdckk..selyankk]
        END
        ELSE BEGIN
          audflag := audit;
          counting := listcounts AND (kind = 2);
          lst := listit OR listactive OR listinactive;
          IF lst THEN
            IF listactive OR listinactive THEN
              listing := [blankk..deckk, pointatk..upperk]
            ELSE IF listdirectives THEN
              listing := [compfilk..deckk, pointatk..upperk]
        END
      END
      ELSE IF secflag THEN copy := false
      ELSE BEGIN
        IF kind = 1 THEN setwritefile (tpyfile)
        ELSE setwritefile (tpzfile);
        ofil := writefile;
        strc := writerec; stlo := writeloc
      END;
      reseq := odd (data DIV 8) AND (cdrw OR (kind = 2) OR
        (kind = 1) AND NOT factive [comfile]);
      IF lst THEN
      BEGIN
        IF reseq THEN listing := listing - [dok, dontk];
        lk := compiling + listing + sourcelist;
        IF factive [comfile] THEN
          IF listit THEN
            lk := lk + [compfilk..ifnidntk, pointatk..upperk];
        IF NOT nowlisting THEN
          IF listdirectives THEN
            listing := [compfilk..selyankk, pointatk..upperk]
          ELSE listing := [ ]
      END
      ELSE lk := [ ];
      skipflag := skipflag OR (listing <> [ ]);
      IF counting THEN
        FOR i := 1 TO 5 DO count [i] := 0;
      curid := idno;
      word := name;
      identword := word;
      thisdeckname := identword;
      thisdeckid := curid;
      thisdeck := id;
      oldmaxid := maxid;
      IF cdrw OR (kind = 2) OR (kind = 1) AND NOT factive [comfile]
        THEN IF oldmaxident <> NIL THEN IF NOT secflag THEN
        BEGIN
          oldmaxid := oldmaxident @.idno - 1;
          setupmod (oldmaxident)
        END;
      IF listit THEN
        IF (kind = 1) OR (kind = 4) THEN
          data := data + 4;
      key := getbyte;
      IF NOT (key IN [comdeckk, deckk, identk]) THEN
        fatal (badopl);
      IF key = identk THEN idprocess
      ELSE processline;
      WHILE bef <> NIL DO WITH bef @ DO
      BEGIN
        t1 := bef;
        bef := cnext;
        setreadfile (tpzfile, locus, where);
        key := getbyte;
        IF key > maxk THEN fatal (badopl);
        IF key <> endk THEN processline;
        dispose (t1)
      END;
      IF sylist <> NIL THEN clearselyanks (true);
      IF befores <> NIL THEN IF mxrc < maxfilerec THEN
      BEGIN
        linenum := mxrc + 1;
        addbefore (id)
      END;
      IF reseq THEN mxrc := lineno;
 
      IF counting THEN
      BEGIN
        ensure (1,7);
        IF thisdeckid <> 1 THEN
        BEGIN
          write ('Deck ');
          fwwrite (thisdeckname, true)
        END
        ELSE BEGIN
          write ('The yank deck');
          count [2] := count [2] - 1
        END;
        writeln (' contained:');
        skipflag := true;
        FOR i := 1 TO 5 DO
        IF (count [i] > 0) OR
          (thisdeckid = 1) AND (i = 2) AND (count [4] = 0) THEN
        BEGIN
          ensure (0, 1);
          write (count [i] : 10, ' ');
          CASE i OF
            1 : write ('comment');
            2 : write ('active line');
            3 : write ('skipped line');
            4 : write ('inactive line');
            5 : write ('purged line')
          END;
          IF count [i] <> 1 THEN write ('s');
          writeln
        END;
        skipflag := true
      END;
 
      listdirectives := ldi;
      dlinenum := olddline;
      IF lst THEN
        IF (kind <> 2) AND listit THEN
        BEGIN
          sourcelist := tlk;
          IF kind <> 3 THEN data := data - 4
        END
        ELSE IF (kind = 1) AND NOT listit THEN
          compiling := tlk;
      IF copy THEN putbyte (0)
    END
  END   (* processdeck *);
 
PROCEDURE processcomdecks;
 
  VAR dk : ident;
 
  BEGIN   (* processcomdecks *)
    dk := first [1];
    WHILE dk <> NIL DO WITH dk @ DO
    BEGIN
      IF odd (data DIV 4) THEN data := 4
      ELSE IF (chgs <> NIL) OR odd (data DIV 8) THEN
        IF factive [comfile] THEN processdeck (dk, false, true);
      dk := next
    END;
    IF fstatus [tpyfile] <> closed THEN flush (tpyfile);
    dk := first [1];
    WHILE dk <> NIL DO WITH dk @ DO
    BEGIN
      IF odd (data) THEN
        BEGIN
          textinput := false;
          processdeck (dk, false, false);
          IF textinput THEN IF fstatus [srcfile] = opwrite THEN
          BEGIN
            writeln (source); write (source, masterch, 'ENDTEXT');
            textinput := false
          END
        END;
        dk := next
    END
  END   (* processcomdecks *);
 
PROCEDURE copydecks;
 
  VAR dk : ident;
       i : 1..alfaleng;
      ch : intchar;
opc, npc : char;
pfl, ufl : boolean;
  n1, n2 : namelist;
 
  BEGIN   (* copydecks *)
    ufl := uppercase;
    pfl := pascflag;
    opc := oldpch; npc := newpch;
    dk := first [2];
    WHILE dk <> NIL DO WITH dk @ DO
    BEGIN
      IF odd (data) THEN IF NOT odd (data DIV 4) THEN
      IF odd (data DIV 2) THEN
      BEGIN
        IF factive [nplfile] THEN
          processdeck (dk, false, false)
      END
      ELSE BEGIN
        curdatawid := datawid;
        curcompwid := compwid;
        curseqwid := curcompwid - curdatawid;
        activeifs := 0;
        skippedifs := 0;
        textinput := false;
        uppercase := ufl;
        pascflag := pfl;
        oldpch := opc; newpch := npc;
        processdeck (dk, true, false);
        WITH yankdeck @ DO
        BEGIN
          n1 := dlst; dlst := NIL
        END;
        WHILE n1 <> NIL DO
        BEGIN
          n2 := n1; n1 := n2 @.nnext; dispose (n2)
        END;
        IF textinput THEN
          IF fstatus [srcfile] = opwrite THEN
          BEGIN
            writeln (source);
            write (source, masterch, 'ENDTEXT');
            textinput := false
          END;
        activeifs := activeifs + skippedifs;
        IF (activeifs <> 0) OR (skippedifs <> 0) THEN
        BEGIN
          error;
          write (' ', activeifs:1, ' missing *ENDIF directive');
          IF activeifs > 1 THEN write ('s');
          write (' in deck ');
          fwwrite (name, true);
          writeln ('.')
        END
      END;
      dk := next
    END
  END   (* copydecks *);
 
PROCEDURE copymodsets;
 
  VAR dk : ident;
 
  BEGIN   (* copymodsets *)
    dk := first [3];
    WHILE dk <> NIL DO WITH dk @ DO
    BEGIN
      IF NOT odd (data DIV 4) THEN
        IF odd (data) THEN
          processdeck (dk, false, false);
      dk := next
    END
  END   (* copymodsets *);
 
PROCEDURE pull (m : ident);
 
  LABEL 1;
 
  VAR    ln : modlist;
         af : decklist;
         fi : fileindex;
 i, j, k, l : bignumber;
         mi : idnumber;
 
  PROCEDURE addescwithcom;
 
    VAR ll, lm  : modlist;
 
    BEGIN   (* adddescwithcom *)
      readloc := readloc - 1;
      IF i <> 0 THEN IF j <> 0 THEN
      IF key IN [beforek..insertk] THEN
      BEGIN
        ll := ln; lm := NIL;
        WHILE ll <> NIL DO WITH ll @ DO
          IF befid > i THEN ll := NIL
          ELSE IF befid < i THEN
          BEGIN
            lm := ll; ll := nextm
          END
          ELSE IF befno > j THEN ll := NIL
          ELSE BEGIN
            lm := ll; ll := nextm
          END;
 
        new (ll);
        WITH ll @ DO
        BEGIN
          CASE key OF
            beforek : ctype := before;
  deletek, deleterk : ctype := delete;
 restorek, restorrk : ctype := restore
          OTHERWISE   ctype := insert
          END;
          befid := i; locat := readloc;
          befno := j; recor := readrec;
          IF lm = NIL THEN
          BEGIN
            nextm := ln; ln := ll
          END
          ELSE BEGIN
            nextm := lm @.nextm; lm @.nextm := ll
          END
        END
      END;
      i := getbyte; readloc := readloc + i
    END   (* adddescwithcom *);
 
  PROCEDURE searchdeck (a : decklist);
 
    VAR  e : decklist;
        id : ident;
    select : boolean;
 
    PROCEDURE scan;
 
      VAR                          lin : 0..mfrplus1;
                                  i, j : bignumber;
                                   idn : idnumber;
affect, deleet, thisdelete, lastdelete : boolean;
 
      FUNCTION unknown (k : keyrange; rf : ident; lin : bignumber) :
        boolean;
 
        LABEL 1;
 
        VAR i : idnumber;
         j, n : byte;
            r : bignumber;
           fi : nplfile..tpzfile;
       m1, m2 : modlist;
           ck : changetyp;
 
        BEGIN   (* unknown *)
          key := k;
          i := rf @.idno;
          m1 := ln; m2 := NIL;
          WHILE m1 <> NIL DO WITH m1 @ DO
            IF befid > i THEN m1 := NIL
            ELSE IF befid < i THEN
            BEGIN
              m2 := m1; m1 := nextm
            END
            ELSE IF befno > lin THEN m1 := NIL
            ELSE IF befno < lin THEN
            BEGIN
              m2 := m1; m1 := nextm
            END
            ELSE BEGIN
              CASE key OF
                beforek : ck := before;
      deletek, deleterk : ck := delete;
                insertk : ck := insert
              OTHERWISE ck := restore
              END;
              IF ctype = ck THEN
              BEGIN
                fi := readfile; r := readrec; i := readloc;
                IF k = beforek THEN
                BEGIN
                  firstref := rf; firstline := lin
                END;
                setreadfile (m @.ofil, recor, locat);
                j := getbyte;
                iline [1] := chr (j);
                FOR n := 2 TO j + 1 DO iline [n] := chr (getbyte);
                setreadfile (fi, r, i);
                list;
                IF m2 = NIL THEN ln := nextm
                ELSE m2 @.nextm := nextm;
                unknown := false;
                dispose (m1);
                GOTO 1
              END
              ELSE BEGIN
                m2 := m1; m1 := nextm
              END
            END;
          unknown := true;
1:      END   (* unknown *);
 
      PROCEDURE checkbefore;
 
        VAR b1, b2 : beflist;
        infr, supr : ident;
        infl, supl : bignumber;
        infk, supk : beforek..insertk;
 
        BEGIN   (* checkbefore *)
          infr := firstref; supr := infr;
          infl := firstline; supl := infl;
          infk := insertk; supk := infk;
          b1 := m @.bfor; b2 := NIL;
          WHILE b1 <> NIL DO WITH b1 @ DO
            IF mline < lin THEN
            BEGIN
              b2 := b1; b1 := bnext
            END
            ELSE IF mline > lin THEN b1 := NIL
            ELSE BEGIN
              IF biden @.idno < infr @.idno THEN
              BEGIN
                supr := biden; supl := bline; supk := beforek
              END
              ELSE BEGIN
                infr := biden; infl := bline; infk := beforek
              END;
              IF b2 = NIL THEN m @.bfor := bnext
              ELSE b2 @.bnext := bnext;
              dispose (b1);
              b1 := NIL
            END;
          IF unknown (infk, infr, infl) THEN
            IF unknown (supk, supr, supl) THEN
            BEGIN
              iline [1] := chr (0);
              IF supk = beforek THEN
              BEGIN
                firstref := supr; firstline := supl
              END;
              list
            END
        END   (* checkbefore *);
 
      BEGIN   (* scan *)
        WITH id @ DO
        BEGIN
          IF NOT odd (data) THEN
          BEGIN
            data := data + 1;
            affect := factive [srcfile]; factive [srcfile] := false;
            deleet := factive [nplfile]; factive [nplfile] := false;
            processdeck (id, false, false);
            lineactive := true;
            factive [srcfile] := affect; factive [nplfile] := deleet
          END;
          IF declared <> id THEN
          BEGIN
            declared := id;
            key := declarek;
            word := name;
            list
          END;
          firstref := id; firstline := 1;
          secondline := 0;
          lastdelete := false;
          setreadfile (ofil, strc, stlo + 3);
          idsearch := true;
          REPEAT
            key := getbyte;
            affect := false;
            IF key = commentk THEN idn := 1
            ELSE BEGIN
              IF key = endk THEN lin := mxrc + 1
              ELSE BEGIN
                lin := getbyte; lin := lin * bytep1 + getbyte
              END;
              IF key < comdeckk THEN idn := idno
              ELSE IF (key > selyankk) AND (key <= insertk) THEN
                idn := thisdeckid
              ELSE BEGIN
                IF (key = dopins) OR (key = dontpins) THEN
                  key := key - insertk;
                IF key >= lowmk THEN key := key - beforek
                ELSE IF key > insertk THEN key := key - insertk
                ELSE BEGIN
                  i := getbyte; i := i * bytep1 + getbyte;
                  IF key = selyankk
                  THEN BEGIN
                    j := getbyte; j := j * bytep1 + getbyte
                  END
                END;
                idn := getbyte;
                idn := idn * bytep1 + getbyte
              END;
              IF idn = idno THEN found := true
              ELSE IF (idn = mi) AND (idno > 1) THEN found := true
              ELSE IF idn <= mi THEN
              BEGIN
                IF idn = mi THEN
                  IF i <= maxident THEN curid := i
                  ELSE fatal (badopl)
                ELSE curid := idn;
                found := false; search (idtree);
                IF found THEN IF odd (curdesc @.data DIV 4) THEN
                  found := false
              END
              ELSE found := false;
              affect := false;
              deleet := NOT lastdelete;
              IF idn = mi THEN
              BEGIN
                REPEAT
                  i := getbyte; i := i * bytep1 + getbyte
                UNTIL i = 0;
                IF secondline = 0 THEN IF firstline <> 0 THEN
                IF idno > 1 THEN
                BEGIN
                  i := key;
                  checkbefore;
                  key := i;
                  firstline := 0
                END
              END
              ELSE IF key <> endk THEN
                REPEAT
                  i := getbyte; thisdelete := i >= halfbyte;
                  i := (i MOD halfbyte) * bytep1 + getbyte;
                  IF i = mi THEN IF found THEN
                  BEGIN
                    deleet := thisdelete; affect := true
                  END
                UNTIL i = 0;
              IF found THEN
              BEGIN
                IF secondline <> 0 THEN IF deleet <> lastdelete
                THEN BEGIN
                  i := key; iline [1] := chr (0);
                  IF lastdelete THEN key := deletek
                  ELSE key := restorek;
                  IF unknown (key, secondref, secondline) THEN list;
                  key := i;
                  secondline := 0
                END
                ELSE BEGIN
                  IF idn = idno THEN secondref := id
                  ELSE secondref := curdesc;
                  secondline := lin
                END;
                IF affect THEN
                  IF secondline = 0 THEN
                  BEGIN
                    IF idn = idno THEN firstref := id
                    ELSE firstref := curdesc;
                    secondref := firstref;
                    firstline := lin;
                    secondline := firstline;
                    lastdelete := deleet
                  END
                  ELSE BEGIN
                    IF idn = idno THEN secondref := id
                    ELSE secondref := curdesc;
                    secondline := lin
                  END
                ELSE IF idn = mi THEN firstline := 0
                ELSE IF secondline = 0 THEN
                BEGIN
                  IF idn = idno THEN firstref := id
                  ELSE firstref := curdesc;
                  firstline := lin
                END
              END
            END;
            IF idn = mi THEN
            BEGIN
              IF key IN [dok, dontk, yankdckk..selyankk] THEN
              BEGIN
                word := curdesc @.name;
                IF key = selyankk
                THEN BEGIN
                  curid := j; found := false; search (idtree);
                  IF found THEN thisdeckname := curdesc @.name
                  ELSE thisdeckname := blanks
                END
              END
              ELSE IF key IN [datak..compfilk] THEN
              BEGIN
                iline [1] := chr (getbyte);
                FOR i := 2 TO ord (iline [1]) + 1 DO
                  iline [i] := chr (getbyte)
              END
              ELSE IF key IN [callk..ifnidntk] THEN
              BEGIN
                i := getbyte;
                IF (i > alfaleng) OR (i = 0) THEN fatal (badopl);
                getname (i)
              END
              ELSE IF key > declarek THEN key := key + 8
              ELSE IF key = widthk THEN
              BEGIN
                newdwid := getbyte; newswid := getbyte
              END;
              list
            END
            ELSE IF key IN [commentk, datak..compfilk, callk..ifnidntk]
            THEN BEGIN
              i := getbyte; readloc := readloc + i
            END
            ELSE IF key = widthk THEN readloc := readloc + 2
          UNTIL key = endk
        END
      END   (* scan *);
 
    BEGIN   (* searchdeck *)
      id := a @.adeck;
      IF id <> NIL THEN
        IF id @.data >= 4 THEN id := NIL;
      IF id = NIL THEN e := a
      ELSE e := m @.afct;
      IF id = NIL THEN WITH e @ DO
 
      BEGIN
        IF where > l THEN IF where < m @.mxrc THEN
        BEGIN
          error;
          write ('Line');
          IF l + 1 = where THEN write (' ', where:1)
          ELSE write ('s ', l + 1:1, ' through ', where:1);
          write (' of modification ');
          fwwrite (m @.name, true);
          writeln (' cannot be recovered.')
        END
      END
      ELSE BEGIN
        select := true;
        WHILE e <> a DO WITH e @ DO
          IF adeck = id THEN
          BEGIN
            select := false;
            e := a
          END
          ELSE e := anext;
        IF select THEN scan
      END;
      l := a @.where
    END   (* searchdeck *);
 
  BEGIN   (* pull *)
    declared := yankdeck;
    key := identk;
    ln := NIL;
 
    WITH m @ DO
    BEGIN
      word := name; mi := idno;
      list;
      fi := ofil;
      setreadfile (fi, strc, stlo + 3);
      af := afct
    END;
 
    key := getbyte;
    WHILE key <> endk DO
    BEGIN
      IF key = commentk THEN
      BEGIN
        i := getbyte;
        iline [1] := chr (i);
        FOR k := 2 TO i + 1 DO iline [k] := chr (getbyte);
        list
      END
      ELSE BEGIN
        IF key > insertk THEN
        BEGIN
          key := key - beforek;
          i := getbyte;
          IF i >= halfbyte THEN i := 0
          ELSE i := i * bytep1 + getbyte;
          IF i > 1 THEN
          BEGIN
            curid := i; idsearch := true; found := false;
            search (idtree);
            IF found THEN addmodtomod (m, curdesc, m @.mxrc)
          END
        END;
 
1:      i := getbyte;
        j := 0;
        IF i >= halfbyte THEN i := 0
        ELSE BEGIN
          i := i * bytep1 + getbyte;
          IF i <> 0 THEN
          BEGIN
            j := getbyte; j := j * bytep1 + getbyte
          END
        END;
        IF (key = deleterk) OR (key = restorrk) THEN
        BEGIN
          key := key - 1; GOTO 1
        END;
        IF getbyte <> 0 THEN addescwithcom
      END;
      key := getbyte
    END;
 
    l := 0;
    WHILE af <> NIL DO WITH af @ DO
    BEGIN
      IF adeck <> NIL THEN searchdeck (af);
      af := anext
    END;
    iline [1] := chr (0); word := m @.name;
    key := commentk; list;
    key := nullk; list;
    key := commentk; list
  END   (* pull *);
 
PROCEDURE recreatemods;
 
  LABEL 1;
 
  VAR dk : ident;
 
  BEGIN   (* recreatemods *)
    lineactive := true;
    textinput := false;
    listcounts := false;
    listdirectives := false;
    listactive := false;
    listinactive := false;
    audit := false;
    factive [comfile] := false;
    compiling := [];
    listing := [];
    sourcelist := [commentk..ifnidntk, yankdckk..upperk];
    IF NOT factive [modfile] THEN
      IF NOT factive [srcfile] THEN
        factive [modfile] := true;
    IF factive [modfile] THEN
    BEGIN
      pullingmods := sourcelist; sourcelist := []
    END;
 
    dk := first [3];
1:  WHILE dk <> NIL DO WITH dk @ DO
    BEGIN
      IF odd (data DIV 8) THEN
        IF NOT odd (data DIV 4) THEN
          IF factive [nplfile] THEN pull (dk)
          ELSE IF oldmaxident = NIL THEN pull (dk)
          ELSE IF idno < oldmaxident @.idno THEN pull (dk)
          ELSE BEGIN
            error;
            write ('Unable to carry out *PULLMOD on ',
              'new modifications such as ');
            fwwrite (name, true); writeln;
            ensure (0, 1);
            writeln (' ':6, 'unless a new program library is',
              ' being created.');
            dk := NIL;
            GOTO 1
          END;
      dk := next
    END
  END   (* recreatemods *);
 
PROCEDURE readdirectory (fi : fileindex);
 
  VAR i, st : bignumber;
     j, stl : bufrange;
     yanked : boolean;
         xn : alfa;
         id : ident;
 
  BEGIN   (* readdirectory *)
    IF fi = altfile THEN
    BEGIN
      new (altyankdeck, true, 2, false);
      WITH altyankdeck @ DO
      BEGIN
        name := blanks;
        idno := 1;
        kind := 4;
        data := 0;
        strc := 1;
        stlo := 8;
        mxrc := 1;
        next := NIL;
        ofil := altfile;
        dlst := NIL;
        chgs := NIL
      END
    END;
    xn := word;
    fwhere [fi] := 2;
    setreadfile (fi, 1, 0);
    IF getbyte <> loctoint [defmasterch] - lcz THEN fatal (badopl);
    i := getbyte;
    IF i >= zer THEN fatal (badopl)
    ELSE IF i <> loctoint [masterch] - lcz THEN
      IF fi = altfile THEN fatal (badmasterch)
      ELSE BEGIN
        error;
        write ('Master control character changed from ''',
          masterch, ''' to ''');
        masterch := inttoloc [i + lcz];
        writeln (masterch, '''.')
      END;
    i := getbyte;
    IF i >= zer THEN fatal (badopl)
    ELSE IF i <> loctoint [commentch] - lcz THEN
      IF fi <> altfile THEN
      BEGIN
        error;
        write ('Comment character changed from ''',
          commentch, ''' to ''');
        commentch := inttoloc [i + lcz];
        writeln (commentch, '''.')
      END;
    i := getbyte;
    fsize [fi] := i * bytep1 + getbyte;
    i := getbyte;
    i := i * bytep1 + getbyte;
    IF (i = 0) OR (i > fsize [fi]) THEN fatal (badopl);
    j := getbyte * bufmult;
    setreadfile (fi, i, j);
    newflag := false;
    addflag := true;
    i := getbyte;
    WHILE i <> 0 DO
    BEGIN
      yanked := i >= yankoffset;
      i := i MOD yankoffset;
      curkind := i DIV alfaleng;
      IF curkind = 0 THEN fatal (badopl);
      i := i MOD alfaleng + 1;
      getname (i);
      identword := word;
      i := getbyte;
      IF i >= halfbyte THEN fatal (badopl);
      curid := i * bytep1 + getbyte;
      IF curid < 2 THEN fatal (badopl);
      i := getbyte;
      st := i * bytep1 + getbyte;
      IF st > fsize [fi] THEN fatal (badopl);
      stl := getbyte * bufmult;
      found := false;
      idsearch := false;
      addflag := true;
      IF fi = altfile THEN
        IF curkind = 3 THEN
        BEGIN
          curkind := 5;
          secondary := true; found := false; idsearch := true;
          search (idtree);
          i := getbyte;
          WHILE i <> 0 DO
          BEGIN
            readloc := readloc + 3;
            i := getbyte
          END;
          secondary := false
        END   (* curkind = 3 *)
        ELSE BEGIN
          IF curkind = 1 THEN
          BEGIN
            curkind := 4;
            IF NOT yanked THEN search (nmtree)
            ELSE found := true;
            IF NOT found THEN WITH curdesc @ DO
            BEGIN
              strc := st; stlo := stl
            END
          END;
          readloc := readloc + 2;
          j := getbyte;
          WHILE j <> 0 DO
          BEGIN
            readloc := readloc + j MOD alfaleng + 1; j := getbyte
          END
        END   (* curkind = 1 or 2 *)
      ELSE BEGIN
        search (nmtree);
        IF found THEN fatal (badopl);
        IF curid > maxid THEN maxid := curid;
        WITH curdesc @ DO
        BEGIN
          strc := st;
          stlo := stl;
          IF curkind = 3 THEN
          BEGIN
            id := curdesc; i := getbyte;
            WHILE i <> 0 DO
            BEGIN
              IF i < halfbyte THEN fatal (badopl);
              i := i MOD halfbyte;
              curid := i * bytep1 + getbyte;
              IF curid = 0 THEN curdesc := NIL
              ELSE IF curid = 1 THEN curdesc := yankdeck
              ELSE BEGIN
                addflag := false; idsearch := true;
                found := false; search (idtree);
                IF NOT found THEN curdesc := NIL
              END;
              i := getbyte;
              addmodtomod (id, curdesc, i * bytep1 + getbyte);
              i := getbyte
            END
          END   (* modset *)
          ELSE BEGIN
            i := getbyte; id := curdesc;
            mxrc := i * bytep1 + getbyte;
            j := getbyte;
            WHILE j <> 0 DO
            BEGIN
              getname (j MOD alfaleng + 1);
              addcall (id, word, j DIV alfaleng);
              j := getbyte
            END
          END   (* deck or comdeck *)
        END   (* with curdesc *)
      END   (* oldpl *);
      i := getbyte
    END   (* while i <> 0 *);
    secondary := false; addflag := false; idsearch := false;
    i := key;
    stl := longth;
    IF fi = altfile THEN processdeck (altyankdeck, false, true)
    ELSE processdeck (yankdeck, false, true);
    longth := stl;
    idsearch := false;
    key := i;
    word := xn
  END   (* readdirectory *);
 
BEGIN   (* updatepl *)
  initialise;
 
  IF factive [inpfile] THEN
    REPEAT
      readline (input);
      IF (key = commentk) OR (key = blankk) THEN key := nullk
      ELSE IF key = filek THEN
      BEGIN
        getlword;
        IF bline [nextin] = ',' THEN nextin := nextin + 1
        ELSE IF bline [nextin] <> ' ' THEN word := '        ';
        IF word = 'INPUT   ' THEN secondaryinput (input, inpfile)
        ELSE IF word = 'OUTPUT  ' THEN
        BEGIN
          getfname (outfile, false, true);
          rwfile (outfile)
        END
        ELSE IF word = 'OLDPL   ' THEN
          getfname (oplfile, true, true)
        ELSE IF word = 'NEWPL   ' THEN
          IF fullrestruct THEN flagline (inappropriate)
          ELSE getfname (nplfile, false, true)
        ELSE IF word = 'COMPILE ' THEN
          getfname (comfile, false, true)
        ELSE IF word = 'SOURCE  ' THEN
          getfname (srcfile, false, true)
        ELSE IF word = 'GETMOD  ' THEN
          getfname (modfile, false, true)
        ELSE IF word = 'ALTPL   ' THEN
          getfname (altfile, true, true)
        ELSE flagline (notfiledes);
        key := nullk
      END   (* key = filek *)
    UNTIL key <> nullk
    ELSE key := nullk;
  expected := commands;
 
  IF factive [comfile] THEN compiling := [blankk..endtextk]
  ELSE compiling := [ ];
 
  IF factive [oplfile] THEN readdirectory (oplfile)
  ELSE createyankdeck;
  oldmaxident := last [3];
  IF factive [inpfile] THEN
  BEGIN
    IF key <> endk THEN processinput;
    IF deleteinput THEN erase (z1, inpfile)
  END;
  IF oldmaxident = NIL THEN oldmaxident := first [3]
  ELSE oldmaxident := oldmaxident @.next;
  IF NOT fullmode THEN setcompilebits;
 
  IF fstatus [tpzfile] <> closed THEN flush (tpzfile);
 
  processdeck (yankdeck, false, false);
  IF factive [srcfile] THEN sourcelist := [commentk..endifk,
    callk..deckk, pointatk..upperk];
  IF factive [altfile] THEN
    readdirectory (altfile);
  processcomdecks;
  copydecks;
  IF factive [nplfile] THEN
  BEGIN
    copymodsets;
    writedirectory
  END;
 
  IF binchars > 0 THEN
  BEGIN
    ensure (2, 1);
    write ('The INPUT lines contained ', binchars:1,
      ' unprintable character');
    IF binchars > 1 THEN writeln ('s.')
    ELSE writeln ('.')
  END;
 
  IF listdirectory THEN directorylisting;
  recreatemods;
  closefiles
 
END   (* updatepl *).
