//		Copyright (c) 1999 by
//		Advanced Visual Systems Inc.
//		All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/dbil/dbil_error.hxx#1 $
//

// file: dbil_error.hxx
// author: Patrick Li, Advanced Visual Systems
// purpose: Class definition for DBIL Error handler
//
//  This class can be subclassed to add the ability to store and retrieve error
//    state. It provides a common interface for users of the DBIL classes to get
//    error information.
//
#ifndef DBIL_ERROR_DEFINED
#define DBIL_ERROR_DEFINED 1

#define DBIL_MAX_ERROR_LENGTH 1024

// Define DBIL_Error_Tool class
//
class DBIL_Error_Tool {
public:
   DBIL_Error_Tool();
   virtual ~DBIL_Error_Tool();

   // Clear errors
   //
   void ResetErrors();

   // Set errors based on various input args
   //
   void SetErrors( DBIL_Error_Tool &err );
   void SetErrors( const char *dbil, const char *se = NULL, const char *db = NULL );
   void SetDBErrors( const int errcode, const char *db = NULL );
   void SetDBILErrors( const int errcode, const char *dbil = NULL );

   // Return an error string with all errors
   //
   const char *GetErrorString();

   // Return individual errors strings
   //
   const int GetDBILErrorCode() const{ return dbil_errcode; }
   const char *GetDBILError() const{ return dbil_err; }
   const char *GetSEError() const{ return se_err; }
   const char *GetDBError() const{ return db_err; }

	// Return db specific error code
	//
   const int GetDBErrorCode() const{ return db_errcode; }

protected:
   char *dbil_err;
   char *se_err;
   char *db_err;
   int	db_errcode;
   int	dbil_errcode;
   char *errString;

private:
   // Create private copy constructor and assignment operator 
   // to invalidate copys and assignments
   //
   DBIL_Error_Tool( const DBIL_Error_Tool & ) {}
   DBIL_Error_Tool &operator=(const DBIL_Error_Tool &) { return *this; }
};
#endif
