//			Copyright (c) 2003 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/demos/v/apps/flight.v#1 $

// This demo inherits from the Demo3D template. This template provides
// some standard functionality which is shared amongst the demos.

DEMOS.Macros.Demo3D FlightPath<NEsmallPixmapName="$XP_PATH<0>/demos/icons/flight.bmp",NEhelpFile="demos/Flight.html",NEdisplayMode="maximized"> {

// The top level params block is used to store common variables that are
// used throughout the application. Typically, this is also the approach
// used to store application state.

   params {
      int run<NEportLevels=1> = 0;
      title = "Flight Path Demo";
      info_text = "To show realtime camera transformation.\nUse the Editor above to draw a\nflight path with the <RMB>.";
      int frames<NEportLevels=1> = 2;
      int interpolation_type<NEportLevels=1> = 0;
      int texture<NEportLevels=1> = 0;
   };

// The Info macro is inherited from the Demo3D template. This contains some
// standard GUI shared amongst the demos. Here we add in some UI and behaviour
// specific to this demo.

   Info {
      Summary<NEportLevels={0,2}> {
         option {
            set = 1;
         };
      };
      UItoggle Run_Flight {
         parent => <-.Summary;
         set => params.run;
         //y = 370;
         y => <-.UIbuttonHtml.Help.y + <-.UIbuttonHtml.Help.height + 12;
      };
      Image {
         parent => ;
      };
      UIslider Frames {
         parent => <-.Summary;
         value => params.frames;
         //height => UIdata.UIfonts[0].lineHeight * 2;
         y => <-.Run_Flight.y + <-.Run_Flight.height + 5;
         min = 1.;
         max = 10.;
         decimalPoints = 0;
         increment = 1.;
      };
      macro InterpolationUI {
         UIoptionMenu Interpolation_Type {
            parent => <-.parent;
            cmdList => {<-.Linear,<-.Cubic,
               <-.Quintic,<-.Sinusoidal};
            selectedItem => params.interpolation_type;
            y => Frames.y + Frames.height + 5;
         };
         link parent<NEportLevels={2,1}> => <-.Summary;
         UIoption Linear;
         UIoption Cubic;
         UIoption Quintic;
         UIoption Sinusoidal;
      };
      Text {
         height =>UIdata.UIfonts[0].height * 3; //3 lines of text
      };
      UItoggle Use_Texture_Map {
         parent => <-.Summary;
         set<NEdisplayMode="open"> => params.texture;
         //y = 370;
         y => <-.InterpolationUI.Interpolation_Type.y + <-.InterpolationUI.Interpolation_Type.height;
         x = 80;
         width = 140;
      };
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultWidth = 306;
                        defaultHeight = 306;
                        defaultX = 626;
                        defaultY = 99;
                     };
                  };
               };
            };
         };
         Top {
            child_objs => {
               <-.<-.<-.FlightPath_Editor.extract_mesh.out_obj,
               <-.<-.<-.SurfaceCreator.obj};
         };
         Camera {

// This is the core of the application. We create some variables to hold the
// information that we need to calculate the position of the camera along the
// flightpath. Note the uses of the copy_on_change modules which force a one
// way connection of objects.

            GMOD.copy_on_change z1 {
               input => <-.Zfrom;
            };
            GMOD.copy_on_change z2 {
               input => <-.Zto;
            };
            float Xfrom => from_now[0];
            float Yfrom => from_now[1];
            float Zfrom => (from_now[2] + FromLift);
            float Xto   => to_now[0];
            float Yto   => to_now[1];
            float Zto   => (to_now[2] + ToLift);
            float FromLift = 18.;
            float ToLift = 17.;
            Camera {
               auto_norm = "None";
               int animate => (FlightPath_Editor.surf_plot#1.out_fld.nnodes > 1);

// This application works because we are changing the from and at objects
// inside the Camera. These control where the object is located in 3D space
// and where it points to.

               from => switch(animate,{Xfrom,Yfrom,z1.output});
               at => switch(animate,{Xto,Yto,z2.output});
               up => switch(animate,{0,0,1});
               fov = 100.;
               perspec = 1;
               front = 1.;
            };
            float xyz_coords<NEportLevels=1>[][] => FlightPath_Editor.surf_plot#1.out_fld.coordinates.values;

// ArrayInterpolator modules are used to interpolate between the coordinates
// generated by the user tracing a flight path. This is done to smooth the
// transitions of the animation.

            ANIM.ArrayInterpolator FromArrayInterpolator {
               loopCount => count;
               keysArray => init_array(<-.ncoords,0,(<-.ncoords - 1));
               valuesArray => <-.xyz_coords;
               resultArray => <-.from_now;
               interpType => params.interpolation_type;
            };
            int ncoords<NEportLevels=1> => FlightPath_Editor.surf_plot#1.out_fld.nnodes;
            float from_now<NEportLevels=1>[3] = {154.962,416.378,57.45};
            float to_now<NEportLevels=1>[3] = {154.962,411.02,58.85};
            ANIM.ArrayInterpolator ToArrayInterpolator {
               loopCount => (count + 1);
               keysArray => init_array(ncoords,0,(ncoords - 1));
               valuesArray => <-.xyz_coords;
               resultArray => to_now;
               interpType => params.interpolation_type;
            };
            float count<NEportLevels=1> => Loop.count;
         };
      };
      Scene_Editor {
         View_Editor {
            GDobj_sel {
               curobj_name = "Top";
            };
            IUI {
               optionList {
                  selectedItem = 0;
               };
               General {
                  IUI {
                     panel {
                        visible = 1;
                     };
                  };
               };
            };
            InfoPanel {
               curobj_sel {
                  selectedItem = 0;
                  width = 238;
                  height = 246;
                  x = 0;
                  y = 0;
                  ok = 1;
               };
            };
         };
         Object_Editor {
            GDprops_edit {
               inherit = 0;
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/helens2.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.downsize downsize {
      in_field => <-.Read_Field.field;
      DownsizeParam {
         factor0 = 4.;
         factor1 = 4.;
         factor2 = 4.;
      };
   };
   MODS.Loop Loop {
      end => (<-.FlightPath_Editor.ContinuousSketch.cont_sketch.GDmap2d_ss.out_mesh.coordinates.nvals - 2);
      incr => (1. / params.frames);
      LoopUI {
         UIfield FromFld {
            y = 275;
            parent => UIpanel;
            value => Uviewer3D.Scene.Camera.FromLift;
         };
         UIfield ToFld {
            y = 300;
            parent => UIpanel;
            value => Uviewer3D.Scene.Camera.ToLift;
         };
         Once {
            set = 0;
         };
         Cycle {
            set = 1;
         };
      };
      count = 10.;
      run => params.run;
      cycle = 1;
      done = 1;
   };

// The FlightPath_Editor macro contains the required objects for creating the
// flight path. This includes a custom viewer and some graphics interaction to
// trace the flight path with the mouse.

   macro FlightPath_Editor {
      GDM.ContinuousSketch ContinuousSketch {
         view_in => <-.view;
         obj_in => <-.obj;
         cont_sketch {
            option_polyl {
               set = 1;
            };
            GDmap2d_ss {
               out_mesh {
                  nnodes = 22;
                  nspace = 2;
                  ncell_sets = 1;
                  coordinates {

// A simple straight line path is set as the default when you launch the
// application. Here, the coordinates are defined.

                     values = {
                        154.962,416.378,154.962,411.02,154.962,408.34,154.962,
405.661,154.962,402.982,154.962,400.302,154.962,397.623,154.962,394.943,154.962,
389.585,154.962,386.905,154.962,384.226,154.962,381.546,154.962,378.867,154.962,
376.188,154.962,373.508,154.962,370.829,154.962,368.149,154.962,365.47,154.962,
362.791,154.962,360.111,154.962,357.432,154.962,354.752
                     };
                  };
                  Polyline cell_set[ncell_sets] {
                     npolys = 1;
                     poly_connect_list = {0,21};
                  };
               };
            };
            draw_copy {
               set = 1;
            };
            GDroi2d_cont {
               immed = "On Button Up";
            };
         };
      };
      MODS.interp_data interp_data {
         in_field => <-.field;
         in_probe => <-.ContinuousSketch.cont_sketch.GDmap2d_ss.out_mesh;
      };
      MODS.extract_mesh extract_mesh {
         in_field => <-.surf_plot#1.out_fld;
         obj {
            Props {
               jitter = 2;
               inherit = 0;
            };
         };
         out_obj<NEportLevels={1,3}>;
      };
      MODS.surf_plot surf_plot#1 {
         in_field => <-.interp_data.out_fld;
         SurfPlotParam {
            scale => <-.<-.<-.SurfaceCreator.surf_plot.SurfPlotParam.scale;
         };
      };

// The Crosshair macro is an example of how to create a simple geometric object
// directly in v code. The float value Position contains the x and y
// coordinates that we want to draw the crosshair at in the viewer. The lines
// of the crosshair are constructed using the coord array and the connect
// array. The coord array contains the coordinates for the nodes, and the
// connect array contains the indexes into the nodes to define the
// connectivity. In this case things are pretty simple because we are
// connecting nodes 0 and 1 and nodes 2 and 3, each with a single line.

      macro Crosshair {
         float Position<NEportLevels={1,1}>[2] => Uviewer3D.Scene.Camera.from_now[0:1];
         link obj<NEportLevels={1,2}> => .line_mesh.obj;
         FLD_MAP.line_mesh line_mesh {
            coord[4][2] => {
               (Position[0] - scale),Position[1],
               (Position[0] + scale),Position[1],
                Position[0],(Position[1] - scale),
                Position[0],(Position[1] + scale)
            };
            connect = {0,1,2,3};
            DataObject.Props.col = {1.,0.,0.};
         };
         float scale<NEportLevels=1> = 20.;
      };
      GDM.Iscene2D Iscene2D<NEx=566.,NEy=198.> {
         Top {
            child_objs => {
               <-.<-.<-.downsize.out_obj,
               <-.<-.ContinuousSketch.cont_sketch.DataObject.obj,
               Crosshair.obj};
            Xform {
               ocenter = {163.,231.5,0.};
               dcenter = {-797.132,-1132.41,0.};
            };
         };
         View {
            ViewUI {
               ViewWindow {
                  parent => <-.<-.<-.<-.UIframe;
               };
            };
         };
      };
      UIframe UIframe {
         parent => <-.parent;
         y = 15;
         width = 250;
         height = 220;
      };
      link view<NEportLevels={1,1}> => .Iscene2D.View.View;
      link field<NEportLevels={2,1}> => <-.downsize.out_fld;
      link obj<NEportLevels={2,1}> => <-.downsize.out_obj;
      link parent<NEportLevels={2,1}> => <-.Info.Summary;
   }; // FlightPath_Editor

   macro SurfaceCreator {
      MODS.surf_plot surf_plot {
         in_field => <-.fld;
         SurfPlotParam {
            scale = 0.05;
         };
      };
      MODS.texture_mesh texture_mesh {
         in_field => <-.surf_plot.out_fld;
         texture => <-.Read_Texture.field;
      };

      link fld<NEportLevels={2,1}> => <-.downsize.out_fld;
      link obj<NEportLevels={1,2}> => switch((params.texture+1),surf_plot.out_obj,texture_mesh.out_obj);
      MODS.Read_Image Read_Texture {
         read_image_ui {
            file_browser {
               filename = "$XP_PATH<0>/demos/data/planets/textures/io.jpg";
            };
            format_from {
               set = 1;
            };
         };
      };
   }; // SurfaceCreator
};
