//			Copyright (c) 2003 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/demos/v/apps/solarsystem.v#1 $

// This demo inherits from the Demo3D template. This template provides
// some standard functionality which is shared amongst the demos.

DEMOS.Macros.Demo3D Solar_System<NEdisplayMode="maximized",NEsmallPixmapName="$XP_PATH<0>/demos/icons/earth.bmp",NEhelpFile="demos/Solar_System.html"> {

// The top level params block is used to store common variables that are
// used throughout the application. Typically, this is also the approach
// used to store application state.

   params {
      title = "Solar System Demo";
      filepath = "$XP_PATH<0>/demos/data/planets/images/";
      image => str_format("%s.bmp",PlanetPicker.planet);
      info_text = "This example simulates the solar system.\nIt is not accurately represented but it\n gives an idea for how simulations can be\n realised with Express";
      int run = 0;
      int orbits<NEportLevels=1> = 1; //Controls orbit path visibility
      int animate<NEportLevels=1> = 0;	//Controls animation status
      int name_planets<NEportLevels=1> = 0;	//Controls planet names visibility
      string planet_names<NEportLevels={1,1}>[10] = {
         "Sun","Mercury","Venus","Earth","Mars","Jupiter","Saturn","Uranus",
         "Neptune","Pluto"
      };
   };

// The Info macro is inherited from the Demo3D template. This contains some
// standard  GUI shared amongst the demos. Here we add in some UI and
// behaviour specific to  this demo.

   Info {   	
      Title.width => 140;
      Title.alignment => "left";

// Using the UIdata.UIfonts[0].lineHeight is a useful way of setting up UI
// that is compatible with Windows, large and small fonts, and UNIX.

      //Text.y => PlanetViewer.Select_View.y + PlanetViewer.Select_View.y;
      Text.y => PlanetViewer.Select_View.y + UIdata.UIfonts[0].lineHeight + 10;
      Text.height => (UIdata.UIfonts[0].lineHeight) * 4;

      Summary {
         clientHeight = 1500;
      };
      UItoggle Run_Simulation {
         parent => <-.Summary;
         set => <-.<-.params.run;
         y => Identify_Planets.y + UIdata.UIfonts[0].lineHeight + 5;
         width = 120;
      };
      UItoggle Identify_Planets {
         parent => <-.Summary;
         set => <-.<-.params.name_planets;
         y => UIbuttonHtml.Help.y + UIbuttonHtml.Help.height + 5;
         width = 120;
      };
      UIbutton Run_Animate_Sequence {
         parent => <-.Summary;
         label => str_format("%s%s",state[<-.<-.params.animate]," Animate Sequence");
         y => Run_Simulation.y + UIdata.UIfonts[0].lineHeight + 5;
         width = 180;
      };
      GMOD.parse_v parse_v {
         v_commands = "params.run = 0; params.animate = (1 - params.animate);";
         trigger => <-.Run_Animate_Sequence.do;
         on_inst = 0;
         relative => <-;
      };
      string state<NEportLevels=1>[2] = {"Run","Stop"};
      Image {

// Using switch is a very useful approach when programming with Express. It is
// typically used to control whether an object is connected to a parent
// depending upon a condition.  It is useful to note that switch returns
// nothing when the first argument is zero. In the case below, when the
// PlanetViewer.Select_View.selectedItem is equal to 1, Summary is selected,
// but when it is not the conditional statement returns 0 and switch returns
// nothing. Therefore this controls whether or not this Image object is
// connected to the Summary parent panel or not.

         parent => switch((<-.<-.PlanetViewer.Select_View.selectedItem == 1),<-.Summary);
         label => "";
      };
      GMOD.parse_v BlockAnimate {
         v_commands = "params.animate = 0;";
         trigger => <-.Run_Simulation.do;
         relative => <-;
      };
   };
   UI {
      shell {
         x = 60;
         y = 32;
      };
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.solar_system.planets,<-.<-.<-.solar_system.orbits,
               <-.<-.<-.BackgroundFade.out_obj,<-.<-.<-.PlanetPicker.obj};
            Xform {
               ocenter = {0.0795689,0.,0.};
               dcenter = {0.00710544,-0.0063741,-0.0256926};
               mat = {
                  0.0680212,0.0494665,-0.0384819,0.,-0.0624841,0.057924,-0.0359894,
				  0.,0.00485186,0.0524647,0.0760171,0.,0.,0.,0.,1.
               };
               xlate = {-0.00805962,0.,0.};
               center = {0.0795689,0.,0.};
            };
            obj<NEportLevels={1,3}>;
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
         View {
            ViewUI {
               PickInteractor {
                  startEvent = "<BtnRDown>";
                  runEvent = "<BtnRMotion>";
                  stopEvent = "<BtnRUp>";
               };
            };
         };
      };
      Scene_Editor {
         Camera_Editor {
            GDcamera_edit {
               auto_norm = "None";
            };
         };
         Object_Editor {
            GDobj_edit {
               pickable = 1;
            };
            GDmodes_edit {
               lines = "Inherit";
            };
            GDprops_edit {
               inherit = 1;
               ambient = 0.300999999;
               diffuse = 0.7020000219;
               trans = 1.;
            };
         };
         Track_Editor {
            cur_obj<NEportLevels={3,1}> => <-.<-.Scene.Top.obj;
         };
      };
   };

// The solar system macro takes care of the generation and management of the
// graphics objects that depict the solar system and its annotation.

   macro solar_system {
      int num = 10;
      float size<NEportLevels={0,1}>[.num] = {4.,0.5,0.5,0.5,0.5,3.,3.,2.,2.,1.};

// MODS.Loop is the only way to create a loop inside of Express. It can be
// very useful for setting up animations and looping through filenames.

      MODS.Loop Loop {
         run => <-.<-.params.run;
         cycle = 1;
         start = 1.;
         end = 2000.;
         incr = 0.1;
         count = 1.;
         LoopUI {
            Once {
               set = 0;
            };
            Cycle {
               set = 1;
            };
         };
      };
      link planets<NEportLevels={1,2}> => .makePlanets.PlanetsGroup.obj;
      double radii<NEportLevels=1>[.num] =
         {0.001,4.,6.,8.,15.,25.,30.,40.,45.,50.};

// Note that the v language has many built in mathematical functions, including
// the standard trigonometric ones. It is often possible to write a simple v
// macro to perform a particular computation rather than building a custom
// C/C++ or Fortran module. Here we use the sin and cos functions to calculate
// the x and y coordinates for the planets at a particular simulation step.

      double x<NEportLevels=1>[.num] => (sin((.day / .periods)) * .radii);
      double y<NEportLevels=1>[.num] => (cos((.day / .periods)) * .radii);
      double z<NEportLevels=1>[.num] => 0;
      double day<NEportLevels=1> => .Loop.count;
      double periods<NEportLevels={1,1}>[.num] =
         {1.,0.08,0.1,0.2,0.9,2.,3.,4.,6.,8.};
      link orbits<NEportLevels={1,2}> => .OrbitsGroup.obj;
      GDM.GroupObject OrbitsGroup {
         child_objs => <-.PlanetOrbits.out_obj;
         Top {
            pickable = 0;
         };
      };
      macro makePlanets {
         FLD_MAP.point_mesh point_mesh {
            coord => <-.interleave_3_arrays.out;
         };
         MODS.glyph Glyph {
            in_field => <-.combine_mesh_data.out;
            in_glyph => <-.Sphere.bounds.out;
            GlyphParam {
               vector = 0;
               scale = 1.71;
            };
            obj {
               Modes {
                  mode = {0,0,4,0,0};
               };
            };
            out_fld<NEportLevels={1,3}>;
         };
         FLD_MAP.combine_mesh_data combine_mesh_data {
            in_mesh => <-.point_mesh.out;
            in_nd => <-.node_scalar.out;
         };
         GEOMS.FCircle3D Ring {
            dim = 12;
            rad = 3.46;
            probe_ui.panel.title = "Saturn's Ring";
            obj {
               Props {
                  col = {1.,1.,0.};
               };
               Obj {
                  pickable = 0;
               };
            };
            circle {
               xform {
                  mat = {
                     0.866025,0.,-0.5,0.,0.,1.,0.,0.,0.5,0.,0.866025,0.,0.,0.,0.,1.
                  };
                  xlate = {9.81584,28.3487,0.};
               };
            };

// GDM.GDxform_edit is a very useful module for editing and setting the
// transformation matrix associated with a graphics display object. You
// provide it with a reference to the appropriate xform and then set the
// rotations, translations and centres that you require.

            GDM.GDxform_edit GDxform_edit {
               xform => <-.circle.xform;
               y_rot = 30.;
               z_rot = 0.;
               x_trans => x[6];
               y_trans => y[6];
               absolute = 1;
               abs_y_rot = 30.;
               abs_z_rot = 0.;
               abs_x_trans = 9.815840721;
               abs_y_trans = 28.34870911;
               abs_x_cent = 0.;
               abs_y_cent = 3.654163599;
            };
         };
         GDM.GroupObject PlanetsGroup {
            child_objs => {<-.Glyph.out_obj,
               <-.Ring.out_obj,<-.Text_Glyph.out_obj};
            obj<NEportLevels={1,3}>;
         };
         FLD_MAP.node_scalar node_scalar {
            in_data<NEportLevels={3,0}> => <-.<-.size;
         };
         FLD_MAP.interleave_3_arrays interleave_3_arrays {
            in1<NEportLevels={3,0}> => <-.<-.x;
            in2<NEportLevels={3,0}> => <-.<-.y;
            in3<NEportLevels={3,0}> => <-.<-.z;
         };
         MODS.text_glyph Text_Glyph {
            in_mesh => <-.combine_mesh_data.out;
            in_text => <-.<-.<-.params.planet_names;
            TextUI {
               Leadline {
                  set = 1;
               };
               Radial {
                  set = 1;
               };
               Offset {
                  set = 1;
               };
            };
            obj {
               Obj {
                  visible => <-.<-.<-.<-.<-.params.name_planets;
                  pickable = 0;
               };
            };
         };
         GEOMS.Sphere Sphere {
            subdiv = 15;
         };
      };
      GEOMS.FCircle3D PlanetOrbits[num] {
         probe_ui.panel.title =>
            params.planet_names[index_of(<-.<-.<-.PlanetOrbits)] + " Orbit";
         rad => radii[index_of(<-.PlanetOrbits)];
         obj {
            Obj {
               pickable = 0;
            };
         };
         dim = 50;
      };
   };

// The Animator is a good utility for generation custom keyframe animations.
// There are various interpolation techniques supported, and it comes with a
// standard GUI.  It is often used in conjunction with image_capture to
// generate MPEG and AVI movies.

   ANIM_MODS.animator Animator {
      animParam {
         run_options = 2;
         interp_editor_ok = 1;
         interp_editor_visible = 0;
         current_time = 1.;
         interp_type = 3;
         run => <-.<-.params.animate;
         interpolator_selected = -1;
         time_selected = -1;
      };
      animUI {
         KeyframeControls {
            TimesList {
               selectedText = "1.000";
               selectedItem = 1;
            };
         };
      };
      animCompute {
         AnimControl {
            frameTimes[6] = {0.,1.,2.,3.,4.,5.};
            currentFrame = 6;
            InterpolatorGroup {
               ANIM.TransformMatrixInterpolator Uviewer3D_Scene_Top_Xform_mat {
                  loopCount => <-.<-.count;
                  keysArray[6] = {0.,1.,2.,3.,4.,5.};
                  valuesArray[96] = {
                     0.106841,0.,0.,0.,0.,0.106841,0.,0.,0.,0.,0.106841,0.,
0.,0.,0.,1.,0.118803,0.0228164,-0.0247139,0.,-0.0326986,0.0996087,-0.0652255,0.,
0.00788446,0.0693035,0.101884,0.,0.,0.,0.,1.,0.161666,0.0359709,-0.0459227,0.,
-0.0582017,0.108558,-0.11986,0.,0.00392066,0.128296,0.114295,0.,0.,0.,0.,
1.,0.130305,0.109212,-0.22564,0.,-0.250589,0.0636402,-0.11391,0.,0.0067939,0.252671,
0.126219,0.,0.,0.,0.,1.,-0.0491356,0.289464,-0.450616,0.,-0.535491,-0.0347378,0.0360759,
0.,-0.00968848,0.451954,0.291379,0.,0.,0.,0.,1.,-0.590242,0.272934,-0.402807,0.,
-0.485585,-0.290228,0.514887,0.,0.0308829,0.653,0.397203,0.,0.,0.,0.,1.
                  };
                  resultArray[16] => <-.<-.<-.<-.<-.Uviewer3D.Scene.Top.Xform.mat;
               };
               ANIM.ArrayInterpolator Uviewer3D_Scene_Top_Xform_xlate {
                  loopCount => <-.<-.count;
                  keysArray[6] = {0.,1.,2.,3.,4.,5.};
                  float valuesArray<NEportLevels={2,0}>[18] = {
                     -0.00805962,0.,0.,-0.00805962,0.,0.,-0.00805962,0.,0.,
                     -0.00805962,0.,0.,-0.00805962,0.,0.,-0.00805962,0.,0.
                  };
                  float resultArray<NEportLevels={0,2}>[3] => <-.<-.<-.<-.<-.Uviewer3D.Scene.Top.Xform.xlate;
               };
               ANIM.ArrayInterpolator Uviewer3D_Scene_Top_Xform_center {
                  loopCount => <-.<-.count;
                  keysArray[1] = {0.};
                  float valuesArray<NEportLevels={2,0}>[3] = {0.0795689,0.,0.};
                  float resultArray<NEportLevels={0,2}>[3] => <-.<-.<-.<-.<-.Uviewer3D.Scene.Top.Xform.center;
               };
            };
         };
      };
   };

// Here is the background object that allows the viewer to be coloured with
// a colourful backdrop.

   GEOMS.BackgroundFade BackgroundFade {
      params {
         Lower_Left_Red = 0.;
         Lower_Left_Green = 0.;
         Lower_Left_Blue = 0.;
         Lower_Right_Red = 0.;
         Lower_Right_Green = 0.;
         Lower_Right_Blue = 0.;
      };
   };
   macro PlanetPicker {
      GDM.GDpick_process GDpick_process {
         obj_in => <-.pickedObject;
         cell_index = 99;
      };

// The Box macro is a good example of how you can create simple Fields
// yourself using the V language. You can see how the points array defines
// the coordinate bounds for the box which is effectively a uniform field of
// dimensions 2x2x2.

      macro Box<module_stack_menu=1> {
         int dim1<export=2> = 2;
         int dim2<export=2> = 2;
         int dim3<export=2> = 2;

         float point<NEportLevels={2,1}>[3] => <-.GDpick_process.point;
         float size<NEportLevels=1> = 3.;

         Mesh_Unif box<NEcolor1=16711680> {
            nspace = 3;
            ndim = 3;
            dims => {<-.dim1,<-.dim2,<-.dim3};
            points => {
               (point[0] - <-.size),(point[1] - <-.size),(point[2] - <-.size),
               (point[0] + <-.size),(point[1] + <-.size),(point[2] + <-.size)
            };
         };

         int error => !is_valid( point );
         olink out_fld<NEportLevels={1,2}> => switch(!error, .box);

         GDM.DataObject obj {
            in => <-.out_fld;
            Props {
               material = {0.3,0.7,0.4,12.};
               trans = 0.5799999833;
               inherit = 0;
            };
            Modes {
               mode = {0,2,0,0,0};
            };
         };
         olink out_obj<NEportLevels={1,2}> => .obj.obj;
      };
      link pickedObject<NEportLevels={2,1}> => <-.Uviewer3D.Scene.View.View.picked_obj;
      link obj<NEportLevels={1,2}> => .Box.out_obj;
      int index<NEportLevels={1,2}> => (.GDpick_process.cell_index / 200);
      string planet<NEportLevels={1,2}> => params.planet_names[index];
   };

// The PlanetViewer macro demonstrates how you can build a simple custom 3D
// viewer with some of the lower level Graphics Display objects.

   macro PlanetViewer {
      GDM.GDtrack_edit GDtrack_edit {
         camera => <-.Iscene3D.Camera.Camera;
         obj => <-.Iscene3D.Top.obj;
         event => UImouseEvents.state;
         x => UImouseEvents.x;
         y => UImouseEvents.y;
         view => <-.Iscene3D.View.View;
         time => UImouseEvents.time;
         mode => UImouseEvents.buttonType;
         normalize => RNC.do;
      };
      GDM.Iscene3D Iscene3D {
         Top {
            child_objs<NEportLevels={4,1}> => {
               <-.<-.<-.BackgroundFade.out_obj,<-.<-.Ring.obj,
               <-.<-.Texture_Sphere.out_obj};
            obj<NEportLevels={1,3}>;
         };
         Camera {
            Camera<NEportLevels={0,3}>;
         };
         View {
            ViewUI {
               ViewWindow {
                  parent => <-.<-.<-.<-.PlanetView;
               };
            };
         };
      };
      UIframe PlanetView {
         parent => switch((<-.Select_View.selectedItem == 0),<-.parent);
         y => UIdata.UIfonts[0].lineHeight + 5;
         width = 250;
         height = 220;
      };
      link parent<NEportLevels={2,1}> => <-.Info.Summary;
      link planet<NEportLevels={2,1}> => <-.PlanetPicker.planet;
      UImouseEvents &UImouseEvents<NEportLevels={1,0}> => .Iscene3D.View.ViewUI.ViewEvents;
      MODS.texture_sphere Texture_Sphere {
         texture => <-.Read_Image.field;
         TextureSphereParam {
            sphere_dims => {150,100};
         };
      };
      UIlabel UIlabel {
         parent => <-.parent;
         label => <-.planet;
         y = 0;
         x => <-.<-.Info.Title.x + <-.<-.Info.Title.width + 4;
         width => .parent.clientWidth - .x;
         fontAttributes<NEdisplayMode="open"> {
            weight = "bold";
         };
      };
      UIoptionMenu Select_View {
         parent => <-.parent;
         cmdList => {<-.Texture_Map_3D, <-.Image};
         selectedItem = 1;
         y => Info.Image.y + Info.Image.height + 5;
      };
      UIoption Texture_Map_3D;
      UIoption Image {
         set = 1;
      };
      MODS.Read_Image Read_Image {
         DVread_image {
            filename => switch((<-.<-.Select_View.selectedItem == 0),str_format("$XP_PATH<0>/demos/data/planets/textures/%s.jpg",<-.<-.planet));
         };
         read_image_ui {
            format_from {
               set = 1;
            };
         };
      };
      macro Ring {
         Field_Cyl_Unif Field_Cyl_Unif<NEportLevels={0,1}> {
            dims = {2,40};
            ndim = 2;
            points => {7589000,(2 * 3.141592653),9999000,0};
            nspace = 2;
         };
         GDM.DataObject DataObject {
            in => <-.Field_Cyl_Unif;
            Props {
               col = {0.3,0.3,0.};
            };
            Obj {
               visible => (PlanetPicker.index == 6);
            };
         };
         link obj<NEportLevels={1,2}> => .DataObject.obj;
      };
      UIbutton RNC {
         parent => <-.parent;
         height = 22;
         label => ;
         x = 225;
         y => Info.Image.y + Info.Image.height + 5;
         width = 22;
         label = "";
         pixmap {
            filename = "$XP_PATH<0>/v/vizxp/icons/rnc.x";
         };
      };
   };
};
