//			Copyright (c) 2003 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/demos/v/apps/volumeshells.v#1 $

// This demo inherits from the Demo3D template. This template provides
// some standard functionality which is shared amongst the demos.

DEMOS.Macros.Demo3D VolumeShells<NEdisplayMode="maximized",NEsmallPixmapName="$XP_PATH<0>/demos/icons/volshells.bmp",NEhelpFile="demos/VolumeShells.html"> {

// The top level params block is used to store common variables that are
// used throughout the application. Typically, this is also the approach
// used to store application state.

   params {
      title = "Volume Shells Demo";
      image = "volshells.bmp";
      info_text = "This example shows how you can use\nAVS/Express to volume render your data.\nThe approach here is to use the\nColormapEditor to create opacity levels\nthat result in the rendering of shells\nwithin the volume. The majority of the\nvolume is rendered as transparent with\njust the 'shells' of interest being shown.";
   };

   UI {
      shell {
         x = 103;
         y = 47;
      };
   };

// The Info macro is inherited from the Demo3D template. This contains some
// standard GUI shared amongst the demos. Here we add in some UI and behaviour
// specific to this demo.

   Info {
      Text.height => (UIdata.UIfonts[0].height * 9); // 9 lines of text
      UIslider min0_slider {
         parent => <-.Summary;
         title => "I min";
         max+nres => (crop.in_field.dims[0] - 2);
         value+nres<NEportLevels={2,0}> => crop.CropParam.min[0];
         mode = "integer";
         y => UIbuttonHtml.Help.y + UIbuttonHtml.Help.height + 5;
         width => <-.panel.width;
         //height => UIdata.UIfonts[0].lineHeight * 2;
      };
      UIslider max0_slider {
         parent => <-.Summary;
         title => "I max";
         max+nres => (crop.in_field.dims[0] - 1);
         value+nres<NEportLevels={2,0}> => crop.CropParam.max[0];
         mode = "integer";
         y => ((<-.min0_slider.y + <-.min0_slider.height) + 5);
         width => <-.panel.width;
         min => min0_slider.value + 1;
         //height =>UIdata.UIfonts[0].lineHeight * 2;
      };
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.crop.out_obj};
            Xform {
               ocenter = {31.5,44.,31.5};
               dcenter = {4.,5.5873,4.};
               mat = {
                  0.0891684,-0.0223164,0.0454995,0.,0.0223405,-0.0653434,-0.0758316,
				  0.,0.0454877,0.0758385,-0.0519483,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-5.5873,-4.};
               center = {31.5,44.,31.5};
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
               perspec = 1;
               front = 1.;
            };
         };
         View {
            View {
               trigger = 2;
               renderer => "Software";
            };
         };
      };
      Scene_Editor {
         Camera_Editor {
            GDcamera_edit {
               front = 1.;
            };
         };
         Object_Editor {
            GDmodes_edit {
               volume = "Inherit";
            };
            GDprops_edit {
               inherit = 0;
               fat_ray = 1;
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
   };
   MODS.crop crop {
      in_field => <-.Read_Field.field;
     
      CropParam {
         min = {0,25,0};
         max = {63,63,63};
      };
      obj {
 // Force the use of the alternate object during rotation/pan/scale operations     
         Obj {
	   use_altobj = 1;
         };
         Datamap {
            DataRange[8] = {
               {
                  DataMaxValue=66.3429718,,,,,,,,,,,,,,,,,,,,,,,
               },
               {
                  DataMaxValue=77.13294983,,,,,,,,,,,,,,DataMinValue=><-.DataRange[0].DataMaxValue,controlPoints=>
                  {DatamapValue[2],
                     DatamapValue[3]},,,,,,,,
               },
               {
                  DataMaxValue=87.15222168,,,,,,,,,,,,,,DataMinValue=><-.DataRange[1].DataMaxValue,controlPoints=>
                  {DatamapValue[4],
                     DatamapValue[5]},,,,,,,,
               },
               {
                  DataMaxValue=132.6242828,,,,,,,,,,,,,,DataMinValue=><-.DataRange[2].DataMaxValue,controlPoints=>
                  {DatamapValue[6],
                     DatamapValue[7]},,,,,,,,
               },
               {
                  DataMaxValue=143.4142609,,,,,,,,,,,,,,DataMinValue=><-.DataRange[3].DataMaxValue,controlPoints=>
                  {DatamapValue[8],
                     DatamapValue[9]},,,,,,,,
               },
               {
                  DataMaxValue=154.2042389,,,,,,,,,,,,,,DataMinValue=><-.DataRange[4].DataMaxValue,controlPoints=>
                  {DatamapValue[10],
                     DatamapValue[11]},,,,,,,,
               },
               {
                  DataMaxValue=215.0905457,,,,,,,,,,,,,,DataMinValue=><-.DataRange[5].DataMaxValue,controlPoints=>
                  {DatamapValue[12],
                     DatamapValue[13]},,,,,,,,
               },
               {
                  DataMinValue=><-.DataRange[6].DataMaxValue,controlPoints=>
                  {DatamapValue[14],
                     DatamapValue[15]},,,,,,,,
               }
            };
            DatamapValue[16] = {
               {
                  value=0.,,,v2=0.6600000262,
               },
               {
                  value=66.3429718,,,v2=0.4917646646,v1=0.
               },
               {
                  value=66.3429718,v4=1.,v3=1.,v2=0.4917646646,v1=0.
               },
               {
                  value=77.13294983,v4=1.,v3=1.,v2=0.4281244874,v1=0.4759150147
               },
               {
                  value=77.13294983,v4=1.,v3=1.,v2=0.4281244874,v1=0.4759150147
               },
               {
                  value=87.15222168,v4=1.,v3=1.,v2=0.3794358373,v1=0.
               },
               {
                  value=87.15222168,v4=1.,v3=1.,v2=0.3794358373,v1=0.
               },
               {
                  value=132.6242828,v4=1.,v3=1.,v2=0.3151426613,v1=0.006262000185
               },
               {
                  value=132.6242828,v4=1.,v3=1.,v2=0.3151426613,v1=0.006262000185
               },
               {
                  value=143.4142609,v4=1.,v3=1.,v2=0.2887949944,v1=0.512041986
               },
               {
                  value=143.4142609,v4=1.,v3=1.,v2=0.2887949944,v1=0.512041986
               },
               {
                  value=154.2042389,v4=1.,v3=1.,v2=0.2844879925,v1=0.01830399968
               },
               {
                  value=154.2042389,v4=1.,v3=1.,v2=0.2844879925,v1=0.01830399968
               },
               {
                  value=215.0905457,v4=1.,v3=1.,v2=0.19727166,v1=0.
               },
               {
                  value=215.0905457,v4=1.,v3=1.,v2=0.19727166,v1=0.
               },
               {
                  value=255.,v4=1.,v3=1.,v2=0.,v1=1.
               }
            };
         };
         Props {
            fat_ray = 0;
            inherit = 0;
         };
         Modes {
            mode = {0,0,0,3,0};
         };
      };
   };
   CMAP_EDTR.ColorMapEditor ColormapEditor {
      InObj => <-.crop.out_obj;
      in_field => <-.crop.out_fld;
      UIshell {
         x = 400;
         y = 150;
      };
      ColorMapEditorParams {
         histo_enable = 1;
         histo_log = 1;
      };
   };
};
