/*
        This file is under Perforce control
        $Id: //depot/express/fcs70/getstart/echo.c#1 $
*/

#define XP_WIDE_API   /* Use Wide APIs */

#include "user.h"
#include <stdio.h>
#include <avs/f_utils.h>

/***************************************************************/
/* echo_reader: reads a data file into the echo_reader module. */
/*                                                             */
/* Most of the code you see here was generated by AVS/Express. */
/* This includes the function declaration, the OM calls        */
/* to access the module's data parameters, and the variable    */
/* definitions related to those calls.                         */
/*                                                             */
/* You add routine-specific code, in this case, code to open a */
/* data file, read its values, and populate the time and       */
/* location arrays.                                            */
/***************************************************************/

/***************************************************************/
/* AVS/Express generates the function declaration you          */
/* see below.  The function's first input parameter is the key */
/* one for the purposes of most routines.  AVS/Express assigns */
/* a unique object ID to each object in the object hierarchy.  */
/* The first input parameter contains the object ID of the     */
/* calling module.  From this ID, you can access the module's  */
/* data parameters.  The other two function parameters provide */
/* additional information, which you do not need for this      */
/* module.                                                     */
/***************************************************************/
int
echo_reader(OMobj_id echo_reader_id,
	    OMevent_mask event_mask, int seq_num)
{
   /***********************/
   /*  Declare variables  */
   /***********************/
   char  *filename = NULL;
   double  distance_sr;
   int  num_values;
   xp_long  time_size;
   float *time;
   xp_long  location_size;
   float *location;

   int i;
   char Buff[512];
   FILE  *fp;

   /************************************************************/
   /* A routine typically begins by getting the module's input */
   /* data parameters.  In this case, it gets the value of     */
   /* parameter filename.                                      */
   /*                                                          */
   /* Most API calls have the prefix OM, for Object Manager.   */
   /* The call to OMget_name_str_val, generated for you by     */
   /* AVS/Express, looks in the module identified by           */
   /* echo_reader_id for a parameter named "filename", and     */
   /* places the value of that parameter in the variable       */
   /* filename.                                                */
   /************************************************************/
   if (OMget_name_str_val(echo_reader_id,
			  OMstr_to_name("filename"), &filename, 0)
       != OM_STAT_SUCCESS)
      filename = NULL;

   /***********************/
   /* Function's Body     */
   /***********************/
   /* Code you supply to open the data file. */
   fp = FILEfopen(filename, "r");
   if (fp == NULL) {
      ERRerror("EchoReader", 1, ERR_ORIG, "Cannot open file %s", filename);
      return(0);
   }

   /* Code you supply to strip off header (lines beginning with #)     */
   /* (assumes there is a blank line after last header line) */
   while (fgets(Buff, sizeof(Buff), fp))
      if (Buff[0] != '#') break;


   /* Code you supply to read distance SR and the number of   */
   /* data points. These are the first two values in the      */
   /* input file.                                             */
   fscanf(fp, "%lf", &distance_sr);
   fscanf(fp, "%d", &num_values);

   /***********************************************************/
   /* AVS/Express also generates OM calls to set the value of */
   /* the module's scalar output parameters. For example,     */
   /* the first call to OMset_name_real_val looks in the      */
   /* module identified by echo_reader_id for a parameter     */
   /* named "distance_sr" and places into that parameter the  */
   /* value of distance_sr.                                   */
   /***********************************************************/
   /* Set distance_sr's value */
   OMset_name_real_val(echo_reader_id,
		       OMstr_to_name("distance_sr"), distance_sr);

   /* Set num_values's value */
   OMset_name_int_val(echo_reader_id,
		      OMstr_to_name("num_values"), num_values);

   /************************************************************/
   /* For array parameters, AVS/Expresss generates OM calls to */
   /* return a pointer to the array.  For example, the first   */
   /* call to OMret_name_array_ptr looks in the module         */
   /* identified by echo-reader_id for a subobject named       */
   /* "time" and returns a pointer to the array.  The argument */
   /* OM_GET_ARRAY_WR tells the Object Manager that you intend */
   /* to write to the array.  After the call, the fourth       */
   /* argument, time_size, contains the number of elements in  */
   /* the array.                                               */
   /************************************************************/
   /* Get a pointer to the time array */
   time = (float *)OMret_name_array_ptr(echo_reader_id,
       OMstr_to_name("time"), OM_GET_ARRAY_WR, &time_size, NULL);

   /* Get a pointer to the location array */
   location = (float *)OMret_name_array_ptr(echo_reader_id,
       OMstr_to_name("location"), OM_GET_ARRAY_WR, &location_size, NULL);

   /* Code you supply to read the data into the arrays */
   for (i=0; i<num_values; i++)
      fscanf(fp, "%f %f %f", time+i, location+2*i, location+2*i+1);

   /************************************************************/
   /* The Object Manager keeps track of array references. A    */
   /* call to OMret_name_array_ptr tells the Object Manager    */
   /* that the routine needs to reference the array. A         */
   /* subsequent call to ARRfree, generated by AVS/Express,    */
   /* tells the Object Manager that the routine is finished    */
   /* with the array.                                          */
   /************************************************************/
   if (filename) free(filename);
   if (time != NULL) ARRfree(time);
   if (location != NULL) ARRfree(location);

   return(1);
}


