//*-*-c++-*-*
/*
                        Copyright (c) 1996 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/gis/xp_mods/modcia.cxx#1 $
*/


#define XP_WIDE_API	/* Use Wide APIs */

#include "GISCIA.hxx"


//
//      function prototype
//
//      Note: the function Index() is defined in modProjection.cxx

xp_long Index(xp_long, xp_long, xp_long);

//
//      mfunction:      ingest
//
//      Working code for the WorldMap module. Based on user
//      requests, this will read in a CIA World DataBank file
//      and bundle up the appropriate polygons. If the 
//      read_data flag is not set, this thing will 
//      immediately jettison
//

/* 64-bit porting. Only Modified Internally */
int
GIS_READERS_GISCIAMapII::ingest(OMevent_mask event_mask, int seq_num)
{
  // Local variables 
  xp_long       TotalPolys[4];          // number of polys for this region
  xp_long       TotalVertices[4];       // How many total vertices in each polyline set?
  xp_long       validPolylines[4];      // how many viewable polyCollections are left?

  // Iterators
  xp_long       i,j;
  xp_long       coordIterate;
  xp_long       nodeIterate;

  // Convience pointers
  WorldMap::LL_PolyLine *pl;            // Sequence pointer
  float                 *coordPtr;      // data array pointer
  xp_long               *polyPtr;       // polyline connectivity array pointer

  // if read_data isn't set, get outta here
  if (! read_data)
    return (1);         // All is ok, tho

  // Force the OM to clean out its data arrays
  geoPolylines.nnodes = 0;
  polPolylines.nnodes = 0;
  coastalPolylines.nnodes = 0;
  riverPolylines.nnodes = 0;

  geoPolylines.ncell_sets = 0;
  polPolylines.ncell_sets = 0;
  coastalPolylines.ncell_sets = 0;
  riverPolylines.ncell_sets = 0;


  // Retrieve the pointer for the WorldMap class. It 
  // should have been instanced when this class was created.
  WorldMap *WM;

  WM = (WorldMap *)ret_class_ptr("WorldMap");

  // Turn off verbosity
  WM->setVerbosity(0);

  // Set the path name
  WM->setCIADirectory((char *)ciaDirectory);

  // Set the users requested precision.
  WM->setPrecision(precision);


  // Get the boundaries of the area to read, set them in
  // the WorldMap class, and then RESET THEM in the 
  // module parameters. The user may have requested something
  // outta bounds.
  LatLon *llBoundary = new LatLon(southLatitude, westLongitude);
  LatLon *urBoundary = new LatLon(northLatitude, eastLongitude);

#if 0
  // WE CANNOT DO THIS. IT CAUSES A FEEDBACK LOOP!
  // Place the new name as a string back into the 
  // module, so the user knows (sort of) if it
  // was accepted or not.
  southLatitude = llBoundary->fetchLat();
  westLongitude = llBoundary->fetchLon();
  northLatitude = urBoundary->fetchLat();
  eastLongitude = urBoundary->fetchLon();
#endif

  WM->setLowLeftBoundary(llBoundary);
  WM->setUpRightBoundary(urBoundary);

  // OK, retreive the information that the user wishes to
  // collect from each of the data file, and set those points of 
  // interest.
  UtString      IncludeFeatures;
  infoLevels    features;

  // start with the geographic end with the rivers 
  overlaySections os;
  for (os=geoBoundary; os<=river; increment(os))
    {
      switch (os)
        {
        case geoBoundary:
          {
            IncludeFeatures = (const char *)geographicFeatures;
            break;
          }
        case polBoundary:
          {
            IncludeFeatures = (const char *)politicalFeatures;
            break;
          }
        case coastal:
          {
            IncludeFeatures = (const char *)coastalFeatures;
            break;
          }
        case river:
          {
            IncludeFeatures = (const char *)riverFeatures;
            break;
          }
        }
      IncludeFeatures.lower();

      features = definite;

      // Get the text and translate
      if (IncludeFeatures == "all")
        features = everything;
      if (IncludeFeatures == "none")
        features = none;
      if (IncludeFeatures == "both")
        features = both;
      if (IncludeFeatures == "definite")
        features = definite;
      if (IncludeFeatures == "major")
        features = wm_major;
      if (IncludeFeatures == "indefinite")
        features = indefinite;
      if (IncludeFeatures == "minor")
        features = wm_minor;
      if (IncludeFeatures == "double lines")
        features = doubleLines;
      if (IncludeFeatures == "major some maps")
        features = intermittentMajor;
      if (IncludeFeatures == "minor some maps")
        features = intermittentMinor;
      if (IncludeFeatures == "additional major")
        features = additionalMajor;
      if (IncludeFeatures == "reefs")
        features = reefs;
      if (IncludeFeatures == "ocean salt pans")
        features = saltPans1; // be careful to set both saltPans1 and 2
      if (IncludeFeatures == "major canals")
        features = majorCanals;
      if (IncludeFeatures == "minor canals")
        features = lesserCanals;
      if (IncludeFeatures == "recorded irrigation")
        features = irrigations;
      if (IncludeFeatures == "continental shelves")
        features = shelves1;  // be careful to set both shelves1 and 2
      if (IncludeFeatures == "glaciers")
        features = glaciers;
      if (IncludeFeatures == "Doubled Lined Beds")
        features = doubleLines;

      // Special cases
      switch (features)
        {
        case everything:
          {
            // everything is not all thing to all people...
            switch (os)
              {
              case geoBoundary:
              case polBoundary:
                WM->setPOI((overlaySections)os, definite, 1);
                WM->setPOI((overlaySections)os, indefinite, 1);
                break;
              case coastal:
                WM->setPOI((overlaySections)os, wm_minor, 1);
                WM->setPOI((overlaySections)os, wm_major, 1);
                WM->setPOI((overlaySections)os, intermittentMajor, 1);
                WM->setPOI((overlaySections)os, intermittentMinor, 1);
                WM->setPOI((overlaySections)os, additionalMajor, 1);
                WM->setPOI((overlaySections)os, reefs, 1);
                WM->setPOI((overlaySections)os, saltPans1, 1);
                WM->setPOI((overlaySections)os, saltPans2, 1);
                WM->setPOI((overlaySections)os, glaciers, 1);
                WM->setPOI((overlaySections)os, shelves1, 1);
                WM->setPOI((overlaySections)os, shelves2, 1);
                break;
              case river:
                WM->setPOI((overlaySections)os, wm_minor, 1);
                WM->setPOI((overlaySections)os, wm_major, 1);
                WM->setPOI((overlaySections)os, intermittentMajor, 1);
                WM->setPOI((overlaySections)os, intermittentMinor, 1);
                WM->setPOI((overlaySections)os, additionalMajor, 1);
                WM->setPOI((overlaySections)os, majorCanals, 1);
                WM->setPOI((overlaySections)os, lesserCanals, 1);
                WM->setPOI((overlaySections)os, irrigations, 1);
                WM->setPOI((overlaySections)os, doubleLines, 1);
                break;
              }
            break;
          }
        case none:
          {
            // ...but nothing is
	    infoLevels i2;
            for (i2=both; i2 < lastIL; increment(i2))
              WM->setPOI((overlaySections)os, (infoLevels)i2, 0);
            break;
          }
        default:
          {
            // Set the points of interest for the current feature file
            WM->setPOI((overlaySections)os, features, 1);

            // Check the two-parters
            if (features == saltPans1)
              WM->setPOI((overlaySections)os, saltPans2, 1);
            if (features == shelves1)
              WM->setPOI((overlaySections)os, shelves2, 1);
            break;
          }
        }
    } // Done for this feature set

  // The status check has bogus numbers, but it will tell folks
  // something is going on. These file readers are all self
  // contained, so I can't really get periodic status checks back
  // with them.
  OMstatus_check(5, "GISCIAMapII", NULL);
  // All set...read the data, and sort into polygonal regions
  WM->readData();
  OMstatus_check(70, "GISCIAMapII", NULL);

  // Output the number of polygons per region so 
  // people know what's up
  TotalPolys[geoBoundary] = WM->fetchPolygonCollection(geoBoundary).size();
  TotalPolys[polBoundary] = WM->fetchPolygonCollection(polBoundary).size();
  TotalPolys[coastal] = WM->fetchPolygonCollection(coastal).size();
  TotalPolys[river] = WM->fetchPolygonCollection(river).size();


  // Tell the polyline structures how big they will be in terms of polylines - 
  // eventually, each polyline will hold a piece of information from the
  // World databank: major, minor, etc. For immediate testing, this will
  // just hold one thing.
  geoPolylines.ncell_sets = 1;
  polPolylines.ncell_sets = 1;
  coastalPolylines.ncell_sets = 1;
  riverPolylines.ncell_sets = 1;

  // force the nspace to be 3-space
  geoPolylines.nspace = 3;
  polPolylines.nspace = 3;
  coastalPolylines.nspace = 3;
  riverPolylines.nspace = 3;

  // Necessary extra loop here. Determine apriori how many 
  // total vertices are in each polyline collection.
  // 
  // There seems to be something wrong with the ()++ operator
  // for overlaySections. Doing this manually for now..
  //
  // New decree:
  // There will be no line segment consisting of a single point
  for (os=geoBoundary; os<=river; increment(os))
    {
      TotalVertices[os] = 0;
      // How many polylines will be left after we eliminate
      // all of the single point polylines?
      validPolylines[os] = TotalPolys[os];
      for (i=0; i<TotalPolys[os]; i++)
	{
	  // Set a convience pointer 
	  pl = (WM->fetchPolyline((overlaySections)os, i));
	  if (pl->size() > 1)
	    TotalVertices[os] += pl->size();
	  else
	    validPolylines[os]--;     // there are not enough vertices in
					     // this line to count for squat
	}
      // reset the total number of polyline collections
    }

  // OK, now set this value in each Mesh field
  geoPolylines.nnodes = TotalVertices[geoBoundary];
  polPolylines.nnodes = TotalVertices[polBoundary];
  coastalPolylines.nnodes = TotalVertices[coastal];
  riverPolylines.nnodes = TotalVertices[river];

  // OK, now you are left with a collection of collections containing
  // the lat/lon/alt tuplets that form the vertices of the 
  // polylines. Since we are using a mesh, we must also specify the 
  // connectivity of each polyline. This is pretty easy, since 
  // the connectivity is just represented as the endpoints of each polyline

  // Geoboundary
  OMstatus_check(75, "GISCIAMapII", NULL);

  coordIterate = 0;
  nodeIterate = 0;
  // for now, we just have a single cellset

  // Set the number of polylines greater than one vertice for this guy 
  geoPolylines.cell_set[0].npolys = validPolylines[geoBoundary];

  if (TotalPolys[geoBoundary])
    {
      // Get the array representing the coordinate values --- this will be the
      // location information
      coordPtr = 
        (float *)geoPolylines.coordinates.values.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                     OM_TYPE_FLOAT,
                                                                     (xp_long *)NULL);
      if (coordPtr == (void *)NULL)
        {
          return 1;
        }


      // Get the array representing the connection list -- this will be connectivity
      polyPtr = 
        (xp_long *)geoPolylines.cell_set[0].poly_connect_list.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                              OM_TYPE_LONG,
                                                                              (xp_long *)NULL);

      if (polyPtr == (void *)NULL)
        {
          return 1;
        }


      // Loop through the polylines
      for (i=0; i<TotalPolys[geoBoundary]; i++)
        {
          // Set a convience pointer
          pl = (WM->fetchPolyline(geoBoundary, i));

          // OK...supply the coordinate locations and the connectivity.
          // New decree:
          // No more single point polylines!
          if (pl->size() > 1)
            {
              // This should exclude "single vertex" line
              for (j=0; j<pl->size(); j++)
                {
                  // First, the beginning and end points for connectivity information
                  if ((j == 0) || (j == (pl->size() - 1)))
                    polyPtr[nodeIterate++] = coordIterate;
                  // Add the current vertices to the coordinate list.
                  coordPtr[Index(coordIterate,1,3)] =
                    (WM->fetchLatLon(geoBoundary, i, j))->fetchLat();
                  coordPtr[Index(coordIterate,0,3)] = 
                    (WM->fetchLatLon(geoBoundary, i, j))->fetchLon();
                  coordPtr[Index(coordIterate,2,3)] = 
                    (WM->fetchLatLon(geoBoundary, i, j))->fetchAltitude();
                  coordIterate++;
                }
            }

        }
      ARRfree(polyPtr);
      ARRfree(coordPtr);
    }


  // PolBoundary
  OMstatus_check(80, "GISCIAMapII", NULL);

  coordIterate = 0;
  nodeIterate = 0;

  // for now, we just have a single cellset

  // Set the number of polylines greater than one vertices for this guy
  polPolylines.cell_set[0].npolys = validPolylines[polBoundary];

  if (TotalPolys[polBoundary])
    {
      // Get the array representing the coordinate values --- this will be the
      // location information
      coordPtr = 
        (float *)polPolylines.coordinates.values.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                     OM_TYPE_FLOAT,
                                                                     (xp_long *)NULL);
      if (coordPtr == (void *)NULL)
        {
          return 1;
        }

      // Get the array representing the connection list -- this will be connectivity
      polyPtr = 
        (xp_long *)polPolylines.cell_set[0].poly_connect_list.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                              OM_TYPE_LONG,
                                                                              (xp_long *)NULL);

      if (polyPtr == (void *)NULL)
        {
          return 1;
        }


      // Loop through the polylines
      for (i=0; i<TotalPolys[polBoundary]; i++)
        {
          // Set a convience pointer
          pl = (WM->fetchPolyline(polBoundary, i));

          // OK...supply the coordinate locations and the connectivity.
          // New decree:
          // No more single point polylines!
          if (pl->size() > 1)
            {
              // This should exclude "single vertex" line
              for (j=0; j<pl->size(); j++)
                {
                  // First, the beginning and end points for connectivity information
                  if ((j == 0) || (j == (pl->size() - 1)))
                    polyPtr[nodeIterate++] = coordIterate;
                  // Add the current vertices to the coordinate list.
                  coordPtr[Index(coordIterate,1,3)] =
                    (WM->fetchLatLon(polBoundary, i, j))->fetchLat();
                  coordPtr[Index(coordIterate,0,3)] = 
                    (WM->fetchLatLon(polBoundary, i, j))->fetchLon();
                  coordPtr[Index(coordIterate,2,3)] = 
                    (WM->fetchLatLon(polBoundary, i, j))->fetchAltitude();
                  coordIterate++;
                }
            }

        }
      ARRfree(polyPtr);
      ARRfree(coordPtr);
    }


  // Coastal
  OMstatus_check(85, "GISCIAMapII", NULL);

  coordIterate = 0;
  nodeIterate = 0;

  // for now, we just have a single cellset

  // Set the number of polylines greater than one vertice for this guy
  coastalPolylines.cell_set[0].npolys = validPolylines[coastal];

  if (TotalPolys[coastal])
    {
      // Get the array representing the coordinate values --- this will be the
      // location information
      coordPtr = 
        (float *)coastalPolylines.coordinates.values.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                         OM_TYPE_FLOAT,
                                                                         (xp_long *)NULL);
      if (coordPtr == (void *)NULL)
        {
          return 1;
        }

      // Get the array representing the connection list -- this will be connectivity
      polyPtr = 
        (xp_long *)coastalPolylines.cell_set[0].poly_connect_list.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                                  OM_TYPE_LONG,
                                                                                  (xp_long *)NULL);

      if (polyPtr == (void *)NULL)
        {
          return 1;
        }


      // Loop through the polylines
      for (i=0; i<TotalPolys[coastal]; i++)
        {
          // Set a convience pointer
          pl = (WM->fetchPolyline(coastal, i));

          // OK...supply the coordinate locations and the connectivity.
          // New decree:
          // No more single point polylines!
          if (pl->size() > 1)
            {
              // This should exclude "single vertex" line
              for (j=0; j<pl->size(); j++)
                {
                  // First, the beginning and end points for connectivity information
                  if ((j == 0) || (j == (pl->size() - 1)))
                    polyPtr[nodeIterate++] = coordIterate;
                  // Add the current vertices to the coordinate list.
                  coordPtr[Index(coordIterate,1,3)] =
                    (WM->fetchLatLon(coastal, i, j))->fetchLat();
                  coordPtr[Index(coordIterate,0,3)] = 
                    (WM->fetchLatLon(coastal, i, j))->fetchLon();
                  coordPtr[Index(coordIterate,2,3)] = 
                    (WM->fetchLatLon(coastal, i, j))->fetchAltitude();
                  coordIterate++;
                }
            }

        }
      ARRfree(polyPtr);
      ARRfree(coordPtr);
    }


  // Rivers
  OMstatus_check(90, "GISCIAMapII", NULL);

  coordIterate = 0;
  nodeIterate = 0;

  // for now, we just have a single cellset

  // Set the number of polylines greater than one vertice for this guy
  riverPolylines.cell_set[0].npolys = validPolylines[river];

  if (TotalPolys[river])
    {
      // Get the array representing the coordinate values --- this will be the
      // location information
      coordPtr = 
        (float *)riverPolylines.coordinates.values.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                       OM_TYPE_FLOAT,
                                                                       (xp_long *)NULL);
      if (coordPtr == (void *)NULL)
        {
          return 1;
        }

      // Get the array representing the connection list -- this will be connectivity
      polyPtr = 
        (xp_long *)riverPolylines.cell_set[0].poly_connect_list.ret_typed_array_ptr(OM_GET_ARRAY_WR,
                                                                              OM_TYPE_LONG,
                                                                              (xp_long *)NULL);

      if (polyPtr == (void *)NULL)
        {
          return 1;
        }


      // Loop through the polylines
      for (i=0; i<TotalPolys[river]; i++)
        {
          // Set a convience pointer
          pl = (WM->fetchPolyline(river, i));

          // OK...supply the coordinate locations and the connectivity.
          // New decree:
          // No more single point polylines!
          if (pl->size() > 1)
            {
              // This should exclude "single vertex" line
              for (j=0; j<pl->size(); j++)
                {
                  // First, the beginning and end points for connectivity information
                  if ((j == 0) || (j == (pl->size() - 1)))
                    polyPtr[nodeIterate++] = coordIterate;
                  // Add the current vertices to the coordinate list.
                  coordPtr[Index(coordIterate,1,3)] =
                    (WM->fetchLatLon(river, i, j))->fetchLat();
                  coordPtr[Index(coordIterate,0,3)] = 
                    (WM->fetchLatLon(river, i, j))->fetchLon();
                  coordPtr[Index(coordIterate,2,3)] = 
                    (WM->fetchLatLon(river, i, j))->fetchAltitude();
                  coordIterate++;
                }
            }

        }
      ARRfree(polyPtr);
      ARRfree(coordPtr);
    }

  OMstatus_check(100, "GISCIAMapII", NULL);

  // return 1 for success
  return(1);
}

