//*-*-c++-*-*
/*
                        Copyright (c) 1996 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved
        
        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.
        
        This file is under Perforce control
        $Id: //depot/express/fcs70/gis/xp_mods/modintrf.cxx#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include "GISIntrf.hxx"

//
//	function prototype
//
//	Note: the function Index() is defined in modProjection.cxx

xp_long Index(xp_long, xp_long, xp_long);

//
//	mfunction: inv_project
//
//	This method is invoke by notifications from the input
//	X/Y/Z ports. It performs a map projection from
//	XYZ space to LatLon space.

/* 64-bit porting. Only Modified Internally */
int
GIS_GISInverseProj::inv_project(OMevent_mask event_mask, int seq_num)
{

  // Retrieve the pointer for the Projection class. It 
  // should have been instanced when this class was created.
  Projection *inversePtr = (Projection *)ret_class_ptr("Projection");

#if 0
  // Can we talk?
  DebugBreak(); 
#endif
  
  // The input vector length can only be two or three. 
  // The output vector length here is forced to be whatever
  // the input veclen is. (If its 2, then no altitude data)
  if ((inXYZ.veclen < 2) || (inXYZ.veclen > 3))
    return 1;

  int ncols = inXYZ.veclen;
  
#if 0
  // Can we talk?
  DebugBreak(); 
#endif

  // Retrieve the pointers for the arrays involved
  // First, retrieve the input array
  // Try forcing the datatype.

  double *inPtr = 
    (double *)inXYZ.values.ret_typed_array_ptr(OM_GET_ARRAY_RD,
					       OM_TYPE_DOUBLE,
					       (xp_long *)NULL);
  if (inPtr == (double *)NULL)
    {
      return 1;
    }

  double *outPtr = (double *)
    outLLA.values.ret_typed_array_ptr(OM_GET_ARRAY_WR,
				      OM_TYPE_DOUBLE,
				      (xp_long *)NULL);

  if (outPtr == (void *)NULL)
    {
      return 1;
    }


  
  // Set the projection type
  inversePtr->setProjection((char *)InverseTransform);

#if 0
  // WE CANNOT DO THIS. IT CAUSES A FEEDBACK LOOP
  // Place the new name as a string back into the 
  // module, so the user knows (sort of) if it
  // was accepted or not.
  UtString	outTransform;
  outTransform = inversePtr->fetchProjectionName();
  InverseTransform = outTransform;
#endif

  // Set the global radius
  inversePtr->setGlobeRadius(GlobalRadius);

  // Set the base latitude and long. The module defaults the
  // location to Boston
  inversePtr->setBaseLatLon(baseLat, baseLon);

  // Set the first and second parallels
  inversePtr->setFirstPar(firstPar);
  inversePtr->setSecondPar(secondPar);


  // OK...loop through the LLA values projecting them to
  // XYZ values. If the input array only has a veclen of 2, 0 fill 
  // the altitude value.


  for (xp_long i = 0; i < inXYZ.nvals; i++)
    {
      // set location values...
      if (inXYZ.veclen == 2)
	inversePtr->setWorldCoordinates(inPtr[Index(i,0,ncols)], 
				     inPtr[Index(i,1,ncols)], 
				     0.0);
      else
	inversePtr->setWorldCoordinates(inPtr[Index(i,0,ncols)], 
				     inPtr[Index(i,1,ncols)], 
				     inPtr[Index(i,2,ncols)]);
  
  
      // Perform the map transformation and place the results
      // into the XYZ output ports
      // Convert the point to the requested projection type
      switch (inversePtr->fetchProjection())
	{
	case cartesian:
	  if (inversePtr->inverseCartesian())
	    break;
	case mercator:
	  if (inversePtr->inverseMercator())
	    break;
	case lambert_cyl:
	  if (inversePtr->inverseLambertCylindric())
	    break;
	case lambert_conical:
	  if (inversePtr->inverseLambertConical())
	    break;
	case gnomonic:
	  if (inversePtr->inverseGnomonic())
	    break;
	case stereo:
	  if (inversePtr->inverseStereo())
	    break;
	case ortho:
	  if (inversePtr->inverseOrthographic())
	    break;
	case postel:
	  if (inversePtr->inversePostel())
	    break;
	case lambert_azi:
	  if (inversePtr->inverseLambertAzimuthal())
	    break;
	case albers:
	  if (inversePtr->inverseAlbers())
	    break;	
	case cassini_soldner:
	  if (inversePtr->inverseCassiniSoldner())
	    break;
	case bonne:
	  if (inversePtr->inverseBonne())
	    break;
	case werner:
	  if (inversePtr->inverseWerner())
	    break;
	case sanson_flamsteed:
	  if (inversePtr->inverseSansonFlamsteed())
	    break;
	case globe:
	  if (inversePtr->inverseGlobe())
	    break;
	}
  
      // Fetch the stored lat/lon/alt
      double	lat,
		lon,
		alt;
      
      inversePtr->fetchLLCoordinates(&lat,&lon,&alt);
     
      outPtr[Index(i,1,ncols)] = lat;
      outPtr[Index(i,0,ncols)] = lon;
      if (ncols == 3)
	outPtr[Index(i,2,ncols)] = alt;
    }

  // Free the two pointers
  ARRfree(inPtr);
  ARRfree(outPtr);

  // return 1 for success
  return(1);
}

