//*-*-c++-*-*
/*
                        Copyright (c) 1996 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved
        
        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.
        
        This file is under Perforce control
        $Id: //depot/express/fcs70/gis/xp_mods/modll.cxx#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include "GISll.hxx"


int
GIS_GISLatLon::createLL(OMevent_mask event_mask, int seq_num)
{
   // latDegree (OMXdouble read req notify)
   // latMinute (OMXdouble read req notify)
   // latSecond (OMXdouble read req notify)
   // lonDegree (OMXdouble read req notify)
   // lonMinute (OMXdouble read req notify)
   // lonSecond (OMXdouble read req notify)
   // Latitude (OMXdouble write)
   // Longitude (OMXdouble write)

   /***********************/
   /* Function's Body     */
   /***********************/
   
   // Retrieve the pointer for the LatLon class. It should have
   // been instanced when this class was created.
   LatLon *llPtr = (LatLon *)ret_class_ptr("LatLon");

   // Set the values with the incoming information
   llPtr->setLat(latDegree, latMinute, latSecond);
   llPtr->setLon(lonDegree, lonMinute, lonSecond);
   llPtr->setAlt(inAlt);

   // Place the decimal equivalent of the lats and lons in the 
   // output parameters
   // 
   // must set up temporary doubles and place those doubles into the
   // parameter spaces because the parameters are really OMXdoubles.
   double	latTemp, 
		lonTemp,
		Alt;

   llPtr->fetchLat(&latTemp);
   llPtr->fetchLon(&lonTemp);
   Alt = llPtr->fetchAltitude();

   Latitude = latTemp;
   Longitude = lonTemp;
   Altitude = Alt;

   // return 1 for success
   return(1);
}

