/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/err_prnt.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdlib.h>

#include <avs/om.h>
#include <avs/err.h>

int GMODprint_error (OMobj_id obj_id, OMevent_mask mask, int seq_num)
{
	int on_inst, err;
	char *src, *msg;

	/*
	 * If we are being woken up by an instance event, we don't execute
	 * if the on_inst flag is not set.
	 */
	if ((mask & OM_EVENT_INST) &&
	    OMget_name_int_val(obj_id, OMstr_to_name("on_inst"), &on_inst) == 1
	    && on_inst == 0)
		return(1);

	if (OMget_name_int_val(obj_id, OMstr_to_name("error"), &err) !=1 || err == 0)
		return(1);

	if (OMget_name_str_val(obj_id, OMstr_to_name("error_source"), &src, 0) != 1)
		src = strdup("");
	if (OMget_name_str_val(obj_id, OMstr_to_name("error_message"), &msg, 0) != 1)
		msg = strdup("error");

	ERRerror(src, 0, ERR_ORIG, msg);
	if (src)
		free(src);
	if (msg)
		free(msg);
	return(1);
}
