/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/gmod.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/om.h>

int OMset_inst_state(OMobj_id obj_id, int val);

int GMODbase_init(int *argc, char **argv)
{
   int i;
   OMobj_id jobj;
   for (i = 1; i < *argc && i >= 1; i++) {
      if (!strcmp(argv[i],"-journal")) {
	 if (i + 1 < *argc) {
	    /*
	     * Create a global journal object and kick it off
	     */
	    jobj = OMcreate_obj_from_path("GMOD.journal","Journal",OMroot_obj);
	    OMset_name_str_val(jobj,OMstr_to_name("record_filename"),argv[i+1]);
	    OMset_name_int_val(jobj,OMstr_to_name("start_recording"),1);
	    OMset_inst_state(jobj,1);
	 }
	 else {
	    ERRerror("GMODinit",1,ERR_ORIG,
		     "missing file argument to -journal option to: %s",
		     argv[0]);
	    (*argc) -= 1;
	    i -= 1;
	    continue;
	 }
	 if ((*argc) > i + 1) {
	    MEMMOVE(&argv[i],&argv[i+2],((*argc)-i-1) * sizeof(char *));
	 }
	 i -= 2;
	 (*argc) -= 2;
      }
   }
   return 1;
}

