/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/morph.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/om.h>
#include <avs/om_att.h>

int OMset_inst_state(OMobj_id obj_id, int val);

/*
module morph {
   int morph_type;
   group morph_types<instanced=0>;
   omethod+notify_inst morph_inst<weight=0> = "GMODmorph_inst";
};
*/


int
GMODmorph_inst(OMobj_id obj_id, OMevent_mask event_mask, int seq_num)
{
   OMobj_id templ_id, old_templ_id, types_id;
   int ind, old_ind;
   OMobj_id sub_id, morph_id;

   if (OMget_name_int_val(obj_id, OMstr_to_name("morph_type"), &ind) != 1)
      ind = 0;
   if (OMget_name_int_val(obj_id, OMstr_to_name("old_index"), &old_ind) != 1)
      old_ind = -1;

   /*
    * Need to head this off to deal with recursion problem
    */
   if (ind == old_ind || ind == -1) {
      return(1);
   }

   types_id = OMfind_subobj(obj_id, OMstr_to_name("morph_types"), OM_OBJ_RD);
   if (OMget_array_subobj(types_id, ind, &templ_id, OM_OBJ_RD) != 1) {
      ERRerror("GMODmorph_inst",2,ERR_ORIG,
	   "no entry in morph_types defined for morph_type: %d in object: %s",
		ind,OMret_obj_name(obj_id));
      return(0);
   }

   sub_id = OMfind_subobj(obj_id, OMstr_to_name("morph_obj"), OM_OBJ_RD);
   if (OMget_obj_val(sub_id, &morph_id) != 1) morph_id = obj_id;

#if 0
  save old_ind instead
   /*
    * No need to do this if it's already done
    */
   if (OMis_subclass_of(morph_id, templ_id) == 1)
      return(1);
#endif

   OMset_inst_state(morph_id, 0);
   /*
    * Get rid of the old type before adding the new one.
    */
   if (old_ind != -1) {
      if (OMget_array_subobj(types_id,old_ind,&old_templ_id,OM_OBJ_RD) == 1) {
	 OMmerge_obj(old_templ_id, morph_id, OM_MERGE_UNMERGE_OBJ);
      }
   }

   OMmerge_obj(templ_id, morph_id, 0);

   OMset_inst_state(morph_id, 1);

   OMset_state_mode(OM_STATE_PRG);
   OMset_name_int_val(obj_id, OMstr_to_name("old_index"), ind);

   return(1);
}

