/*

    		Copyright (c) 1994 by
      		Advanced Visual Systems Inc.
      		All Rights Reserved

      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.

      This file is under Perforce control
      $Id: //depot/express/fcs70/gmod/sel_ent.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>

#include <avs/om.h>

/* This routine is called to respond to any changes in its
   input which is an array of entries. Each entry has an
   int and some type of value (eg. string, GDview, etc). This
   routine checks the sequence number of each entry and if it
   is greater than the sequence number of the update function
   outputs that entry id as the output. This gives us a general
   capability of selecting from a list of input items.
*/

/* 64-bit porting. Only Modified Internally */
int select_entry(OMobj_id elem_id)
{
   OMobj_id seq_id, nentries_id, entries_id;
   OMobj_id array_id, entry_id, active_id, select_id, sel_entry_id;
   int seq, active_seq;
   int found = 0;
   xp_long i, nentries;


   /* Every time the update function runs the sequence number goes up. This
      means the sequence number of the element itself will be the same
      as the sequence number of the update function after the update function
      executes.  We can use this fact to determine if any of the sub-elements
      has changed since the last time we ran.  If any of the elements have a
      sequence number higher than this, we know that the element has been
      modified since the last execution.
   */
   seq_id = OMfind_subobj(elem_id, OMstr_to_name("update"), OM_OBJ_RD);
   if (OMis_null_obj(seq_id))
      return(0);
   seq = OMget_obj_seq(seq_id, OMnull_obj, 0);

   /* Find the size of the entries array */
   nentries_id = OMfind_subobj(elem_id, OMstr_to_name("nentries"), OM_OBJ_RW);
   if (OMis_null_obj(nentries_id))
      return(0);
   if (!OMget_long_val(nentries_id, &nentries))
      return(0);

   /* Get id of the entries array */
   entries_id = OMfind_subobj(elem_id, OMstr_to_name("entries"), OM_OBJ_RW);
   if (OMis_null_obj(entries_id))
      return(0);

   /* Loop over array of entries to find the one that has changed.
      Go thru the whole list and take the one with the largest
      sequence number greater than the update seq. number. This
      is done to work around the fact we don't have an instance
      function so the first time we run everything looks like it
      has changed. This is probably the right thing to do anyway,
      in case multiple things have actually changed.
   */
   for (i=0; i<nentries; i++) {
      OMget_array_val(entries_id, i, &array_id, OM_OBJ_RW);
      if (!OMis_null_obj(array_id)) {
         OMget_obj_val(array_id, &entry_id);
         if (!OMis_null_obj(entry_id)) {
            active_id = OMfind_subobj(entry_id, OMstr_to_name("active"), OM_OBJ_RW);
            if (!OMis_null_obj(active_id)) {
               active_seq = OMget_obj_seq(active_id, OMnull_obj, OM_SEQ_VAL);
               if (active_seq > seq) {
                  found = 1;
		  /* save current entry and make its seq number the
		     one to now compare against.
                  */
#if defined (__alpha) && defined(__osf__)
/* Ack! Alpha compiler bug that only strikes when _not_ compiling with -g */
/* $XP_TESTPATH/gd/dodec.v is an example test that fails due to the bug.   */
/* CFS PR 22171 */
		  sel_entry_id.elem_id = entry_id.elem_id;
		  sel_entry_id.proc_id = entry_id.proc_id;
#else
		  sel_entry_id = entry_id;
#endif
		  seq = active_seq;
               }
            }
         }
      }
   }

   /* if we have found a changed entry, set its id to the selected id */
   if (found) {
      select_id = OMfind_subobj(elem_id, OMstr_to_name("selected"), OM_OBJ_RW);
      if (OMis_null_obj(select_id))
         return(0);
      OMset_obj_ref(select_id, sel_entry_id, 0);
      /* Make sure we generate an event in the case the same
         item has last time was selected.
      */
      OMsend_event(select_id, OM_EVENT_VAL);
   }
   return(1);
}
