/*
			Copyright (c) 2002 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/str_chc.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>
#include <stdlib.h>
#include <avs/om.h>

#define GET_SEQ(id) OMget_obj_seq( id, OMnull_obj, OM_SEQ_VAL )

int GMODstr_choice_update( OMobj_id mod_id, OMevent_mask mask, int seq_num )
{
    OMobj_id choices_id, index_id, string_id;
    int index_seq, index_stat, string_seq, string_stat;
    int choices_seq;
    int i, index;
    xp_long num_choices;
    int stat;
    char *string = NULL;

    choices_id = OMfind_subobj( mod_id, OMstr_to_name("choices"),
                                OM_OBJ_RW );

    choices_seq = GET_SEQ( choices_id );
    stat = OMget_array_size( choices_id, &num_choices );
    if( stat != OM_STAT_SUCCESS ) return 0;

    index_id   = OMfind_subobj( mod_id, OMstr_to_name("selected_index"),
                                OM_OBJ_RW );
    index_seq = GET_SEQ(index_id);
    index_stat = OMget_int_val( index_id, &index );

    string_id  = OMfind_subobj( mod_id, OMstr_to_name("selected_string"),
                                OM_OBJ_RW );
    string_seq = GET_SEQ(string_id);
    string_stat = OMget_str_val( string_id, &string, 0 );

    if( index_stat != OM_STAT_SUCCESS && string_stat != OM_STAT_SUCCESS )
        /* If neither selected_index or selected_string are valid,
         * then we are kinda stuck.
         */
        return 0;

    /* Choices array updated most recently */

    if( choices_seq > string_seq && choices_seq > index_seq ) {
        int tmp;

        if( string_seq < index_seq && index_seq == seq_num ) {
            /* The index sequence only appears more recent because
             * it was updated the last time the module fired.
             */
            tmp = string_seq; string_seq = index_seq; index_seq = tmp;
        }
        else if ( index_seq < string_seq && string_seq == seq_num ) {
            /* The index sequence only appears more recent because
             * it was updated the last time the module fired.
             */
            tmp = string_seq; string_seq = index_seq; index_seq = tmp;
        }
    }

    /* Do we update the index to match the string or the string
     * to match the index ?
     */

    if( string_seq < index_seq ) {

        /* Index updated more recently */

        if( index_stat != OM_STAT_SUCCESS ||
            index < 0 ||
            (int)num_choices <= index ) {
            /* Invalid index ... skip past links and unset the sel_string */
            if( OMget_obj_val( string_id, &string_id ) == OM_STAT_SUCCESS )
                OMset_obj_val( string_id, OMnull_obj, 0 );
        }
        else {
            char *choice = NULL;
            stat = OMget_str_array_val( choices_id, index, &choice, 0 );
            if( stat == OM_STAT_SUCCESS ) {
                if( string_stat != OM_STAT_SUCCESS ||
                    strcmp( choice, string ) != 0 ) {
                    OMset_str_val( string_id, choice );
                }
            }
            free( choice );
        }
    }
    else /* if( index_seq < string_seq ) */ {

        /* String updated more recently */

        if( string_stat != OM_STAT_SUCCESS ) {
            /* Invalid string ... unset the selected_index
             *
             * Careful, we don't want to nuke any connections this
             * object has.  Skip past links.
             */
            if( OMget_obj_val( index_id, &index_id ) == OM_STAT_SUCCESS )
                OMset_obj_val( index_id, OMnull_obj, 0 );
        }
        else {
            int found = 0;
            for( i = 0; i < (int)num_choices; i++ ) {
                char *choice = NULL;

                stat = OMget_str_array_val( choices_id, i, &choice, 0 );
                if( stat != OM_STAT_SUCCESS ) continue;

                if( strcmp( choice, string ) == 0 ) {
                    found = 1;
                    if( index_stat != OM_STAT_SUCCESS || i != index )
                        OMset_int_val( index_id, i );
                    free( choice );
                    break;
                }

                free( choice );
            }
            if( !found ) {
                /* Skip past links and unset the selected_index */
                if( OMget_obj_val( index_id, &index_id ) == OM_STAT_SUCCESS )
                    OMset_obj_val( index_id, OMnull_obj, 0 );
            }
        }
    }

    if( string ) free( string );

    return 1;
}
