/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/timer.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/gmod.h>
#include "uci_gmod.h"
#include <avs/event.h>
#include <avs/om.h>

#if 1
void
TimerFunc(char *ts_arg)
{
    TimerStruct *ts = (TimerStruct *)ts_arg;
    TimerBitmask OutBmk;

    OMcstruct_resolve_ptr(ts, NULL);

    ts->Val += ts->ValStep;

    memset((char *)&OutBmk, 0, sizeof(TimerBitmask));
    OutBmk.Val = 1;
    OMcstruct_update_om(ts, &OutBmk);
}

int
TimerUpdate(TimerStruct *ts, TimerBitmask *Bmk)
{
    if (Bmk->Active || Bmk->TimeStep) {
	if (ts->WasActive)
	    (void) EVdel_select(EV_TIMEOUT0, 0, TimerFunc, NULL, (void *) ts,
				ts->OldTimeStep);
	ts->WasActive = ts->Active;

	if (ts->Active)
	    EVadd_select(EV_TIMEOUT0, 0, TimerFunc, NULL, (void *) ts,
			 ts->TimeStep);
	ts->OldTimeStep = ts->TimeStep;
    }
    return 1;
}

int
TimerDel(TimerStruct *ts, TimerBitmask *Bmk)
{
    if (ts->WasActive) (void) EVdel_select(EV_TIMEOUT0, 0, TimerFunc, NULL,
					   (void *) ts, ts->OldTimeStep);
    ts->WasActive = 0;
    return 1;
}

#else /* MSDOS */

TimerStruct *Timers = NULL;

void CALLBACK
TimerFunc(HWND hWnd, int Msg, int id, DWORD Time)
{
    TimerStruct *ts;
    TimerBitmask OutBmk;

    for (ts = Timers; ts; ts = ts->Next)
	if (ts->Timer == id) break;
    if (!ts) return;

    OMcstruct_resolve_ptr(ts, NULL);

    ts->Val += ts->ValStep;

    memset(&OutBmk, 0, sizeof(TimerBitmask));
    OutBmk.Val = 1;
    OMcstruct_update_om(ts, &OutBmk);
}

int
TimerUpdate(TimerStruct *ts, TimerBitmask *Bmk)
{
    int TimeStep;

    if (!ts->Next) {
	ts->Next = Timers;
	Timers = ts;
	}

    if (Bmk->Active || Bmk->TimeStep) {
	if (ts->WasActive) KillTimer(NULL, ts->Timer);
	ts->WasActive = ts->Active;

	if (ts->TimeStep >= 10) TimeStep = ts->TimeStep;
	else			TimeStep = 10;

	if (ts->Active)
	     ts->Timer = SetTimer(NULL, 0, TimeStep, (TIMERPROC) TimerFunc);
	else ts->Timer = 0;
	}
    }

int
TimerDel(TimerStruct *ts, TimerBitmask *Bmk)
{
    TimerStruct *Cur, *Last;

    if (ts->WasActive) KillTimer(NULL, ts->Timer);
    ts->WasActive = 0;

    Last = NULL;
    for (Cur=Timers; Cur; Cur=Cur->Next) {
	if (Cur == ts) break;
	Last = Cur;
	}

    if (Cur) {
	if (!Last) Timers = Cur->Next;
	else       Last->Next = Cur->Next;
	}
    ts->Next = NULL;

    ts->Timer = 0;
    }
#endif
