/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      $Id: //depot/express/fcs70/include/agx/agx32.h#1 $
//
// UNIRAS function declarations for IMA
//--------------------------------------------------------------------*/

#ifndef _agx64_h
#ifndef _agx32_h
#define _agx32_h

#ifndef WIN32
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#else
#include <windows.h>
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif

/*
 *  Set version defines
  */
#define XuVERSION_STRING "AVS/UNIRAS TOOLMASTER - agX Version 7V1"
#define XuVERSION         7
#define XuREVISION        1
#define XuUPDATE_LEVEL   ' '
#define XuVersion        (XuVERSION*1000 + XuREVISION*100 + XuUPDATE_LEVEL)

/*
 *  Set some test defines
 */
#define AGX_6V3B  (6*1000 + 3*100 + 'B')
#define AGX_6V4A  (6*1000 + 4*100 + 'A')
#define AGX_6V4B  (6*1000 + 4*100 + 'B')
#define AGX_6V5A  (6*1000 + 5*100 + 'A')
#define AGX_7V0   (7*1000 + 0*100 + ' ')
#define AGX_7V1   (7*1000 + 1*100 + ' ')

/*
 * Set return state definitions
 */
#define XuOK 0
#define XuWARNING 1
#define XuERROR 2
#define XuFATAL 3

#ifndef XuCallCnv
#ifndef WIN32
#define XuCallCnv
#else
// We are currently using an version of the agX library compiled with
// MSDEV 6 (_MSC_VER==1200), so using this header file while compiling 
// Express with MSDEV 7 (MSC_VER==1300) leads to link errors.
#if _MSC_VER >= 1300
#define XuCallCnv
#else
#define XuCallCnv __stdcall
#endif
#endif
#endif

#ifndef XuType
#define XuType void
#endif

#ifndef _XuFloat
#define _XuFloat
typedef float XuFloat;
#endif /* _XuFloat */

/*
 * XuOpenAdvanced options
 */
#ifndef WIN32
typedef struct {
  int colormodel;
  int colors;
  int depth;
  Colormap cmap;
  Visual* visual;
  XStandardColormap* stdcmap;
  int subtractive;
  Screen* screen;
} XuAdvancedOptions;
#else              
typedef struct {
  int colormodel;
  int colors;
  int depth;
  void *cmap;
  void *visual;
  void *stdcmap;
  int subtractive;
  void *screen;
} XuAdvancedOptions;
#endif
/*                                                                       */
/* XuInitialize - Initialize UNIRAS                                      */
/*                                                                       */
extern XuType XuInitialize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       argc     , /* i   in  \tts argc from main program            */
  char      **argv     /* c   in  \tts argv from main program            */
#endif
);

#ifdef WIN32
/*                                                                       */
/* XuTextUNICODEDraw - Draw UNICODE text                                 */
/*                                                                       */
extern XuType XuCallCnv XuTextUNICODEDraw (
#if NeedFunctionPrototypes
  wchar_t *str, 
  double x, 
  double y
#endif
);
/*                                                                       */
/* XuTextUNICODEContinueDraw - Draw UNICODE continuation text            */
/*                                                                       */
extern XuType XuCallCnv XuTextUNICODEContinueDraw(
#if NeedFunctionPrototypes
  wchar_t *str
#endif  
);
#endif

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agx32_h */
#else
ERROR_Single_precision_version_agX_32_cannot_be_mixed_with_64_bit_version
#endif /* _agx64_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */
