/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under CVS/RCS control in:
//      $Id: //depot/express/fcs70/include/agx/agxaxi.h#1 $
//
// UNIRAS function declarations for AXI
//--------------------------------------------------------------------*/

#ifndef _agxaxi_h
#define _agxaxi_h

#ifndef _agx64_h
#ifndef _agx32_h
#include <agX/agx32.h>
#endif
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif
/*                                                                       */
/* XuAxisAxleExponent - Set exponent value for power scale axis          */
/*                                                                       */
extern XuType XuCallCnv XuAxisAxleExponent (
#if NeedFunctionPrototypes
/*                                                                       */
  double    exponent    /* r   in  Exponent value                        */
#endif
);
/*                                                                       */
/* exponent: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisAxle - Set scale layout and axle attributes                     */
/*                                                                       */
extern XuType XuCallCnv XuAxisAxle (
#if NeedFunctionPrototypes
/*                                                                       */
  int       scale        , /* i   in  Select scale type                  */
  int       color_index  , /* i   in  Axle color index                   */
  int       line_style   , /* i   in  Axle linestyle                     */
  double    width          /* r   in  Axle width (mm)                    */
#endif
);
/*                                                                       */
/* scale: Linear scale                                                   */
#ifndef XuLINEAR
#define XuLINEAR 1
#endif
/* scale: Logarithmic (base 10) scale                                    */
#ifndef XuLOG10
#define XuLOG10 2
#endif
/* scale: Power scale                                                    */
#ifndef XuPOWER
#define XuPOWER 3
#endif
/* scale: User-defined scale                                             */
#ifndef XuUSER
#define XuUSER 4
#endif
/* scale: Ignore argument                                                */
#ifndef XuI_IGNORE
#define XuI_IGNORE 9999
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTick - Set tickmark attributes                                  */
/*                                                                       */
extern XuType XuCallCnv XuAxisTick (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length         , /* r   in  Tickmark length (mm)             */
  int       color_index    , /* i   in  Tickmark color index             */
  double    width          , /* r   in  Tickmark width (mm)              */
  int       justification    /* i   in  Tickmark justification           */
#endif
);
/*                                                                       */
/* length: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* justification: Right justified in relation to axle                    */
#ifndef XuTICK_RIGHT
#define XuTICK_RIGHT 1
#endif
/* justification: Left justified in relation to axle                     */
#ifndef XuTICK_LEFT
#define XuTICK_LEFT 2
#endif
/* justification: Center justified in relation to axle                   */
#ifndef XuTICK_CENTER
#define XuTICK_CENTER 3
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTickLayout - Set tickmark features                              */
/*                                                                       */
extern XuType XuCallCnv XuAxisTickLayout (
#if NeedFunctionPrototypes
/*                                                                       */
  int       layout_style  , /* i   in  Select tickmark layout style      */
  double    tick_first    , /* r   in  Tickmark first reference axis value    */
  double    tick_second   , /* r   in  Tickmark second reference axis value    */
  double    tick_step       /* r   in  Tickmark step value               */
#endif
);
/*                                                                       */
/* tick_step: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolygonsDelete - Delete the axis bounding polygons              */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolygonsDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component    /* i   in  Axis component                       */
#endif
);
/*                                                                       */
/* component: All axis components                                        */
#ifndef XuALL
#define XuALL 0
#endif
/* component: Axle                                                       */
#ifndef XuAXLE
#define XuAXLE 1
#endif
/* component: Tickmarks                                                  */
#ifndef XuTICKS
#define XuTICKS 2
#endif
/* component: Minor tickmarks                                            */
#ifndef XuMINOR_TICKS
#define XuMINOR_TICKS 3
#endif
/* component: Axis-labels                                                */
#ifndef XuLABELS
#define XuLABELS 4
#endif
/* component: Axis-unit                                                  */
#ifndef XuUNIT
#define XuUNIT 5
#endif
/* component: Axis-text                                                  */
#ifndef XuTEXT
#define XuTEXT 6
#endif
/* component: Ticklines                                                  */
#ifndef XuTICKLINES
#define XuTICKLINES 7
#endif
/* component: Minor ticklines                                            */
#ifndef XuMINOR_TICKLINES
#define XuMINOR_TICKLINES 8
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolarPolygonsDelete - Delete the polar axis bounding polygons   */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarPolygonsDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component    /* i   in  Axis component                       */
#endif
);
/*                                                                       */
/* XuAxisDrawOptions - Set draw and measure options for axis components  */
/*                                                                       */
extern XuType XuCallCnv XuAxisDrawOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component      , /* i   in  Axis component                   */
  int       draw_code      , /* i   in  Select draw status               */
  int       suppress_code    /* i   in  Suppression factor               */
#endif
);
/*                                                                       */
/* draw_code: Don't draw                                                 */
#ifndef XuOFF
#define XuOFF 0
#endif
/* draw_code: Draw                                                       */
#ifndef XuON
#define XuON 1
#endif
/* draw_code: Measure                                                    */
#ifndef XuMEASURE
#define XuMEASURE 2
#endif
/* draw_code: Draw and measure                                           */
#ifndef XuON_MEASURE
#define XuON_MEASURE 3
#endif
/* suppress_code: Suppress first tickmark, label or tickline             */
#ifndef XuFIRST
#define XuFIRST 1
#endif
/* suppress_code: Suppress last tickmark, label or tickline              */
#ifndef XuLAST
#define XuLAST 2
#endif
/* suppress_code: Suppress first and last tickmarks, labels or ticklines */
#ifndef XuENDS
#define XuENDS 3
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolarPolygonsNumberSize - Query the number and size of the pola */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarPolygonsNumberSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  int       *number    , /* i   out Number of bounding polygons          */
  int       *size        /* i   out Size in elements of a bounding polygons array    */
#endif
);
/*                                                                       */
/* XuAxisPolarPolygonsQuery - Query the polar axis component bounding po */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarPolygonsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component         , /* i   in  Axis component                */
  int       *num_points_array , /* ia  out Number of points of polygons    */
  void      *x_array          , /* ra  out X-coordinates of points       */
  void      *y_array            /* ra  out Y-coordinates of points       */
#endif
);
/*                                                                       */
/* XuAxisLimitsQuery - Help for axis limits                              */
/*                                                                       */
extern XuType XuCallCnv XuAxisLimitsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type    , /* i   in  Axis type                          */
  double    height       , /* r   in  Height of axis-labels (mm)         */
  double    grace_start  , /* r   in  Minimum start grace clearance      */
  double    grace_end    , /* r   in  Minimum end grace clearance        */
  int       select_code  , /* i   in  Select outputs                     */
  XuFloat   *value_start , /* r   out Starting axis value (user units)    */
  XuFloat   *value_end   , /* r   out Final axis value (user units)      */
  XuFloat   *tick_step   , /* r   out Tickmark step value (user units)    */
  XuFloat   *label_step    /* r   out Axis-label step value (user units)    */
#endif
);
/*                                                                       */
/* axis_type: X axis                                                     */
#ifndef XuX_AXIS
#define XuX_AXIS 1
#endif
/* axis_type: Y axis                                                     */
#ifndef XuY_AXIS
#define XuY_AXIS 2
#endif
/* select_code: Return new \PP{value_start} and \PP{value_end}           */
#ifndef XuSTART_END
#define XuSTART_END 1
#endif
/* select_code: Return new \PP{value_start} only (ignore \PP{grace_end}) */
#ifndef XuSTART
#define XuSTART 2
#endif
/* select_code: Return new \PP{value_end} only (ignore \PP{grace_start}) */
#ifndef XuEND
#define XuEND 3
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPlanesQuery - Help for drawing a single axis in 3D              */
/*                                                                       */
extern XuType XuCallCnv XuAxisPlanesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type      , /* i   in  Axis type                        */
  int       tick_plane     , /* i   in  Tickline plane                   */
  double    cross_value_1  , /* r   in  1st axis cross value             */
  double    cross_value_2  , /* r   in  2nd axis cross value             */
  void      *help_array_1  , /* ra  out 1st argument set                 */
  void      *help_array_2  , /* ra  out 2nd argument set                 */
  int       *plane_number    /* i   out Selected drawing plane           */
#endif
);
/*                                                                       */
/* axis_type: Z axis                                                     */
#ifndef XuZ_AXIS
#define XuZ_AXIS 3
#endif
/* tick_plane: YZ plane                                                  */
#ifndef XuYZ_PLANE
#define XuYZ_PLANE 1
#endif
/* tick_plane: XZ plane                                                  */
#ifndef XuXZ_PLANE
#define XuXZ_PLANE 2
#endif
/* tick_plane: XY plane                                                  */
#ifndef XuXY_PLANE
#define XuXY_PLANE 3
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPlanesSetQuery - Help for drawing a set of axes in 3D           */
/*                                                                       */
extern XuType XuCallCnv XuAxisPlanesSetQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       help_code   , /* i   in  Help option                         */
  int       axis_type   , /* i   in  Axis type                           */
  int       plane       , /* i   in  Orientation of axis scale           */
  void      *help_array , /* ra  out Argument sets                       */
  int       *num_help     /* i   out Number of argument sets to be used    */
#endif
);
/*                                                                       */
/* help_code: Scales                                                     */
#ifndef XuSCALE
#define XuSCALE 1
#endif
/* help_code: Ticklines                                                  */
#ifndef XuTICKLINE
#define XuTICKLINE 2
#endif
/* axis_type: X axes                                                     */
#ifndef XuX_AXES
#define XuX_AXES 1
#endif
/* axis_type: Y axes                                                     */
#ifndef XuY_AXES
#define XuY_AXES 2
#endif
/* axis_type: Z axes                                                     */
#ifndef XuZ_AXES
#define XuZ_AXES 3
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolarLengthQuery - Help for polar axis length                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarLengthQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type  , /* i   in  Axis type                            */
  double    radius     , /* r   in  Radius (user units)                  */
  XuFloat   *length      /* r   out Length (mm)                          */
#endif
);
/*                                                                       */
/* axis_type: R axis                                                     */
#ifndef XuR_AXIS
#define XuR_AXIS 1
#endif
/* axis_type: T axis                                                     */
#ifndef XuT_AXIS
#define XuT_AXIS 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolarToWorld - Convert local polar coordinates to world coordin */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarToWorld (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *r_array    , /* ra  io  R-coordinates on entry              */
  void      *t_array    , /* ra  io  T-coordinates on entry              */
  int       num_points    /* i   in  Number of points                    */
#endif
);
/*                                                                       */
/* XuAxisPolarWorldToPolar - Convert world coordinates to local polar co */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarWorldToPolar (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  io  X-coordinates on entry              */
  void      *y_array    , /* ra  io  Y-coordinates on entry              */
  int       num_points    /* i   in  Number of points                    */
#endif
);
/*                                                                       */
/* XuAxisPolarLimitsQuery - Query local polar coordinate system limits   */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarLimitsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *radius_start   , /* r   out Start radius (user units)       */
  XuFloat   *angle_start    , /* r   out Start angle (degrees)           */
  XuFloat   *radius_end     , /* r   out End radius (user units)         */
  XuFloat   *angle_end      , /* r   out End angle (degrees)             */
  XuFloat   *origin         , /* r   out Polar origin (user units)       */
  XuFloat   *rotation_angle , /* r   out Rotation angle of the R-axis (degrees)    */
  int       *direction      , /* i   out Angle increment direction       */
  int       *justification    /* i   out Justification of the polar area    */
#endif
);
/*                                                                       */
/* direction: Counter-clockwise                                          */
#ifndef XuCOUNTERCLOCKWISE
#define XuCOUNTERCLOCKWISE 1
#endif
/* direction: Clockwise                                                  */
#ifndef XuCLOCKWISE
#define XuCLOCKWISE 2
#endif
/* justification: Lower left corner                                      */
#ifndef XuMAP_LOWER_LEFT
#define XuMAP_LOWER_LEFT 1
#endif
/* justification: Lower right corner                                     */
#ifndef XuMAP_LOWER_RIGHT
#define XuMAP_LOWER_RIGHT 2
#endif
/* justification: Upper left corner                                      */
#ifndef XuMAP_UPPER_LEFT
#define XuMAP_UPPER_LEFT 3
#endif
/* justification: Upper right corner                                     */
#ifndef XuMAP_UPPER_RIGHT
#define XuMAP_UPPER_RIGHT 4
#endif
/* justification: Center                                                 */
#ifndef XuMAP_CENTER
#define XuMAP_CENTER 5
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolygonsNumberSize - Query the number and size of the axis boun */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolygonsNumberSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  int       *number    , /* i   out Number of bounding polygons          */
  int       *size        /* i   out Size in elements of a bounding polygons array    */
#endif
);
/*                                                                       */
/* XuAxisPolygonsQuery - Query the axis component bounding polygons      */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolygonsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component         , /* i   in  Axis component                */
  int       *num_points_array , /* ia  out Number of points of polygons    */
  void      *x_array          , /* ra  out X-coordinates of points       */
  void      *y_array            /* ra  out Y-coordinates of points       */
#endif
);
/*                                                                       */
/* XuAxisDraw - Draw axis                                                */
/*                                                                       */
extern XuType XuCallCnv XuAxisDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type    , /* i   in  Axis type                          */
  double    cross_value  , /* r   in  Cross value for X- or Y-axis       */
  double    height       , /* r   in  Height of axis-labels (mm)         */
  int       label_mode     /* i   in  Labelling mode                     */
#endif
);
/*                                                                       */
/* label_mode: Normal mode                                               */
#ifndef XuNORMAL
#define XuNORMAL 1
#endif
/* label_mode: Reversed mode                                             */
#ifndef XuREVERSED
#define XuREVERSED 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisSystemDraw - Draw 2D axis system                                */
/*                                                                       */
extern XuType XuCallCnv XuAxisSystemDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    y       , /* r   in  Y position for X axis                   */
  double    x       , /* r   in  X position for Y axis                   */
  double    height  , /* r   in  Height of axis-labels (mm)              */
  void      *text   , /* ca  in  Texts for axis-unit and axis-text       */
  int       mxtext    /* i   in  Maximum length of text strings in text    */
#endif
);
/*                                                                       */
/* XuAxisSystem3DDraw - Draw 3D axis system                              */
/*                                                                       */
extern XuType XuCallCnv XuAxisSystem3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type  , /* i   in  Axis type                            */
  double    height     , /* r   in  Height of axis-labels (mm)           */
  int       *plane     , /* ia  in  Orientation of X/Y/Z axis scale      */
  void      *text      , /* ca  in  Texts for axis-unit and axis-text    */
  int       mxtext       /* i   in  Maximum length of text strings in text    */
#endif
);
/*                                                                       */
/* axis_type: X, Y, Z axes                                               */
#ifndef XuXYZ_AXES
#define XuXYZ_AXES 0
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolarDraw - Draw polar axis                                     */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type      , /* i   in  Axis type                        */
  double    cross_value    , /* r   in  Cross value for R or T axis      */
  double    height         , /* r   in  Height of axis-labels (mm)       */
  int       justification    /* i   in  Scale justification              */
#endif
);
/*                                                                       */
/* justification: Right mode                                             */
#ifndef XuRIGHT_MODE
#define XuRIGHT_MODE 1
#endif
/* justification: Left mode                                              */
#ifndef XuLEFT_MODE
#define XuLEFT_MODE 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisScale - Set axis scale                                          */
/*                                                                       */
extern XuType XuCallCnv XuAxisScale (
#if NeedFunctionPrototypes
/*                                                                       */
  int       method    /* i   in  Select fine or coarse axis scale        */
#endif
);
/*                                                                       */
/* method: Fine axis scale                                               */
#ifndef XuFINE
#define XuFINE 1
#endif
/* method: Coarse axis scale                                             */
#ifndef XuCOARSE
#define XuCOARSE 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisLabelColors - Set axis-label colors                             */
/*                                                                       */
extern XuType XuCallCnv XuAxisLabelColors (
#if NeedFunctionPrototypes
/*                                                                       */
  double    value_min        , /* r   in  Axis value                     */
  double    value_max        , /* r   in  Axis value                     */
  int       *color_min_array , /* ia  in  Color indices                  */
  int       *color_max_array , /* ia  in  Color indices                  */
  int       *color_mid_array   /* ia  in  Color indices                  */
#endif
);
/*                                                                       */
/* value_min: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* value_max: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisLabelFormat - Set axis-label numeric format                     */
/*                                                                       */
extern XuType XuCallCnv XuAxisLabelFormat (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_decimal  , /* i   in  Number of decimal places           */
  int       power        , /* i   in  Axis-unit power factor             */
  int       zero_mode    , /* i   in  Trailing zero fractions treatment    */
  int       label_mode     /* i   in  Select number format               */
#endif
);
/*                                                                       */
/* zero_mode: All trailing zero fractions are truncated (except the      */
#ifndef XuOMIT_ZEROS
#define XuOMIT_ZEROS 1
#endif
/* zero_mode: All trailing zero fractions left untouched                 */
#ifndef XuDRAW_ZEROS
#define XuDRAW_ZEROS 2
#endif
/* label_mode: Reset to default number of decimal places,                */
#ifndef XuRESET
#define XuRESET 0
#endif
/* label_mode: Axis system default format                                */
#ifndef XuDEFAULT_FORMAT
#define XuDEFAULT_FORMAT 1
#endif
/* label_mode: EE format                                                 */
#ifndef XuEE_FORMAT
#define XuEE_FORMAT 2
#endif
/* label_mode: $\times$10 format                                         */
#ifndef Xu10_FORMAT
#define Xu10_FORMAT 3
#endif
/* label_mode: EE format without multipliers                             */
#ifndef XuEE_NO_MULT_FORMAT
#define XuEE_NO_MULT_FORMAT 4
#endif
/* label_mode: $\times$10 format without multipliers                     */
#ifndef Xu10_NO_MULT_FORMAT
#define Xu10_NO_MULT_FORMAT 5
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisLabelStyleFormat - Set axis-label numeric style format          */
/*                                                                       */
extern XuType XuCallCnv XuAxisLabelStyleFormat (
#if NeedFunctionPrototypes
/*                                                                       */
  int       option  , /* i   in  Option to be set                        */
  char      *value    /* c   in  Option character                        */
#endif
);
/*                                                                       */
/* option: This character will act as decimal point                      */
#ifndef XuDECIMAL_POINT
#define XuDECIMAL_POINT 1
#endif
/* option: This character will act as plus sign                          */
#ifndef XuPLUS_SIGN
#define XuPLUS_SIGN 2
#endif
/* option: This character will act as minus sign                         */
#ifndef XuMINUS_SIGN
#define XuMINUS_SIGN 3
#endif
/* option: This character will act as three--digit--spacer               */
#ifndef XuTHREE_DIGIT_SPACER
#define XuTHREE_DIGIT_SPACER 4
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisLabelGap - Set gap between axis-labels and tickmarks            */
/*                                                                       */
extern XuType XuCallCnv XuAxisLabelGap (
#if NeedFunctionPrototypes
/*                                                                       */
  double    distance    /* r   in  Minimum distance between axis-label    */
#endif
);
/*                                                                       */
/* distance: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisLabelScale - Set axis-label value scale factor                  */
/*                                                                       */
extern XuType XuCallCnv XuAxisLabelScale (
#if NeedFunctionPrototypes
/*                                                                       */
  double    scale_factor    /* r   in  Select axis-label scale factor    */
#endif
);
/*                                                                       */
/* XuAxisLogPattern - Set log and power patterns for tickmarks and axis- */
/*                                                                       */
extern XuType XuCallCnv XuAxisLogPattern (
#if NeedFunctionPrototypes
/*                                                                       */
  int       tick_pattern   , /* i   in  Select tickmark pattern          */
  int       label_pattern    /* i   in  Select axis-label pattern        */
#endif
);
/*                                                                       */
/* tick_pattern: Automatic selection based on height of axis-labels      */
#ifndef XuAUTO
#define XuAUTO 0
#endif
/* tick_pattern: 3456789 1 Basic pattern: 1,2,3,4,5,6,7,8,9,10           */
#ifndef XuTICK_123456789
#define XuTICK_123456789 1
#endif
/* tick_pattern: 68 2 Basic pattern: 1,2,4,6,8,10                        */
#ifndef XuTICK_12468
#define XuTICK_12468 2
#endif
/* tick_pattern: Basic pattern: 1,2,4,7,10                               */
#ifndef XuTICK_1247
#define XuTICK_1247 3
#endif
/* tick_pattern: Basic pattern: 1,3,6,10                                 */
#ifndef XuTICK_136
#define XuTICK_136 4
#endif
/* tick_pattern: 5 Basic pattern: 1,5,10                                 */
#ifndef XuTICK_15
#define XuTICK_15 5
#endif
/* tick_pattern: Basic pattern: 1,10                                     */
#ifndef XuTICK_1
#define XuTICK_1 6
#endif
/* label_pattern: 1 Basic pattern: 1,10                                  */
#ifndef XuLABELS_1
#define XuLABELS_1 1
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisPolarLimits - Set local polar coordinate system limits          */
/*                                                                       */
extern XuType XuCallCnv XuAxisPolarLimits (
#if NeedFunctionPrototypes
/*                                                                       */
  double    radius_start    , /* r   in  Start radius (user units)       */
  double    angle_start     , /* r   in  Start angle (degrees)           */
  double    radius_end      , /* r   in  End radius (user units)         */
  double    angle_end       , /* r   in  End angle (degrees)             */
  double    origin          , /* r   in  Polar origin (user units)       */
  double    rotation_angle  , /* r   in  Rotation angle of the R-axis (degrees)    */
  int       direction       , /* i   in  Angle increment direction       */
  int       justification     /* i   in  Justification of the polar area    */
#endif
);
/*                                                                       */
/* origin: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* rotation_angle: Ignore argument                                       */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisReset - Reset axis characteristics                              */
/*                                                                       */
extern XuType XuCallCnv XuAxisReset (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuAxisMinorTick - Set minor tickmark attributes                       */
/*                                                                       */
extern XuType XuCallCnv XuAxisMinorTick (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length         , /* r   in  Minor tickmark length (mm)       */
  int       color_index    , /* i   in  Minor tickmark color index       */
  double    width          , /* r   in  Minor tickmark width (mm)        */
  int       justification    /* i   in  Minor tickmark justification     */
#endif
);
/*                                                                       */
/* length: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisMinorTickCount - Set minor tickmark frequency                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisMinorTickCount (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_minor    /* i   in  Minor tickmark frequency             */
#endif
);
/*                                                                       */
/* XuAxisMinorTickRange - Set minor tickmark range                       */
/*                                                                       */
extern XuType XuCallCnv XuAxisMinorTickRange (
#if NeedFunctionPrototypes
/*                                                                       */
  int       range    /* i   in  Minor tickmark range                     */
#endif
);
/*                                                                       */
/* range: Extended range                                                 */
#ifndef XuEXTENDED
#define XuEXTENDED 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTextColor - Set axis-text attributes                            */
/*                                                                       */
extern XuType XuCallCnv XuAxisTextColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component   , /* i   in  Axis component                      */
  int       line_color  , /* i   in  Line color of text                  */
  int       fill_color  , /* i   in  Filled-area color of text           */
  double    boldness    , /* r   in  Character boldness factor           */
  int       hjust       , /* i   in  Horizontal justification            */
  int       vjust       , /* i   in  Vertical justification              */
  double    angle         /* r   in  Angle of text relative to axle      */
#endif
);
/*                                                                       */
/* boldness: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* hjust: Left justified                                                 */
#ifndef XuLEFT
#define XuLEFT 0
#endif
/* hjust: Center justified                                               */
#ifndef XuCENTER
#define XuCENTER 1
#endif
/* hjust: Right justified                                                */
#ifndef XuRIGHT
#define XuRIGHT 2
#endif
/* vjust: Font bottom                                                    */
#ifndef XuFONT_BOTTOM
#define XuFONT_BOTTOM 0
#endif
/* vjust: Font base                                                      */
#ifndef XuFONT_BASE
#define XuFONT_BASE 1
#endif
/* vjust: Font half                                                      */
#ifndef XuFONT_HALF
#define XuFONT_HALF 2
#endif
/* vjust: Font cap                                                       */
#ifndef XuFONT_CAP
#define XuFONT_CAP 3
#endif
/* vjust: Font top                                                       */
#ifndef XuFONT_TOP
#define XuFONT_TOP 4
#endif
/* vjust: Physical bottom                                                */
#ifndef XuTEXT_BOTTOM
#define XuTEXT_BOTTOM 5
#endif
/* vjust: Physical half                                                  */
#ifndef XuTEXT_HALF
#define XuTEXT_HALF 6
#endif
/* vjust: Physical top                                                   */
#ifndef XuTEXT_TOP
#define XuTEXT_TOP 7
#endif
/* angle: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisFont - Set axis-text font name and mode                         */
/*                                                                       */
extern XuType XuCallCnv XuAxisFont (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  char      *font_name , /* c   in  Text font name                       */
  int       font_mode    /* i   in  Text font mode                       */
#endif
);
/*                                                                       */
/* font_mode: Best-fit                                                   */
#ifndef XuBEST_FIT
#define XuBEST_FIT 0
#endif
/* font_mode: Software text font mode                                    */
#ifndef XuSOFT
#define XuSOFT 1
#endif
/* font_mode: Hardware text font mode                                    */
#ifndef XuHARD
#define XuHARD 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisText - Set axis-text features                                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisText (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  char      *text      , /* c   in  Text for axis-text                   */
  double    x          , /* r   in  Text justification point X- or R-coordinate    */
  double    y          , /* r   in  Text justification point Y- or T-coordinate    */
  double    height       /* r   in  Character height (mm)                */
#endif
);
/*                                                                       */
/* x: Ignore argument                                                    */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* y: Ignore argument                                                    */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* height: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTickline - Set tickline/minor tickline attributes               */
/*                                                                       */
extern XuType XuCallCnv XuAxisTickline (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component    , /* i   in  Axis component                     */
  int       color_index  , /* i   in  Color index                        */
  double    width        , /* r   in  Linewidth (mm)                     */
  int       line_style     /* i   in  Linestyle                          */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTextSpace - Set axis-text spacing and expansion                 */
/*                                                                       */
extern XuType XuCallCnv XuAxisTextSpace (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component     , /* i   in  Axis component                    */
  int       space_mode    , /* i   in  Character spacing mode            */
  double    space_factor  , /* r   in  Character spacing factor          */
  double    expansion       /* r   in  Character expansion factor        */
#endif
);
/*                                                                       */
/* space_mode: Proportional spacing                                      */
#ifndef XuPROPORTIONAL
#define XuPROPORTIONAL 0
#endif
/* space_mode: Fixed spacing based on font width                         */
#ifndef XuFIXED_FONT
#define XuFIXED_FONT 1
#endif
/* space_mode: Proportional spacing with kerning                         */
#ifndef XuKERNED
#define XuKERNED 2
#endif
/* space_mode: Fixed spacing based on character height                   */
#ifndef XuFIXED_HEIGHT
#define XuFIXED_HEIGHT 3
#endif
/* space_factor: Ignore argument                                         */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* expansion: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTextMulti - Set axis-text multiline options                     */
/*                                                                       */
extern XuType XuCallCnv XuAxisTextMulti (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component      , /* i   in  Axis component                   */
  int       justification  , /* i   in  Multiline justification          */
  double    spacing          /* r   in  Multiline spacing factor         */
#endif
);
/*                                                                       */
/* justification: Block justified lines                                  */
#ifndef XuBLOCK
#define XuBLOCK 3
#endif
/* spacing: Ignore argument                                              */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTextPath - Set axis-text path                                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisTextPath (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  int       path         /* i   in  Text path                            */
#endif
);
/*                                                                       */
/* path: Text path from left-to-right                                    */
#ifndef XuPATH_RIGHT
#define XuPATH_RIGHT 0
#endif
/* path: Text path from right-to-left                                    */
#ifndef XuPATH_LEFT
#define XuPATH_LEFT 1
#endif
/* path: Text path from bottom-to-top                                    */
#ifndef XuPATH_UP
#define XuPATH_UP 2
#endif
/* path: Text path from top-to-bottom                                    */
#ifndef XuPATH_DOWN
#define XuPATH_DOWN 3
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTextSkew - Set axis-text skew angle                             */
/*                                                                       */
extern XuType XuCallCnv XuAxisTextSkew (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  double    angle        /* r   in  Skew angle (degrees)                 */
#endif
);
/*                                                                       */
/* angle: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisScaleUser - Set contents of user-defined scale                  */
/*                                                                       */
extern XuType XuCallCnv XuAxisScaleUser (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *tick_array        , /* ra  in  Tickmark coordinates         */
  int       num_ticks          , /* i   in  Number of tickmarks          */
  void      *minor_tick_array  , /* ra  in  Minor tickmark coordinates    */
  int       num_minor_ticks    , /* i   in  Number of minor tickmarks    */
  void      *label_array       , /* ra  in  Axis-label coordinates       */
  void      *label_value_array , /* ra  in  Axis-label values            */
  int       num_labels           /* i   in  Number of axis-labels        */
#endif
);
/*                                                                       */
/* XuAxisTimeHolidays - Set user-defined holidays                        */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeHolidays (
#if NeedFunctionPrototypes
/*                                                                       */
  int       holiday_code  , /* i   in  Set holiday code                  */
  int       *date_array   , /* ia  in  Holiday dates (\sf CCYYMMDD)      */
  int       num_dates       /* i   in  Number of dates                   */
#endif
);
/*                                                                       */
/* holiday_code: Eliminate holidays from scale                           */
#ifndef XuELIMINATE
#define XuELIMINATE 1
#endif
/* holiday_code: Add holidays to scale                                   */
#ifndef XuADD
#define XuADD 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeDisplacement - Set displacement factors                     */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeDisplacement (
#if NeedFunctionPrototypes
/*                                                                       */
  double    start  , /* r   in  Displacement of the axis start value     */
  double    end      /* r   in  Displacement of the axis end value       */
#endif
);
/*                                                                       */
/* start: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* end: Ignore argument                                                  */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimePeriods - Set user-defined periods of time of the day       */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimePeriods (
#if NeedFunctionPrototypes
/*                                                                       */
  int       period_code       , /* i   in  Set time period code          */
  int       *start_time_array , /* ia  in  Start times (\sf hhmmss)      */
  int       *end_time_array   , /* ia  in  End times (\sf hhmmss)        */
  int       num_periods         /* i   in  Number of time periods        */
#endif
);
/*                                                                       */
/* XuAxisTimeWeekends - Set weekend status                               */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeWeekends (
#if NeedFunctionPrototypes
/*                                                                       */
  int       status    /* i   in  Weekend status                          */
#endif
);
/*                                                                       */
/* status: Include Saturdays and Sundays                                 */
#ifndef XuINCLUDE_BOTH
#define XuINCLUDE_BOTH 1
#endif
/* status: Include no weekends                                           */
#ifndef XuINCLUDE_NONE
#define XuINCLUDE_NONE 2
#endif
/* status: Include only Saturdays                                        */
#ifndef XuINCLUDE_SATURDAYS
#define XuINCLUDE_SATURDAYS 3
#endif
/* status: Include only Sundays                                          */
#ifndef XuINCLUDE_SUNDAYS
#define XuINCLUDE_SUNDAYS 4
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeAxle - Set scale layout and axle attributes                 */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeAxle (
#if NeedFunctionPrototypes
/*                                                                       */
  int       scale        , /* i   in  Select scale type                  */
  int       color_index  , /* i   in  Axle color index                   */
  int       line_style   , /* i   in  Axle linestyle                     */
  double    width          /* r   in  Axle width (mm)                    */
#endif
);
/*                                                                       */
/* scale: Year, month and day of the month date scale                    */
#ifndef XuCCYYMMDD
#define XuCCYYMMDD 1
#endif
/* scale: Year, quarter, month and day of the month date scale           */
#ifndef XuCCYYQqMMDD
#define XuCCYYQqMMDD 2
#endif
/* scale: Year and day of the year date scale                            */
#ifndef XuCCYYDDD
#define XuCCYYDDD 3
#endif
/* scale: Year, week number and day number date scale                    */
#ifndef XuCCYYWwwD
#define XuCCYYWwwD 4
#endif
/* scale: Hour, minute and second time scale                             */
#ifndef Xuhhmmss
#define Xuhhmmss 5
#endif
/* scale: Year, month, day of the month, hour, minute and second scale   */
#ifndef XuCCYYMMDDhhmmss
#define XuCCYYMMDDhhmmss 6
#endif
/* scale: Year, quarter, month, day of the month, hour, minute and secon */
#ifndef XuCCYYQqMMDDhhmmss
#define XuCCYYQqMMDDhhmmss 7
#endif
/* scale: Year, day of the year, hour, minute and second scale           */
#ifndef XuCCYYDDDhhmmss
#define XuCCYYDDDhhmmss 8
#endif
/* scale: Year, week number, day number, hour, minute and secondscale    */
#ifndef XuCCYYWwwDhhmmss
#define XuCCYYWwwDhhmmss 9
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeTick - Set tickmark attributes                              */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTick (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length         , /* r   in  Tickmark length (mm)             */
  int       color_index    , /* i   in  Tickmark color index             */
  double    width          , /* r   in  Tickmark width (mm)              */
  int       justification    /* i   in  Tickmark justification           */
#endif
);
/*                                                                       */
/* length: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeDateTickLayout - Set tickmark features of combined date and */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeDateTickLayout (
#if NeedFunctionPrototypes
/*                                                                       */
  int       level     , /* i   in  Axis-label level                      */
  int       ref_date  , /* i   in  Tickmark reference date value         */
  int       ref_time  , /* i   in  Tickmark reference time value         */
  int       step        /* i   in  Tickmark step value                   */
#endif
);
/*                                                                       */
/* level: 1 Level 1                                                      */
#ifndef XuLEVEL1
#define XuLEVEL1 1
#endif
/* level: 2 Level 2                                                      */
#ifndef XuLEVEL2
#define XuLEVEL2 2
#endif
/* level: 3 Level 3                                                      */
#ifndef XuLEVEL3
#define XuLEVEL3 3
#endif
/* level: 4 Level 4                                                      */
#ifndef XuLEVEL4
#define XuLEVEL4 4
#endif
/* level: 5 Level 5                                                      */
#ifndef XuLEVEL5
#define XuLEVEL5 5
#endif
/* level: 6 Level 6                                                      */
#ifndef XuLEVEL6
#define XuLEVEL6 6
#endif
/* level: 7 Level 7                                                      */
#ifndef XuLEVEL7
#define XuLEVEL7 7
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeTickLayout - Set tickmark features                          */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTickLayout (
#if NeedFunctionPrototypes
/*                                                                       */
  int       level      , /* i   in  Axis-label level                     */
  int       reference  , /* i   in  Tickmark reference value             */
  int       step         /* i   in  Tickmark step value                  */
#endif
);
/*                                                                       */
/* XuAxisTimePolygonsDelete - Delete the date, time or combined date and */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimePolygonsDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component    /* i   in  Axis component                       */
#endif
);
/*                                                                       */
/* component: Level 1 axis-labels                                        */
#ifndef XuLABELS_LEVEL1
#define XuLABELS_LEVEL1 41
#endif
/* component: Level 2 axis-labels                                        */
#ifndef XuLABELS_LEVEL2
#define XuLABELS_LEVEL2 42
#endif
/* component: Level 3 axis-labels                                        */
#ifndef XuLABELS_LEVEL3
#define XuLABELS_LEVEL3 43
#endif
/* component: Level 4 axis-labels                                        */
#ifndef XuLABELS_LEVEL4
#define XuLABELS_LEVEL4 44
#endif
/* component: Level 5 axis-labels                                        */
#ifndef XuLABELS_LEVEL5
#define XuLABELS_LEVEL5 45
#endif
/* component: Level 6 axis-labels                                        */
#ifndef XuLABELS_LEVEL6
#define XuLABELS_LEVEL6 46
#endif
/* component: Level 7 axis-labels                                        */
#ifndef XuLABELS_LEVEL7
#define XuLABELS_LEVEL7 47
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeDrawOptions - Set draw and measure options for calender/tim */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeDrawOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component      , /* i   in  Axis component                   */
  int       draw_code      , /* i   in  Select draw status               */
  int       suppress_code    /* i   in  Suppression factor               */
#endif
);
/*                                                                       */
/* XuAxisTimesDatesToWorld - Convert combined date and time values to 2D */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimesDatesToWorld (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type   , /* i   in  Axis type                           */
  int       start_date  , /* i   in  Axis start date value               */
  int       end_date    , /* i   in  Axis end date value                 */
  int       start_time  , /* i   in  Axis start time value               */
  int       end_time    , /* i   in  Axis end time value                 */
  int       *date_array , /* ia  in  date values                         */
  int       *time_array , /* ia  in  time values                         */
  void      *x_array    , /* ra  io  X-coordinates                       */
  void      *y_array    , /* ra  io  Y-coordinates                       */
  int       num_values    /* i   in  Number of values                    */
#endif
);
/*                                                                       */
/* XuAxisTimesDatesToWorld3D - Convert combined date and time values to  */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimesDatesToWorld3D (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type         , /* i   in  Select 3D axis                */
  int       start_date        , /* i   in  Axis start date value         */
  int       end_date          , /* i   in  Axis end date value           */
  int       start_time        , /* i   in  Axis start time value         */
  int       end_time          , /* i   in  Axis end time value           */
  int       *date_array       , /* ia  in  date values                   */
  int       *time_array       , /* ia  in  time values                   */
  void      *coordinate_array , /* ra  out Coordinate values             */
  int       num_values          /* i   in  Number of values              */
#endif
);
/*                                                                       */
/* XuAxisWorldToTimesDates - Convert 2D world coordinates to combined da */
/*                                                                       */
extern XuType XuCallCnv XuAxisWorldToTimesDates (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type   , /* i   in  Axis type                           */
  int       start_date  , /* i   in  Axis start date value               */
  int       end_date    , /* i   in  Axis end date value                 */
  int       start_time  , /* i   in  Axis start time value               */
  int       end_time    , /* i   in  Axis end time value                 */
  void      *x_array    , /* ra  in  X-coordinates                       */
  void      *y_array    , /* ra  in  Y-coordinates                       */
  int       *date_array , /* ia  out Axis date values                    */
  int       *time_array , /* ia  out Axis time values                    */
  int       num_values    /* i   in  Number of values                    */
#endif
);
/*                                                                       */
/* XuAxisWorld3DToTimesDates - Convert 3D world coordinates to combined  */
/*                                                                       */
extern XuType XuCallCnv XuAxisWorld3DToTimesDates (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type         , /* i   in  Select 3D axis                */
  int       start_date        , /* i   in  Axis start date value         */
  int       end_date          , /* i   in  Axis end date value           */
  int       start_time        , /* i   in  Axis start time value         */
  int       end_time          , /* i   in  Axis end time value           */
  void      *coordinate_array , /* ra  in  Coordinate values             */
  int       *date_array       , /* ia  out Axis date values              */
  int       *time_array       , /* ia  out Axis time values              */
  int       num_values          /* i   in  Number of values              */
#endif
);
/*                                                                       */
/* XuAxisTimeDateAttributesQuery - Help for attributes of a given date a */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeDateAttributesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       date        , /* i   in  Date in ISO format                  */
  int       time        , /* i   in  Time of day in ISO format           */
  int       *attributes   /* ia  out Day attributes                      */
#endif
);
/*                                                                       */
/* XuAxisTimesDatesQuery - Help for generating combined dates and times  */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimesDatesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type   , /* i   in  Axis type                           */
  int       level       , /* i   in  Generation level                    */
  int       start_date  , /* i   in  Axis start date value               */
  int       end_date    , /* i   in  Axis end date value                 */
  int       start_time  , /* i   in  Axis start time value               */
  int       end_time    , /* i   in  Axis end time value                 */
  int       step        , /* i   in  Step value                          */
  int       *date_array , /* ia  out Date values                         */
  int       *time_array , /* ia  out Date values                         */
  int       *num_values , /* i   io  Number of values                    */
  int       *num_more     /* i   out Number of remaining values          */
#endif
);
/*                                                                       */
/* XuAxisTimeDaysToISO - Convert number of days since 1601-JAN-01 to an  */
/*                                                                       */
extern int XuCallCnv XuAxisTimeDaysToISO (
#if NeedFunctionPrototypes
/*                                                                       */
  int       days    /* i   in  Number of days since 1601-JAN-01 inclusive    */
#endif
);
/*                                                                       */
/* XuAxisTimeAttributesQuery - Help for attributes of a given day        */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeAttributesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       date        , /* i   in  Date in ISO format                  */
  int       *attributes   /* ia  out Day attributes                      */
#endif
);
/*                                                                       */
/* XuAxisTimesToWorld - Convert dates or times to 2D world coordinates   */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimesToWorld (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type   , /* i   in  Axis type                           */
  int       start       , /* i   in  Axis start value                    */
  int       end         , /* i   in  Axis end value                      */
  int       *time_array , /* ia  in  Axis values (dates/times)           */
  void      *x_array    , /* ra  io  X-coordinates                       */
  void      *y_array    , /* ra  io  Y-coordinates                       */
  int       num_values    /* i   in  Number of values                    */
#endif
);
/*                                                                       */
/* XuAxisTimeEasterQuery - Help for Easter of a given year               */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeEasterQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       year    , /* i   in  Years                                   */
  int       *easter   /* i   out Easter date in ISO format               */
#endif
);
/*                                                                       */
/* XuAxisTimeDatesQuery - Help for generating dates or times             */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeDatesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type   , /* i   in  Axis type                           */
  int       level       , /* i   in  Generation level                    */
  int       start       , /* i   in  Start value                         */
  int       end         , /* i   in  End value                           */
  int       step        , /* i   in  Step value                          */
  int       *date_array , /* ia  out Date/time values                    */
  int       *num_dates  , /* i   io  Number of values                    */
  int       *num_more     /* i   out Number of remaining values          */
#endif
);
/*                                                                       */
/* XuAxisTimesToWorld3D - Convert dates or times to 3D world coordinates */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimesToWorld3D (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type         , /* i   in  Select 3D axis                */
  int       start             , /* i   in  Axis start value              */
  int       end               , /* i   in  Axis end value                */
  int       *time_array       , /* ia  in  Axis values (dates/times)     */
  void      *coordinate_array , /* ra  out Coordinate values             */
  int       num_values          /* i   in  Number of values              */
#endif
);
/*                                                                       */
/* XuAxisWorldToTimes - Convert 2D world coordinates to dates or times   */
/*                                                                       */
extern XuType XuCallCnv XuAxisWorldToTimes (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type   , /* i   in  Axis type                           */
  int       start       , /* i   in  Axis start value                    */
  int       end         , /* i   in  Axis end value                      */
  void      *x_array    , /* ra  in  X-coordinates                       */
  void      *y_array    , /* ra  in  Y-coordinates                       */
  int       *time_array , /* ia  out Axis values (dates/times)           */
  int       num_values    /* i   in  Number of values                    */
#endif
);
/*                                                                       */
/* XuAxisWorld3DToTimes - Convert 3D world coordinates to dates or times */
/*                                                                       */
extern XuType XuCallCnv XuAxisWorld3DToTimes (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type         , /* i   in  Select 3D axis                */
  int       start             , /* i   in  Axis start value              */
  int       end               , /* i   in  Axis end value                */
  void      *coordinate_array , /* ra  in  Coordinate values             */
  int       *time_array       , /* ia  out Axis values (dates/times)     */
  int       num_values          /* i   in  Number of values              */
#endif
);
/*                                                                       */
/* XuAxisTimePolygonsNumberSize - Query the number and size of the date, */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimePolygonsNumberSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  int       *number    , /* i   out Number of bounding polygons          */
  int       *size        /* i   out Size in elements of a bounding polygons array    */
#endif
);
/*                                                                       */
/* XuAxisTimePolygonsQuery - Query the date, time or combined date and t */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimePolygonsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component         , /* i   in  Axis component                */
  int       *num_points_array , /* ia  out Number of points of polygons    */
  void      *x_array          , /* ra  out X-coordinates of points       */
  void      *y_array            /* ra  out Y-coordinates of points       */
#endif
);
/*                                                                       */
/* XuAxisTimeDateToISO - Convert a date to an ISO format                 */
/*                                                                       */
extern int XuCallCnv XuAxisTimeDateToISO (
#if NeedFunctionPrototypes
/*                                                                       */
  int       year   , /* i   in  Year number (1601--)                     */
  int       month  , /* i   in  Month number (1--12)                     */
  int       day      /* i   in  Day number (1--31)                       */
#endif
);
/*                                                                       */
/* XuAxisTimeToISO - Convert a time to an ISO format                     */
/*                                                                       */
extern int XuCallCnv XuAxisTimeToISO (
#if NeedFunctionPrototypes
/*                                                                       */
  int       hour    , /* i   in  Number of hours (0--24)                 */
  int       minute  , /* i   in  Number of minutes (0--60)               */
  int       second    /* i   in  Number of second (0--60)                */
#endif
);
/*                                                                       */
/* XuAxisTimeDraw - Draw date/time axis                                  */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type    , /* i   in  Axis type                          */
  double    cross_value  , /* r   in  Cross value for X- or Y-axle       */
  double    height       , /* r   in  Height of axis-labels (mm)         */
  int       label_mode   , /* i   in  Labelling mode                     */
  int       start        , /* i   in  Axis start value                   */
  int       end            /* i   in  Axis end value                     */
#endif
);
/*                                                                       */
/* XuAxisTimeDateDraw - Draw combined date and time axis                 */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeDateDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type    , /* i   in  Axis type                          */
  double    cross_value  , /* r   in  Cross value for X- or Y-axle       */
  double    height       , /* r   in  Height of axis-labels (mm)         */
  int       label_mode   , /* i   in  Labelling mode                     */
  int       start_date   , /* i   in  Axis start date value              */
  int       end_date     , /* i   in  Axis end date value                */
  int       start_time   , /* i   in  Axis start time value              */
  int       end_time       /* i   in  Axis end time value                */
#endif
);
/*                                                                       */
/* XuAxisTimeScale - Set date, time or combined date and time axis scale */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeScale (
#if NeedFunctionPrototypes
/*                                                                       */
  int       method    /* i   in  Select fine or coarse axis scale        */
#endif
);
/*                                                                       */
/* XuAxisTimeLabelColorWeekends - Set axis-label colors for weekends, ho */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelColorWeekends (
#if NeedFunctionPrototypes
/*                                                                       */
  int       option      , /* i   in  Option                              */
  int       line_color  , /* i   in  Line color of text                  */
  int       fill_color    /* i   in  Filled-area color of text           */
#endif
);
/*                                                                       */
/* option: Saturdays                                                     */
#ifndef XuSATURDAYS
#define XuSATURDAYS 1
#endif
/* option: Sundays                                                       */
#ifndef XuSUNDAYS
#define XuSUNDAYS 2
#endif
/* option: Holidays                                                      */
#ifndef XuHOLIDAYS
#define XuHOLIDAYS 3
#endif
/* option: Time periods                                                  */
#ifndef XuTIME_PERIODS
#define XuTIME_PERIODS 4
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeLabelNames - Set axis-label formats and names               */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelNames (
#if NeedFunctionPrototypes
/*                                                                       */
  int       time_code     , /* i   in  Set option code                   */
  void      *full_names   , /* ca  in  Full names                        */
  void      *abbr_names   , /* ca  in  Abbreviated names                 */
  int       num_names     , /* i   in  Number of names                   */
  int       mxfull_names  , /* i   in  Maximum length of text            */
  int       mxabbr_names    /* i   in  Maximum length of text            */
#endif
);
/*                                                                       */
/* time_code: Set day format and names                                   */
#ifndef XuDAY
#define XuDAY 1
#endif
/* time_code: Set week designator format and names                       */
#ifndef XuWEEK
#define XuWEEK 2
#endif
/* time_code: Set month format and names                                 */
#ifndef XuMONTH
#define XuMONTH 3
#endif
/* time_code: Set quarter designator format and names                    */
#ifndef XuQUARTER
#define XuQUARTER 4
#endif
/* time_code: Set a.m. and p.m. format and names                         */
#ifndef XuAM_PM
#define XuAM_PM 5
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeLabelFormat - Set full or abbreviated axis-label format     */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelFormat (
#if NeedFunctionPrototypes
/*                                                                       */
  int       format    /* i   in  Set format code                         */
#endif
);
/*                                                                       */
/* format: Full format                                                   */
#ifndef XuFULL
#define XuFULL 1
#endif
/* format: Abbreviated format                                            */
#ifndef XuABBREVIATED
#define XuABBREVIATED 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeLabelMonthQuarter - Set month for first quarter             */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelMonthQuarter (
#if NeedFunctionPrototypes
/*                                                                       */
  int       month    /* i   in  Set month for first quarter              */
#endif
);
/*                                                                       */
/* XuAxisTimeLabelFormatString - Set format string for multilevel axis-l */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelFormatString (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  char      *format      /* c   in  Axis-label format string             */
#endif
);
/*                                                                       */
/* XuAxisTimeLabelGap - Set gap between axis-labels and tickmarks        */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelGap (
#if NeedFunctionPrototypes
/*                                                                       */
  double    distance    /* r   in  Minimum distance between axis-label    */
#endif
);
/*                                                                       */
/* distance: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeLabelHeight - Set character height for multilevel axis-labe */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelHeight (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  double    height       /* r   in  Character height (mm)                */
#endif
);
/*                                                                       */
/* height: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeLabelPos - Set option to label tickmark intervals           */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelPos (
#if NeedFunctionPrototypes
/*                                                                       */
  int       label_code    /* i   in  Selects labelling option            */
#endif
);
/*                                                                       */
/* label_code: Label tickmarks                                           */
#ifndef XuLABEL_TICKS
#define XuLABEL_TICKS 1
#endif
/* label_code: Label tickmark intervals                                  */
#ifndef XuLABEL_INTERVALS
#define XuLABEL_INTERVALS 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeLabelSeq - Set axis-label sequence option                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeLabelSeq (
#if NeedFunctionPrototypes
/*                                                                       */
  int       seq_code    /* i   in  Select sequence option                */
#endif
);
/*                                                                       */
/* seq_code: Axis-label sequence depends on \REFER{GLIMIT} limits        */
#ifndef XuDYNAMIC
#define XuDYNAMIC 1
#endif
/* seq_code: Axis-label sequence is independent of \REFER{GLIMIT} limits */
#ifndef XuFIXED
#define XuFIXED 2
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeReset - Reset date, time and combined date and time axis ch */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeReset (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuAxisTimeMinorTick - Set minor tickmark attributes                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeMinorTick (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length         , /* r   in  Minor tickmark length (mm)       */
  int       color_index    , /* i   in  Minor tickmark color index       */
  double    width          , /* r   in  Minor tickmark width (mm)        */
  int       justification    /* i   in  Minor tickmark justification     */
#endif
);
/*                                                                       */
/* length: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeMinorTickCount - Set minor tickmark frequency               */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeMinorTickCount (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_minor    /* i   in  Minor tickmark frequency             */
#endif
);
/*                                                                       */
/* XuAxisTimeTextColor - Set axis-text attributes                        */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTextColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component   , /* i   in  Axis component                      */
  int       line_color  , /* i   in  Line color of text                  */
  int       fill_color  , /* i   in  Filled-area color of text           */
  double    boldness    , /* r   in  Character boldness factor           */
  int       hjust       , /* i   in  Horizontal justification            */
  int       vjust       , /* i   in  Vertical justification              */
  double    angle         /* r   in  Angle of text relative to axle      */
#endif
);
/*                                                                       */
/* boldness: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* angle: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeFont - Set axis-text font name and mode                     */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeFont (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  char      *font_name , /* c   in  Text font name                       */
  int       font_mode    /* i   in  Text font mode                       */
#endif
);
/*                                                                       */
/* XuAxisTimeText - Set axis-text features                               */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeText (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  char      *text      , /* c   in  Text for axis-text                   */
  double    x          , /* r   in  X-coordinate of justification point    */
  double    y          , /* r   in  Y-coordinate of justification point    */
  double    height       /* r   in  Character height (mm)                */
#endif
);
/*                                                                       */
/* x: Ignore argument                                                    */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* y: Ignore argument                                                    */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* height: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeTickline - Set tickline/minor tickline attributes           */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTickline (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component    , /* i   in  Axis component                     */
  int       color_index  , /* i   in  Line color index                   */
  double    width        , /* r   in  Linewidth (mm)                     */
  int       line_style     /* i   in  Linestyle                          */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeTextSpace - Set axis-text spacing and expansion             */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTextSpace (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component     , /* i   in  Axis component                    */
  int       space_mode    , /* i   in  Character spacing mode            */
  double    space_factor  , /* r   in  Character spacing factor          */
  double    expansion       /* r   in  Character expansion factor        */
#endif
);
/*                                                                       */
/* space_factor: Ignore argument                                         */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* expansion: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeTextMulti - Set axis-text multiline options                 */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTextMulti (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component      , /* i   in  Axis component                   */
  int       justification  , /* i   in  Multiline justification          */
  double    spacing          /* r   in  Multiline spacing factor         */
#endif
);
/*                                                                       */
/* spacing: Ignore argument                                              */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisTimeTextPath - Set axis-text path                               */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTextPath (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  int       path         /* i   in  Text path                            */
#endif
);
/*                                                                       */
/* XuAxisTimeTextSkew - Set axis-text skew angle                         */
/*                                                                       */
extern XuType XuCallCnv XuAxisTimeTextSkew (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  double    angle        /* r   in  Skew angle (degrees)                 */
#endif
);
/*                                                                       */
/* angle: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserAxle - Set axle attributes                                  */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserAxle (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index  , /* i   in  Axle color index                   */
  int       line_style   , /* i   in  Axle linestyle                     */
  double    width          /* r   in  Axle width (mm)                    */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserTick - Set tickmark attributes                              */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTick (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length         , /* r   in  Tickmark length (mm)             */
  int       color_index    , /* i   in  Tickmark color index             */
  double    width          , /* r   in  Tickmark width (mm)              */
  int       justification    /* i   in  Tickmark justification           */
#endif
);
/*                                                                       */
/* length: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserTickLayout - Set tickmark displacement factors              */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTickLayout (
#if NeedFunctionPrototypes
/*                                                                       */
  double    first  , /* r   in  Displacement of the first tickmark       */
  double    last     /* r   in  Displacement of the last tickmark        */
#endif
);
/*                                                                       */
/* first: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* last: Ignore argument                                                 */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserPolygonsDelete - Delete the user-labeled axis bounding poly */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserPolygonsDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component    /* i   in  Axis component                       */
#endif
);
/*                                                                       */
/* XuAxisUserDrawOptions - Set draw options for user-labeled axis compon */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserDrawOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component      , /* i   in  Axis component                   */
  int       draw_code      , /* i   in  Select draw status               */
  int       suppress_code    /* i   in  Suppression factor               */
#endif
);
/*                                                                       */
/* XuAxisUserPolygonsNumberSize - Query the number and size of the user- */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserPolygonsNumberSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  int       *number    , /* i   out Number of bounding polygons          */
  int       *size        /* i   out Size in elements of a bounding polygons array    */
#endif
);
/*                                                                       */
/* XuAxisUserPolygonsQuery - Query the user-labeled axis component bound */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserPolygonsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component         , /* i   in  Axis component                */
  int       *num_points_array , /* ia  out Number of points of polygons    */
  void      *x_array          , /* ra  out X-coordinates of points       */
  void      *y_array            /* ra  out Y-coordinates of points       */
#endif
);
/*                                                                       */
/* XuAxisUserDraw - Draw a user-labeled axis                             */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type     , /* i   in  Axis type                         */
  double    cross_value   , /* r   in  Cross value for X- or Y-axis      */
  double    height        , /* r   in  Height of axis-labels (mm)        */
  int       label_mode    , /* i   in  Labelling mode                    */
  void      *text_array   , /* ca  in  Series of axis-labels             */
  int       num_labels    , /* i   in  Total number of                   */
  int       mxtext_array    /* i   in  Maximum length of                 */
#endif
);
/*                                                                       */
/* XuAxisUserScaleUserDraw - Draw a user-labeled axis with a user-define */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserScaleUserDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       axis_type    , /* i   in  Axis type                          */
  double    cross_value  , /* r   in  Cross value for X- or Y-axis       */
  double    height       , /* r   in  Height of axis-labels (mm)         */
  int       label_mode     /* i   in  Labelling mode                     */
#endif
);
/*                                                                       */
/* XuAxisUserLabelColors - Set axis-label colors                         */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserLabelColors (
#if NeedFunctionPrototypes
/*                                                                       */
  int       label_min        , /* i   in  The I'th axis-label            */
  int       label_max        , /* i   in  The J'th axis-label            */
  int       *color_min_array , /* ia  in  Color indices                  */
  int       *color_max_array , /* ia  in  Color indices                  */
  int       *color_mid_array   /* ia  in  Color indices                  */
#endif
);
/*                                                                       */
/* XuAxisUserLabelGap - Set gap between axis-labels and tickmarks        */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserLabelGap (
#if NeedFunctionPrototypes
/*                                                                       */
  double    distance    /* r   in  Minimum distance between axis-label    */
#endif
);
/*                                                                       */
/* distance: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserLabelFit - Set iteration for height of axis-labels          */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserLabelFit (
#if NeedFunctionPrototypes
/*                                                                       */
  int       iteration_code    /* i   in  Select iteration option         */
#endif
);
/*                                                                       */
/* iteration_code: The height of axis-labels is fixed                    */
#ifndef XuFIXED_LABEL_HEIGHT
#define XuFIXED_LABEL_HEIGHT 0
#endif
/* iteration_code: The height of axis-labels is adjusted so that no      */
#ifndef XuFITTED_LABEL_HEIGHT
#define XuFITTED_LABEL_HEIGHT 1
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserLabelPos - Set option to label tickmark intervals           */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserLabelPos (
#if NeedFunctionPrototypes
/*                                                                       */
  int       label_code    /* i   in  Selects labelling option            */
#endif
);
/*                                                                       */
/* XuAxisUserLabelSeq - Set axis-label sequence option                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserLabelSeq (
#if NeedFunctionPrototypes
/*                                                                       */
  int       seq_code    /* i   in  Select sequence option                */
#endif
);
/*                                                                       */
/* XuAxisUserReset - Reset user-labeled axis characteristics             */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserReset (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuAxisUserMinorTick - Set minor tickmark attributes                   */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserMinorTick (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length         , /* r   in  Minor tickmark length (mm)       */
  int       color_index    , /* i   in  Minor tickmark color index       */
  double    width          , /* r   in  Minor tickmark width (mm)        */
  int       justification    /* i   in  Minor tickmark justification     */
#endif
);
/*                                                                       */
/* length: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserMinorTickCount - Set minor tickmark frequency               */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserMinorTickCount (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_minor    /* i   in  Minor tickmark frequency             */
#endif
);
/*                                                                       */
/* XuAxisUserTextColor - Set axis-label and axis-text attributes         */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTextColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component   , /* i   in  Axis component                      */
  int       line_color  , /* i   in  Line color of text                  */
  int       fill_color  , /* i   in  Filled-area color of text           */
  double    boldness    , /* r   in  Character boldness factor           */
  int       hjust       , /* i   in  Horizontal justification            */
  int       vjust       , /* i   in  Vertical justification              */
  double    angle         /* r   in  Angle of text relative to axle      */
#endif
);
/*                                                                       */
/* boldness: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* angle: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserFont - Set axis-text font name and font mode                */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserFont (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  char      *font_name , /* c   in  Text font name                       */
  int       font_mode    /* i   in  Text font mode                       */
#endif
);
/*                                                                       */
/* XuAxisUserText - Set axis-text features                               */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserText (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  char      *text      , /* c   in  Text for axis-text                   */
  double    x          , /* r   in  X-coordinate of justification point    */
  double    y          , /* r   in  Y-coordinate of justification point    */
  double    height       /* r   in  Character height (mm)                */
#endif
);
/*                                                                       */
/* x: Ignore argument                                                    */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* y: Ignore argument                                                    */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* height: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserTickline - Set tickline/minor tickline attributes           */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTickline (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component    , /* i   in  Axis component                     */
  int       color_index  , /* i   in  Line color index                   */
  double    width        , /* r   in  Linewidth (mm)                     */
  int       line_style     /* i   in  Linestyle                          */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserTextSpace - Set axis-text spacing and expansion             */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTextSpace (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component     , /* i   in  Axis component                    */
  int       space_mode    , /* i   in  Character spacing mode            */
  double    space_factor  , /* r   in  Character spacing factor          */
  double    expansion       /* r   in  Character expansion factor        */
#endif
);
/*                                                                       */
/* space_factor: Ignore argument                                         */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* expansion: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserTextMulti - Set axis-text multiline options                 */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTextMulti (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component      , /* i   in  Axis component                   */
  int       justification  , /* i   in  Multiline justification          */
  double    spacing          /* r   in  Multiline spacing factor         */
#endif
);
/*                                                                       */
/* spacing: Ignore argument                                              */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserTextPath - Set axis-text path                               */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTextPath (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  int       path         /* i   in  Text path                            */
#endif
);
/*                                                                       */
/* XuAxisUserTextSkew - Set axis-text skew angle                         */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserTextSkew (
#if NeedFunctionPrototypes
/*                                                                       */
  int       component  , /* i   in  Axis component                       */
  double    angle        /* r   in  Skew angle (degrees)                 */
#endif
);
/*                                                                       */
/* angle: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuAxisUserScaleUser - Set contents of user-defined scale              */
/*                                                                       */
extern XuType XuCallCnv XuAxisUserScaleUser (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *tick_array       , /* ra  in  Tickmark coordinates          */
  int       num_ticks         , /* i   in  Number of tickmarks           */
  void      *minor_tick_array , /* ra  in  Minor tickmark coordinates    */
  int       num_minor_ticks   , /* i   in  Number of minor tickmarks     */
  void      *label_array      , /* ra  in  Axis-label coordinates        */
  void      *label_text_array , /* ca  in  Series of axis-labels         */
  int       num_labels        , /* i   in  Total number of               */
  int       mxtext_array        /* i   in  Maximum length of             */
#endif
);

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agxaxi_h */
