/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under CVS/RCS control in:
//      $Id: //depot/express/fcs70/include/agx/agxcha.h#1 $
//
// UNIRAS function declarations for CHA
//--------------------------------------------------------------------*/

#ifndef _agxcha_h
#define _agxcha_h

#ifndef _agx64_h
#ifndef _agx32_h
#include <agX/agx32.h>
#endif
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif
/*                                                                       */
/* XuBarsLabelBox - Set bar label box                                    */
/*                                                                       */
extern XuType XuCallCnv XuBarsLabelBox (
#if NeedFunctionPrototypes
/*                                                                       */
  int       draw_code    , /* i   in  Toggle drawing of label box        */
  int       fill_color   , /* i   in  Box fill color index               */
  int       frame_color  , /* i   in  Box frame color index              */
  double    frame_width    /* r   in  Box frame width (mm)               */
#endif
);
/*                                                                       */
/* draw_code: Label box off                                              */
#ifndef XuOFF
#define XuOFF 0
#endif
/* draw_code: Label box on (default)                                     */
#ifndef XuON
#define XuON 1
#endif
/* fill_color: Ignore argument                                           */
#ifndef XuI_IGNORE
#define XuI_IGNORE 9999
#endif
/* frame_width: Ignore argument                                          */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuBarsLabelOptions - Set bar label text features                      */
/*                                                                       */
extern XuType XuCallCnv XuBarsLabelOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       position_code  , /* i   in  Label position                   */
  int       value_code     , /* i   in  Label value (content) code       */
  double    height         , /* r   in  Label text height (mm)           */
  int       num_decimal      /* i   in  Number of decimals               */
#endif
);
/*                                                                       */
/* position_code: Inside the bar at the top (default)                    */
#ifndef XuINSIDE_TOP
#define XuINSIDE_TOP 0
#endif
/* position_code: Inside the bar at the center                           */
#ifndef XuINSIDE_CENTER
#define XuINSIDE_CENTER 1
#endif
/* position_code: Inside the bar at the bottom                           */
#ifndef XuINSIDE_BOTTOM
#define XuINSIDE_BOTTOM 2
#endif
/* position_code: Outside the bar at the top                             */
#ifndef XuOUTSIDE_TOP
#define XuOUTSIDE_TOP 3
#endif
/* position_code: Outside the bar at the top, rotated                    */
#ifndef XuOUTSIDE_ROTATED
#define XuOUTSIDE_ROTATED 4
#endif
/* value_code: The end value (default)                                   */
#ifndef XuENDVALUE
#define XuENDVALUE 0
#endif
/* value_code: The difference between start and end values plus          */
#ifndef XuDIFF_AND_END
#define XuDIFF_AND_END 1
#endif
/* value_code: The difference between start and end values               */
#ifndef XuDIFF
#define XuDIFF 2
#endif
/* value_code: The start value                                           */
#ifndef XuSTARTVALUE
#define XuSTARTVALUE 3
#endif
/* value_code: 10 to the power of the end value                          */
#ifndef XuEND_10
#define XuEND_10 4
#endif
/* value_code: 10 to the power of the difference between                 */
#ifndef XuDIFF_AND_TOP_10
#define XuDIFF_AND_TOP_10 5
#endif
/* value_code: 10 to the power of the difference between                 */
#ifndef XuDIFF_10
#define XuDIFF_10 6
#endif
/* value_code: 10 to the power of the start value                        */
#ifndef XuSTART_10
#define XuSTART_10 7
#endif
/* height: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuBarsDraw - Draw bar chart                                           */
/*                                                                       */
extern XuType XuCallCnv XuBarsDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *y_start_array , /* ra  in  Start Y-values                   */
  void      *y_end_array   , /* ra  in  End Y-values                     */
  int       num_bars       , /* i   in  Number of Y-values               */
  double    offset           /* r   in  Offset factor                    */
#endif
);
/*                                                                       */
/* XuBars3DDraw - Draw 3D bar chart                                      */
/*                                                                       */
extern XuType XuCallCnv XuBars3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    z_start      , /* r   in  Start value ($Z = constant$)       */
  void      *z_end_array , /* ra  in  End Z-values                       */
  int       num_y_bars   , /* i   in  Number of bars in Y-direction      */
  int       num_x_bars   , /* i   in  Number of bars in X-direction      */
  int       num_bar_seg    /* i   in  Number of segment in each bar      */
#endif
);
/*                                                                       */
/* XuBarsIrr3DDraw - Draw 3D irregular bar chart                         */
/*                                                                       */
extern XuType XuCallCnv XuBarsIrr3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    z_start      , /* r   in  Start value (Z $= constant$)       */
  void      *x_array     , /* ra  in  X-coordinates for 3D-bar centers    */
  void      *y_array     , /* ra  in  Y-coordinates for 3D-bar centers    */
  void      *z_array     , /* ra  in  End Z-values                       */
  int       num_bar_seg  , /* i   in  Number of stacked bars             */
  int       num_bars       /* i   in  Number of bars                     */
#endif
);
/*                                                                       */
/* XuBarLinesDraw - Draw bar lines                                       */
/*                                                                       */
extern XuType XuCallCnv XuBarLinesDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *y_start_array , /* ra  in  Start Y-values                   */
  void      *y_end_array   , /* ra  in  End Y-values                     */
  int       num_bars       , /* i   in  Number of Y-values               */
  double    offset           /* r   in  Offset factor to control bar placement    */
#endif
);
/*                                                                       */
/* XuBarsVariableWidthDraw - Draw variable width bar chart               */
/*                                                                       */
extern XuType XuCallCnv XuBarsVariableWidthDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *y_start_array  , /* ra  in  Start Y-values                  */
  void      *y_end_array    , /* ra  in  End Y-values                    */
  void      *relative_width , /* ra  in  Relative bar width values       */
  int       num_bars        , /* i   in  Number of Y and bar width values    */
  double    offset            /* r   in  Offset factor                   */
#endif
);
/*                                                                       */
/* XuChartBottom3DDraw - Fill 3D bottom plane                            */
/*                                                                       */
extern XuType XuCallCnv XuChartBottom3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Color index of X,Y plane           */
#endif
);
/*                                                                       */
/* XuBarsFrame - Set bar-frame attributes                                */
/*                                                                       */
extern XuType XuCallCnv XuBarsFrame (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width        , /* r   in  Frame width (mm)                   */
  int       color_index    /* i   in  Frame color index                  */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuBarsShadow - Set 3D shadow                                          */
/*                                                                       */
extern XuType XuCallCnv XuBarsShadow (
#if NeedFunctionPrototypes
/*                                                                       */
  int       code    /* i   in  Draw shadow                               */
#endif
);
/*                                                                       */
/* XuChartBackground3DDraw - Draw 3D background                          */
/*                                                                       */
extern XuType XuCallCnv XuChartBackground3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       wall_code    , /* i   in  Wall drawing code                  */
  int       color_index    /* i   in  Background color index             */
#endif
);
/*                                                                       */
/* wall_code: 3D walls are automatically selected                        */
#ifndef XuAUTO
#define XuAUTO 0
#endif
/* wall_code: The wall at X min                                          */
#ifndef XuX_MIN
#define XuX_MIN 1
#endif
/* wall_code: The wall at X max                                          */
#ifndef XuX_MAX
#define XuX_MAX 2
#endif
/* wall_code: The wall at Y min                                          */
#ifndef XuY_MIN
#define XuY_MIN 3
#endif
/* wall_code: The wall at Y max                                          */
#ifndef XuY_MAX
#define XuY_MAX 4
#endif
/*                                                                       */
/*                                                                       */
/* XuBarsWidth - Set relative bar width                                  */
/*                                                                       */
extern XuType XuCallCnv XuBarsWidth (
#if NeedFunctionPrototypes
/*                                                                       */
  double    relative_width    /* r   in  Relative bar width              */
#endif
);
/*                                                                       */
/* XuBars3DWidth - Set 3D bar width                                      */
/*                                                                       */
extern XuType XuCallCnv XuBars3DWidth (
#if NeedFunctionPrototypes
/*                                                                       */
  double    relative_width    /* r   in  Relative bar width              */
#endif
);
/*                                                                       */
/* XuBarsWidthAbsolute - Set absolute bar width                          */
/*                                                                       */
extern XuType XuCallCnv XuBarsWidthAbsolute (
#if NeedFunctionPrototypes
/*                                                                       */
  double    absolute_width    /* r   in  Absolute bar width in world units    */
#endif
);
/*                                                                       */
/* XuChartPolygonsDataIntQuery - Query the chart component integer data  */
/*                                                                       */
extern XuType XuCallCnv XuChartPolygonsDataIntQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       chart_component  , /* i   in  Chart component                */
  int       *num_int_array   , /* ia  out Number of integer data of polygons    */
  int       *int_array         /* ia  out Integer data                   */
#endif
);
/*                                                                       */
/* chart_component: Curve                                                */
#ifndef XuCURVE
#define XuCURVE 1
#endif
/* chart_component: Scatter                                              */
#ifndef XuSCATTER
#define XuSCATTER 2
#endif
/* chart_component: Bars                                                 */
#ifndef XuBARS
#define XuBARS 3
#endif
/* chart_component: Line bars                                            */
#ifndef XuLINE_BARS
#define XuLINE_BARS 6
#endif
/* chart_component: Fill area curve                                      */
#ifndef XuAREA
#define XuAREA 7
#endif
/* chart_component: Staircase curve                                      */
#ifndef XuSTAIRCASE_CURVE
#define XuSTAIRCASE_CURVE 8
#endif
/* chart_component: Fill area between staircase curves                   */
#ifndef XuSTAIRCASE_AREA
#define XuSTAIRCASE_AREA 9
#endif
/* chart_component: Pie sectors                                          */
#ifndef XuPIE_SECTORS
#define XuPIE_SECTORS 10
#endif
/* chart_component: 3D curve                                             */
#ifndef XuCURVE_3D
#define XuCURVE_3D 101
#endif
/* chart_component: 3D scatter                                           */
#ifndef XuSCATTER_3D
#define XuSCATTER_3D 102
#endif
/* chart_component: 3D regular bars                                      */
#ifndef XuREGULAR_BARS_3D
#define XuREGULAR_BARS_3D 103
#endif
/* chart_component: 3D irregular bars                                    */
#ifndef XuIRREGULAR_BARS_3D
#define XuIRREGULAR_BARS_3D 104
#endif
/*                                                                       */
/*                                                                       */
/* XuChartPolygonsDataFloatQuery - Query the chart component floating po */
/*                                                                       */
extern XuType XuCallCnv XuChartPolygonsDataFloatQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       chart_component  , /* i   in  Chart component                */
  int       *num_float_array , /* ia  out Number of floating point data of polygons    */
  void      *float_array       /* ra  out Floating point data            */
#endif
);
/*                                                                       */
/* XuChartPolygonsDataSize - Query the size of the chart component data  */
/*                                                                       */
extern XuType XuCallCnv XuChartPolygonsDataSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       chart_component  , /* i   in  Chart component                */
  int       *number          , /* i   out Number of bounding polygons    */
  int       *size_int        , /* i   out Size in elements of an integer data array    */
  int       *size_float        /* i   out Size in elements of a floating point data array    */
#endif
);
/*                                                                       */
/* XuChartPolygonsDelete - Delete the chart component bounding polygons  */
/*                                                                       */
extern XuType XuCallCnv XuChartPolygonsDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       chart_component    /* i   in  Chart component                */
#endif
);
/*                                                                       */
/* chart_component: All chart components                                 */
#ifndef XuALL
#define XuALL 0
#endif
/* chart_component: Bar label boxes                                      */
#ifndef XuBAR_LABEL_BOXES
#define XuBAR_LABEL_BOXES 4
#endif
/* chart_component: Bar labels                                           */
#ifndef XuBAR_LABELS
#define XuBAR_LABELS 5
#endif
/* chart_component: Pie arrows                                           */
#ifndef XuPIE_ARROW
#define XuPIE_ARROW 11
#endif
/* chart_component: Pie label boxes                                      */
#ifndef XuPIE_LABEL_BOXES
#define XuPIE_LABEL_BOXES 12
#endif
/* chart_component: Pie labels                                           */
#ifndef XuPIE_LABELS
#define XuPIE_LABELS 13
#endif
/* chart_component: Pie heading                                          */
#ifndef XuPIE_HEADING
#define XuPIE_HEADING 14
#endif
/* chart_component: Reference lines                                      */
#ifndef XuREFERENCE_LINES
#define XuREFERENCE_LINES 15
#endif
/* chart_component: Legend box                                           */
#ifndef XuCHART_LEGEND_BOX
#define XuCHART_LEGEND_BOX 16
#endif
/* chart_component: Legend heading                                       */
#ifndef XuCHART_LEGEND_HEADING
#define XuCHART_LEGEND_HEADING 17
#endif
/* chart_component: Legend texts                                         */
#ifndef XuCHART_LEGEND_TEXTS
#define XuCHART_LEGEND_TEXTS 18
#endif
/* chart_component: Legend items                                         */
#ifndef XuCHART_LEGEND_ITEMS
#define XuCHART_LEGEND_ITEMS 19
#endif
/* chart_component: 3D arrows                                            */
#ifndef XuARROWS_3D
#define XuARROWS_3D 105
#endif
/* chart_component: 3D background                                        */
#ifndef XuBACKGROUND_3D
#define XuBACKGROUND_3D 106
#endif
/* chart_component: 3D baseplane                                         */
#ifndef XuBASEPLANE_3D
#define XuBASEPLANE_3D 107
#endif
/*                                                                       */
/*                                                                       */
/* XuChartDrawOptions - Set draw, measure and probe options for all char */
/*                                                                       */
extern XuType XuCallCnv XuChartDrawOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       draw_code    /* i   in  Select draw status                   */
#endif
);
/*                                                                       */
/* draw_code: Measure                                                    */
#ifndef XuMEASURE
#define XuMEASURE 2
#endif
/* draw_code: Draw and measure                                           */
#ifndef XuON_MEASURE
#define XuON_MEASURE 3
#endif
/* draw_code: Probe integer and floating point data                      */
#ifndef XuPROBE
#define XuPROBE 4
#endif
/* draw_code: Draw and probe integer and floating point data             */
#ifndef XuON_PROBE
#define XuON_PROBE 5
#endif
/* draw_code: Probe integer data                                         */
#ifndef XuPROBE_INT
#define XuPROBE_INT 6
#endif
/* draw_code: Draw and probe integer data                                */
#ifndef XuON_PROBE_INT
#define XuON_PROBE_INT 7
#endif
/* draw_code: Probe floating point data                                  */
#ifndef XuPROBE_FLOAT
#define XuPROBE_FLOAT 8
#endif
/* draw_code: Draw and probe floating point data                         */
#ifndef XuON_PROBE_FLOAT
#define XuON_PROBE_FLOAT 9
#endif
/*                                                                       */
/*                                                                       */
/* XuChartPolygonsQuery - Query the chart component bounding polygons    */
/*                                                                       */
extern XuType XuCallCnv XuChartPolygonsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       chart_component   , /* i   in  Chart component               */
  int       *num_points_array , /* ia  out Number of points of polygons    */
  void      *x_array          , /* ra  out X-coordinates of points       */
  void      *y_array            /* ra  out Y-coordinates of points       */
#endif
);
/*                                                                       */
/* XuChartPolygonsNumberSize - Query the number and size of the chart co */
/*                                                                       */
extern XuType XuCallCnv XuChartPolygonsNumberSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       chart_component  , /* i   in  Chart component                */
  int       *number          , /* i   out Number of bounding polygons    */
  int       *size              /* i   out Size in elements of a bounding polygons array    */
#endif
);
/*                                                                       */
/* XuChartXDataReg - Set regular X-data                                  */
/*                                                                       */
extern XuType XuCallCnv XuChartXDataReg (
#if NeedFunctionPrototypes
/*                                                                       */
  int       dir_code  , /* i   in  Chart layout direction                */
  int       num_x     , /* i   in  Number of regular points              */
  double    grace       /* r   in  Grace clearance                       */
#endif
);
/*                                                                       */
/* dir_code: Horizontal X-axis (default).                                */
#ifndef XuHORIZONTAL
#define XuHORIZONTAL 1
#endif
/* dir_code: Vertical X-axis                                             */
#ifndef XuVERTICAL
#define XuVERTICAL 2
#endif
/*                                                                       */
/*                                                                       */
/* XuChartXDataGet - Get current X-data                                  */
/*                                                                       */
extern XuType XuCallCnv XuChartXDataGet (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array , /* ra  out Defined X-values                       */
  int       *num_x     /* i   io  Number of values                       */
#endif
);
/*                                                                       */
/* XuChartXDataIrr - Set irregular X-data                                */
/*                                                                       */
extern XuType XuCallCnv XuChartXDataIrr (
#if NeedFunctionPrototypes
/*                                                                       */
  int       dir_code  , /* i   in  Chart layout direction                */
  void      *x_array  , /* ra  in  Irregular X-values                    */
  int       num_x       /* i   in  Number of irregular points            */
#endif
);
/*                                                                       */
/* XuChartXDataClip - Set irregular X-data clipping mode                 */
/*                                                                       */
extern XuType XuCallCnv XuChartXDataClip (
#if NeedFunctionPrototypes
/*                                                                       */
  int       clip_mode    /* i   in  Clip mode                            */
#endif
);
/*                                                                       */
/* XuChartFillColor - Set fill color                                     */
/*                                                                       */
extern XuType XuCallCnv XuChartFillColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_index_arr , /* ia  in  Fill color indices             */
  int       num_colors         /* i   in  Number of colors               */
#endif
);
/*                                                                       */
/* XuChartPolynomialFitCalc - Calculate polynomial fitting               */
/*                                                                       */
extern XuType XuCallCnv XuChartPolynomialFitCalc (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array      , /* ra  in  Input X-values                    */
  void      *y_array      , /* ra  in  Input Y-values                    */
  int       num_points    , /* i   in  Number of input points            */
  void      *y_result     , /* ra  out Output Y-values                   */
  int       num_y_result  , /* i   in  Number of output points           */
  int       degree          /* i   in  Polynomial degree                 */
#endif
);
/*                                                                       */
/* XuChartXDataRegInsert - Insert regular points in irregular data       */
/*                                                                       */
extern XuType XuCallCnv XuChartXDataRegInsert (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array      , /* ra  in  Irregular X-data array            */
  int       num_x         , /* i   in  Number of values in x_array       */
  int       num_insert    , /* i   in  Number of regular points to insert    */
  void      *x_result     , /* ra  out New X-data                        */
  int       *num_x_result   /* i   out Number of values in x_result      */
#endif
);
/*                                                                       */
/* XuChartSpline2DCalc - Interpolation with 2D spline                    */
/*                                                                       */
extern XuType XuCallCnv XuChartSpline2DCalc (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array      , /* ra  in  Input X-values                    */
  void      *y_array      , /* ra  in  Input Y-values                    */
  int       num_points    , /* i   in  Number of input points            */
  void      *y_result     , /* ra  out Output Y-values                   */
  int       num_y_result  , /* i   in  Number of output points           */
  double    tension       , /* r   in  Tension factor                    */
  int       end_code        /* i   in  Curve-end option                  */
#endif
);
/*                                                                       */
/* end_code: Different tangents in end points                            */
#ifndef XuDISCONTINUOUS
#define XuDISCONTINUOUS 0
#endif
/* end_code: Force common tangent in colliding end points                */
#ifndef XuCONTINUOUS
#define XuCONTINUOUS 1
#endif
/*                                                                       */
/*                                                                       */
/* XuChartSplineCalc - Interpolation with spline                         */
/*                                                                       */
extern XuType XuCallCnv XuChartSplineCalc (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array      , /* ra  in  Input X-values                    */
  void      *y_array      , /* ra  in  Input Y-values                    */
  int       num_points    , /* i   in  Number of input points            */
  void      *y_result     , /* ra  out Output Y-values                   */
  int       num_y_result  , /* i   in  Number of output points           */
  double    tension         /* r   in  Tension factor                    */
#endif
);
/*                                                                       */
/* XuChartLineColor - Set line color                                     */
/*                                                                       */
extern XuType XuCallCnv XuChartLineColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Line color index                   */
#endif
);
/*                                                                       */
/* XuChartLineStyle - Set linestyle                                      */
/*                                                                       */
extern XuType XuCallCnv XuChartLineStyle (
#if NeedFunctionPrototypes
/*                                                                       */
  int       line_style    /* i   in  Linestyle                           */
#endif
);
/*                                                                       */
/* XuCurveFillDraw - Draw fill area curve chart                          */
/*                                                                       */
extern XuType XuCallCnv XuCurveFillDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *y_start_array , /* ra  in  Start Y-value array              */
  void      *y_end_array   , /* ra  in  End Y-value array                */
  int       num_points     , /* i   in  Number of Y-values               */
  int       draw_code      , /* i   in  Draw code                        */
  int       extrap_code      /* i   in  Extrapolations at ends code      */
#endif
);
/*                                                                       */
/* draw_code: Shade from constant \PP{y_start_array}[0]                  */
#ifndef XuFROM_BASE
#define XuFROM_BASE 0
#endif
/* draw_code: Shade between curves \PP{y_start_array}[num_points]        */
#ifndef XuBETWEEN
#define XuBETWEEN 1
#endif
/* draw_code: Shade from curve \PP{y_start_array}[num_points]            */
#ifndef XuTO_BASE
#define XuTO_BASE 2
#endif
/* extrap_code: Stop curve at end points                                 */
#ifndef XuCUT
#define XuCUT 0
#endif
/* extrap_code: Extrapolate curve to world coordinate limits and through */
#ifndef XuEXTRAPOLATE
#define XuEXTRAPOLATE 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCurve3DDraw - Draw 3D curve                                         */
/*                                                                       */
extern XuType XuCallCnv XuCurve3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  in  X-coordinates                       */
  void      *y_array    , /* ra  in  Y-coordinates                       */
  void      *z_array    , /* ra  in  Z-coordinates                       */
  int       num_points  , /* i   in  Number of points                    */
  int       undef_code    /* i   in  Ignore ``undefined'' points         */
#endif
);
/*                                                                       */
/* XuCurveDraw - Draw curve chart                                        */
/*                                                                       */
extern XuType XuCallCnv XuCurveDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *y_array     , /* ra  in  Y-value array                      */
  int       num_y        , /* i   in  Number of Y-values defining the curve    */
  int       extrap_code  , /* i   in  Extrapolations at ends code        */
  int       undef_code     /* i   in  Ignore ``undefined'' points        */
#endif
);
/*                                                                       */
/* XuLog10Calc - Calculate common 10 based logarithm                     */
/*                                                                       */
extern XuType XuCallCnv XuLog10Calc (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *input_array  , /* ra  in  Input array                       */
  void      *result_array , /* ra  out Output array                      */
  int       num_values      /* i   in  Number of values                  */
#endif
);
/*                                                                       */
/* XuChartLineWidth - Set linewidth                                      */
/*                                                                       */
extern XuType XuCallCnv XuChartLineWidth (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width    /* r   in  Linewidth (mm)                           */
#endif
);
/*                                                                       */
/* XuScatterSymbolBold - Set marker symbol boldness                      */
/*                                                                       */
extern XuType XuCallCnv XuScatterSymbolBold (
#if NeedFunctionPrototypes
/*                                                                       */
  double    boldness    /* r   in  Symbol boldness                       */
#endif
);
/*                                                                       */
/* XuScatterSymbolColor - Set marker symbol color                        */
/*                                                                       */
extern XuType XuCallCnv XuScatterSymbolColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Symbol color index                 */
#endif
);
/*                                                                       */
/* XuChartXDataMerge - Merge X-data sets                                 */
/*                                                                       */
extern XuType XuCallCnv XuChartXDataMerge (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_1_array      , /* ra  in  Input X1-values                 */
  int       num_x_1         , /* i   in  Number of X1-values             */
  void      *x_2_array      , /* ra  in  Input X2-values                 */
  int       num_x_2         , /* i   in  Number of X2-values             */
  void      *x_result_array , /* ra  out Merged X-values (total)         */
  int       *num_results      /* i   out Number of merged X-values       */
#endif
);
/*                                                                       */
/* XuChartUndefInterval - Set undefined intervals                        */
/*                                                                       */
extern XuType XuCallCnv XuChartUndefInterval (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_start_array , /* ra  in  Start positions of intervals     */
  void      *x_end_array   , /* ra  in  End positions of intervals       */
  int       num_intervals    /* i   in  Number of undefined intervals    */
#endif
);
/*                                                                       */
/* XuPieAngle - Set pie starting angle                                   */
/*                                                                       */
extern XuType XuCallCnv XuPieAngle (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle_start  , /* r   in  Starting angle (degrees)           */
  double    angle_size     /* r   in  Size of a full pie (degrees)       */
#endif
);
/*                                                                       */
/* XuPieLabelBox - Set pie label box attributes                          */
/*                                                                       */
extern XuType XuCallCnv XuPieLabelBox (
#if NeedFunctionPrototypes
/*                                                                       */
  int       box_code     , /* i   in  Label box on/off                   */
  int       fill_color   , /* i   in  Label box fill color               */
  int       frame_color  , /* i   in  Label box frame color              */
  double    frame_width    /* r   in  Label box frame width (mm)         */
#endif
);
/*                                                                       */
/* frame_width: Ignore argument                                          */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuPieLabelOptions - Set pie label options                             */
/*                                                                       */
extern XuType XuCallCnv XuPieLabelOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       position_code  , /* i   in  Label box position code          */
  int       content_code   , /* i   in  Label box content code           */
  double    height         , /* r   in  Label height (mm)                */
  int       num_decimal    , /* i   in  Number of decimals in data values    */
  void      *text          , /* ca  in  String array holding text labels    */
  int       num_labels     , /* i   in  Number of labels                 */
  int       mxtext           /* i   in  Maximum length of labels in text    */
#endif
);
/*                                                                       */
/* position_code: Same as above, but the labels which go outside the     */
#ifndef XuALIGNED
#define XuALIGNED 1
#endif
/* position_code: All labels are forced inside their sector              */
#ifndef XuINSIDE_SECTOR
#define XuINSIDE_SECTOR 2
#endif
/* position_code: All labels are on a circle outside the pie             */
#ifndef XuOUTSIDE_PIE
#define XuOUTSIDE_PIE 3
#endif
/* position_code: All labels are vertically aligned outside the pie      */
#ifndef XuOUTSIDE_ALIGNED
#define XuOUTSIDE_ALIGNED 4
#endif
/* content_code: Text labels are drawn only                              */
#ifndef XuTEXT_ONLY
#define XuTEXT_ONLY 0
#endif
/* content_code: Text labels and percentages are drawn                   */
#ifndef XuTEXT_PCT
#define XuTEXT_PCT 1
#endif
/* content_code: Text labels and data values are drawn                   */
#ifndef XuTEXT_VALUE
#define XuTEXT_VALUE 2
#endif
/* content_code: The text label, the data value and the                  */
#ifndef XuTEXT_VALUE_PCT
#define XuTEXT_VALUE_PCT 3
#endif
/* content_code: The text label, the percent value and the               */
#ifndef XuTEXT_PCT_VALUE
#define XuTEXT_PCT_VALUE 4
#endif
/*                                                                       */
/*                                                                       */
/* XuPieLabelPreSuffix - Set pie label text pre and suffix string        */
/*                                                                       */
extern XuType XuCallCnv XuPieLabelPreSuffix (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *pretext         , /* c   in  Text label in front of data value    */
  char      *posttext          /* c   in  Text label placed behind data value    */
#endif
);
/*                                                                       */
/* XuPieLabelArrow - Set pie arrow attributes                            */
/*                                                                       */
extern XuType XuCallCnv XuPieLabelArrow (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width         , /* r   in  Arrow width (mm)                  */
  int       color         , /* i   in  Arrowhead color index             */
  int       shaft_color   , /* i   in  Shaft color index                 */
  int       head_code     , /* i   in  Arrowhead style                   */
  double    length_scale  , /* r   in  Arrowhead longitudinal scaling    */
  double    width_scale     /* r   in  Arrowhead transversal scaling     */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* head_code: The pie arrows have solid heads (default)                  */
#ifndef XuSOLID_HEAD
#define XuSOLID_HEAD 1
#endif
/* head_code: The pie arrows have barbed heads                           */
#ifndef XuBARBED_HEAD
#define XuBARBED_HEAD 2
#endif
/* head_code: The pie arrows have stick heads with no back               */
#ifndef XuSTICK_HEAD
#define XuSTICK_HEAD 3
#endif
/* head_code: The pie arrows have hollow arrow head                      */
#ifndef XuHOLLOW_HEAD
#define XuHOLLOW_HEAD 4
#endif
/* head_code: The pie arrow have very small arrow head                   */
#ifndef XuSMALL_HEAD
#define XuSMALL_HEAD 5
#endif
/* length_scale: Ignore argument                                         */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* width_scale: Ignore argument                                          */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuPieLabelUserBox - Set user-defined pie label boxes                  */
/*                                                                       */
extern XuType XuCallCnv XuPieLabelUserBox (
#if NeedFunctionPrototypes
/*                                                                       */
  int       position_code  , /* i   in  Label box position code          */
  int       num_boxes      , /* i   in  Label box specification          */
  double    height         , /* r   in  Box-heights (mm)                 */
  double    width            /* r   in  Box-lengths (mm)                 */
#endif
);
/*                                                                       */
/* XuPieFrame - Set pie frame attributes                                 */
/*                                                                       */
extern XuType XuCallCnv XuPieFrame (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width        , /* r   in  Frame width (mm)                   */
  int       color_index    /* i   in  Frame color index                  */
#endif
);
/*                                                                       */
/* XuPieDraw - Draw pie chart                                            */
/*                                                                       */
extern XuType XuCallCnv XuPieDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *sector_array , /* ra  in  Array holding data values for pie    */
  int       num_sectors   , /* i   in  Number of sectors in the pie      */
  double    x             , /* r   in  X-coordinate for center of pie chart    */
  double    y             , /* r   in  Y-coordinate for center of pie chart    */
  double    radius        , /* r   in  Radius of pie (mm)                */
  char      *string       , /* c   in  Single string holding pie title    */
  double    height          /* r   in  Text height of string (mm)        */
#endif
);
/*                                                                       */
/* XuPieLabelJustification - Set pie label justification                 */
/*                                                                       */
extern XuType XuCallCnv XuPieLabelJustification (
#if NeedFunctionPrototypes
/*                                                                       */
  int       justify    /* i   in  Justification code                     */
#endif
);
/*                                                                       */
/* justify: Left adjust text inside label box                            */
#ifndef XuLEFT
#define XuLEFT 0
#endif
/* justify: Center adjust text inside label box (default)                */
#ifndef XuCENTER
#define XuCENTER 1
#endif
/* justify: Right adjust text inside label box                           */
#ifndef XuRIGHT
#define XuRIGHT 2
#endif
/*                                                                       */
/*                                                                       */
/* XuChartLegendDraw - Draw chart legend                                 */
/*                                                                       */
extern XuType XuCallCnv XuChartLegendDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x           , /* r   in  X-position of legend box            */
  double    y           , /* r   in  Y-position of legend box            */
  void      *text       , /* ca  in  String array holding text labels    */
  int       num_labels  , /* i   in  Number of labels                    */
  int       mxtext      , /* i   in  Maximum length of labels in         */
  double    height        /* r   in  Height of characters (mm)           */
#endif
);
/*                                                                       */
/* XuScatter3DDraw - Draw 3D scatter chart                               */
/*                                                                       */
extern XuType XuCallCnv XuScatter3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *symbol_array , /* ia  in  Symbol id numbers                 */
  int       num_symbols   , /* i   in  Number of symbols                 */
  void      *x_array      , /* ra  in  X-coordinates                     */
  void      *y_array      , /* ra  in  Y-coordinates                     */
  void      *z_array      , /* ra  in  Z-coordinates                     */
  int       num_points    , /* i   in  Number of points                  */
  double    height        , /* r   in  Symbol height (mm)                */
  int       density         /* i   in  Symbol density                    */
#endif
);
/*                                                                       */
/* XuScatterDraw - Draw scatter chart                                    */
/*                                                                       */
extern XuType XuCallCnv XuScatterDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *symbol_array , /* ia  in  Symbol id numbers                 */
  int       num_symbols   , /* i   in  Number of symbols                 */
  void      *y_array      , /* ra  in  Y-values for marker symbols       */
  int       num_y         , /* i   in  Number of points                  */
  double    height        , /* r   in  Symbol height (mm)                */
  int       density         /* i   in  Symbol density                    */
#endif
);
/*                                                                       */
/* XuChartRefLinesDraw - Draw reference lines                            */
/*                                                                       */
extern XuType XuCallCnv XuChartRefLinesDraw (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuPieLabelUserBoxQuery - Return user-defined pie label boxes          */
/*                                                                       */
extern XuType XuCallCnv XuPieLabelUserBoxQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  out X-coordinates for label boxes       */
  void      *y_array    , /* ra  out Y-coordinates for label boxes       */
  int       *num_points   /* i   out Number of returned boxes            */
#endif
);
/*                                                                       */
/* XuPieOffset - Set offset for exploded pie chart                       */
/*                                                                       */
extern XuType XuCallCnv XuPieOffset (
#if NeedFunctionPrototypes
/*                                                                       */
  double    distance    /* r   in  Sector offset from pie center (mm)    */
#endif
);
/*                                                                       */
/* XuChartDrawOptionsQuery - Query draw status of all charts             */
/*                                                                       */
extern XuType XuCallCnv XuChartDrawOptionsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *draw_code   /* i   out Draw status                          */
#endif
);
/*                                                                       */
/* XuChartQuadFillColor - Set fill color in each quadrant                */
/*                                                                       */
extern XuType XuCallCnv XuChartQuadFillColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_array_q1 , /* ia  in  Fill color indices in quadrant 1    */
  int       *color_array_q2 , /* ia  in  Fill color indices in quadrant 2    */
  int       *color_array_q3 , /* ia  in  Fill color indices in quadrant 3    */
  int       *color_array_q4 , /* ia  in  Fill color indices in quadrant 4    */
  int       num_colors        /* i   in  Number of color indices         */
#endif
);
/*                                                                       */
/* XuChartQuadLineColor - Set line color in each quadrant                */
/*                                                                       */
extern XuType XuCallCnv XuChartQuadLineColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       line_color_q1  , /* i   in  Line color index in quadrant 1    */
  int       line_color_q2  , /* i   in  Line color index in quadrant 2    */
  int       line_color_q3  , /* i   in  Line color index in quadrant 3    */
  int       line_color_q4    /* i   in  Line color index in quadrant 4    */
#endif
);
/*                                                                       */
/* XuChartQuadLineStyle - Set linestyle in each quadrant                 */
/*                                                                       */
extern XuType XuCallCnv XuChartQuadLineStyle (
#if NeedFunctionPrototypes
/*                                                                       */
  int       line_style_q1  , /* i   in  Linestyle in quadrant 1          */
  int       line_style_q2  , /* i   in  Linestyle in quadrant 2          */
  int       line_style_q3  , /* i   in  Linestyle in quadrant 3          */
  int       line_style_q4    /* i   in  Linestyle in quadrant 4          */
#endif
);
/*                                                                       */
/* XuChartQuadLineWidth - Set linewidth in each quadrant                 */
/*                                                                       */
extern XuType XuCallCnv XuChartQuadLineWidth (
#if NeedFunctionPrototypes
/*                                                                       */
  double    line_width_q1  , /* r   in  Linewidth in quadrant 1 (mm)     */
  double    line_width_q2  , /* r   in  Linewidth in quadrant 2 (mm)     */
  double    line_width_q3  , /* r   in  Linewidth in quadrant 3 (mm)     */
  double    line_width_q4    /* r   in  Linewidth in quadrant 4 (mm)     */
#endif
);
/*                                                                       */
/* XuScatterQuadSymbolBold - Set symbol boldness in each quadrant        */
/*                                                                       */
extern XuType XuCallCnv XuScatterQuadSymbolBold (
#if NeedFunctionPrototypes
/*                                                                       */
  double    boldness_q1  , /* r   in  Symbol boldness in quadrant 1      */
  double    boldness_q2  , /* r   in  Symbol boldness in quadrant 2      */
  double    boldness_q3  , /* r   in  Symbol boldness in quadrant 3      */
  double    boldness_q4    /* r   in  Symbol boldness in quadrant 4      */
#endif
);
/*                                                                       */
/* XuScatterQuadSymbolColor - Set symbol color in each quadrant          */
/*                                                                       */
extern XuType XuCallCnv XuScatterQuadSymbolColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       symbol_color_q1  , /* i   in  Symbol color in quadrant 1     */
  int       symbol_color_q2  , /* i   in  Symbol color in quadrant 2     */
  int       symbol_color_q3  , /* i   in  Symbol color in quadrant 3     */
  int       symbol_color_q4    /* i   in  Symbol color in quadrant 4     */
#endif
);
/*                                                                       */
/* XuChartReset - Reset facility                                         */
/*                                                                       */
extern XuType XuCallCnv XuChartReset (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuCurveFillSteppedDraw - Draw fill area between staircase curves      */
/*                                                                       */
extern XuType XuCallCnv XuCurveFillSteppedDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *y_start_array , /* ra  in  Start Y-value array              */
  void      *y_end_array   , /* ra  in  End Y-value array                */
  int       num_y          , /* i   in  Number of Y-values               */
  int       draw_code      , /* i   in  Draw code                        */
  double    shift_factor     /* r   in  Shift factor                     */
#endif
);
/*                                                                       */
/* XuCurveSteppedDraw - Draw staircase curve chart                       */
/*                                                                       */
extern XuType XuCallCnv XuCurveSteppedDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *y_array      , /* ra  in  Y-value array                     */
  int       num_y         , /* i   in  Number of Y-values defining the curve    */
  double    shift_factor  , /* r   in  Shift factor                      */
  int       undef_code      /* i   in  Ignore ``undefined'' points       */
#endif
);
/*                                                                       */
/* XuChartLegendBox - Set legend box options                             */
/*                                                                       */
extern XuType XuCallCnv XuChartLegendBox (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_items    , /* i   in  Number of sub-legends              */
  int       num_columns  , /* i   in  Number of columns                  */
  int       origin_code  , /* i   in  Origin of legend box               */
  int       color        , /* i   in  Background color index             */
  double    frame_width  , /* r   in  Frame width (mm)                   */
  int       frame_color    /* i   in  Frame color index                  */
#endif
);
/*                                                                       */
/* origin_code: Lower left corner (default)                              */
#ifndef XuLOWER_LEFT
#define XuLOWER_LEFT 0
#endif
/* origin_code: Lower right corner                                       */
#ifndef XuLOWER_RIGHT
#define XuLOWER_RIGHT 1
#endif
/* origin_code: Upper left corner                                        */
#ifndef XuUPPER_LEFT
#define XuUPPER_LEFT 2
#endif
/* origin_code: Upper right corner                                       */
#ifndef XuUPPER_RIGHT
#define XuUPPER_RIGHT 3
#endif
/* frame_width: Ignore argument                                          */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuChartLegendOptions - Set legend options                             */
/*                                                                       */
extern XuType XuCallCnv XuChartLegendOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width     , /* r   in  Linewidth (mm)                        */
  double    boldness    /* r   in  Marker boldness                       */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* boldness: Ignore argument                                             */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuChartLegendEntry - Set legend entry                                 */
/*                                                                       */
extern XuType XuCallCnv XuChartLegendEntry (
#if NeedFunctionPrototypes
/*                                                                       */
  int       entry_code    /* i   in  Legend entry sign                   */
#endif
);
/*                                                                       */
/* XuChartLegendItemLength - Set length scaling factor of all chart lege */
/*                                                                       */
extern XuType XuCallCnv XuChartLegendItemLength (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length_scale    /* r   in  Length scaling factor             */
#endif
);
/*                                                                       */
/* XuChartSplineSmoothCalc - Smoothing with spline                       */
/*                                                                       */
extern XuType XuCallCnv XuChartSplineSmoothCalc (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array        , /* ra  in  Input X-values                  */
  void      *y_array        , /* ra  in  Input Y-values                  */
  int       num_points      , /* i   in  Number of input points          */
  void      *y_result_array , /* ra  out Output Y-values                 */
  int       num_results     , /* i   in  Number of output points         */
  int       factor            /* i   in  Smoothing factor                */
#endif
);
/*                                                                       */
/* XuChartQuadRefValues - Set reference values for quadrants             */
/*                                                                       */
extern XuType XuCallCnv XuChartQuadRefValues (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x  , /* r   in  Reference value in X-direction               */
  double    y    /* r   in  Reference value in Y-direction               */
#endif
);
/*                                                                       */
/* XuChartArrow3DDraw - Draw 3D arrow chart                              */
/*                                                                       */
extern XuType XuCallCnv XuChartArrow3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x           , /* r   in  Common X-start point                */
  double    y           , /* r   in  Common Y-start point                */
  double    z           , /* r   in  Common Z-start point                */
  void      *x_array    , /* ra  in  X-coordinates                       */
  void      *y_array    , /* ra  in  Y-coordinates                       */
  void      *z_array    , /* ra  in  Z-coordinates                       */
  int       num_points  , /* i   in  Number of points                    */
  int       density       /* i   in  Vector density                      */
#endif
);

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agxcha_h */
