/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under CVS/RCS control in:
//      $Id: //depot/express/fcs70/include/agx/agxcpl.h#1 $
//
// UNIRAS function declarations for CPL
//--------------------------------------------------------------------*/

#ifndef _agxcpl_h
#define _agxcpl_h

#ifndef _agx64_h
#ifndef _agx32_h
#include <agX/agx32.h>
#endif
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif
/*                                                                       */
/* XuContourUserDraw - Draw 2D transformed shaded contour map            */
/*                                                                       */
extern XuType XuCallCnv XuContourUserDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array , /* ra  in  X-coordinates of grid corners          */
  void      *y_array , /* ra  in  Y-coordinates of grid corners          */
  void      *v_array , /* ra  in  Shading values in the grid corners     */
  int       num_y    , /* i   in  Y dimension of arrays                  */
  int       num_x      /* i   in  X dimension of arrays                  */
#endif
);
/*                                                                       */
/* XuIsolineUserDraw - Draw 2D transformed isoline map                   */
/*                                                                       */
extern XuType XuCallCnv XuIsolineUserDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array , /* ra  in  X-coordinates of grid corners          */
  void      *y_array , /* ra  in  Y-coordinates of grid corners          */
  void      *v_array , /* ra  in  Shading values in the grid corners     */
  int       num_y    , /* i   in  Y dimension of arrays                  */
  int       num_x      /* i   in  X dimension of arrays                  */
#endif
);
/*                                                                       */
/* XuIsolineMinLength - Set isoline minimum length                       */
/*                                                                       */
extern XuType XuCallCnv XuIsolineMinLength (
#if NeedFunctionPrototypes
/*                                                                       */
  double    min_length    /* r   in  Minimum isoline length (mm)         */
#endif
);
/*                                                                       */
/* XuIsolineSplineSmoothing - Activate contour smoothing                 */
/*                                                                       */
extern XuType XuCallCnv XuIsolineSplineSmoothing (
#if NeedFunctionPrototypes
/*                                                                       */
  double    factor    /* r   in  Smoothing factor, must be less than or equal to 10.0    */
#endif
);
/*                                                                       */
/* XuFaultDraw - Draw fault lines                                        */
/*                                                                       */
extern XuType XuCallCnv XuFaultDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width        , /* r   in  Width of the fault lines           */
  int       color_index  , /* i   in  Color index of the fault lines     */
  int       line_style     /* i   in  Linestyle of the fault lines       */
#endif
);
/*                                                                       */
/* XuFaultColor - Set color of fault undefined area                      */
/*                                                                       */
extern XuType XuCallCnv XuFaultColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Color code                         */
#endif
);
/*                                                                       */
/* color_index: Hollow fault area                                        */
#ifndef XuHOLLOW
#define XuHOLLOW 9999
#endif
/*                                                                       */
/*                                                                       */
/* XuFaultCreate - Create fault line                                     */
/*                                                                       */
extern XuType XuCallCnv XuFaultCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array      , /* ra  in  X-coordinates for fault line      */
  void      *y_array      , /* ra  in  Y-coordinates for fault line      */
  int       num_points    , /* i   in  Number of coordinate pairs        */
  int       contour_code    /* i   in  Contouring option for grid faulted cells    */
#endif
);
/*                                                                       */
/* x_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/* y_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/* contour_code: Grid cells hit by a fault line are not contoured        */
#ifndef XuOFF
#define XuOFF 0
#endif
/* contour_code: Grid cells hit by a fault line are contoured            */
#ifndef XuON
#define XuON 1
#endif
/*                                                                       */
/*                                                                       */
/* XuIsolinePriority - Set isoline drawing priority                      */
/*                                                                       */
extern XuType XuCallCnv XuIsolinePriority (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *priority_array , /* ia  in  Contour level priorities        */
  int       num_priorities    /* i   in  Number of priorities            */
#endif
);
/*                                                                       */
/* XuIsolineFeathering - Activate feathering                             */
/*                                                                       */
extern XuType XuCallCnv XuIsolineFeathering (
#if NeedFunctionPrototypes
/*                                                                       */
  double    min_distance  , /* r   in  Minimum distance between isolines (mm)    */
  double    min_length      /* r   in  Minimum length of feathered isoline (mm)    */
#endif
);
/*                                                                       */
/* XuRegionCreate - Create region from irregular data points             */
/*                                                                       */
extern XuType XuCallCnv XuRegionCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  in  X-coordinates of irregular data points    */
  void      *y_array    , /* ra  in  Y-coordinates of irregular data points    */
  int       num_points  , /* i   in  Number of data points               */
  int       *region_id    /* i   out Region identification code          */
#endif
);
/*                                                                       */
/* XuRegionDelete - Delete region                                        */
/*                                                                       */
extern XuType XuCallCnv XuRegionDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       region_id    /* i   in  Region identification code           */
#endif
);
/*                                                                       */
/* region_id: All regions                                                */
#ifndef XuALL
#define XuALL 0
#endif
/*                                                                       */
/*                                                                       */
/* XuRegionDraw - Draw region outline                                    */
/*                                                                       */
extern XuType XuCallCnv XuRegionDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       region_id         , /* i   in  Region identification code    */
  int       fillcolor         , /* i   in  Fill color index              */
  double    frame_width       , /* r   in  Frame width                   */
  int       frame_color       , /* i   in  Frame color index             */
  int       frame_line_style    /* i   in  Frame linestyle               */
#endif
);
/*                                                                       */
/* XuRegionChange - Set or change region                                 */
/*                                                                       */
extern XuType XuCallCnv XuRegionChange (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  in  X-coordinates of region border      */
  void      *y_array    , /* ra  in  Y-coordinates of region border      */
  int       num_points  , /* i   in  Number of coordinates               */
  int       *region_id    /* i   io  Region identification code          */
#endif
);
/*                                                                       */
/* x_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/* y_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuRegionCalculate - Perform region set calculation                    */
/*                                                                       */
extern XuType XuCallCnv XuRegionCalculate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       id_first   , /* i   in  First region identification code     */
  int       id_second  , /* i   in  Second region identification code    */
  int       op_code    , /* i   in  Operation type                       */
  int       *id_result   /* i   out Identification code for created region    */
#endif
);
/*                                                                       */
/* op_code: Union set: region~1+region~2                                 */
#ifndef XuUNION
#define XuUNION 1
#endif
/* op_code: Intersection set: region~1\&region~2                         */
#ifndef XuINTERSECTION
#define XuINTERSECTION 2
#endif
/* op_code: Difference set: region~1$\backslash$region~2                 */
#ifndef XuDIFFERENCE
#define XuDIFFERENCE 3
#endif
/* op_code: Difference set: region~2$\backslash$region~1                 */
#ifndef XuDIFFERENCE_REV
#define XuDIFFERENCE_REV 4
#endif
/* op_code: Complementary set: $-$region~1                               */
#ifndef XuCOMPLEMENT
#define XuCOMPLEMENT 5
#endif
/* op_code: Complementary set: $-$region~2                               */
#ifndef XuCOMPLEMENT_REV
#define XuCOMPLEMENT_REV 6
#endif
/* id_result: Resulting region is empty                                  */
#ifndef XuEMPTY_REGION
#define XuEMPTY_REGION -1
#endif
/*                                                                       */
/*                                                                       */
/* XuRegionStatusQuery - Query region attributes                         */
/*                                                                       */
extern XuType XuCallCnv XuRegionStatusQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       region_id    , /* i   in  Region identification code         */
  int       *num_points  , /* i   out Number of coordinate points        */
  int       *active_code , /* i   out Active/Passive code                */
  int       *inout_code    /* i   out Inside/Outside code                */
#endif
);
/*                                                                       */
/* active_code: Passive                                                  */
#ifndef XuPASSIVE
#define XuPASSIVE -1
#endif
/* active_code: Active                                                   */
#ifndef XuACTIVE
#define XuACTIVE 1
#endif
/* inout_code: Outside                                                   */
#ifndef XuOUTSIDE
#define XuOUTSIDE -1
#endif
/* inout_code: Inside                                                    */
#ifndef XuINSIDE
#define XuINSIDE 1
#endif
/*                                                                       */
/*                                                                       */
/* XuRegionCoordinateQuery - Retrieve region coordinates                 */
/*                                                                       */
extern XuType XuCallCnv XuRegionCoordinateQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       region_id  , /* i   in  Region identification code           */
  int       start      , /* i   in  Start index in region coordinate array    */
  int       end        , /* i   in  End index in region coordinate array    */
  void      *x_array   , /* ra  out X-coordinates of region              */
  void      *y_array     /* ra  out Y-coordinates of region              */
#endif
);
/*                                                                       */
/* XuRegionIdQuery - Retrieve region identification                      */
/*                                                                       */
extern XuType XuCallCnv XuRegionIdQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       region_number  , /* i   in  Region number                    */
  int       *region_id       /* i   out Region identification code       */
#endif
);
/*                                                                       */
/* XuRegionCountQuery - Retrieve number of regions                       */
/*                                                                       */
extern XuType XuCallCnv XuRegionCountQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *num_regions   /* i   out Number of existing regions         */
#endif
);
/*                                                                       */
/* XuRegionCreateSweepRadius - Set absolute sweep vector radius          */
/*                                                                       */
extern XuType XuCallCnv XuRegionCreateSweepRadius (
#if NeedFunctionPrototypes
/*                                                                       */
  int       x_radius  , /* i   in  X-axis radius                         */
  int       y_radius    /* i   in  Y-axis radius                         */
#endif
);
/*                                                                       */
/* XuRegionCreateSweepAngle - Set sweep vector scan angle                */
/*                                                                       */
extern XuType XuCallCnv XuRegionCreateSweepAngle (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle    /* r   in  Maximum sweep angle                      */
#endif
);
/*                                                                       */
/* XuRegionOrientation - Set region orientation                          */
/*                                                                       */
extern XuType XuCallCnv XuRegionOrientation (
#if NeedFunctionPrototypes
/*                                                                       */
  int       region_id   , /* i   in  Region identification code          */
  int       inout_code    /* i   in  Inside/Outside code                 */
#endif
);
/*                                                                       */
/* XuRegionBorder - Set region border Draw code                          */
/*                                                                       */
extern XuType XuCallCnv XuRegionBorder (
#if NeedFunctionPrototypes
/*                                                                       */
  int       draw_code    /* i   in  Region border draw code              */
#endif
);
/*                                                                       */
/* draw_code: No contours in grid cells with region borders              */
#ifndef XuSKIP
#define XuSKIP 0
#endif
/* draw_code: Contour up to the region border                            */
#ifndef XuCONTOUR
#define XuCONTOUR 1
#endif
/*                                                                       */
/*                                                                       */
/* XuRegionCreateSweepFactor - Set relative sweep vector radius          */
/*                                                                       */
extern XuType XuCallCnv XuRegionCreateSweepFactor (
#if NeedFunctionPrototypes
/*                                                                       */
  double    factor    /* r   in  Relative sweep vector radius            */
#endif
);
/*                                                                       */
/* XuRegionState - Set region state                                      */
/*                                                                       */
extern XuType XuCallCnv XuRegionState (
#if NeedFunctionPrototypes
/*                                                                       */
  int       region_id    , /* i   in  Region identification code         */
  int       active_code    /* i   in  Active/Passive code                */
#endif
);
/*                                                                       */
/* XuVariableGridNodesCreate - Create grid net                           */
/*                                                                       */
extern XuType XuCallCnv XuVariableGridNodesCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array , /* ra  in  X-axis positions for grid nodes        */
  int       num_x    , /* i   in  Number of X-axis nodes                 */
  void      *y_array , /* ra  in  Y-axis positions for grid nodes        */
  int       num_y    , /* i   in  Number of Y-axis nodes                 */
  void      *z_array , /* ra  in  Z-axis positions for grid nodes        */
  int       num_z      /* i   in  Number of Z-axis nodes                 */
#endif
);
/*                                                                       */
/* XuVariableGridNodesOption - Set grid definition option                */
/*                                                                       */
extern XuType XuCallCnv XuVariableGridNodesOption (
#if NeedFunctionPrototypes
/*                                                                       */
  int       code    /* i   in  Grid definition option                    */
#endif
);
/*                                                                       */
/* code: Delete user grids                                               */
#ifndef XuGRID_DELETE
#define XuGRID_DELETE 0
#endif
/* code: Define interpolation output grid or mapping input grid          */
#ifndef XuGRID_IN
#define XuGRID_IN 1
#endif
/* code: Define interpolation input grid for \REFER{GINTPR}              */
#ifndef XuGRID_OUT
#define XuGRID_OUT 2
#endif
/*                                                                       */
/*                                                                       */
/* XuWellSymbolDraw - Draw well symbol                                   */
/*                                                                       */
extern XuType XuCallCnv XuWellSymbolDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       symbol_number  , /* i   in  Well symbol number               */
  double    x              , /* r   in  X coordinate of symbol center    */
  double    y              , /* r   in  Y coordinate of symbol center    */
  double    height         , /* r   in  Height of symbol (mm)            */
  double    boldness       , /* r   in  Symbol boldness factor           */
  int       color_index      /* i   in  Color index of symbol drawn      */
#endif
);

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agxcpl_h */
