/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under CVS/RCS control in:
//      $Id: //depot/express/fcs70/include/agx/agxgra.h#1 $
//
// UNIRAS function declarations for GRA
//--------------------------------------------------------------------*/

#ifndef _agxgra_h
#define _agxgra_h

#ifndef _agx64_h
#ifndef _agx32_h
#include <agX/agx32.h>
#endif
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif
/*                                                                       */
/* XuViewWorkboxToMM - Transform box units to millimeter units           */
/*                                                                       */
extern double XuCallCnv XuViewWorkboxToMM (
#if NeedFunctionPrototypes
/*                                                                       */
  double    scalar    /* r   in  Height or length value (box)            */
#endif
);
/*                                                                       */
/* XuCGMGenMetafileDescriptorGet - Return metafile descriptor values     */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenMetafileDescriptorGet (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *metafile_descrip , /* c   out Metafile description string    */
  int       max_length        , /* i   in  Maximum length of string      */
  int       *vdc_type         , /* i   out VDC type                      */
  int       *integer_prec     , /* i   out Integer precision             */
  XuFloat   *real_prec        , /* r   out Real precision                */
  int       *index_prec       , /* i   out Index precision               */
  int       *color_prec       , /* i   out Color precision               */
  int       *color_index_prec , /* i   out Color index precision         */
  int       *max_color_index  , /* i   out Maximum color index           */
  int       *color_value_ext    /* ia  out Colour value extent           */
#endif
);
/*                                                                       */
/* vdc_type: Integer VDC                                                 */
#ifndef XuINTEGER
#define XuINTEGER 0
#endif
/* vdc_type: Real VDC                                                    */
#ifndef XuREAL
#define XuREAL 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMGenPictureDescriptorGet - Return picture descriptor and control  */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenPictureDescriptorGet (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *scale_mode      , /* i   out Scaling mode                   */
  XuFloat   *scale_factor    , /* r   out Scale factor                   */
  int       *color_sel_mode  , /* i   out Colour selection mode          */
  int       *line_width_spec , /* i   out Line width specification mode    */
  int       *mark_size_spec  , /* i   out Marker size specification mode    */
  int       *edge_width_spec , /* i   out Edge width specification mode    */
  void      *vdc_extent      , /* ra  out VDC extent                     */
  int       *vdc_int_prec    , /* i   out VDC integer precision          */
  XuFloat   *vdc_real_prec     /* r   out VDC real precision             */
#endif
);
/*                                                                       */
/* scale_mode: Abstract scaling                                          */
#ifndef XuABSTRACT
#define XuABSTRACT 0
#endif
/* scale_mode: Metric scaling                                            */
#ifndef XuMETRIC
#define XuMETRIC 1
#endif
/* color_sel_mode: Indexed mode                                          */
#ifndef XuINDEXED_MODE
#define XuINDEXED_MODE 0
#endif
/* color_sel_mode: Direct RGB mode                                       */
#ifndef XuDIRECT_MODE
#define XuDIRECT_MODE 1
#endif
/* line_width_spec: Absolute mode                                        */
#ifndef XuABSOLUTE
#define XuABSOLUTE 0
#endif
/* line_width_spec: Scaled mode                                          */
#ifndef XuSCALED
#define XuSCALED 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMGenMetafileClose - Closes a CGM                                  */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenMetafileClose (
#if NeedFunctionPrototypes
/*                                                                       */
  int       metafile_id    /* i   in  Identifier for reference to file    */
#endif
);
/*                                                                       */
/* XuCGMGenMetafileCreate - Create a CGM and write metafile descriptor   */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenMetafileCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *metafile_id   , /* i   out Identifier for reference to file    */
  int       encoding       , /* i   in  Encoding type for metafile       */
  char      *file_name     , /* c   in  Name of physical file            */
  char      *metafile_name   /* c   in  Metafile name parameter of BEGMF    */
#endif
);
/*                                                                       */
/* encoding: Encoding from profile                                       */
#ifndef XuCGMPROF
#define XuCGMPROF 0
#endif
/* encoding: Character encoding                                          */
#ifndef XuCHARACTER
#define XuCHARACTER 2
#endif
/* encoding: Binary encoding                                             */
#ifndef XuBINARY
#define XuBINARY 3
#endif
/* encoding: Clear Text encoding                                         */
#ifndef XuCLEAR
#define XuCLEAR 4
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMGenPictureClose - Closes a CGM Picture                           */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenPictureClose (
#if NeedFunctionPrototypes
/*                                                                       */
  int       metafile_id    /* i   in  Identifier for reference to file    */
#endif
);
/*                                                                       */
/* XuCGMGenPictureOpen - Open a CGM Picture and write the Picture Descri */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenPictureOpen (
#if NeedFunctionPrototypes
/*                                                                       */
  int       metafile_id   , /* i   in  Identifier for reference to file    */
  char      *picture_name   /* c   in  Picture name parameter of BEGP    */
#endif
);
/*                                                                       */
/* XuCGMGenProfileInitialize - Initialize generator profile system       */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenProfileInitialize (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *profile_name , /* c   in  Generator profile file            */
  int       *error_state    /* i   out Error status                      */
#endif
);
/*                                                                       */
/* XuCGMGenMetafileDescriptor - Sets metafile descriptor values to be wr */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenMetafileDescriptor (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *metafile_descrip , /* c   in  Metafile description string    */
  int       vdc_type          , /* i   in  VDC type                      */
  int       integer_prec      , /* i   in  Integer precision             */
  double    real_prec         , /* r   in  Real precision                */
  int       index_prec        , /* i   in  Index precision               */
  int       color_prec        , /* i   in  Color precision               */
  int       color_index_prec  , /* i   in  Color index precision         */
  int       max_color_index   , /* i   in  Maximum color index           */
  int       *color_value_ext    /* ia  in  Colour value extent           */
#endif
);
/*                                                                       */
/* XuCGMGenPictureDescriptor - Sets picture descriptor and control value */
/*                                                                       */
extern XuType XuCallCnv XuCGMGenPictureDescriptor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       scale_mode       , /* i   in  Scaling mode                   */
  double    scale_factor     , /* r   in  Scale factor                   */
  int       color_sel_mode   , /* i   in  Colour selection mode          */
  int       line_width_spec  , /* i   in  Line width specification mode    */
  int       mark_size_spec   , /* i   in  Marker size specification mode    */
  int       edge_width_spec  , /* i   in  Edge width specification mode    */
  void      *vdc_extent      , /* ra  in  VDC extent                     */
  int       vdc_int_prec     , /* i   in  VDC integer precision          */
  double    vdc_real_prec      /* r   in  VDC real precision             */
#endif
);
/*                                                                       */
/* XuClassToColor - Transform class number to color index                */
/*                                                                       */
extern int XuCallCnv XuClassToColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       class_num    /* i   in  Class number                         */
#endif
);
/*                                                                       */
/* XuContextDeviceCreate - Create a device context                       */
/*                                                                       */
extern XuType XuCallCnv XuContextDeviceCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *context_id   /* i   out Device context identifier           */
#endif
);
/*                                                                       */
/* XuContextDeviceDelete - Delete a device context                       */
/*                                                                       */
extern XuType XuCallCnv XuContextDeviceDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       context_id    /* i   in  Device context identifier           */
#endif
);
/*                                                                       */
/* XuContextDeviceSelect - Select a device context                       */
/*                                                                       */
extern XuType XuCallCnv XuContextDeviceSelect (
#if NeedFunctionPrototypes
/*                                                                       */
  int       context_id    /* i   in  Device context identifier           */
#endif
);
/*                                                                       */
/* XuContextDeviceQuery - Query the current device context               */
/*                                                                       */
extern XuType XuCallCnv XuContextDeviceQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *context_id   /* i   out Device context identifier           */
#endif
);
/*                                                                       */
/* XuViewAngle - Tilt image                                              */
/*                                                                       */
extern XuType XuCallCnv XuViewAngle (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle    /* r   in  Amount of tilt (degrees)                 */
#endif
);
/*                                                                       */
/* XuArrowScale - Set arrowhead scaling                                  */
/*                                                                       */
extern XuType XuCallCnv XuArrowScale (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length_scale  , /* r   in  Length scaling factor             */
  double    width_scale     /* r   in  Width scaling factor              */
#endif
);
/*                                                                       */
/* XuArrowDraw - Draw arrow                                              */
/*                                                                       */
extern XuType XuCallCnv XuArrowDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    xhead        , /* r   in  Head X-coordinate                  */
  double    yhead        , /* r   in  Head Y-coordinate                  */
  int       head_code    , /* i   in  Head option                        */
  double    xtail        , /* r   in  Tail X-coordinate                  */
  double    ytail        , /* r   in  Tail Y-coordinate                  */
  int       tail_code    , /* i   in  Tail option (See head_code)        */
  int       head_color   , /* i   in  Color of head and tail             */
  int       shaft_color  , /* i   in  Color of shaft                     */
  double    width          /* r   in  Width of shaft (mm)                */
#endif
);
/*                                                                       */
/* head_code: No arrowhead                                               */
#ifndef XuOFF
#define XuOFF 0
#endif
/* head_code: Solid arrowhead                                            */
#ifndef XuSOLID_HEAD
#define XuSOLID_HEAD 1
#endif
/* head_code: Barbed arrowhead                                           */
#ifndef XuBARBED_HEAD
#define XuBARBED_HEAD 2
#endif
/* head_code: Stick arrowhead                                            */
#ifndef XuSTICK_HEAD
#define XuSTICK_HEAD 3
#endif
/* head_code: Hollow arrowhead                                           */
#ifndef XuHOLLOW_HEAD
#define XuHOLLOW_HEAD 4
#endif
/* head_code: Very small arrowhead                                       */
#ifndef XuSMALL_HEAD
#define XuSMALL_HEAD 5
#endif
/* head_code: Solid reversed arrowhead                                   */
#ifndef XuSOLID_HEAD_REV
#define XuSOLID_HEAD_REV -1
#endif
/* head_code: Barbed reversed arrowhead                                  */
#ifndef XuBARBED_HEAD_REV
#define XuBARBED_HEAD_REV -2
#endif
/* head_code: Stick reversed arrowhead                                   */
#ifndef XuSTICK_HEAD_REV
#define XuSTICK_HEAD_REV -3
#endif
/* head_code: Hollow reversed arrowhead                                  */
#ifndef XuHOLLOW_HEAD_REV
#define XuHOLLOW_HEAD_REV -4
#endif
/* head_code: Very small reversed arrowhead                              */
#ifndef XuSMALL_HEAD_REV
#define XuSMALL_HEAD_REV -5
#endif
/*                                                                       */
/*                                                                       */
/* XuGridSize - Set grid/block size                                      */
/*                                                                       */
extern XuType XuCallCnv XuGridSize (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x_size  , /* r   in  Grid/block size in X-direction          */
  double    y_size  , /* r   in  Grid/block size in Y-direction          */
  double    z_size    /* r   in  Grid/block size in Z-direction          */
#endif
);
/*                                                                       */
/* x_size: Ignore value for X-direction                                  */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* y_size: Ignore value for Y-direction                                  */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* z_size: Ignore value for Z-direction                                  */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuLegendOptions - Set options for shading scale legend                */
/*                                                                       */
extern XuType XuCallCnv XuLegendOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *strings     , /* ca  in  Legend Texts                       */
  int       mxstrings    , /* i   in  Maximum length of text strings in    */
  double    height       , /* r   in  Colored rectangles height (mm)     */
  int       num_decimal  , /* i   in  Number of decimal places           */
  double    angle        , /* r   in  Plot direction (degrees)           */
  int       class_code     /* i   in  Legend options                     */
#endif
);
/*                                                                       */
/* class_code: Class limits in descending order                          */
#ifndef XuDESCENDING
#define XuDESCENDING -1
#endif
/* class_code: No boxes for ``BELOW'' and ``ABOVE''                      */
#ifndef XuOMIT_EXTREMES
#define XuOMIT_EXTREMES 0
#endif
/* class_code: Class limits in ascending order                           */
#ifndef XuASCENDING
#define XuASCENDING 1
#endif
/*                                                                       */
/*                                                                       */
/* XuLabelRectangleDraw - Draw colored rectangle with text               */
/*                                                                       */
extern XuType XuCallCnv XuLabelRectangleDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x            , /* r   in  X-coordinate of rectangle lower left corner    */
  double    y            , /* r   in  Y-coordinate of rectangle lower left corner    */
  int       color_index  , /* i   in  Color index                        */
  char      *string        /* c   in  Descriptive text                   */
#endif
);
/*                                                                       */
/* XuColorSpaceLoad - Load user-defined color space                      */
/*                                                                       */
extern XuType XuCallCnv XuColorSpaceLoad (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_level_1  , /* i   in  Intensities for first component    */
  int       num_level_2  , /* i   in  Intensities for second component    */
  int       num_level_3  , /* i   in  Intensities for third component    */
  int       start_index    /* i   in  First entry in color table to be updated    */
#endif
);
/*                                                                       */
/* XuIsolineColors - Set isoline colors                                  */
/*                                                                       */
extern XuType XuCallCnv XuIsolineColors (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_index_arr , /* ia  in  Contour line color indices     */
  int       num_colors         /* i   in  Number of color indices        */
#endif
);
/*                                                                       */
/* XuIsolineStyles - Set isoline linestyles                              */
/*                                                                       */
extern XuType XuCallCnv XuIsolineStyles (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *line_style_array , /* ia  in  Isoline linestyles            */
  int       num_line_styles     /* i   in  Number of linestyles          */
#endif
);
/*                                                                       */
/* XuIsolineWidths - Set isoline widths                                  */
/*                                                                       */
extern XuType XuCallCnv XuIsolineWidths (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *width_array , /* ra  in  Contour line widths                */
  int       num_widths     /* i   in  Number of contour levels           */
#endif
);
/*                                                                       */
/* XuLegendDraw - Draw shading scale legend                              */
/*                                                                       */
extern XuType XuCallCnv XuLegendDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x  , /* r   in  X-origin of shading scale                    */
  double    y    /* r   in  Y-origin of shading scale                    */
#endif
);
/*                                                                       */
/* XuLegendSmallDraw - Draw small shading scale legend                   */
/*                                                                       */
extern XuType XuCallCnv XuLegendSmallDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x  , /* r   in  X-origin of shading scale                    */
  double    y    /* r   in  Y-origin of shading scale                    */
#endif
);
/*                                                                       */
/* XuLegendLineDraw - Draw line scale legend                             */
/*                                                                       */
extern XuType XuCallCnv XuLegendLineDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x  , /* r   in  X-origin of line scale                       */
  double    y    /* r   in  Y-origin of line scale                       */
#endif
);
/*                                                                       */
/* XuViewDistance - Set distance from spectator to display               */
/*                                                                       */
extern XuType XuCallCnv XuViewDistance (
#if NeedFunctionPrototypes
/*                                                                       */
  double    scale_factor    /* r   in  Scaling factor                    */
#endif
);
/*                                                                       */
/* XuDotsDraw - Draw dot                                                 */
/*                                                                       */
extern XuType XuCallCnv XuDotsDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  in  X-coordinates of dot centers        */
  void      *y_array    , /* ra  in  Y-coordinates of dot centers        */
  int       num_points    /* i   in  Number of points                    */
#endif
);
/*                                                                       */
/* XuFlush - Empty graphics output buffer                                */
/*                                                                       */
extern XuType XuCallCnv XuFlush (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuMapFrameColor - Set frame color                                     */
/*                                                                       */
extern XuType XuCallCnv XuMapFrameColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Color code                         */
#endif
);
/*                                                                       */
/* XuMapFrameWidth - Set frame width                                     */
/*                                                                       */
extern XuType XuCallCnv XuMapFrameWidth (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width    /* r   in  Width                                    */
#endif
);
/*                                                                       */
/* XuViewPoint - Set viewpoint in 3D box coordinates                     */
/*                                                                       */
extern XuType XuCallCnv XuViewPoint (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x  , /* r   in  Eye position X-coordinates (box)             */
  double    y  , /* r   in  Eye position Y-coordinates (box)             */
  double    z    /* r   in  Eye position Z-coordinates (box)             */
#endif
);
/*                                                                       */
/* XuViewFocusPoint - Set focus point                                    */
/*                                                                       */
extern XuType XuCallCnv XuViewFocusPoint (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x  , /* r   in  Focus point X-coordinate (box)               */
  double    y  , /* r   in  Focus point Y-coordinate (box)               */
  double    z    /* r   in  Focus point Z-coordinate (box)               */
#endif
);
/*                                                                       */
/* XuMap3DFrameWidth - Set 3D frame width                                */
/*                                                                       */
extern XuType XuCallCnv XuMap3DFrameWidth (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width    /* r   in  Width of frame                           */
#endif
);
/*                                                                       */
/* XuBackgroundDraw - Draw 2D background                                 */
/*                                                                       */
extern XuType XuCallCnv XuBackgroundDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Background color code              */
#endif
);
/*                                                                       */
/* XuWorkbox3DDraw - Draw 3D workbox sides                               */
/*                                                                       */
extern XuType XuCallCnv XuWorkbox3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       wall_code    , /* i   in  Wall select code                   */
  int       color_index  , /* i   in  Color index                        */
  double    frame_width    /* r   in  Width of wall frame (mm)           */
#endif
);
/*                                                                       */
/* wall_code: All six walls                                              */
#ifndef XuALL6
#define XuALL6 -1
#endif
/* wall_code: The back-most vertical walls                               */
#ifndef XuBEHIND
#define XuBEHIND 0
#endif
/* wall_code: The wall at X min                                          */
#ifndef XuX_MIN
#define XuX_MIN 1
#endif
/* wall_code: The wall at X max                                          */
#ifndef XuX_MAX
#define XuX_MAX 2
#endif
/* wall_code: The wall at Y min                                          */
#ifndef XuY_MIN
#define XuY_MIN 3
#endif
/* wall_code: The wall at Y max                                          */
#ifndef XuY_MAX
#define XuY_MAX 4
#endif
/* wall_code: The wall at Z min                                          */
#ifndef XuZ_MIN
#define XuZ_MIN 5
#endif
/* wall_code: The wall at Z max                                          */
#ifndef XuZ_MAX
#define XuZ_MAX 6
#endif
/* color_index: Frame the wall                                           */
#ifndef XuHOLLOW
#define XuHOLLOW 9999
#endif
/* color_index: Shade the wall                                           */
#ifndef XuSHADED
#define XuSHADED -9999
#endif
/*                                                                       */
/*                                                                       */
/* XuColorHLSLoad - Load HLS color scheme                                */
/*                                                                       */
extern XuType XuCallCnv XuColorHLSLoad (
#if NeedFunctionPrototypes
/*                                                                       */
  int       hue_start    , /* i   in  First hue value                    */
  int       light_start  , /* i   in  First lightness value              */
  int       sat_start    , /* i   in  First saturation value             */
  int       hue_end      , /* i   in  Last hue value                     */
  int       light_end    , /* i   in  Last lightness value               */
  int       sat_end      , /* i   in  Last saturation value              */
  int       num_colors   , /* i   in  Number of entries to be calculated    */
  int       start_index    /* i   in  Start index in \UNIRAS\ color table    */
#endif
);
/*                                                                       */
/* XuViewWorldLimits - Set world coordinate system limits                */
/*                                                                       */
extern XuType XuCallCnv XuViewWorldLimits (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x_min  , /* r   in  Minimum world X-limit                    */
  double    x_max  , /* r   in  Maximum world X-limit                    */
  double    y_min  , /* r   in  Minimum world Y-limit                    */
  double    y_max  , /* r   in  Maximum world Y-limit                    */
  double    z_min  , /* r   in  Minimum world Z-limit                    */
  double    z_max    /* r   in  Maximum world Z-limit                    */
#endif
);
/*                                                                       */
/* XuMapPolygonsDelete - Delete map component bounding polygons and data */
/*                                                                       */
extern XuType XuCallCnv XuMapPolygonsDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       map_component    /* i   in  Map component                    */
#endif
);
/*                                                                       */
/* map_component: All map components                                     */
#ifndef XuALL
#define XuALL 0
#endif
/* map_component: Irregular dot map                                      */
#ifndef XuIRR_DOT
#define XuIRR_DOT 1
#endif
/* map_component: Irregular symbol map                                   */
#ifndef XuIRR_SYMBOL
#define XuIRR_SYMBOL 2
#endif
/* map_component: Regular grid map                                       */
#ifndef XuREG_GRID
#define XuREG_GRID 3
#endif
/* map_component: Irregular grid map                                     */
#ifndef XuIRR_GRID
#define XuIRR_GRID 4
#endif
/* map_component: Isoline map                                            */
#ifndef Xu2D_ISOLINE
#define Xu2D_ISOLINE 5
#endif
/* map_component: User defined isoline map                               */
#ifndef XuUSER_2D_ISOLINE
#define XuUSER_2D_ISOLINE 6
#endif
/* map_component: Quick shaded contour map                               */
#ifndef XuQUICK_2D_CONTOUR
#define XuQUICK_2D_CONTOUR 7
#endif
/* map_component: Shaded contour map                                     */
#ifndef Xu2D_CONTOUR
#define Xu2D_CONTOUR 8
#endif
/* map_component: User defined shaded contour map                        */
#ifndef XuUSER_2D_CONTOUR
#define XuUSER_2D_CONTOUR 9
#endif
/* map_component: Shaded polygon map                                     */
#ifndef Xu2D_POLYGON
#define Xu2D_POLYGON 10
#endif
/* map_component: Workbox                                                */
#ifndef Xu2D_WORKBOX
#define Xu2D_WORKBOX 11
#endif
/* map_component: Grid net                                               */
#ifndef Xu2D_GRID
#define Xu2D_GRID 12
#endif
/* map_component: User defined grid net                                  */
#ifndef XuUSER_2D_GRID
#define XuUSER_2D_GRID 13
#endif
/* map_component: Major mesh                                             */
#ifndef Xu2D_MAJOR_MESH
#define Xu2D_MAJOR_MESH 14
#endif
/* map_component: Minor mesh                                             */
#ifndef Xu2D_MINOR_MESH
#define Xu2D_MINOR_MESH 15
#endif
/* map_component: Isoline label boxes                                    */
#ifndef Xu2D_ISOLINE_LABEL_BOXES
#define Xu2D_ISOLINE_LABEL_BOXES 16
#endif
/* map_component: Isoline labels                                         */
#ifndef Xu2D_ISOLINE_LABELS
#define Xu2D_ISOLINE_LABELS 17
#endif
/* map_component: Regions                                                */
#ifndef XuREGIONS
#define XuREGIONS 18
#endif
/* map_component: Fault lines                                            */
#ifndef XuFAULT_LINES
#define XuFAULT_LINES 19
#endif
/* map_component: Well symbol                                            */
#ifndef XuWELL_SYMBOL
#define XuWELL_SYMBOL 20
#endif
/* map_component: Map border frame                                       */
#ifndef XuMAP_BORDER_FRAME
#define XuMAP_BORDER_FRAME 21
#endif
/* map_component: Legend box                                             */
#ifndef XuMAP_LEGEND_BOX
#define XuMAP_LEGEND_BOX 22
#endif
/* map_component: Legend texts                                           */
#ifndef XuMAP_LEGEND_TEXTS
#define XuMAP_LEGEND_TEXTS 23
#endif
/* map_component: Legend items                                           */
#ifndef XuMAP_LEGEND_ITEMS
#define XuMAP_LEGEND_ITEMS 24
#endif
/* map_component: Isoline tickmark symbols                               */
#ifndef Xu2D_ISOLINE_TICK_SYMBOLS
#define Xu2D_ISOLINE_TICK_SYMBOLS 25
#endif
/* map_component: 3D regular grid map                                    */
#ifndef Xu3D_REG_GRID
#define Xu3D_REG_GRID 101
#endif
/* map_component: 3D irregular grid map                                  */
#ifndef Xu3D_IRR_GRID
#define Xu3D_IRR_GRID 102
#endif
/* map_component: 3D Isoline map                                         */
#ifndef Xu3D_ISOLINE
#define Xu3D_ISOLINE 103
#endif
/* map_component: 3D shaded contour map                                  */
#ifndef Xu3D_CONTOUR
#define Xu3D_CONTOUR 104
#endif
/* map_component: 3D regular block diagram                               */
#ifndef Xu3D_REG_BLOCK
#define Xu3D_REG_BLOCK 105
#endif
/* map_component: 3D irregular block diagram                             */
#ifndef Xu3D_IRR_BLOCK
#define Xu3D_IRR_BLOCK 106
#endif
/* map_component: 3D isoline block diagram                               */
#ifndef Xu3D_ISOLINE_BLOCK
#define Xu3D_ISOLINE_BLOCK 107
#endif
/* map_component: 3D shaded contour block diagram                        */
#ifndef Xu3D_CONTOUR_BLOCK
#define Xu3D_CONTOUR_BLOCK 108
#endif
/* map_component: 3D workbox walls                                       */
#ifndef Xu3D_WORKBOX_WALLS
#define Xu3D_WORKBOX_WALLS 109
#endif
/* map_component: 3D major surface mesh                                  */
#ifndef Xu3D_MAJOR_MESH
#define Xu3D_MAJOR_MESH 110
#endif
/* map_component: 3D minor surface mesh                                  */
#ifndef Xu3D_MINOR_MESH
#define Xu3D_MINOR_MESH 111
#endif
/* map_component: 3D major wall mesh                                     */
#ifndef Xu3D_MAJOR_WALL_MESH
#define Xu3D_MAJOR_WALL_MESH 112
#endif
/* map_component: 3D minor wall mesh                                     */
#ifndef Xu3D_MINOR_WALL_MESH
#define Xu3D_MINOR_WALL_MESH 113
#endif
/* map_component: 3D plinth walls                                        */
#ifndef Xu3D_PLINTH_WALLS
#define Xu3D_PLINTH_WALLS 114
#endif
/* map_component: 3D plinth bottom                                       */
#ifndef Xu3D_PLINTH_BOTTOM
#define Xu3D_PLINTH_BOTTOM 115
#endif
/* map_component: 4D regular grid map                                    */
#ifndef Xu4D_REG_GRID
#define Xu4D_REG_GRID 201
#endif
/* map_component: 4D irregular grid map                                  */
#ifndef Xu4D_IRR_GRID
#define Xu4D_IRR_GRID 202
#endif
/* map_component: 4D isoline map                                         */
#ifndef Xu4D_ISOLINE
#define Xu4D_ISOLINE 203
#endif
/* map_component: 4D shaded contour map                                  */
#ifndef Xu4D_CONTOUR
#define Xu4D_CONTOUR 204
#endif
/* map_component: 4D irregular block diagram                             */
#ifndef Xu4D_IRR_BLOCK
#define Xu4D_IRR_BLOCK 205
#endif
/*                                                                       */
/*                                                                       */
/* XuMapDrawOptions - Set draw, measure and probe options for all block, */
/*                                                                       */
extern XuType XuCallCnv XuMapDrawOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       draw_code    /* i   in  Select draw status                   */
#endif
);
/*                                                                       */
/* draw_code: Draw                                                       */
#ifndef XuON
#define XuON 1
#endif
/* draw_code: Measure                                                    */
#ifndef XuMEASURE
#define XuMEASURE 2
#endif
/* draw_code: Draw and measure                                           */
#ifndef XuON_MEASURE
#define XuON_MEASURE 3
#endif
/* draw_code: Probe integer and floating point data                      */
#ifndef XuPROBE
#define XuPROBE 4
#endif
/* draw_code: Draw and probe integer and floating point data             */
#ifndef XuON_PROBE
#define XuON_PROBE 5
#endif
/* draw_code: Probe integer data                                         */
#ifndef XuPROBE_INT
#define XuPROBE_INT 6
#endif
/* draw_code: Draw and probe integer data                                */
#ifndef XuON_PROBE_INT
#define XuON_PROBE_INT 7
#endif
/* draw_code: Probe floating point data                                  */
#ifndef XuPROBE_FLOAT
#define XuPROBE_FLOAT 8
#endif
/* draw_code: Draw and probe floating point data                         */
#ifndef XuON_PROBE_FLOAT
#define XuON_PROBE_FLOAT 9
#endif
/*                                                                       */
/*                                                                       */
/* XuMapPolygonsDataSize - Query the size of the map component data      */
/*                                                                       */
extern XuType XuCallCnv XuMapPolygonsDataSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       map_component  , /* i   in  Map component                    */
  int       *number        , /* i   out Number of bounding polygons      */
  int       *size_int      , /* i   out Size in elements of an integer data array    */
  int       *size_float      /* i   out Size in elements of a floating point data array    */
#endif
);
/*                                                                       */
/* XuMapBorderFrameWidth - Set map frame width                           */
/*                                                                       */
extern XuType XuCallCnv XuMapBorderFrameWidth (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width    /* r   in  Width of map frame                       */
#endif
);
/*                                                                       */
/* XuMapPolygonsDataIntQuery - Query the map component integer data      */
/*                                                                       */
extern XuType XuCallCnv XuMapPolygonsDataIntQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       map_component  , /* i   in  Map component                    */
  int       *num_int_array , /* ia  out Number of integer data of polygons    */
  int       *int_array       /* ia  out Integer data                     */
#endif
);
/*                                                                       */
/* XuMapPolygonsQuery - Query the map component bounding polygons        */
/*                                                                       */
extern XuType XuCallCnv XuMapPolygonsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       map_component     , /* i   in  Map component                 */
  int       *num_points_array , /* ia  out Number of points of polygons    */
  void      *x_array          , /* ra  out X-coordinates of points       */
  void      *y_array            /* ra  out Y-coordinates of points       */
#endif
);
/*                                                                       */
/* XuMapPolygonsDataFloatQuery - Query the map component floating point  */
/*                                                                       */
extern XuType XuCallCnv XuMapPolygonsDataFloatQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       map_component    , /* i   in  Map component                  */
  int       *num_float_array , /* ia  out Number of floating point data of polygons    */
  void      *float_array       /* ra  out Floating point data            */
#endif
);
/*                                                                       */
/* XuMapPolygonsNumberSize - Query the number and size of the map compon */
/*                                                                       */
extern XuType XuCallCnv XuMapPolygonsNumberSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       map_component  , /* i   in  Map component                    */
  int       *number        , /* i   out Number of bounding polygons      */
  int       *size            /* i   out Size in elements of a bounding polygons array    */
#endif
);
/*                                                                       */
/* XuViewOblique - Set oblique projection angle and relative depth       */
/*                                                                       */
extern XuType XuCallCnv XuViewOblique (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle  , /* r   in  Oblique angle                            */
  double    depth    /* r   in  Relative depth                           */
#endif
);
/*                                                                       */
/* XuClassesCalc - Compute data class limits                             */
/*                                                                       */
extern XuType XuCallCnv XuClassesCalc (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *limit_array   , /* ra  in  Data values                      */
  int       num_limits     , /* i   in  Number of data values            */
  void      *percent_array , /* ra  in  Percentiles                      */
  void      *result_array  , /* ra  out Calculated class limits          */
  int       num_percents     /* i   in  Number of percentiles            */
#endif
);
/*                                                                       */
/* XuPlinthDraw - Draw plinth                                            */
/*                                                                       */
extern XuType XuCallCnv XuPlinthDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width        , /* r   in  Plinth width (mm)                  */
  int       color_index    /* i   in  Color table index                  */
#endif
);
/*                                                                       */
/* XuViewProjection - Set world coordinate system projection type        */
/*                                                                       */
extern XuType XuCallCnv XuViewProjection (
#if NeedFunctionPrototypes
/*                                                                       */
  int       projection_type    /* i   in  Projection option              */
#endif
);
/*                                                                       */
/* projection_type: Perspective projection                               */
#ifndef XuPERSPECTIVE
#define XuPERSPECTIVE 1
#endif
/* projection_type: Oblique projection                                   */
#ifndef XuOBLIQUE
#define XuOBLIQUE 2
#endif
/*                                                                       */
/*                                                                       */
/* XuViewAngleQuery - Query tilt angle                                   */
/*                                                                       */
extern XuType XuCallCnv XuViewAngleQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *angle   /* r   out Amount of tilt (degrees)                 */
#endif
);
/*                                                                       */
/* XuArrowBoxQuery - Query arrow bounding box                            */
/*                                                                       */
extern XuType XuCallCnv XuArrowBoxQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  double    xhead      , /* r   in  Head X-coordinate                    */
  double    yhead      , /* r   in  Head Y-coordinate                    */
  int       head_code  , /* i   in  Head option                          */
  double    xtail      , /* r   in  Tail X-coordinate                    */
  double    ytail      , /* r   in  Tail Y-coordinate                    */
  int       tail_code  , /* i   in  Tail option (See head_code)          */
  double    width      , /* r   in  Width of shaft (mm)                  */
  void      *x_array   , /* ra  out X-coordinates of arrow bounding box    */
  void      *y_array     /* ra  out Y-coordinates of arrow bounding box    */
#endif
);
/*                                                                       */
/* XuViewDistanceQuery - Query distance from spectator to display        */
/*                                                                       */
extern XuType XuCallCnv XuViewDistanceQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *scale_factor   /* r   out Scaling factor                    */
#endif
);
/*                                                                       */
/* XuViewPointQuery - Query view point in 3D box coordinates             */
/*                                                                       */
extern XuType XuCallCnv XuViewPointQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x , /* r   out Eye position X-coordinates (box)             */
  XuFloat   *y , /* r   out Eye position Y-coordinates (box)             */
  XuFloat   *z   /* r   out Eye position Z-coordinates (box)             */
#endif
);
/*                                                                       */
/* XuViewFocusPointQuery - Query focus point in 3D box coordinates       */
/*                                                                       */
extern XuType XuCallCnv XuViewFocusPointQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x , /* r   out Focus point X-coordinate (box)               */
  XuFloat   *y , /* r   out Focus point Y-coordinate (box)               */
  XuFloat   *z   /* r   out Focus point Z-coordinate (box)               */
#endif
);
/*                                                                       */
/* XuViewWorldLimitsQuery - Query world coordinate system limits         */
/*                                                                       */
extern XuType XuCallCnv XuViewWorldLimitsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x_min , /* r   out Minimum world X-limit                    */
  XuFloat   *x_max , /* r   out Maximum world X-limit                    */
  XuFloat   *y_min , /* r   out Minimum world Y-limit                    */
  XuFloat   *y_max , /* r   out Maximum world Y-limit                    */
  XuFloat   *z_min , /* r   out Minimum world Z-limit                    */
  XuFloat   *z_max   /* r   out Maximum world Z-limit                    */
#endif
);
/*                                                                       */
/* XuMapDrawOptionsQuery - Query draw status of all block, isoline, shad */
/*                                                                       */
extern XuType XuCallCnv XuMapDrawOptionsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *draw_code   /* i   out Draw status                          */
#endif
);
/*                                                                       */
/* XuViewObliqueQuery - Query the oblique projection angle and relative  */
/*                                                                       */
extern XuType XuCallCnv XuViewObliqueQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *angle , /* r   out Oblique angle                            */
  XuFloat   *depth   /* r   out Relative depth                           */
#endif
);
/*                                                                       */
/* XuViewProjectionQuery - Query world coordinate system projection type */
/*                                                                       */
extern XuType XuCallCnv XuViewProjectionQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *projection_type   /* i   out Projection option              */
#endif
);
/*                                                                       */
/* XuViewportQuery - Query viewport                                      */
/*                                                                       */
extern XuType XuCallCnv XuViewportQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x      , /* r   out Viewport offset in X-direction (mm)     */
  XuFloat   *y      , /* r   out Viewport offset in Y-direction (mm)     */
  XuFloat   *width  , /* r   out X-dimension of viewport (mm)            */
  XuFloat   *height   /* r   out Y-dimension of viewport (mm)            */
#endif
);
/*                                                                       */
/* XuViewUpVectorQuery - Query world coordinate system up vector         */
/*                                                                       */
extern XuType XuCallCnv XuViewUpVectorQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *up_code   /* i   out Up vector option                       */
#endif
);
/*                                                                       */
/* up_code: Default projection: y-up                                     */
#ifndef XuY_UP
#define XuY_UP 1
#endif
/* up_code: Alternate projection: z-up                                   */
#ifndef XuZ_UP
#define XuZ_UP 2
#endif
/*                                                                       */
/*                                                                       */
/* XuViewPointPolarQuery - Query viewpoint in angles                     */
/*                                                                       */
extern XuType XuCallCnv XuViewPointPolarQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *phi      , /* r   out Angle in X-Y plane (degrees)          */
  XuFloat   *theta    , /* r   out Vertical angle (degrees)              */
  XuFloat   *distance   /* r   out Distance from focus point to viewpoint (box)    */
#endif
);
/*                                                                       */
/* XuViewWorkboxQuery - Query workbox dimensions                         */
/*                                                                       */
extern XuType XuCallCnv XuViewWorkboxQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x_size , /* r   out X-dimension of the workbox (box)        */
  XuFloat   *y_size , /* r   out Y-dimension of the workbox (box)        */
  XuFloat   *z_size   /* r   out Z-dimension of the workbox (box)        */
#endif
);
/*                                                                       */
/* XuDeviceQuery - Inquire selected device                               */
/*                                                                       */
extern XuType XuCallCnv XuDeviceQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *string   /* c   out Device name                             */
#endif
);
/*                                                                       */
/* XuDeviceAttributesQuery - Inquire selected device attributes          */
/*                                                                       */
extern XuType XuCallCnv XuDeviceAttributesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *xtype     , /* i   out Drawing area X-direction type        */
  int       *ytype     , /* i   out Drawing area Y-direction type        */
  XuFloat   *width_mm  , /* r   out Drawing area length in X-direction    */
  XuFloat   *height_mm , /* r   out Drawing area length in Y-direction    */
  char      *string      /* c   out Device name                          */
#endif
);
/*                                                                       */
/* xtype: No drawing area size                                           */
#ifndef XuNO_SIZE
#define XuNO_SIZE 0
#endif
/* xtype: Fixed drawing area size                                        */
#ifndef XuFIXED_SIZE
#define XuFIXED_SIZE 1
#endif
/* xtype: Virtual drawing area size                                      */
#ifndef XuVIRTUAL_SIZE
#define XuVIRTUAL_SIZE 2
#endif
/* xtype: Any drawing area size                                          */
#ifndef XuANY_SIZE
#define XuANY_SIZE 3
#endif
/*                                                                       */
/*                                                                       */
/* XuCoordinatesReduce - Reduce coordinates                              */
/*                                                                       */
extern XuType XuCallCnv XuCoordinatesReduce (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array        , /* ra  in  Dataset X-coordinates           */
  void      *y_array        , /* ra  in  Dataset Y-coordinates           */
  int       num_points      , /* i   in  Number of input coordinates     */
  void      *x_result_array , /* ra  out Thinned X-coordinates (mm)      */
  void      *y_result_array , /* ra  out Thinned Y-coordinates (mm)      */
  int       *num_results      /* i   out Number of output coordinates    */
#endif
);
/*                                                                       */
/* XuCoordinatesReduceTolerance - Set tolerance factor                   */
/*                                                                       */
extern XuType XuCallCnv XuCoordinatesReduceTolerance (
#if NeedFunctionPrototypes
/*                                                                       */
  int       tolerance    /* i   in  Tolerance factor                     */
#endif
);
/*                                                                       */
/* XuReset - Reset parameters                                            */
/*                                                                       */
extern XuType XuCallCnv XuReset (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuDeviceSelect - Select graphics device                               */
/*                                                                       */
extern XuType XuCallCnv XuDeviceSelect (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *string   /* c   in  Command string                          */
#endif
);
/*                                                                       */
/* XuViewWorld - Activate 2D scaling                                     */
/*                                                                       */
extern XuType XuCallCnv XuViewWorld (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuViewMM - Activate plot coordinates                                  */
/*                                                                       */
extern XuType XuCallCnv XuViewMM (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuUPIFileClose - Close UNIPICT file                                   */
/*                                                                       */
extern XuType XuCallCnv XuUPIFileClose (
#if NeedFunctionPrototypes
/*                                                                       */
  int       close_code    /* i   in  File option                         */
#endif
);
/*                                                                       */
/* close_code: Close UNIPICT file (pt. only choice)                      */
#ifndef XuNOT_USED
#define XuNOT_USED 0
#endif
/*                                                                       */
/*                                                                       */
/* XuUPIClose - Close segment                                            */
/*                                                                       */
extern XuType XuCallCnv XuUPIClose (
#if NeedFunctionPrototypes
/*                                                                       */
  int       segment_id    /* i   in  Segment identification number       */
#endif
);
/*                                                                       */
/* XuUPIFileCompress - Compress segment file                             */
/*                                                                       */
extern XuType XuCallCnv XuUPIFileCompress (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuUPICreate - Create segment                                          */
/*                                                                       */
extern XuType XuCallCnv XuUPICreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       segment_id    /* i   in  Segment identification number       */
#endif
);
/*                                                                       */
/* XuUPIDelete - Delete segment                                          */
/*                                                                       */
extern XuType XuCallCnv XuUPIDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       segment_id    /* i   in  Segment identification number       */
#endif
);
/*                                                                       */
/* XuUPIQuery - Segment availability                                     */
/*                                                                       */
extern XuType XuCallCnv XuUPIQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       segment_id  , /* i   in  Segment identification number       */
  int       *exist_code   /* i   out Segment status code                 */
#endif
);
/*                                                                       */
/* exist_code: Invalid segment number                                    */
#ifndef XuINVALID
#define XuINVALID -1
#endif
/* exist_code: Segment does not exist                                    */
#ifndef XuFREE
#define XuFREE 0
#endif
/* exist_code: Segment exists and is closed                              */
#ifndef XuEXISTS
#define XuEXISTS 1
#endif
/* exist_code: Segment exists and is open for read                       */
#ifndef XuOPEN_FOR_READ
#define XuOPEN_FOR_READ 2
#endif
/* exist_code: Segment exists and is open for write                      */
#ifndef XuOPEN_FOR_WRITE
#define XuOPEN_FOR_WRITE 3
#endif
/*                                                                       */
/*                                                                       */
/* XuUPIOptions - Set segment options                                    */
/*                                                                       */
extern XuType XuCallCnv XuUPIOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       option_code  , /* i   in  Segment option code                */
  int       value          /* i   in  Action code                        */
#endif
);
/*                                                                       */
/* option_code: Recording of colors                                      */
#ifndef XuCOLORS
#define XuCOLORS 1
#endif
/* option_code: Line width handling when drawing                         */
#ifndef XuLINE_WIDTH
#define XuLINE_WIDTH 2
#endif
/* option_code: Graphics primitives recording                            */
#ifndef XuRECORD_STATUS
#define XuRECORD_STATUS 3
#endif
/* option_code: Draw segment on screen or not                            */
#ifndef XuDRAW_STATUS
#define XuDRAW_STATUS 4
#endif
/* option_code: Record drawing area information                          */
#ifndef XuAREA_INFO
#define XuAREA_INFO 5
#endif
/* option_code: Draw text in various fonts                               */
#ifndef XuFONTS
#define XuFONTS 6
#endif
/* option_code: Drawing mode                                             */
#ifndef XuDRAWING_MODE
#define XuDRAWING_MODE 7
#endif
/* option_code: Clip mode                                                */
#ifndef XuCLIP
#define XuCLIP 8
#endif
/* value: Write only used colors to segment                              */
#ifndef XuRECORD_USED
#define XuRECORD_USED 0
#endif
/* value: Write all colors to segment                                    */
#ifndef XuRECORD_ALL
#define XuRECORD_ALL 1
#endif
/* value: Scale line width with segment                                  */
#ifndef XuDRAW_SCALED
#define XuDRAW_SCALED 0
#endif
/* value: Draw line using absolute width                                 */
#ifndef XuDRAW_ABSOLUTE
#define XuDRAW_ABSOLUTE 1
#endif
/* value: Draw all lines one pixel thick                                 */
#ifndef XuDRAW_THIN
#define XuDRAW_THIN 2
#endif
/* value: Write graphics primitives to segment                           */
#ifndef XuOPEN
#define XuOPEN 0
#endif
/* value: Temporarily disable writing segment                            */
#ifndef XuCLOSED
#define XuCLOSED 1
#endif
/* value: Write size of window/hardcopy device to segment                */
#ifndef XuRECORD
#define XuRECORD 0
#endif
/* value: Don't include area information in segment                      */
#ifndef XuIGNORE
#define XuIGNORE 1
#endif
/* value: Draw all text using the original fonts                         */
#ifndef XuDRAW_AS_DEFINED
#define XuDRAW_AS_DEFINED 0
#endif
/* value: Draw all text using the ``simplex'' font                       */
#ifndef XuDRAW_IN_SIMPLEX
#define XuDRAW_IN_SIMPLEX 1
#endif
/* value: Draw all text using the ''hardware'' mode                      */
#ifndef XuDRAW_FAST
#define XuDRAW_FAST 2
#endif
/* value: Obey the drawing mode stored in the segment                    */
#ifndef XuAS_DEFINED
#define XuAS_DEFINED 0
#endif
/* value: Draw all graphics in GXcopy (``replace'') mode                 */
#ifndef XuFORCE_REPLACE
#define XuFORCE_REPLACE 1
#endif
/*                                                                       */
/*                                                                       */
/* XuUPITransformation - Transform segment                               */
/*                                                                       */
extern XuType XuCallCnv XuUPITransformation (
#if NeedFunctionPrototypes
/*                                                                       */
  int       segment_id  , /* i   in  Segment identification number       */
  double    x           , /* r   in  Offset in the X-direction           */
  double    y           , /* r   in  Offset in the Y-direction           */
  double    scale_x     , /* r   in  Scale factor in the X-direction     */
  double    scale_y     , /* r   in  Scale factor in the Y-direction     */
  double    angle         /* r   in  Rotation angle (degrees)            */
#endif
);
/*                                                                       */
/* XuUPIDraw - Copy segment to workstation                               */
/*                                                                       */
extern XuType XuCallCnv XuUPIDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       segment_id    /* i   in  Segment identification number       */
#endif
);
/*                                                                       */
/* XuSystemMessageHandler - Set a system specific message handler        */
/*                                                                       */
extern XuType XuCallCnv XuSystemMessageHandler (
#if NeedFunctionPrototypes
/*                                                                       */
  void      (*sysfn)(char *,int *,void *)  /* vp  in  Pointer to system message handler    */
#endif
);
/*                                                                       */
/* XuUPIHeader - Read/write segment header items                         */
/*                                                                       */
extern XuType XuCallCnv XuUPIHeader (
#if NeedFunctionPrototypes
/*                                                                       */
  int       segment_id   , /* i   in  Segment number                     */
  int       item         , /* i   in  Item number                        */
  int       *length      , /* i   io  Length of string                   */
  char      *string      , /* c   io  String                             */
  int       max_length   , /* i   in  Maximum length of string           */
  int       *int_array   , /* ia  io  Integer array                      */
  int       *num_int     , /* i   io  Number of integers                 */
  void      *float_array , /* ra  io  Real array                         */
  int       *num_float     /* i   io  Number of reals                    */
#endif
);
/*                                                                       */
/* XuPolygonFrameColor - Set surface frame color                         */
/*                                                                       */
extern XuType XuCallCnv XuPolygonFrameColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Color table index                  */
#endif
);
/*                                                                       */
/* XuViewWorld3DTo2D - Transform 3D coordinates to 2D                    */
/*                                                                       */
extern XuType XuCallCnv XuViewWorld3DTo2D (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  io  3D world coordinates (In),\\        */
  void      *y_array    , /* ra  io  3D world coordinates (In),\\        */
  void      *z_array    , /* ra  io  3D world coordinates (In),\\        */
  int       num_points    /* i   in  Number of points to be transformed    */
#endif
);
/*                                                                       */
/* XuMessageHandler - Set a user-defined message handler                 */
/*                                                                       */
extern XuType XuCallCnv XuMessageHandler (
#if NeedFunctionPrototypes
/*                                                                       */
  void      (*userfn)(char *,int *,void *), /* vp  in  Pointer to user message handler    */
  int       long_messages  , /* i   in  Long messages flag               */
  void      *user_data       /* vd  in  Pointer to user data             */
#endif
);
/*                                                                       */
/* XuRasterSymbolDraw - Draw user-designed raster symbol                 */
/*                                                                       */
extern XuType XuCallCnv XuRasterSymbolDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *matrix , /* ia  in  Symbol Matrix                           */
  double    x       , /* r   in  X-coordinate of lower left corner of symbol    */
  double    y         /* r   in  Y-coordinate of lower left corner of symbol    */
#endif
);
/*                                                                       */
/* XuRasterUserPattern - Set user-defined raster pattern                 */
/*                                                                       */
extern XuType XuCallCnv XuRasterUserPattern (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *mask_array , /* ia  in  Bit mask array                      */
  int       num_mask    , /* i   in  Number of masks                     */
  int       *patt_array , /* ia  in  Pattern array                       */
  int       num_patt    , /* i   in  Number of patterns                  */
  int       num_lines     /* i   in  Number of scan lines                */
#endif
);
/*                                                                       */
/* XuLineDraw - Draw line                                                */
/*                                                                       */
extern XuType XuCallCnv XuLineDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  in  X-coordinates of points             */
  void      *y_array    , /* ra  in  X-coordinates of points             */
  int       num_points    /* i   in  Number of points                    */
#endif
);
/*                                                                       */
/* x_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/* y_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuViewport - Set viewport                                             */
/*                                                                       */
extern XuType XuCallCnv XuViewport (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x       , /* r   in  Viewport offset in X-direction (mm)     */
  double    y       , /* r   in  Viewport offset in Y-direction (mm)     */
  double    width   , /* r   in  X-dimension of viewport (mm)            */
  double    height    /* r   in  Y-dimension of viewport (mm)            */
#endif
);
/*                                                                       */
/* XuViewUpVector - Set world coordinate system up vector                */
/*                                                                       */
extern XuType XuCallCnv XuViewUpVector (
#if NeedFunctionPrototypes
/*                                                                       */
  int       up_code    /* i   in  Up vector option                       */
#endif
);
/*                                                                       */
/* XuViewPointPolar - Set viewpoint in angles                            */
/*                                                                       */
extern XuType XuCallCnv XuViewPointPolar (
#if NeedFunctionPrototypes
/*                                                                       */
  double    phi       , /* r   in  Angle in X-Y plane (degrees)          */
  double    theta     , /* r   in  Vertical angle (degrees)              */
  double    distance    /* r   in  Distance from focus point to viewpoint (box)    */
#endif
);
/*                                                                       */
/* XuViewWorkbox - Set workbox dimensions                                */
/*                                                                       */
extern XuType XuCallCnv XuViewWorkbox (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x_size  , /* r   in  X-size of the workbox (box)             */
  double    y_size  , /* r   in  Y-size of the workbox (box)             */
  double    z_size    /* r   in  Z-size of the workbox (box)             */
#endif
);
/*                                                                       */
/* XuWidthColor - Set width and color                                    */
/*                                                                       */
extern XuType XuCallCnv XuWidthColor (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width        , /* r   in  Line width or dot diameter (mm)    */
  int       color_index    /* i   in  Color index                        */
#endif
);
/*                                                                       */
/* XuRasterMemorySize - Set max memory size used for host                */
/*                                                                       */
extern XuType XuCallCnv XuRasterMemorySize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_words    /* i   in  Max size of rasterize memory in computer words    */
#endif
);
/*                                                                       */
/* XuOpen - Open UNIRAS                                                  */
/*                                                                       */
extern XuType XuCallCnv XuOpen (
#if NeedFunctionPrototypes
/*                                                                       */
#ifndef WIN32
  Display   *connection_id   /* xp  in  Connection identifier            */
#else
  HWND      connection_id   /* xp  in  Connection identifier             */
#endif
#endif
);
/*                                                                       */
/* connection_id: Open \UNIRAS\ and create new drawing area.             */
#ifndef XuCREATE
#define XuCREATE 0
#endif
/* connection_id: Reopen a previously defined drawing area (if           */
#ifndef XuREOPEN
#define XuREOPEN 1
#endif
/*                                                                       */
/*                                                                       */
/* XuViewMMToWorkbox - Transform millimeter units to box units           */
/*                                                                       */
extern double XuCallCnv XuViewMMToWorkbox (
#if NeedFunctionPrototypes
/*                                                                       */
  double    scalar    /* r   in  Height or length value (``millimeter'')    */
#endif
);
/*                                                                       */
/* XuViewMMToWorld - Transform ``millimeter to 2D world coordinates      */
/*                                                                       */
extern XuType XuCallCnv XuViewMMToWorld (
#if NeedFunctionPrototypes
/*                                                                       */
  int       option      , /* i   in  Conversion option                   */
  void      *x_array    , /* ra  io  X ``millimeter'' coordinates (In),\\    */
  void      *y_array    , /* ra  io  Y ``millimeter'' coordinates (In),\\    */
  int       num_points    /* i   in  Number of points to be transformed    */
#endif
);
/*                                                                       */
/* option: Convert all points                                            */
#ifndef XuCONVERT_ALL
#define XuCONVERT_ALL 0
#endif
/* option: Convert all points except breakpoints                         */
#ifndef XuSKIP_BREAK_POINTS
#define XuSKIP_BREAK_POINTS 1
#endif
/*                                                                       */
/*                                                                       */
/* XuViewPCToWorld - Transform plot coordinates (mm) to 2D world coordin */
/*                                                                       */
extern XuType XuCallCnv XuViewPCToWorld (
#if NeedFunctionPrototypes
/*                                                                       */
  int       option      , /* i   in  Conversion option                   */
  void      *x_array    , /* ra  io  X plot coordinates (In),\\          */
  void      *y_array    , /* ra  io  Y plot coordinates (In),\\          */
  int       num_points    /* i   in  Number of points to be transformed    */
#endif
);
/*                                                                       */
/* XuPlotfile - Set name for hardcopy plotfile                           */
/*                                                                       */
extern XuType XuCallCnv XuPlotfile (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *file_name   /* c   in  Filename                             */
#endif
);
/*                                                                       */
/* XuRasterPostprocessorRun - Postprocess raster file                    */
/*                                                                       */
extern XuType XuCallCnv XuRasterPostprocessorRun (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *device_name   /* c   in  \UNIRAS\ host raster device name    */
#endif
);
/*                                                                       */
/* XuWindowRasterDraw - Draw raster picture in an X drawable             */
/*                                                                       */
extern XuType XuCallCnv XuWindowRasterDraw (
#if NeedFunctionPrototypes
/*                                                                       */
#ifndef WIN32
  Display   *connection_id , /* xp  in  Connection identifier            */
#else
  HWND      connection_id , /* xp  in  Connection identifier             */
#endif
#ifndef WIN32
  Drawable  drawable         /* w   in  Window or pixmap id for drawable to use    */
#else
  HDC       drawable         /* w   in  Window or pixmap id for drawable to use    */
#endif
#endif
);
/*                                                                       */
/* XuRasterDevice - Create raster device                                 */
/*                                                                       */
extern XuType XuCallCnv XuRasterDevice (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *name            , /* c   in  Device Name                    */
  char      *description     , /* c   in  Device Description             */
  double    line_pixel_size  , /* r   in  Line direction pixel size (mm)    */
  double    scan_pixel_size  , /* r   in  Scan direction pixel size (mm)    */
  int       num_line_pixels  , /* i   in  Number of pixels in line direction    */
  int       num_scan_pixels  , /* i   in  Number of pixels in scan direction    */
  char      *color_handling  , /* c   in  Device color-handling type     */
  int       num_colors       , /* i   in  Primary colors on device       */
  int       num_levels       , /* i   in  Number of bits for primary color    */
  int       layout             /* i   in  Raster database layout         */
#endif
);
/*                                                                       */
/* XuCGMCreate - Direct graphical output to a CGM.                       */
/*                                                                       */
extern XuType XuCallCnv XuCGMCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       encoding    /* i   in  Encoding of metafile                  */
#endif
);
/*                                                                       */
/* XuCircleDraw - Draw circle                                            */
/*                                                                       */
extern XuType XuCallCnv XuCircleDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x            , /* r   in  Circle center X-coordinates        */
  double    y            , /* r   in  Circle center Y-coordinates        */
  double    radius       , /* r   in  Circle radius (mm)                 */
  int       color_index  , /* i   in  Color index used to fill circle    */
  double    frame_width    /* r   in  Circle frame width (mm)            */
#endif
);
/*                                                                       */
/* XuColorTableIndexRelease - Release color table index.                 */
/*                                                                       */
extern XuType XuCallCnv XuColorTableIndexRelease (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id  , /* i   in  Color table id                  */
  int       color_index       /* i   in  Color index                     */
#endif
);
/*                                                                       */
/* XuColorDrawingAreaClear - Clear window and release color table        */
/*                                                                       */
extern XuType XuCallCnv XuColorDrawingAreaClear (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id    /* i   in  Color table id                  */
#endif
);
/*                                                                       */
/* XuClasses - Set class limits                                          */
/*                                                                       */
extern XuType XuCallCnv XuClasses (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *class_array , /* ra  in  Array of class limits              */
  int       num_classes    /* i   in  Number of class limits             */
#endif
);
/*                                                                       */
/* XuClassesMinMax - Set class limits from min and max values            */
/*                                                                       */
extern XuType XuCallCnv XuClassesMinMax (
#if NeedFunctionPrototypes
/*                                                                       */
  double    class_min    , /* r   in  Minimum value                      */
  double    class_max    , /* r   in  Maximum value                      */
  int       num_classes    /* i   in  Number of class limits             */
#endif
);
/*                                                                       */
/* XuClip - Set clipping mode                                            */
/*                                                                       */
extern XuType XuCallCnv XuClip (
#if NeedFunctionPrototypes
/*                                                                       */
  int       clip_code    /* i   in  Clip code                            */
#endif
);
/*                                                                       */
/* XuLogoScan - Scan logo data file                                      */
/*                                                                       */
extern XuType XuCallCnv XuLogoScan (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *file_name       , /* c   in  Logo file name                 */
  int       *max_color_index , /* i   out Maximum color index value      */
  XuFloat   *aspectratio       /* r   out Aspect ratio of logo window    */
#endif
);
/*                                                                       */
/* XuClose - Close UNIRAS                                                */
/*                                                                       */
extern XuType XuCallCnv XuClose (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuClassesPercentiles - Set class limits from percentiles              */
/*                                                                       */
extern XuType XuCallCnv XuClassesPercentiles (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *pct_array , /* ra  in  Array of percentiles                 */
  int       num_pct    , /* i   in  Number of percentiles in array       */
  int       keep_code    /* i   in  Keep calculated limits flag          */
#endif
);
/*                                                                       */
/* keep_code: Re-calculate class limits every time                       */
#ifndef XuRECALC
#define XuRECALC 0
#endif
/* keep_code: Keep class limits calculated first time                    */
#ifndef XuKEEP
#define XuKEEP 1
#endif
/*                                                                       */
/*                                                                       */
/* XuClassesScanData - Set class limits by scanning data                 */
/*                                                                       */
extern XuType XuCallCnv XuClassesScanData (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_classes  , /* i   in  Number of class limits             */
  int       method       , /* i   in  Method to compute classes from data    */
  int       keep_code      /* i   in  Keep calculated limits flag        */
#endif
);
/*                                                                       */
/* XuClassesStartStep - Set class limits from start and step values      */
/*                                                                       */
extern XuType XuCallCnv XuClassesStartStep (
#if NeedFunctionPrototypes
/*                                                                       */
  double    class_start  , /* r   in  Start value, first class limit     */
  double    class_step   , /* r   in  Step between class values          */
  int       num_classes    /* i   in  Number of class limits             */
#endif
);
/*                                                                       */
/* XuColor - Set color and hatch pattern in color table                  */
/*                                                                       */
extern XuType XuCallCnv XuColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       action_code  , /* i   in  Programming mode                   */
  int       index        , /* i   in  Index number of entry in table     */
  void      *color_array , /* ra  in  Color definition array             */
  void      *hatch_array   /* ra  in  Hatching definition array          */
#endif
);
/*                                                                       */
/* action_code: Color only                                               */
#ifndef XuCOLOR
#define XuCOLOR 0
#endif
/* action_code: Hatch pattern only                                       */
#ifndef XuPATTERN
#define XuPATTERN 1
#endif
/* action_code: Both color and hatch pattern                             */
#ifndef XuCOLOR_AND_PATTERN
#define XuCOLOR_AND_PATTERN 2
#endif
/*                                                                       */
/*                                                                       */
/* XuComponentPointsGap - Set filter gap between two consecutive points  */
/*                                                                       */
extern XuType XuCallCnv XuComponentPointsGap (
#if NeedFunctionPrototypes
/*                                                                       */
  double    gap    /* r   in  Filter gap in mm                           */
#endif
);
/*                                                                       */
/* XuShadingScaleChange - Change a shading scale definition              */
/*                                                                       */
extern XuType XuCallCnv XuShadingScaleChange (
#if NeedFunctionPrototypes
/*                                                                       */
  int       scale_id         , /* i   in  Shading scale id number (1--25)    */
  void      *scale_def_array , /* ra  in  Shading scale definition       */
  int       num_fix_shades   , /* i   in  Number of fix points           */
  int       scheme           , /* i   in  Color mode for scale_def_array    */
  double    max_level          /* r   in  Maximum color level for scale_def_array    */
#endif
);
/*                                                                       */
/* scheme: Hue, Lightness, Saturation                                    */
#ifndef XuHLS
#define XuHLS 1
#endif
/* scheme: Red, Green, Blue                                              */
#ifndef XuRGB
#define XuRGB 2
#endif
/* scheme: Cyan, Magenta, Yellow                                         */
#ifndef XuCMY
#define XuCMY 3
#endif
/* scheme: B/W Additive                                                  */
#ifndef XuBWA
#define XuBWA 4
#endif
/* scheme: B/W Subtractive                                               */
#ifndef XuBWS
#define XuBWS 5
#endif
/*                                                                       */
/*                                                                       */
/* XuShadingScaleReset - Reset default shading scale definitions         */
/*                                                                       */
extern XuType XuCallCnv XuShadingScaleReset (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuShadingScaleLoad - Load colors from shading scale definition        */
/*                                                                       */
extern XuType XuCallCnv XuShadingScaleLoad (
#if NeedFunctionPrototypes
/*                                                                       */
  int       scale_id        , /* i   in  Shading scale id number (1--25)    */
  int       color_table_id  , /* i   in  Color table id number (1--127)    */
  int       start_index     , /* i   in  Start color index               */
  int       num_shades        /* i   in  Number of colors                */
#endif
);
/*                                                                       */
/* XuShadingScaleDistribution - Set shading scale distribution method    */
/*                                                                       */
extern XuType XuCallCnv XuShadingScaleDistribution (
#if NeedFunctionPrototypes
/*                                                                       */
  int       code    /* i   in  Distribution method                       */
#endif
);
/*                                                                       */
/* code: Generate fully evenly distributed colors                        */
#ifndef XuFULL_SCALE
#define XuFULL_SCALE 1
#endif
/* code: Generate semi evenly distributed colors                         */
#ifndef XuSEMI_SCALE
#define XuSEMI_SCALE 2
#endif
/*                                                                       */
/*                                                                       */
/* XuColorTableActivate - Set current active user color table.           */
/*                                                                       */
extern XuType XuCallCnv XuColorTableActivate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id    /* i   in  Color table number              */
#endif
);
/*                                                                       */
/* XuColorTableCreate - Create a color table                             */
/*                                                                       */
extern XuType XuCallCnv XuColorTableCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id  , /* i   in  Color table id number (1--127)    */
  int       max_index       , /* i   in  Highest color table index       */
  int       color_mode      , /* i   in  \UNIRAS\ color table mode       */
  int       color_scheme    , /* i   in  Color scheme                    */
  double    max_level         /* r   in  Maximum level of color code     */
#endif
);
/*                                                                       */
/* color_mode: Lookup                                                    */
#ifndef XuLOOKUP
#define XuLOOKUP 1
#endif
/* color_mode: Virtual                                                   */
#ifndef XuVIRTUAL
#define XuVIRTUAL 2
#endif
/* color_mode: Combined lookup/virtual                                   */
#ifndef XuCOMBINED
#define XuCOMBINED 3
#endif
/* color_mode: Direct                                                    */
#ifndef XuDIRECT
#define XuDIRECT 4
#endif
/*                                                                       */
/*                                                                       */
/* XuColorTableDelete - Delete a color table                             */
/*                                                                       */
extern XuType XuCallCnv XuColorTableDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id    /* i   in  Color table id number (1--127)    */
#endif
);
/*                                                                       */
/* XuColorTableChange - Change a color table                             */
/*                                                                       */
extern XuType XuCallCnv XuColorTableChange (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id  , /* i   in  Color table id number (1--127)    */
  int       max_index       , /* i   in  Highest color table index       */
  int       color_mode      , /* i   in  Color system mode               */
  int       color_scheme    , /* i   in  Color scheme type               */
  double    max_level         /* r   in  Maximum level of color code     */
#endif
);
/*                                                                       */
/* color_mode: Ignore argument                                           */
#ifndef XuI_IGNORE
#define XuI_IGNORE 9999
#endif
/* max_level: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuColorTableRelease - Release color table.                            */
/*                                                                       */
extern XuType XuCallCnv XuColorTableRelease (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id    /* i   in  Color table id                  */
#endif
);
/*                                                                       */
/* XuColorTableSystemActivate - Set current active system color table.   */
/*                                                                       */
extern XuType XuCallCnv XuColorTableSystemActivate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id    /* i   in  Color table number              */
#endif
);
/*                                                                       */
/* XuColorTableScope - Set color table scope                             */
/*                                                                       */
extern XuType XuCallCnv XuColorTableScope (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id   , /* i   in  Color table number             */
  int       color_table_use    /* i   in  Color table usage              */
#endif
);
/*                                                                       */
/* color_table_use: Universal color table                                */
#ifndef XuUNIVERSAL
#define XuUNIVERSAL 1
#endif
/* color_table_use: Global color table                                   */
#ifndef XuGLOBAL
#define XuGLOBAL 2
#endif
/* color_table_use: Local color table                                    */
#ifndef XuLOCAL
#define XuLOCAL 3
#endif
/*                                                                       */
/*                                                                       */
/* XuContextCopyCreate - Create a copy of the current graphics context   */
/*                                                                       */
extern XuType XuCallCnv XuContextCopyCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *context_id   /* i   out Context identifier                  */
#endif
);
/*                                                                       */
/* XuContextCreate - Create a graphics context                           */
/*                                                                       */
extern XuType XuCallCnv XuContextCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *context_id   /* i   out Graphics Context identifier         */
#endif
);
/*                                                                       */
/* XuContextDelete - Delete a graphics context                           */
/*                                                                       */
extern XuType XuCallCnv XuContextDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       context_id    /* i   in  Graphics context identifier         */
#endif
);
/*                                                                       */
/* XuContextSelect - Select a graphics context                           */
/*                                                                       */
extern XuType XuCallCnv XuContextSelect (
#if NeedFunctionPrototypes
/*                                                                       */
  int       context_id    /* i   in  Graphics context identifier         */
#endif
);
/*                                                                       */
/* XuColorType - Set color index type                                    */
/*                                                                       */
extern XuType XuCallCnv XuColorType (
#if NeedFunctionPrototypes
/*                                                                       */
  int       index       , /* i   in  Color index number                  */
  int       color_type    /* i   in  Color type                          */
#endif
);
/*                                                                       */
/* color_type: Background color index                                    */
#ifndef XuBACKGROUND
#define XuBACKGROUND 1
#endif
/* color_type: Antibackground color index                                */
#ifndef XuANTIBACKGROUND
#define XuANTIBACKGROUND 2
#endif
/* color_type: Hollow color index                                        */
#ifndef XuHOLLOW_COLOR
#define XuHOLLOW_COLOR 3
#endif
/*                                                                       */
/*                                                                       */
/* XuLineStyle - Set line style                                          */
/*                                                                       */
extern XuType XuCallCnv XuLineStyle (
#if NeedFunctionPrototypes
/*                                                                       */
  int       line_style    /* i   in  Linestyle (0--30)                   */
#endif
);
/*                                                                       */
/* XuRasterFile - Set name for raster file                               */
/*                                                                       */
extern XuType XuCallCnv XuRasterFile (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *file_name   /* c   in  Filename                             */
#endif
);
/*                                                                       */
/* XuTextFontDefault - Set default font name and mode                    */
/*                                                                       */
extern XuType XuCallCnv XuTextFontDefault (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *font_name , /* c   in  Default font name                    */
  int       font_mode    /* i   in  Default font mode                    */
#endif
);
/*                                                                       */
/* font_mode: Best-fit                                                   */
#ifndef XuBEST_FIT
#define XuBEST_FIT 0
#endif
/* font_mode: Software text font mode                                    */
#ifndef XuSOFT
#define XuSOFT 1
#endif
/* font_mode: Hardware text font mode                                    */
#ifndef XuHARD
#define XuHARD 2
#endif
/*                                                                       */
/*                                                                       */
/* XuColorLookupUsage - Specify lookup table usage                       */
/*                                                                       */
extern XuType XuCallCnv XuColorLookupUsage (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_phy    , /* i   in  Number of physical mode lookup entries    */
  int       num_vir    , /* i   in  Number of virtual mode lookup entries    */
  int       mode_code    /* i   in  VIR mode pattern selection           */
#endif
);
/*                                                                       */
/* XuDrawingMode - Set drawing mode                                      */
/*                                                                       */
extern XuType XuCallCnv XuDrawingMode (
#if NeedFunctionPrototypes
/*                                                                       */
  int       mode    /* i   in  Drawing mode                              */
#endif
);
/*                                                                       */
/* mode: Opaque drawing                                                  */
#ifndef XuDRAW_OPAQUE
#define XuDRAW_OPAQUE 1
#endif
/* mode: Transparent drawing                                             */
#ifndef XuDRAW_TRANSPARENT
#define XuDRAW_TRANSPARENT 2
#endif
/* mode: XOR drawing                                                     */
#ifndef XuDRAW_XOR
#define XuDRAW_XOR 3
#endif
/*                                                                       */
/*                                                                       */
/* XuDrawOptions - Set draw, measure and probe options for all fundament */
/*                                                                       */
extern XuType XuCallCnv XuDrawOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       draw_code    /* i   in  Select draw status                   */
#endif
);
/*                                                                       */
/* XuEllipseWidthColor - Set ellipse fill color and frame width          */
/*                                                                       */
extern XuType XuCallCnv XuEllipseWidthColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index  , /* i   in  Polygon ellipse fill color index    */
  double    width          /* r   in  Polygon frame width (mm or pixels)    */
#endif
);
/*                                                                       */
/* width: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuEllipseLimits - Set ellipse limits                                  */
/*                                                                       */
extern XuType XuCallCnv XuEllipseLimits (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle_start  , /* r   in  Start angle of arc (degrees)       */
  double    angle_end      /* r   in  End angle of arc (degrees)         */
#endif
);
/*                                                                       */
/* XuEllipseDraw - Draw ellipse                                          */
/*                                                                       */
extern XuType XuCallCnv XuEllipseDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       type  , /* i   in  Select ellipse type                       */
  double    x     , /* r   in  Centerpoint X-coordinate                  */
  double    y       /* r   in  Centerpoint Y-coordinate                  */
#endif
);
/*                                                                       */
/* type: Elliptic arc                                                    */
#ifndef XuARC
#define XuARC 1
#endif
/* type: Hollow elliptic arc with chord                                  */
#ifndef XuHOLLOW_ARC
#define XuHOLLOW_ARC 2
#endif
/* type: Hollow elliptic sector                                          */
#ifndef XuHOLLOW_SECTOR
#define XuHOLLOW_SECTOR 3
#endif
/* type: Filled elliptic arc with chord                                  */
#ifndef XuFILLED_ARC
#define XuFILLED_ARC 4
#endif
/* type: Filled elliptic sector                                          */
#ifndef XuFILLED_SECTOR
#define XuFILLED_SECTOR 5
#endif
/*                                                                       */
/*                                                                       */
/* XuEllipseAngle - Set ellipse rotation                                 */
/*                                                                       */
extern XuType XuCallCnv XuEllipseAngle (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle_base  , /* r   in  Ellipse base vector angle (degrees)    */
  double    angle_skew    /* r   in  Ellipse skew angle (degrees)        */
#endif
);
/*                                                                       */
/* angle_base: Ignore argument                                           */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* angle_skew: Ignore argument                                           */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuEllipseSize - Set ellipse size                                      */
/*                                                                       */
extern XuType XuCallCnv XuEllipseSize (
#if NeedFunctionPrototypes
/*                                                                       */
  double    length_up  , /* r   in  Ellipse up vector length (mm)        */
  double    factor       /* r   in  Expansion factor                     */
#endif
);
/*                                                                       */
/* length_up: Ignore argument                                            */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* factor: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuEllipseUpVector - Set ellipse base and up vectors                   */
/*                                                                       */
extern XuType XuCallCnv XuEllipseUpVector (
#if NeedFunctionPrototypes
/*                                                                       */
  double    base_x  , /* r   in  X-coordinate of ellipse base vector     */
  double    base_y  , /* r   in  Y-coordinate of ellipse base vector     */
  double    up_x    , /* r   in  X-coordinate of ellipse up vector       */
  double    up_y      /* r   in  Y-coordinate of ellipse up vector       */
#endif
);
/*                                                                       */
/* XuColorDefaultLoad - Load default colors into color table             */
/*                                                                       */
extern XuType XuCallCnv XuColorDefaultLoad (
#if NeedFunctionPrototypes
/*                                                                       */
  int       max_index    /* i   in  Max.\ color index to load            */
#endif
);
/*                                                                       */
/* XuColorOfPen - Set pen color                                          */
/*                                                                       */
extern XuType XuCallCnv XuColorOfPen (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *color_array , /* ra  in  Color of the pen                   */
  int       pen_number     /* i   in  Number of pen                      */
#endif
);
/*                                                                       */
/* XuLogoDraw - Draw logo                                                */
/*                                                                       */
extern XuType XuCallCnv XuLogoDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *file_name , /* c   in  Logo file name                       */
  double    x_start    , /* r   in  X startpoint justification vector (mm)    */
  double    y_start    , /* r   in  Y startpoint justification vector (mm)    */
  double    x_end      , /* r   in  X endpoint justification vector (mm)    */
  double    y_end      , /* r   in  Y endpoint justification vector (mm)    */
  int       justify      /* i   in  Logo justification factor            */
#endif
);
/*                                                                       */
/* XuMessageLevels - Set actions for messages                            */
/*                                                                       */
extern XuType XuCallCnv XuMessageLevels (
#if NeedFunctionPrototypes
/*                                                                       */
  int       info_level     , /* i   in  Action on ``information'' messages    */
  int       warning_level  , /* i   in  Action on ``warning'' messages    */
  int       error_level    , /* i   in  Action on ``error'' messages     */
  int       fatal_level      /* i   in  Action on ``fatal error'' messages    */
#endif
);
/*                                                                       */
/* info_level: No change to current state                                */
#ifndef XuMESSAGE_KEEP_STATE
#define XuMESSAGE_KEEP_STATE 0
#endif
/* info_level: Ignore informational messages                             */
#ifndef XuMESSAGE_IGNORE
#define XuMESSAGE_IGNORE 1
#endif
/* info_level: Continue after messages have been logged                  */
#ifndef XuMESSAGE_CONTINUE
#define XuMESSAGE_CONTINUE 2
#endif
/* info_level: Trace back to application program after messages          */
#ifndef XuMESSAGE_TRACEBACK
#define XuMESSAGE_TRACEBACK 3
#endif
/* info_level: Log error messages, then stop program                     */
#ifndef XuMESSAGE_ABORT
#define XuMESSAGE_ABORT 4
#endif
/*                                                                       */
/*                                                                       */
/* XuColorByName - Set color by name in color table                      */
/*                                                                       */
extern XuType XuCallCnv XuColorByName (
#if NeedFunctionPrototypes
/*                                                                       */
  int       index       , /* i   in  Index number of entry in color table    */
  char      *color_name   /* c   in  Color name                          */
#endif
);
/*                                                                       */
/* XuDrawingAreaOrientation - Set drawing area orientation               */
/*                                                                       */
extern XuType XuCallCnv XuDrawingAreaOrientation (
#if NeedFunctionPrototypes
/*                                                                       */
  int       orient_code    /* i   in  Orientation modifier               */
#endif
);
/*                                                                       */
/* orient_code: Default orientation                                      */
#ifndef XuDEFAULT
#define XuDEFAULT 0
#endif
/* orient_code: Landscape orientation                                    */
#ifndef XuLANDSCAPE
#define XuLANDSCAPE 1
#endif
/* orient_code: Portrait orientation                                     */
#ifndef XuPORTRAIT
#define XuPORTRAIT 2
#endif
/* orient_code: Reversed landscape orientation                           */
#ifndef XuLANDSCAPE_REV
#define XuLANDSCAPE_REV 3
#endif
/* orient_code: Reversed portrait orientation                            */
#ifndef XuPORTRAIT_REV
#define XuPORTRAIT_REV 4
#endif
/*                                                                       */
/*                                                                       */
/* XuRasterPattern - Select raster pattern                               */
/*                                                                       */
extern XuType XuCallCnv XuRasterPattern (
#if NeedFunctionPrototypes
/*                                                                       */
  int       pattern    /* i   in  Pattern identification number          */
#endif
);
/*                                                                       */
/* pattern: Dither patterns 4 by 4 pixels                                */
#ifndef XuDITHER_4X4
#define XuDITHER_4X4 0
#endif
/* pattern: Halftone patterns 4 by 4 pixels                              */
#ifndef XuHALFTONE_4X4
#define XuHALFTONE_4X4 1
#endif
/* pattern: Halftone patterns 8 by 8 pixels                              */
#ifndef XuHALFTONE_8X8
#define XuHALFTONE_8X8 2
#endif
/* pattern: Greytone patterns 4 by 4 pixels                              */
#ifndef XuGREYTONE_4X4
#define XuGREYTONE_4X4 3
#endif
/* pattern: Geological patterns                                          */
#ifndef XuGEOLOGIC
#define XuGEOLOGIC 4
#endif
/*                                                                       */
/*                                                                       */
/* XuColorDeviceLoad - Program virtual color in device                   */
/*                                                                       */
extern XuType XuCallCnv XuColorDeviceLoad (
#if NeedFunctionPrototypes
/*                                                                       */
  int       index    /* i   in  Index number of entry to lock            */
#endif
);
/*                                                                       */
/* XuPolygonsDelete - Delete bounding polygons and data of the geometric */
/*                                                                       */
extern XuType XuCallCnv XuPolygonsDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       primitive_component    /* i   in  Fundamental geometric primitive component    */
#endif
);
/*                                                                       */
/* primitive_component: Dot                                              */
#ifndef XuDOT
#define XuDOT 1
#endif
/* primitive_component: Polyline                                         */
#ifndef XuPOLYLINE
#define XuPOLYLINE 2
#endif
/* primitive_component: Rectangle                                        */
#ifndef XuRECTANGLE
#define XuRECTANGLE 3
#endif
/* primitive_component: Circle                                           */
#ifndef XuCIRCLE
#define XuCIRCLE 4
#endif
/* primitive_component: Ellipse                                          */
#ifndef XuELLIPSE
#define XuELLIPSE 5
#endif
/* primitive_component: Text                                             */
#ifndef XuTEXT
#define XuTEXT 6
#endif
/* primitive_component: Polygon                                          */
#ifndef XuPOLYGON
#define XuPOLYGON 7
#endif
/* primitive_component: Shaded polygon                                   */
#ifndef XuSHADED_POLYGON
#define XuSHADED_POLYGON 8
#endif
/* primitive_component: Arrow                                            */
#ifndef XuARROW
#define XuARROW 9
#endif
/* primitive_component: Legend box                                       */
#ifndef XuLEGEND_BOX
#define XuLEGEND_BOX 10
#endif
/* primitive_component: Legend texts                                     */
#ifndef XuLEGEND_TEXTS
#define XuLEGEND_TEXTS 11
#endif
/* primitive_component: Legend items                                     */
#ifndef XuLEGEND_ITEMS
#define XuLEGEND_ITEMS 12
#endif
/* primitive_component: User-designed raster symbol                      */
#ifndef XuRASTER_SYMBOL
#define XuRASTER_SYMBOL 13
#endif
/*                                                                       */
/*                                                                       */
/* XuPolygonsDataSize - Query the data size of the fundamental geometric */
/*                                                                       */
extern XuType XuCallCnv XuPolygonsDataSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       primitive_component  , /* i   in  Fundamental geometric primitive component    */
  int       *number              , /* i   out Number of bounding polygons    */
  int       *size_int            , /* i   out Size in elements of an integer data array    */
  int       *size_float            /* i   out Size in elements of a floating point data array    */
#endif
);
/*                                                                       */
/* XuPolygonsDataIntQuery - Query the integer data of the fundamental ge */
/*                                                                       */
extern XuType XuCallCnv XuPolygonsDataIntQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       primitive_component  , /* i   in  Fundamental geometric primitive component    */
  int       *num_int_array       , /* ia  out Number of integer data of polygons    */
  int       *int_array             /* ia  out Integer data               */
#endif
);
/*                                                                       */
/* XuPolygonsQuery - Query the bounding polygons of the fundamental geom */
/*                                                                       */
extern XuType XuCallCnv XuPolygonsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       primitive_component  , /* i   in  Fundamental geometric primitive component    */
  int       *num_points_array    , /* ia  out Number of points of polygons    */
  void      *x_array             , /* ra  out X-coordinates of points    */
  void      *y_array               /* ra  out Y-coordinates of points    */
#endif
);
/*                                                                       */
/* XuPolygonsDataFloatQuery - Query the floating point data of the funda */
/*                                                                       */
extern XuType XuCallCnv XuPolygonsDataFloatQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       primitive_component  , /* i   in  Fundamental geometric primitive component    */
  int       *num_float_array     , /* ia  out Number of floating point data of polygons    */
  void      *float_array           /* ra  out Floating point data        */
#endif
);
/*                                                                       */
/* XuPolygonsNumberSize - Query the number and size of the geometric pri */
/*                                                                       */
extern XuType XuCallCnv XuPolygonsNumberSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       primitive_component  , /* i   in  Fundamental geometric primitive component    */
  int       *number              , /* i   out Number of bounding polygons    */
  int       *size                  /* i   out Size in elements of a bounding polygons array    */
#endif
);
/*                                                                       */
/* XuViewPixelToWorld - Transform device pixel addresses to world coordi */
/*                                                                       */
extern XuType XuCallCnv XuViewPixelToWorld (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *x_pix      , /* ia  in  X-pixel addresses                   */
  int       *y_pix      , /* ia  in  Y-pixel addresses                   */
  int       num_points  , /* i   in  Number of coordinates               */
  void      *x_wc       , /* ra  out X-world coordinates                 */
  void      *y_wc         /* ra  out Y-world coordinates                 */
#endif
);
/*                                                                       */
/* XuDrawingAreaQuery - Query drawing area size                          */
/*                                                                       */
extern XuType XuCallCnv XuDrawingAreaQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *width_mm   , /* r   out Drawing area length in X-direction (mm)    */
  XuFloat   *height_mm  , /* r   out Drawing area length in Y-direction (mm)    */
  int       *width_pix  , /* i   out Drawing area length in X-direction (px)    */
  int       *height_pix   /* i   out Drawing area length in Y-direction (px)    */
#endif
);
/*                                                                       */
/* XuColorIndexQuery - Query index of color type                         */
/*                                                                       */
extern XuType XuCallCnv XuColorIndexQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_type  , /* i   in  Color type                          */
  int       *index        /* i   out Index number of entry in table      */
#endif
);
/*                                                                       */
/* XuClassesQuery - Query user-defined class limits                      */
/*                                                                       */
extern XuType XuCallCnv XuClassesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *limit_array , /* ra  out Class limit array                  */
  int       *num_limits    /* i   out Number of class limits             */
#endif
);
/*                                                                       */
/* XuClipQuery - Query clipping mode                                     */
/*                                                                       */
extern XuType XuCallCnv XuClipQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *clip_code   /* i   out Clip code                            */
#endif
);
/*                                                                       */
/* XuColorQuery - Query information from one color entry                 */
/*                                                                       */
extern XuType XuCallCnv XuColorQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       index        , /* i   in  Index number of entry              */
  void      *color_array , /* ra  out Color definition array             */
  void      *hatch_array   /* ra  out Hatching definition array          */
#endif
);
/*                                                                       */
/* XuHitPolygonComplexQuery - Query if a given point is inside, on or ou */
/*                                                                       */
extern XuType XuCallCnv XuHitPolygonComplexQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *xp         , /* ra  in  X polygon coordinates.              */
  void      *yp         , /* ra  in  Y polygon coordinates.              */
  int       num_points  , /* i   in  Number of polygon points            */
  double    x           , /* r   in  X test point coordinate.            */
  double    y           , /* r   in  Y test point coordinate.            */
  int       *inside     , /* l   out Inside flag.                        */
  int       *border       /* l   out Border flag.                        */
#endif
);
/*                                                                       */
/* xp: Break point coordinate                                            */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/* yp: Break point coordinate                                            */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuColorTableQuery - Query color table setup                           */
/*                                                                       */
extern XuType XuCallCnv XuColorTableQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_table_id , /* i   io  Color table number (1--127)     */
  int       *num_vir        , /* i   out Number of color table entries    */
  int       *color_mode     , /* i   out Selected color mode             */
  int       *color_scheme   , /* i   out Color scheme                    */
  XuFloat   *max_level        /* r   out Maximum level of color code     */
#endif
);
/*                                                                       */
/* XuColorTableActiveQuery - Query current active user color table       */
/*                                                                       */
extern XuType XuCallCnv XuColorTableActiveQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_table_id   /* i   out Color table number              */
#endif
);
/*                                                                       */
/* XuColorTableFreeQuery - Query a free color table number               */
/*                                                                       */
extern XuType XuCallCnv XuColorTableFreeQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_table_id   /* i   out Color table number              */
#endif
);
/*                                                                       */
/* XuColorTableSystemActiveQuery - Query current active system color tab */
/*                                                                       */
extern XuType XuCallCnv XuColorTableSystemActiveQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_table_id   /* i   out Color table number              */
#endif
);
/*                                                                       */
/* XuColorTableScopeQuery - Query color table scope                      */
/*                                                                       */
extern XuType XuCallCnv XuColorTableScopeQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_table_id     , /* i   in  Color table number           */
  int       *color_table_scope   /* i   out Color table scope            */
#endif
);
/*                                                                       */
/* color_table_scope: Non-existent color table                           */
#ifndef XuVOID
#define XuVOID 0
#endif
/*                                                                       */
/*                                                                       */
/* XuContextQuery - Query the current graphics context                   */
/*                                                                       */
extern XuType XuCallCnv XuContextQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *context_id   /* i   out Graphics context identifier         */
#endif
);
/*                                                                       */
/* XuColorTypeQuery - Query type of color index                          */
/*                                                                       */
extern XuType XuCallCnv XuColorTypeQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       index       , /* i   in  Color index number                  */
  int       *color_type   /* i   out Color type                          */
#endif
);
/*                                                                       */
/* XuLineStyleQuery - Query line style                                   */
/*                                                                       */
extern XuType XuCallCnv XuLineStyleQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       line_style  , /* i   in  Line style number                   */
  int       *dash_array , /* ia  out Line style specification array      */
  int       *num_dash     /* i   out Length of specification array       */
#endif
);
/*                                                                       */
/* XuColorDeviceQuery - Query device color capabilities                  */
/*                                                                       */
extern XuType XuCallCnv XuColorDeviceQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *num_colors , /* i   out Number of device lookup entries     */
  int       *num_locked , /* i   out Number of locked device lookup entries    */
  int       *num_phy    , /* i   out Physical intensity levels           */
  int       *num_vir      /* i   out Virtual intensity levels            */
#endif
);
/*                                                                       */
/* XuDrawingModeQuery - Query drawing mode                               */
/*                                                                       */
extern XuType XuCallCnv XuDrawingModeQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *mode   /* i   out Drawing mode                              */
#endif
);
/*                                                                       */
/* XuDrawOptionsQuery - Query draw status of all fundamental geometric p */
/*                                                                       */
extern XuType XuCallCnv XuDrawOptionsQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *draw_code   /* i   out Draw status                          */
#endif
);
/*                                                                       */
/* XuLicenseQuery - Inquire license availability                         */
/*                                                                       */
extern XuType XuCallCnv XuLicenseQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *status   /* i   out License status                          */
#endif
);
/*                                                                       */
/* status: License available                                             */
#ifndef XuLICOK
#define XuLICOK 1
#endif
/* status: Trial license available                                       */
#ifndef XuTRIAL
#define XuTRIAL 2
#endif
/* status: Maximum number of licenses reached                            */
#ifndef XuMAXUSER
#define XuMAXUSER 3
#endif
/* status: License expired                                               */
#ifndef XuEXPIRED
#define XuEXPIRED 4
#endif
/* status: Error during license checkout                                 */
#ifndef XuLICERROR
#define XuLICERROR 6
#endif
/*                                                                       */
/*                                                                       */
/* XuClassesNumberQuery - Query user-defined number of class limits      */
/*                                                                       */
extern XuType XuCallCnv XuClassesNumberQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *num_limits   /* i   out Number of class limits              */
#endif
);
/*                                                                       */
/* XuColorByNameQuery - Query list of color names                        */
/*                                                                       */
extern XuType XuCallCnv XuColorByNameQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *name_list , /* ca  out Array of color names                 */
  int       *num_names   /* i   io  Number of color names defined        */
#endif
);
/*                                                                       */
/* XuShadingColorQuery - Query colors used for class shading             */
/*                                                                       */
extern XuType XuCallCnv XuShadingColorQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *shade_array , /* ia  out Packed color indices               */
  int       *num_shades    /* i   out Number of indices                  */
#endif
);
/*                                                                       */
/* XuHitPolygonSimpleQuery - Query if a given point is inside, on or out */
/*                                                                       */
extern XuType XuCallCnv XuHitPolygonSimpleQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *xp         , /* ra  in  X polygon coordinates.              */
  void      *yp         , /* ra  in  Y polygon coordinates.              */
  int       num_points  , /* i   in  Number of polygon points            */
  double    x           , /* r   in  X test point coordinate.            */
  double    y           , /* r   in  Y test point coordinate.            */
  int       *inside     , /* l   out Inside flag.                        */
  int       *border       /* l   out Border flag.                        */
#endif
);
/*                                                                       */
/* XuTextContinueQuery - Query text continuation parameters              */
/*                                                                       */
extern XuType XuCallCnv XuTextContinueQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x     , /* r   out X-coordinate of continuation point       */
  XuFloat   *y     , /* r   out Y-coordinate of continuation point       */
  int       *hjust , /* i   out Horizontal justification                 */
  int       *vjust   /* i   out Vertical Justification                   */
#endif
);
/*                                                                       */
/* hjust: Left justified (default)                                       */
#ifndef XuLEFT
#define XuLEFT 0
#endif
/* hjust: Center justified                                               */
#ifndef XuCENTER
#define XuCENTER 1
#endif
/* hjust: Right justified                                                */
#ifndef XuRIGHT
#define XuRIGHT 2
#endif
/* vjust: Font base (default)                                            */
#ifndef XuFONT_BASE
#define XuFONT_BASE 1
#endif
/* vjust: Physical bottom                                                */
#ifndef XuTEXT_BOTTOM
#define XuTEXT_BOTTOM 5
#endif
/* vjust: Physical bottom                                                */
#ifndef XuTEXT_TOP
#define XuTEXT_TOP 7
#endif
/*                                                                       */
/*                                                                       */
/* XuTextFontDefaultQuery - Query default font names and mode            */
/*                                                                       */
extern XuType XuCallCnv XuTextFontDefaultQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *font_soft , /* c   out Default software font                */
  char      *font_hard , /* c   out Default hardware font                */
  int       *font_mode   /* i   out Default font mode                    */
#endif
);
/*                                                                       */
/* XuTextFontListQuery - Query list of font names                        */
/*                                                                       */
extern XuType XuCallCnv XuTextFontListQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *font_list  , /* ca  out Array of font names                 */
  int       *font_codes , /* ia  out Array of support codes              */
  int       *num_fonts    /* i   io  Number of fonts defined             */
#endif
);
/*                                                                       */
/* font_codes: Both software and hardware font                           */
#ifndef XuBOTH
#define XuBOTH 3
#endif
/*                                                                       */
/*                                                                       */
/* XuTextFontQuery - Query current font name and font mode               */
/*                                                                       */
extern XuType XuCallCnv XuTextFontQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *font_name , /* c   out Font name                            */
  int       *font_mode   /* i   out Font mode                            */
#endif
);
/*                                                                       */
/* XuTextBoxISOQuery - Query ISO values text box parallelogram           */
/*                                                                       */
extern XuType XuCallCnv XuTextBoxISOQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *iso_array , /* ia  in  Array of ISO values                  */
  int       num_iso    , /* i   in  Number of ISO values                 */
  double    x          , /* r   in  X-coordinate of text justification point    */
  double    y          , /* r   in  Y-coordinate of text justification point    */
  void      *x_array   , /* ra  out X-coordinates of text box parallelogram    */
  void      *y_array     /* ra  out Y-coordinates of text box parallelogram    */
#endif
);
/*                                                                       */
/* XuTextLanguageListQuery - Query list of national languages            */
/*                                                                       */
extern XuType XuCallCnv XuTextLanguageListQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *language_list , /* ca  out Array of language names          */
  int       *num_languages   /* i   io  Number of languages defined      */
#endif
);
/*                                                                       */
/* XuTextLanguageQuery - Query current national language                 */
/*                                                                       */
extern XuType XuCallCnv XuTextLanguageQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *language   /* c   out Current language name                 */
#endif
);
/*                                                                       */
/* XuTextBoxFloatQuery - Query number box parallelogram                  */
/*                                                                       */
extern XuType XuCallCnv XuTextBoxFloatQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  double    value        , /* r   in  Floating point number              */
  int       num_decimal  , /* i   in  Number of decimal places           */
  double    x            , /* r   in  X-coordinate of text justification point    */
  double    y            , /* r   in  Y-coordinate of text justification point    */
  void      *x_array     , /* ra  out X-coordinates of text box parallelogram    */
  void      *y_array       /* ra  out Y-coordinates of text box parallelogram    */
#endif
);
/*                                                                       */
/* XuTextBoxQuery - Query text box parallelogram                         */
/*                                                                       */
extern XuType XuCallCnv XuTextBoxQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *string  , /* c   in  Character string                       */
  double    x        , /* r   in  X-coordinate of text justification point    */
  double    y        , /* r   in  Y-coordinate of text justification point    */
  void      *x_array , /* ra  out X-coordinates of text box parallelogram    */
  void      *y_array   /* ra  out Y-coordinates of text box parallelogram    */
#endif
);
/*                                                                       */
/* XuTextBoxCLDQuery - Query CLD indices box parallelogram               */
/*                                                                       */
extern XuType XuCallCnv XuTextBoxCLDQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *cld_array , /* ia  in  Array of CLD character indices       */
  int       num_cld    , /* i   in  Number of character indices          */
  double    x          , /* r   in  X-coordinate of text justification point    */
  double    y          , /* r   in  Y-coordinate of text justification point    */
  void      *x_array   , /* ra  out X-coordinates of text box parallelogram    */
  void      *y_array     /* ra  out Y-coordinates of text box parallelogram    */
#endif
);
/*                                                                       */
/* XuUndefinedQuery - Query the ``undefined2 and color index             */
/*                                                                       */
extern XuType XuCallCnv XuUndefinedQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *value       , /* r   out ``Undefined'' value                */
  int       *color_index   /* i   out Color index of the ``undefined'' value    */
#endif
);
/*                                                                       */
/* XuViewWallQuery - Query currently active wall projection              */
/*                                                                       */
extern XuType XuCallCnv XuViewWallQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *x_axis  , /* i   out Reference axis for world coord.\ X-axis    */
  int       *y_axis  , /* i   out Reference axis for world coord.\ Y-axis    */
  int       *z_axis  , /* i   out Reference axis for world coord.\ Z-axis    */
  XuFloat   *z_value   /* r   out Z coordinate for wall projections      */
#endif
);
/*                                                                       */
/* XuWindowQuery - Query currently selected window/pixmap for drawing    */
/*                                                                       */
extern XuType XuCallCnv XuWindowQuery (
#if NeedFunctionPrototypes
/*                                                                       */
#ifndef WIN32
  Drawable  *drawable   /* w   out Window or pixmap id for drawable to use    */
#else
  HDC       *drawable   /* w   out Window or pixmap id for drawable to use    */
#endif
#endif
);
/*                                                                       */
/* XuWindowColorQuery - Query X Window color information                 */
/*                                                                       */
extern XuType XuCallCnv XuWindowColorQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       index        , /* i   in  Color index                        */
  int       *pixel_index , /* i   out \ProductNameX Window color pixel value    */
  int       *pixmap        /* i   out \ProductNameX Window color pixmap    */
#endif
);
/*                                                                       */
/* XuOpenAdvancedQuery - Query UNIRAS advanced open options              */
/*                                                                       */
extern XuType XuCallCnv XuOpenAdvancedQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_options  , /* i   in  Number of options given in options.    */
  int       *options       /* ia  out Options array.                     */
#endif
);
/*                                                                       */
/* XuRectangleDraw - Draw rectangle                                      */
/*                                                                       */
extern XuType XuCallCnv XuRectangleDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x_low        , /* r   in  X-coordinates of lower left corner    */
  double    y_low        , /* r   in  Y-coordinates of lower left corner    */
  double    x_up         , /* r   in  X-coordinates of upper right corner    */
  double    y_up         , /* r   in  Y-coordinates of upper right corner    */
  int       color_index  , /* i   in  Color index used to fill rectangle    */
  double    frame_width    /* r   in  Width of rectangle frame (mm)      */
#endif
);
/*                                                                       */
/* XuUPIFormattedfileRead - Convert formatted segment file               */
/*                                                                       */
extern XuType XuCallCnv XuUPIFormattedfileRead (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *filename , /* c   in  Formatted file name                   */
  int       nr          /* i   in  Segment identification number         */
#endif
);
/*                                                                       */
/* XuUPIFormattedfileWrite - Convert binary segment file                 */
/*                                                                       */
extern XuType XuCallCnv XuUPIFormattedfileWrite (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *filename , /* c   in  Formatted file name                   */
  int       nr          /* i   in  Segment identification number         */
#endif
);
/*                                                                       */
/* XuShadingColorData - Set shading by color data                        */
/*                                                                       */
extern XuType XuCallCnv XuShadingColorData (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuShadingColorIndices - Apply color indices for shading               */
/*                                                                       */
extern XuType XuCallCnv XuShadingColorIndices (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_indices , /* ia  in  Color indices                    */
  int       num_colors       /* i   in  Number of indices                */
#endif
);
/*                                                                       */
/* XuShadingScale - Apply a shading scale                                */
/*                                                                       */
extern XuType XuCallCnv XuShadingScale (
#if NeedFunctionPrototypes
/*                                                                       */
  int       scale_id    /* i   in  Shading scale id number (1--25)       */
#endif
);
/*                                                                       */
/* XuShadingColorTable - Apply colors from a table for shading           */
/*                                                                       */
extern XuType XuCallCnv XuShadingColorTable (
#if NeedFunctionPrototypes
/*                                                                       */
  int       start_index  , /* i   in  Start color                        */
  int       num_colors     /* i   in  Number of consecutive colors       */
#endif
);
/*                                                                       */
/* XuMessageTypes - Set long and short messages on/off                   */
/*                                                                       */
extern XuType XuCallCnv XuMessageTypes (
#if NeedFunctionPrototypes
/*                                                                       */
  int       short_code  , /* i   in  Short messages display mode         */
  int       long_code     /* i   in  Long messages display mode          */
#endif
);
/*                                                                       */
/* XuShadingLegendDraw - Draw shading scale legend                       */
/*                                                                       */
extern XuType XuCallCnv XuShadingLegendDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x_origin  , /* r   in  X position of origin                  */
  double    y_origin  , /* r   in  Y position of origin                  */
  int       type        /* i   in  Legend type                           */
#endif
);
/*                                                                       */
/* type: Each class range has it's own separate                          */
#ifndef XuSTEPPED
#define XuSTEPPED 0
#endif
/* type: Continuous shaded color bar with class                          */
#ifndef XuCONTINUOUS
#define XuCONTINUOUS 1
#endif
/* type: Isolines with numbers at the right                              */
#ifndef XuISOLINE
#define XuISOLINE 2
#endif
/*                                                                       */
/*                                                                       */
/* XuShadingLegendOptions - Set options for shading scale legend         */
/*                                                                       */
extern XuType XuCallCnv XuShadingLegendOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *strings     , /* ca  in  Legend Text                        */
  int       mxstrings    , /* i   in  Maximum length of text strings in    */
  double    height       , /* r   in  Height in mm of text used for      */
  int       num_decimal  , /* i   in  Number of decimal places           */
  double    angle        , /* r   in  Plot direction (degrees),          */
  int       class_code     /* i   in  Class ordering                     */
#endif
);
/*                                                                       */
/* num_decimal: Default number of decimal places                         */
#ifndef XuDEFAULT_DECIMAL
#define XuDEFAULT_DECIMAL -1
#endif
/*                                                                       */
/*                                                                       */
/* XuShadingLegendSizeQuery - Return size of shading scale legend        */
/*                                                                       */
extern XuType XuCallCnv XuShadingLegendSizeQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x_size , /* r   out Size in X direction                     */
  XuFloat   *y_size , /* r   out Size in Y direction                     */
  int       type      /* i   in  Legend type                             */
#endif
);
/*                                                                       */
/* XuShadingLegendUserDraw - Draw shading scale legend with user-defined */
/*                                                                       */
extern XuType XuCallCnv XuShadingLegendUserDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x_origin      , /* r   in  X position of origin              */
  double    y_origin      , /* r   in  Y position of origin              */
  int       type          , /* i   in  Legend type                       */
  void      *text_array   , /* ca  in  Series of legend text             */
  int       num_text      , /* i   in  Total number of                   */
  int       mxtext_array    /* i   in  Maximum length of                 */
#endif
);
/*                                                                       */
/* XuShadingLegendUserOptions - Set options for shading scale legend wit */
/*                                                                       */
extern XuType XuCallCnv XuShadingLegendUserOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       type                  , /* i   in  Legend type               */
  double    height                , /* r   in  Height in mm of legend text    */
  double    height_scale          , /* r   in  Height scaling factor     */
  double    length_scale          , /* r   in  Length scaling factor     */
  double    vertical_gap_scale    , /* r   in  Vertical gap scaling factor    */
  double    horizontal_gap_scale  , /* r   in  Horizontal gap scaling factor    */
  double    angle                 , /* r   in  Legend rotation (degrees)    */
  int       class_order             /* i   in  Class ordering            */
#endif
);
/*                                                                       */
/* height: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* height_scale: Ignore argument                                         */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* length_scale: Ignore argument                                         */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* vertical_gap_scale: Ignore argument                                   */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* horizontal_gap_scale: Ignore argument                                 */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* angle: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuShadingLegendUserSizeQuery - Return size of shading scale legend wi */
/*                                                                       */
extern XuType XuCallCnv XuShadingLegendUserSizeQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  XuFloat   *x_size       , /* r   out Size in X direction               */
  XuFloat   *y_size       , /* r   out Size in Y direction               */
  int       type          , /* i   in  Legend type                       */
  void      *text_array   , /* ca  in  Series of legend text             */
  int       num_text      , /* i   in  Total number of                   */
  int       mxtext_array    /* i   in  Maximum length of                 */
#endif
);
/*                                                                       */
/* XuContourSampling - Set sampling density for bilinear contour generat */
/*                                                                       */
extern XuType XuCallCnv XuContourSampling (
#if NeedFunctionPrototypes
/*                                                                       */
  double    density    /* r   in  Sampling density                       */
#endif
);
/*                                                                       */
/* XuPolygonDraw - Draw polygon                                          */
/*                                                                       */
extern XuType XuCallCnv XuPolygonDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array     , /* ra  in  User-declared array of X coordinates    */
  void      *y_array     , /* ra  in  User-declared array of Y coordinates    */
  int       num_points   , /* i   in  Number of points that define polygon    */
  int       color_index  , /* i   in  Color index used to fill polygon    */
  double    frame_width    /* r   in  Width of polygon frame (mm)        */
#endif
);
/*                                                                       */
/* x_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/* y_array: Break point coordinate                                       */
#ifndef XuF_BREAK
#define XuF_BREAK 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuPolygonShadeDraw - Draw a shaded quadric surface                    */
/*                                                                       */
extern XuType XuCallCnv XuPolygonShadeDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array       , /* ra  in  X coordinates of vertices        */
  void      *y_array       , /* ra  in  Y coordinates of vertices        */
  void      *shading_array , /* ra  in  Shading values of vertices       */
  double    frame_width      /* r   in  Width of surface frame (mm or pixels)    */
#endif
);
/*                                                                       */
/* XuPolygonMemorySize - Set polygon memory size used for host           */
/*                                                                       */
extern XuType XuCallCnv XuPolygonMemorySize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       num_words    /* i   in  Max size of polygon work memory in computer words    */
#endif
);
/*                                                                       */
/* XuWindowSelect - Select window/pixmap for drawing                     */
/*                                                                       */
extern XuType XuCallCnv XuWindowSelect (
#if NeedFunctionPrototypes
/*                                                                       */
#ifndef WIN32
  Drawable  drawable    /* w   in  Window or pixmap id for drawable to use    */
#else
  HDC       drawable    /* w   in  Window or pixmap id for drawable to use    */
#endif
#endif
);
/*                                                                       */
/* XuWindowRasterSelect - Select raster device for X Window              */
/*                                                                       */
extern XuType XuCallCnv XuWindowRasterSelect (
#if NeedFunctionPrototypes
/*                                                                       */
  int       width          , /* i   in  Width of raster drawing area.    */
  int       height         , /* i   in  Height of raster drawing area.    */
  double    pix_width_mm   , /* r   in  Width of one pixel in millimeters.    */
  double    pix_height_mm  , /* r   in  Height of one pixel in millimeters.    */
  int       depth            /* i   in  Preferred depth of raster drawing area.    */
#endif
);
/*                                                                       */
/* XuTextDraw - Draw text                                                */
/*                                                                       */
extern XuType XuCallCnv XuTextDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *string , /* c   in  Character string                        */
  double    x       , /* r   in  X-coordinate of text justification point    */
  double    y         /* r   in  Y-coordinate of text justification point    */
#endif
);
/*                                                                       */
/* XuTextAngle - Set text angle                                          */
/*                                                                       */
extern XuType XuCallCnv XuTextAngle (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle    /* r   in  Angle of text (degrees)                  */
#endif
);
/*                                                                       */
/* XuTextBoldness - Set character boldness                               */
/*                                                                       */
extern XuType XuCallCnv XuTextBoldness (
#if NeedFunctionPrototypes
/*                                                                       */
  double    boldness    /* r   in  Character boldness factor for text    */
#endif
);
/*                                                                       */
/* XuTextContinueDraw - Draw continuation text                           */
/*                                                                       */
extern XuType XuCallCnv XuTextContinueDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *string   /* c   in  Character string                        */
#endif
);
/*                                                                       */
/* XuTextColor - Set character color                                     */
/*                                                                       */
extern XuType XuCallCnv XuTextColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       frame_color  , /* i   in  Color index for line part of text    */
  int       fill_color     /* i   in  Color index for filled areas in text    */
#endif
);
/*                                                                       */
/* XuTextExpansion - Set character expansion factor                      */
/*                                                                       */
extern XuType XuCallCnv XuTextExpansion (
#if NeedFunctionPrototypes
/*                                                                       */
  double    expansion    /* r   in  Expansion factor (relative units)    */
#endif
);
/*                                                                       */
/* XuTextFont - Set text font and mode                                   */
/*                                                                       */
extern XuType XuCallCnv XuTextFont (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *font_name , /* c   in  Font name                            */
  int       font_mode    /* i   in  Font mode                            */
#endif
);
/*                                                                       */
/* XuTextHeight - Set character height                                   */
/*                                                                       */
extern XuType XuCallCnv XuTextHeight (
#if NeedFunctionPrototypes
/*                                                                       */
  double    height    /* r   in  Character height (mm)                   */
#endif
);
/*                                                                       */
/* XuTextISODraw - Draw text from ISO values                             */
/*                                                                       */
extern XuType XuCallCnv XuTextISODraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *iso_array , /* ia  in  Array of ISO values                  */
  int       num_iso    , /* i   in  Number of ISO values                 */
  double    x          , /* r   in  X-coordinate of text justification point    */
  double    y            /* r   in  Y-coordinate of text justification point    */
#endif
);
/*                                                                       */
/* XuTextISOToText - Convert ISO values to character string              */
/*                                                                       */
extern XuType XuCallCnv XuTextISOToText (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *iso_array     , /* ia  in  Array of ISO values              */
  int       num_iso        , /* i   in  Number of ISO values to convert    */
  int       *string_length , /* i   out Number of output characters      */
  char      *string        , /* c   out Character representation of ISO values    */
  int       max_length       /* i   in  Length of string                 */
#endif
);
/*                                                                       */
/* XuTextISOContinueDraw - Draw continuation text from ISO values        */
/*                                                                       */
extern XuType XuCallCnv XuTextISOContinueDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *iso_array , /* ia  in  Array of ISO values                  */
  int       num_iso      /* i   in  Number of ISO values                 */
#endif
);
/*                                                                       */
/* XuTextJustification - Set text justification                          */
/*                                                                       */
extern XuType XuCallCnv XuTextJustification (
#if NeedFunctionPrototypes
/*                                                                       */
  int       just_horizontal  , /* i   in  Horizontal justification       */
  int       just_vertical      /* i   in  Vertical justification         */
#endif
);
/*                                                                       */
/* just_vertical: Font bottom                                            */
#ifndef XuFONT_BOTTOM
#define XuFONT_BOTTOM 0
#endif
/* just_vertical: Font half                                              */
#ifndef XuFONT_HALF
#define XuFONT_HALF 2
#endif
/* just_vertical: Font cap                                               */
#ifndef XuFONT_CAP
#define XuFONT_CAP 3
#endif
/* just_vertical: Font top                                               */
#ifndef XuFONT_TOP
#define XuFONT_TOP 4
#endif
/* just_vertical: Physical text half                                     */
#ifndef XuTEXT_HALF
#define XuTEXT_HALF 6
#endif
/*                                                                       */
/*                                                                       */
/* XuTextLanguage - Set national language translation                    */
/*                                                                       */
extern XuType XuCallCnv XuTextLanguage (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *language   /* c   in  National language name                */
#endif
);
/*                                                                       */
/* XuTextMultilineOptions - Set multiline text options                   */
/*                                                                       */
extern XuType XuCallCnv XuTextMultilineOptions (
#if NeedFunctionPrototypes
/*                                                                       */
  int       justify  , /* i   in  Justification of multiline text        */
  double    spacing    /* r   in  Spacing between multiline text lines    */
#endif
);
/*                                                                       */
/* justify: Any line is expanded to the same length as the               */
#ifndef XuBLOCK
#define XuBLOCK 3
#endif
/*                                                                       */
/*                                                                       */
/* XuTextFloatDraw - Draw floating point number                          */
/*                                                                       */
extern XuType XuCallCnv XuTextFloatDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    value        , /* r   in  Floating point number to be drawn    */
  int       num_decimal  , /* i   in  Number of decimal places           */
  double    x            , /* r   in  X-coordinate of text justification point    */
  double    y              /* r   in  Y-coordinate of text justification point    */
#endif
);
/*                                                                       */
/* XuTextFloatToISO - Convert floating point text to ISO values          */
/*                                                                       */
extern XuType XuCallCnv XuTextFloatToISO (
#if NeedFunctionPrototypes
/*                                                                       */
  double    value        , /* r   in  Floating point number to convert    */
  int       num_decimal  , /* i   in  Number of decimals                 */
  int       *iso_array   , /* ia  out Array of ISO values                */
  int       *num_iso       /* i   out Number of ISO values               */
#endif
);
/*                                                                       */
/* XuTextFloatFormat - Set floating point format                         */
/*                                                                       */
extern XuType XuCallCnv XuTextFloatFormat (
#if NeedFunctionPrototypes
/*                                                                       */
  int       code   , /* i   in  Index of option to be set                */
  char      *value   /* c   in  Option character                         */
#endif
);
/*                                                                       */
/* code: This character will act as decimal point                        */
#ifndef XuDECIMAL_POINT
#define XuDECIMAL_POINT 1
#endif
/* code: This character will act as plus sign                            */
#ifndef XuPLUS_SIGN
#define XuPLUS_SIGN 2
#endif
/* code: This character will act as minus sign                           */
#ifndef XuMINUS_SIGN
#define XuMINUS_SIGN 3
#endif
/* code: This character will act as three--digit--spacer                 */
#ifndef XuTHREE_DIGIT_SPACER
#define XuTHREE_DIGIT_SPACER 4
#endif
/* code: This character indicates the floating point                     */
#ifndef XuFLOAT_FORMAT
#define XuFLOAT_FORMAT 5
#endif
/* code: This character indicates the integer                            */
#ifndef XuINT_FORMAT
#define XuINT_FORMAT 6
#endif
/* code: This character indicates the format of the                      */
#ifndef XuEXP_FORMAT
#define XuEXP_FORMAT 7
#endif
/* code: This character steers trailing zeros.                           */
#ifndef XuTRAILING_ZEROS
#define XuTRAILING_ZEROS 8
#endif
/*                                                                       */
/*                                                                       */
/* XuTextFloatContinueDraw - Draw continuation number                    */
/*                                                                       */
extern XuType XuCallCnv XuTextFloatContinueDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  double    value        , /* r   in  Floating point number to be drawn    */
  int       num_decimal    /* i   in  Number of decimal places           */
#endif
);
/*                                                                       */
/* XuTextPath - Set text path                                            */
/*                                                                       */
extern XuType XuCallCnv XuTextPath (
#if NeedFunctionPrototypes
/*                                                                       */
  int       path_code    /* i   in  Path type for text drawing           */
#endif
);
/*                                                                       */
/* path_code: Text path from left to right (default)                     */
#ifndef XuPATH_RIGHT
#define XuPATH_RIGHT 0
#endif
/* path_code: Text path right to left                                    */
#ifndef XuPATH_LEFT
#define XuPATH_LEFT 1
#endif
/* path_code: Text path from bottom to top                               */
#ifndef XuPATH_UP
#define XuPATH_UP 2
#endif
/* path_code: Text path from top to bottom                               */
#ifndef XuPATH_DOWN
#define XuPATH_DOWN 3
#endif
/*                                                                       */
/*                                                                       */
/* XuTextToISO - Convert text to ISO values                              */
/*                                                                       */
extern XuType XuCallCnv XuTextToISO (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *string        , /* c   in  Character string                 */
  int       *iso_array     , /* ia  out Array of ISO values              */
  int       *num_iso         /* i   out Number of ISO values             */
#endif
);
/*                                                                       */
/* XuTextEscChar - Set text escape characters                            */
/*                                                                       */
extern XuType XuCallCnv XuTextEscChar (
#if NeedFunctionPrototypes
/*                                                                       */
  int       escape_code    , /* i   in  Escape code to be changed        */
  char      *esc_character   /* c   in  New escape character             */
#endif
);
/*                                                                       */
/* escape_code: This character will make next character subscript        */
#ifndef XuSUBSCRIPT
#define XuSUBSCRIPT -1
#endif
/* escape_code: This character will make next character superscript      */
#ifndef XuSUPERSCRIPT
#define XuSUPERSCRIPT -2
#endif
/* escape_code: This character followed by a CLD index will draw a CLD   */
#ifndef XuCLD_INDEX
#define XuCLD_INDEX -5
#endif
/* escape_code: This character will make a backspace                     */
#ifndef XuBACKSPACE
#define XuBACKSPACE -6
#endif
/* escape_code: This character will act as string terminator             */
#ifndef XuTERMINATOR
#define XuTERMINATOR -7
#endif
/* escape_code: This character followed by a number (0--255) will draw   */
#ifndef XuISO_INDEX
#define XuISO_INDEX -8
#endif
/* escape_code: This character will act as a carriage return plus a      */
#ifndef XuNEWLINE
#define XuNEWLINE -9
#endif
/* escape_code: Resets all escape characters to undefined                */
#ifndef XuNO_ESCAPE
#define XuNO_ESCAPE -10
#endif
/* escape_code: Saves the current escape character setting               */
#ifndef XuSAVE
#define XuSAVE -11
#endif
/* escape_code: Restores saved escape character setting                  */
#ifndef XuRESTORE
#define XuRESTORE -12
#endif
/*                                                                       */
/*                                                                       */
/* XuTextSkew - Set character skew angle                                 */
/*                                                                       */
extern XuType XuCallCnv XuTextSkew (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle    /* r   in  Skew angle of text (degrees)             */
#endif
);
/*                                                                       */
/* XuTextSpacingFac - Set character spacing factor                       */
/*                                                                       */
extern XuType XuCallCnv XuTextSpacingFac (
#if NeedFunctionPrototypes
/*                                                                       */
  double    space_factor    /* r   in  Spacing factor (relative units)    */
#endif
);
/*                                                                       */
/* XuTextSpacingMode - Set character spacing mode                        */
/*                                                                       */
extern XuType XuCallCnv XuTextSpacingMode (
#if NeedFunctionPrototypes
/*                                                                       */
  int       space_mode    /* i   in  Spacing mode for text drawing       */
#endif
);
/*                                                                       */
/* space_mode: Proportional spacing                                      */
#ifndef XuPROPORTIONAL
#define XuPROPORTIONAL 0
#endif
/* space_mode: Fixed spacing based on font width                         */
#ifndef XuFIXED_FONT
#define XuFIXED_FONT 1
#endif
/* space_mode: Kerning applied                                           */
#ifndef XuKERNED
#define XuKERNED 2
#endif
/* space_mode: Fixed spacing based on character height                   */
#ifndef XuFIXED_HEIGHT
#define XuFIXED_HEIGHT 3
#endif
/*                                                                       */
/*                                                                       */
/* XuTextCLDDraw - Draw text from CLD character indices                  */
/*                                                                       */
extern XuType XuCallCnv XuTextCLDDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *cld_array , /* ia  in  Array of CLD character indices       */
  int       num_cld    , /* i   in  Number of character indices          */
  double    x          , /* r   in  X-coordinate of text justification point    */
  double    y            /* r   in  Y-coordinate of text justification point    */
#endif
);
/*                                                                       */
/* XuTextCLDContinueDraw - Draw continuation text from CLD indices       */
/*                                                                       */
extern XuType XuCallCnv XuTextCLDContinueDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *cld_array , /* ia  in  Array of CLD character indices       */
  int       num_cld      /* i   in  Number of CLD character indices      */
#endif
);
/*                                                                       */
/* XuTextOrientationVector - Set character base and up vectors           */
/*                                                                       */
extern XuType XuCallCnv XuTextOrientationVector (
#if NeedFunctionPrototypes
/*                                                                       */
  double    base_x  , /* r   in  X-coordinate of character base vector    */
  double    base_y  , /* r   in  Y-coordinate of character base vector    */
  double    up_x    , /* r   in  X-coordinate of character up vector     */
  double    up_y      /* r   in  Y-coordinate of character up vector     */
#endif
);
/*                                                                       */
/* XuLineStyleUserLoad - Load user defined line style                    */
/*                                                                       */
extern XuType XuCallCnv XuLineStyleUserLoad (
#if NeedFunctionPrototypes
/*                                                                       */
  int       line_style  , /* i   in  Line style index                    */
  int       *dash_array , /* ia  in  Line style specification            */
  int       num_dash      /* i   in  Length of specification             */
#endif
);
/*                                                                       */
/* XuUndefined - Set the ``undefined3 and color index                    */
/*                                                                       */
extern XuType XuCallCnv XuUndefined (
#if NeedFunctionPrototypes
/*                                                                       */
  double    value        , /* r   in  ``Undefined'' value                */
  int       color_index    /* i   in  Color index of the ``undefined'' value    */
#endif
);
/*                                                                       */
/* XuWait - Wait a number of seconds                                     */
/*                                                                       */
extern XuType XuCallCnv XuWait (
#if NeedFunctionPrototypes
/*                                                                       */
  double    seconds    /* r   in  Number of seconds to wait              */
#endif
);
/*                                                                       */
/* XuViewWall - Activate wall projection scaling                         */
/*                                                                       */
extern XuType XuCallCnv XuViewWall (
#if NeedFunctionPrototypes
/*                                                                       */
  int       x_axis   , /* i   in  Reference axis for world coord.\ X-axis    */
  int       y_axis   , /* i   in  Reference axis for world coord.\ Y-axis    */
  int       z_axis   , /* i   in  Reference axis for world coord.\ Z-axis    */
  double    z_value    /* r   in  Z coordinate for wall projections      */
#endif
);
/*                                                                       */
/* XuViewWorldToPixel - Transform device pixel addresses from world coor */
/*                                                                       */
extern XuType XuCallCnv XuViewWorldToPixel (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_wc       , /* ra  in  World X-coordinates                 */
  void      *y_wc       , /* ra  in  World Y-coordinates                 */
  int       num_points  , /* i   in  Number of coordinates               */
  int       *x_pix      , /* ia  out Pixel X-addresses                   */
  int       *y_pix        /* ia  out Pixel Y-addresses                   */
#endif
);
/*                                                                       */
/* XuWindowSize - Set window size                                        */
/*                                                                       */
extern XuType XuCallCnv XuWindowSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       width_pix   , /* i   in  Drawing area length in X-direction (px)    */
  int       height_pix    /* i   in  Drawing area length in Y-direction (px)    */
#endif
);
/*                                                                       */
/* XuLogoCreate - Create a logo file from a UNIPICT segment              */
/*                                                                       */
extern XuType XuCallCnv XuLogoCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *file_name , /* c   in  Logo file name                       */
  int       id           /* i   in  Segment identification number        */
#endif
);
/*                                                                       */
/* XuOpenAdvanced - Open UNIRAS with advanced options                    */
/*                                                                       */
extern XuType XuCallCnv XuOpenAdvanced (
#if NeedFunctionPrototypes
/*                                                                       */
#ifndef WIN32
  Display   *connection_id , /* xp  in  Connection identifier.           */
#else
  HWND      connection_id , /* xp  in  Connection identifier.            */
#endif
  int       num_options    , /* i   in  Number of options given in options.    */
  int       *options         /* ia  io  Options array.                   */
#endif
);
/*                                                                       */
/* options: Black and white dithering with 9 patterns.                   */
#ifndef XuMONOCHROME
#define XuMONOCHROME 2
#endif
/* options: Color dithering with 125 patterns.                           */
#ifndef XuDITHER
#define XuDITHER 3
#endif
/* options: Request use of best standard color map if                    */
#ifndef XuBEST
#define XuBEST 4
#endif
/* options: Create private PseudoColor colormap (if possible).           */
#ifndef XuPRIVATE
#define XuPRIVATE 5
#endif
/* options: Create private TrueColor or Static* colormap                 */
#ifndef XuSTATIC
#define XuSTATIC 6
#endif
/* options: \PP{options}[5] contains an {\tt XStandardColormap}          */
#ifndef XuSTANDARD
#define XuSTANDARD 7
#endif
/*                                                                       */
/*                                                                       */
/* XuUPIFile - Set name for UNIPICT file                                 */
/*                                                                       */
extern XuType XuCallCnv XuUPIFile (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *file_name   /* c   in  Filename                             */
#endif
);
/*                                                                       */
/* XuValueToClass - Transform data value to class number                 */
/*                                                                       */
extern int XuCallCnv XuValueToClass (
#if NeedFunctionPrototypes
/*                                                                       */
  double    value    /* r   in  Data value                               */
#endif
);
/*                                                                       */
/* XuViewWorldToMM - Transform 2D world coordinates to ``millimeter      */
/*                                                                       */
extern XuType XuCallCnv XuViewWorldToMM (
#if NeedFunctionPrototypes
/*                                                                       */
  int       option      , /* i   in  Conversion option                   */
  void      *x_array    , /* ra  io  X world coordinates (In),\\         */
  void      *y_array    , /* ra  io  Y world coordinates (In),\\         */
  int       num_points    /* i   in  Number of points to be transformed    */
#endif
);
/*                                                                       */
/* XuViewWorldToPC - Transform 2D world coordinates to plot coordinates  */
/*                                                                       */
extern XuType XuCallCnv XuViewWorldToPC (
#if NeedFunctionPrototypes
/*                                                                       */
  int       option      , /* i   in  Conversion option                   */
  void      *x_array    , /* ra  io  X world coordinates (In),\\         */
  void      *y_array    , /* ra  io  Y world coordinates (In),\\         */
  int       num_points    /* i   in  Number of points to be transformed    */
#endif
);

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agxgra_h */
