/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under CVS/RCS control in:
//      $Id: //depot/express/fcs70/include/agx/agxima.h#1 $
//
// UNIRAS function declarations for IMA
//--------------------------------------------------------------------*/

#ifndef _agxima_h
#define _agxima_h

#ifndef _agx64_h
#ifndef _agx32_h
#include <agX/agx32.h>
#endif
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif
/*                                                                       */
/* XuScanFloatDraw - Draw raster scan from real data                     */
/*                                                                       */
extern XuType XuCallCnv XuScanFloatDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *data_array , /* ra  in  Image input data along one scan line    */
  int       num_data    , /* i   in  Number of grid points in scan line    */
  int       code          /* i   in  Options                             */
#endif
);
/*                                                                       */
/* code: Initialization, no scan line is drawn.                          */
#ifndef XuINITIALIZE
#define XuINITIALIZE 0
#endif
/* code: Draw next scan line.                                            */
#ifndef XuDRAW_SCAN
#define XuDRAW_SCAN 1
#endif
/* code: Termination, no scan line is drawn.                             */
#ifndef XuTERMINATE
#define XuTERMINATE 9999
#endif
/* code: No data exists for this scan line.                              */
#ifndef XuSKIP_SCAN
#define XuSKIP_SCAN -1
#endif
/*                                                                       */
/*                                                                       */
/* XuScanIntDraw - Draw raster scan from integer data                    */
/*                                                                       */
extern XuType XuCallCnv XuScanIntDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *int_array , /* ia  in  Image input data along one scan line    */
  int       num_int    , /* i   in  Number of grid points in scan line    */
  int       code         /* i   in  Options                              */
#endif
);
/*                                                                       */
/* XuScanChannel - Set channel definition                                */
/*                                                                       */
extern XuType XuCallCnv XuScanChannel (
#if NeedFunctionPrototypes
/*                                                                       */
  int       channel_id   , /* i   in  Channel assignment number          */
  double    value_min    , /* r   in  Minimum data value                 */
  double    value_max    , /* r   in  Maximum data value                 */
  int       level        , /* i   in  Intensity level for Z-values       */
  int       index_first  , /* i   in  First data value start index       */
  int       index_step     /* i   in  Data value index step              */
#endif
);
/*                                                                       */
/* XuScanPropagationDirection - Set scan line propagation direction      */
/*                                                                       */
extern XuType XuCallCnv XuScanPropagationDirection (
#if NeedFunctionPrototypes
/*                                                                       */
  int       direction_x  , /* i   in  X-direction of scan line           */
  int       direction_y    /* i   in  Y-direction of scan line           */
#endif
);
/*                                                                       */
/* XuScanGridSize - Set grid size                                        */
/*                                                                       */
extern XuType XuCallCnv XuScanGridSize (
#if NeedFunctionPrototypes
/*                                                                       */
  double    grid_width   , /* r   in  X-direction grid size              */
  double    grid_height    /* r   in  Y-direction grid size              */
#endif
);
/*                                                                       */
/* XuScanOrigin - Set raster scan origin                                 */
/*                                                                       */
extern XuType XuCallCnv XuScanOrigin (
#if NeedFunctionPrototypes
/*                                                                       */
  double    x  , /* r   in  Map origin in X-direction                    */
  double    y    /* r   in  Map origin in Y-direction                    */
#endif
);
/*                                                                       */
/* XuScanDirection - Set horizontal or vertical scanning                 */
/*                                                                       */
extern XuType XuCallCnv XuScanDirection (
#if NeedFunctionPrototypes
/*                                                                       */
  int       direction    /* i   in  Scan direction                       */
#endif
);
/*                                                                       */
/* direction: Horizontal scanning                                        */
#ifndef XuHORIZONTAL
#define XuHORIZONTAL 1
#endif
/* direction: Vertical scanning (def)                                    */
#ifndef XuVERTICAL
#define XuVERTICAL 2
#endif
/*                                                                       */
/*                                                                       */
/* XuScanSize - Set raster scan size                                     */
/*                                                                       */
extern XuType XuCallCnv XuScanSize (
#if NeedFunctionPrototypes
/*                                                                       */
  double    width   , /* r   in  X-direction map size                    */
  double    height    /* r   in  Y-direction map size                    */
#endif
);

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agxima_h */
