/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/TreeP.h#1 $
*/

/* NAME TreeP  */
/* PACK h      */
/* COMP NONE   */
/* VERS 940719 */
/* HIST 1V0    */
/*---------------------------------------------------------------------*/
/*                                                                     */
/*                A V S /  U N I R A S   S O F T W A R E               */
/*                                                                     */
/*     The   contents   of   this   document  are  proprietary  to     */
/*                                                                     */
/*                     A V S / U N I R A S  A/S                        */
/*                                                                     */
/*     and  are  not  to  be  disclosed  to  others  or  used  for     */
/*     purposes  other  than  described  in  agreement  or written     */
/*     approval  of  the  owners.                                      */
/*                                                                     */
/*---------------------------------------------------------------------*/
/* @(#) TreeP.h 1.3 07/27/94 AVS/UNIRAS */
 
#ifndef _TreeP_h
#define _TreeP_h
 
#include <assert.h>
#include <avs/Tree.h>
#include <Xm/ManagerP.h>
 
/*****************************************************************************
                                  Any Defines
 ****************************************************************************/

/*****************************************************************************
                              Type Definitions
 ****************************************************************************/

typedef struct {
    Dimension  *array;
    int         size;
 }  XmVariableArray;

/*****************************************************************************
                          The class record definition
 ****************************************************************************/

typedef struct _XmTreeClassPart {
  XtPointer ignore;
} XmTreeClassPart;

typedef struct _XmTreeClassRec {
  CoreClassPart       core_class;
  CompositeClassPart  composite_class;
  ConstraintClassPart constraint_class;
  XmManagerClassPart  manager_class;
  XmTreeClassPart     tree_class;
} XmTreeClassRec;
extern XmTreeClassRec xmTreeClassRec;
            
/*****************************************************************************
                            The instance structure
 ****************************************************************************/
 
/* Instance part structure */
 
typedef struct {
    Dimension		h_min_space;
    Dimension		v_min_space;
    XmVariableArray	*horizontal;
    XmVariableArray	*vertical;
    Widget		tree_root;
    int			branchStyle;
} XmTreePart;

/* Full instance record structure */

typedef struct _XmTreeRec {
    CorePart        core;
    CompositePart   composite;
    ConstraintPart  constraint;
    XmManagerPart   manager;
    XmTreePart      tree;
}  XmTreeRec;

typedef struct _XmTreeConstraintPart {
  Widget        super_node;
  WidgetList    sub_nodes;
  long          n_sub_nodes;
  long          max_sub_nodes;
  Position      x, y;
} XmTreeConstraintPart;

typedef struct _XmTreeConstraintsRec {
   XmManagerConstraintPart   manager;
   XmTreeConstraintPart      tree;
} XmTreeConstraintsRec, *XmTreeConstraints;

/*****************************************************************************
                       Convenience Function Declarations
 ****************************************************************************/
 
#ifdef __cplusplus  /* Do not leave open across includes */
extern "C" {        /* For C++ V2.0 */
#endif

#ifdef __cplusplus
}  /* For C++ V2.0 */
#endif
 
#endif /* _TreeP_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */

