//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/attrdefs.hxx#1 $
//

// attrdefs.hxx - Definition of all Toolmaster++ attributes
// This file is only to be included in class definition source
// files using one or more of these attributes

//----------------------------------------------------------------------
#ifndef AG_ATTRDEFS_HXX
#define AG_ATTRDEFS_HXX

#ifndef CXXUTIL_STRING_HXX
#include <avs/cxxutl/string.hxx>
#endif

#ifndef CXXUTIL_ARRAY_HXX
#include <avs/cxxutl/array.hxx>
#endif

#ifndef AG_COLOR_HXX
#include "color.hxx"
#endif

#ifndef AG_LSTYLE_HXX
#include "lstyle.hxx"
#endif

#ifndef AG_FONT_HXX
#include "font.hxx"
#endif

#ifndef AG_DISTANCE_HXX
#include "distance.hxx"
#endif

#ifndef AG_FIELD_HXX
#include "field.hxx"
#endif

#ifndef CXXUTIL_TYPEATTR_HXX
#include <avs/cxxutl/typeattr.hxx>
#endif

#ifndef CXXUTIL_PTRATTR_HXX
#include <avs/cxxutl/ptrattr.hxx>
#endif

#ifndef AG_ENUMDEFS_HXX
#include "enumdefs.hxx"
#endif

#ifndef AG_ATTRNAME_HXX
#include "attrname.hxx"
#endif

#ifndef AG_GEOMETRY_HXX
#include "geometry.hxx"
#endif

#ifndef AG_DATAMAP_HXX
#include "datamap.hxx"
#endif

#include <avs/port.h>

#ifdef IRIX6_OBSOLETE
#define AGINT long
#define AGFLOAT double
#else
#define AGINT int
#define AGFLOAT float
#endif

//----------------------------------------------------------------------
// AgAttrColor
//----------------------------------------------------------------------
class AgAttrColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrNnegativeColor
//----------------------------------------------------------------------
class AgAttrNegativeColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrNegativeColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrFillColor
//----------------------------------------------------------------------
class AgAttrFillColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrFillColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLabelBoxFillColor
//----------------------------------------------------------------------
class AgAttrLabelBoxFillColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrLabelBoxFillColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLineStyle
//----------------------------------------------------------------------
class AgAttrLineStyle : public UtPtrAttr<AgLineStyle> {
  public:
    AgAttrLineStyle();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrWidth
//----------------------------------------------------------------------
class AgAttrWidth : public UtAttr<AgDistance> {
  public:
    AgAttrWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrDiameter
//----------------------------------------------------------------------
class AgAttrDiameter : public UtAttr<AgDistance> {
  public:
    AgAttrDiameter();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrExplodeOffset
//----------------------------------------------------------------------
class AgAttrExplodeOffset : public UtAttr<AgDistance> {
  public:
    AgAttrExplodeOffset();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrFrameColor
//----------------------------------------------------------------------
class AgAttrFrameColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrFrameColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLabelBoxFrameColor
//----------------------------------------------------------------------
class AgAttrLabelBoxFrameColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrLabelBoxFrameColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrFrameWidth
//----------------------------------------------------------------------
class AgAttrFrameWidth : public UtAttr<AgDistance> {
  public:
    AgAttrFrameWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrBarFrameWidth
//----------------------------------------------------------------------
class AgAttrBarFrameWidth : public UtAttr<AgDistance> {
  public:
    AgAttrBarFrameWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelBoxFrameWidth
//----------------------------------------------------------------------
class AgAttrLabelBoxFrameWidth : public UtAttr<AgDistance> {
  public:
    AgAttrLabelBoxFrameWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrClip
//----------------------------------------------------------------------
class AgAttrClip : public UtBooleanAttr {
  public:
    AgAttrClip();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrVisibility
//----------------------------------------------------------------------
class AgAttrVisibility : public UtBooleanAttr {
  public:
    AgAttrVisibility();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPriority
//----------------------------------------------------------------------
class AgAttrPriority : public UtAttr<int> {
  public:
    AgAttrPriority();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrBarWidth
//----------------------------------------------------------------------
class AgAttrBarWidth : public UtAttr<AgDistance> {
  public:
    AgAttrBarWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrBarOffset
//----------------------------------------------------------------------
class AgAttrBarOffset : public UtRangeAttr<float> {
  public:
    AgAttrBarOffset();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrBarOffsets
//----------------------------------------------------------------------
class AgAttrBarOffsets : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrBarOffsets();
    // The values must be in the range -1 1
    virtual void _validate();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrClassValues
//----------------------------------------------------------------------
class AgAttrClassValues : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrClassValues();
    // The values must be in the range -1 1
    virtual void _validate();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// Set the transformation matrix which must be defined like
//
//   r11 r12 tx
//   r21 r22 ty
//  ( 0   0   1) This part is not used and may be omitted
//----------------------------------------------------------------------
// AgAttrTransform
//----------------------------------------------------------------------
class AgAttrTransform : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrTransform();
    // There must be at least 6 values in a 2D transform
    virtual void _validate();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrGeometry
//----------------------------------------------------------------------
class AgAttrGeometry : public UtPtrAttr<AgGeometry> {
  public:
    AgAttrGeometry();
    virtual UtBaseAttr *newOf();
    virtual void _validate();
};

//----------------------------------------------------------------------
// AgAttrValues
//----------------------------------------------------------------------
class AgAttrValues : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrValues();
    virtual UtBaseAttr *newOf();
    virtual void _validate();
};

//----------------------------------------------------------------------
// Base class for the X/YValues attributes
//----------------------------------------------------------------------
// AgBaseAttrValues
//----------------------------------------------------------------------
class AgBaseAttrValues : public UtArrAttr<AGFLOAT> {
  public:
    AgBaseAttrValues(const char *name);
    // If not at least 2 values then unset
    virtual void _validate();
};

//----------------------------------------------------------------------
// AgAttrValuesY
//----------------------------------------------------------------------
class AgAttrValuesY : public AgBaseAttrValues {
  public:
    AgAttrValuesY();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrBaseValuesY
//----------------------------------------------------------------------
class AgAttrBaseValuesY : public AgBaseAttrValues {
  public:
    AgAttrBaseValuesY();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrValuesX
//----------------------------------------------------------------------
class AgAttrValuesX : public AgBaseAttrValues {
  public:
    AgAttrValuesX();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLineWidth
//----------------------------------------------------------------------
class AgAttrLineWidth : public UtAttr<AgDistance> {
  public:
    AgAttrLineWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrReferenceValue
//----------------------------------------------------------------------
class AgAttrReferenceValue : public UtAttr<float> {
  public:
    AgAttrReferenceValue();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrColors
//----------------------------------------------------------------------
class AgAttrColors : public UtArrAttr<AgColor> {
  public:
    AgAttrColors();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrGraphColors
//----------------------------------------------------------------------
class AgAttrGraphColors : public UtArrAttr<AgColor> {
  public:
    AgAttrGraphColors();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrScatterSymbols
//----------------------------------------------------------------------
class AgAttrScatterSymbols : public UtArrAttr<UtString> {
  public:
    AgAttrScatterSymbols();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelStrings
//----------------------------------------------------------------------
class AgAttrLabelStrings : public UtArrAttr<UtString> {
  public:
    AgAttrLabelStrings();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrScatterSymbol
//----------------------------------------------------------------------
class AgAttrScatterSymbol : public UtStringAttr {
  public:
    AgAttrScatterSymbol();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelPrefix
//----------------------------------------------------------------------
class AgAttrLabelPrefix : public UtStringAttr {
  public:
    AgAttrLabelPrefix();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelSuffix
//----------------------------------------------------------------------
class AgAttrLabelSuffix : public UtStringAttr {
  public:
    AgAttrLabelSuffix();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrGraphType
//----------------------------------------------------------------------
class AgAttrGraphType : public UtEnumAttr<GraphTypeEnum> {
  public:
    AgAttrGraphType();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrArcType
//----------------------------------------------------------------------
class AgAttrArcType : public UtEnumAttr<ArcTypeEnum> {
  public:
    AgAttrArcType();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrAngleInterval
//----------------------------------------------------------------------
class AgAttrAngleInterval : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrAngleInterval();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrAxleColor
//----------------------------------------------------------------------
class AgAttrAxleColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrAxleColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrArrowColor
//----------------------------------------------------------------------
class AgAttrArrowColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrArrowColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrAxleWidth
//----------------------------------------------------------------------
class AgAttrAxleWidth : public UtAttr<AgDistance> {
  public:
    AgAttrAxleWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelHeight
//----------------------------------------------------------------------
class AgAttrLabelHeight : public UtAttr<AgDistance> {
  public:
    AgAttrLabelHeight();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrTextHeight
//----------------------------------------------------------------------
class AgAttrTextHeight : public UtAttr<AgDistance> {
  public:
    AgAttrTextHeight();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrSymbolHeight
//----------------------------------------------------------------------
class AgAttrSymbolHeight : public UtAttr<AgDistance> {
  public:
    AgAttrSymbolHeight();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPositionX
//----------------------------------------------------------------------
class AgAttrPositionX : public UtAttr<float> {
  public:
    AgAttrPositionX();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPositionY
//----------------------------------------------------------------------
class AgAttrPositionY : public UtAttr<float> {
  public:
    AgAttrPositionY();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPositionR
//----------------------------------------------------------------------
class AgAttrPositionR : public UtAttr<float> {
  public:
    AgAttrPositionR();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPositionT
//----------------------------------------------------------------------
class AgAttrPositionT : public UtAttr<float> {
  public:
    AgAttrPositionT();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPowerExponent
//----------------------------------------------------------------------
class AgAttrPowerExponent : public UtRangeAttr<float> {
  public:
    AgAttrPowerExponent();
    // This may not me zero
    virtual void _validate();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrShiftPosition
//----------------------------------------------------------------------
class AgAttrShiftPosition : public UtRangeAttr<float> {
  public:
    AgAttrShiftPosition();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrScaleTypeX AgAttrScaleTypeY
//----------------------------------------------------------------------
class AgAttrScaleTypeX : public UtEnumAttr<ScaleTypeEnum> {
  public:
    AgAttrScaleTypeX();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};
class AgAttrScaleTypeY : public UtEnumAttr<ScaleTypeEnum> {
  public:
    AgAttrScaleTypeY();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelMode
//----------------------------------------------------------------------
class AgAttrLabelMode : public UtEnumAttr<LabelModeEnum> {
  public:
    AgAttrLabelMode();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelPosition
//----------------------------------------------------------------------
class AgAttrLabelPosition : public UtEnumAttr<LabelPositionEnum> {
  public:
    AgAttrLabelPosition();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrTitle
//----------------------------------------------------------------------
class AgAttrTitle : public UtStringAttr {
  public:
    AgAttrTitle();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrHeight
//----------------------------------------------------------------------
class AgAttrHeight : public UtAttr<AgDistance> {
  public:
    AgAttrHeight();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrUpVector
//----------------------------------------------------------------------
class AgAttrUpVector : public UtPtrAttr<AgGeometry> {
  public:
    AgAttrUpVector();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrBaseVector
//----------------------------------------------------------------------
class AgAttrBaseVector : public UtPtrAttr<AgGeometry> {
  public:
    AgAttrBaseVector();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrAngle
//----------------------------------------------------------------------
class AgAttrAngle : public UtAttr<float> {
  public:
    AgAttrAngle();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrOriginR
//----------------------------------------------------------------------
class AgAttrOriginR : public UtAttr<float> {
  public:
    AgAttrOriginR();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};


//----------------------------------------------------------------------
// AgAttrTitleHeight
//----------------------------------------------------------------------
class AgAttrTitleHeight : public UtAttr<AgDistance> {
  public:
    AgAttrTitleHeight();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrNumColumns
//----------------------------------------------------------------------
class AgAttrNumColumns : public UtMinRangeAttr<int> {
  public:
    AgAttrNumColumns();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrText
//----------------------------------------------------------------------
class AgAttrText : public UtStringAttr {
  public:
    AgAttrText();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrTexts
//----------------------------------------------------------------------
class AgAttrTexts : public UtArrAttr<UtString> {
  public:
    AgAttrTexts();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrFont
//----------------------------------------------------------------------
class AgAttrFont : public UtPtrAttr<AgFont> {
  public:
    AgAttrFont();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLegendText
//----------------------------------------------------------------------
class AgAttrLegendText : public UtStringAttr {
  public:
    AgAttrLegendText();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelColor
//----------------------------------------------------------------------
class AgAttrLabelColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrLabelColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrTitleColor
//----------------------------------------------------------------------
class AgAttrTitleColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrTitleColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrTextColor
//----------------------------------------------------------------------
class AgAttrTextColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrTextColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMajorTickColor
//----------------------------------------------------------------------
class AgAttrMajorTickColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrMajorTickColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMinorTickColor
//----------------------------------------------------------------------
class AgAttrMinorTickColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrMinorTickColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLabelFont
//----------------------------------------------------------------------
class AgAttrLabelFont : public UtPtrAttr<AgFont> {
  public:
    AgAttrLabelFont();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrTextFont
//----------------------------------------------------------------------
class AgAttrTextFont : public UtPtrAttr<AgFont> {
  public:
    AgAttrTextFont();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrSymbolFont
//----------------------------------------------------------------------
class AgAttrSymbolFont : public UtPtrAttr<AgFont> {
  public:
    AgAttrSymbolFont();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMajorTickLineStyle
//----------------------------------------------------------------------
class AgAttrMajorTickLineStyle : public UtPtrAttr<AgLineStyle> {
  public:
    AgAttrMajorTickLineStyle();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMinorTickLineStyle
//----------------------------------------------------------------------
class AgAttrMinorTickLineStyle : public UtPtrAttr<AgLineStyle> {
  public:
    AgAttrMinorTickLineStyle();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorTickWidth
//----------------------------------------------------------------------
class AgAttrMajorTickWidth : public UtAttr<AgDistance> {
  public:
    AgAttrMajorTickWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMinorTickWidth
//----------------------------------------------------------------------
class AgAttrMinorTickWidth : public UtAttr<AgDistance> {
  public:
    AgAttrMinorTickWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorReferenceX
//----------------------------------------------------------------------
class AgAttrMajorReferenceX : public UtAttr<float> {
  public:
    AgAttrMajorReferenceX();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorReferenceY
//----------------------------------------------------------------------
class AgAttrMajorReferenceY : public UtAttr<float> {
  public:
    AgAttrMajorReferenceY();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorReferenceR
//----------------------------------------------------------------------
class AgAttrMajorReferenceR : public UtAttr<float> {
  public:
    AgAttrMajorReferenceR();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorReferenceT
//----------------------------------------------------------------------
class AgAttrMajorReferenceT : public UtAttr<float> {
  public:
    AgAttrMajorReferenceT();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorStepX
//----------------------------------------------------------------------
class AgAttrMajorStepX : public UtMinRangeAttr<float> {
  public:
    AgAttrMajorStepX();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorStepY
//----------------------------------------------------------------------
class AgAttrMajorStepY : public UtMinRangeAttr<float> {
  public:
    AgAttrMajorStepY();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorStepR
//----------------------------------------------------------------------
class AgAttrMajorStepR : public UtMinRangeAttr<float> {
  public:
    AgAttrMajorStepR();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorStepT
//----------------------------------------------------------------------
class AgAttrMajorStepT : public UtMinRangeAttr<float> {
  public:
    AgAttrMajorStepT();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorTickOn
//----------------------------------------------------------------------
class AgAttrMajorTickOn : public UtBooleanAttr {
  public:
    AgAttrMajorTickOn();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMinorTickCount
//----------------------------------------------------------------------
class AgAttrMinorTickCount : public UtMinRangeAttr<int> {
  public:
    AgAttrMinorTickCount();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrNiceLimits
//----------------------------------------------------------------------
class AgAttrNiceLimits : public UtBooleanAttr {
  public:
    AgAttrNiceLimits();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrUniformScaling
//----------------------------------------------------------------------
class AgAttrUniformScaling : public UtBooleanAttr {
  public:
    AgAttrUniformScaling();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLimits
//----------------------------------------------------------------------
class AgAttrLimits : public UtArrAttr<AGFLOAT> {
  protected:
    AgAttrLimits(const char *name);
    // Only accept limits if min and max are different
    virtual void _validate();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLimitsX
//----------------------------------------------------------------------
class AgAttrLimitsX : public AgAttrLimits {
  public:
    AgAttrLimitsX();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLimitsY
//----------------------------------------------------------------------
class AgAttrLimitsY : public AgAttrLimits {
  public:
    AgAttrLimitsY();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLimitsR
//----------------------------------------------------------------------
class AgAttrLimitsR : public AgAttrLimits {
  public:
    AgAttrLimitsR();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLimitsT
//----------------------------------------------------------------------
class AgAttrLimitsT : public AgAttrLimits {
  public:
    AgAttrLimitsT();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLimitsMargin
//----------------------------------------------------------------------
class AgAttrLimitsMargin : public UtArrAttr<AGFLOAT> {
  protected:
    AgAttrLimitsMargin(const char *name);
    // Only accept limits margins which sum is not -100
    virtual void _validate();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLimitsMarginX
//----------------------------------------------------------------------
class AgAttrLimitsMarginX : public AgAttrLimitsMargin {
  public:
    AgAttrLimitsMarginX();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrLimitsMarginY
//----------------------------------------------------------------------
class AgAttrLimitsMarginY : public AgAttrLimitsMargin {
  public:
    AgAttrLimitsMarginY();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMultiLineJustification
//----------------------------------------------------------------------
class AgAttrMultiLineJustification 
    : public UtEnumAttr<MultiLineJustificationEnum> {
  public:
    AgAttrMultiLineJustification();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMultiLineSpacingFactor
//----------------------------------------------------------------------
class AgAttrMultiLineSpacingFactor : public UtAttr<float> {
  public:
    AgAttrMultiLineSpacingFactor();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrHorizontalJustification
//----------------------------------------------------------------------
class AgAttrHorizontalJustification 
    : public UtEnumAttr<HorizontalJustificationEnum> {
  public:
    AgAttrHorizontalJustification();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrVerticalJustification
//----------------------------------------------------------------------
class AgAttrVerticalJustification 
    : public UtEnumAttr<VerticalJustificationEnum> {
  public:
    AgAttrVerticalJustification();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPieLabelJustification
//----------------------------------------------------------------------
class AgAttrPieLabelJustification 
    : public UtEnumAttr<HorizontalJustificationEnum> {
  public:
    AgAttrPieLabelJustification();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPieLabelPosition
//----------------------------------------------------------------------
class AgAttrPieLabelPosition
    : public UtEnumAttr<PieLabelPositionEnum> {
  public:
    AgAttrPieLabelPosition();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrPieLabelContent
//----------------------------------------------------------------------
class AgAttrPieLabelContent
    : public UtEnumAttr<PieLabelContentEnum> {
  public:
    AgAttrPieLabelContent();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrNumClasses
//----------------------------------------------------------------------
class AgAttrNumClasses : public UtRangeAttr<int> {
  public:
    AgAttrNumClasses();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrIsoLineLabelDecimals
//----------------------------------------------------------------------
class AgAttrIsoLineLabelDecimals : public UtRangeAttr<int> {
  public:
    AgAttrIsoLineLabelDecimals();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelDecimals
//----------------------------------------------------------------------
class AgAttrLabelDecimals : public UtRangeAttr<int> {
  public:
    AgAttrLabelDecimals();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrLabelPowerFactor
//----------------------------------------------------------------------
class AgAttrLabelPowerFactor : public UtRangeAttr<int> {
  public:
    AgAttrLabelPowerFactor();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorIsoLineReference
//----------------------------------------------------------------------
class AgAttrMajorIsoLineReference : public UtMinRangeAttr<int> {
  public:
    AgAttrMajorIsoLineReference();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorIsoLineFrequency
//----------------------------------------------------------------------
class AgAttrMajorIsoLineFrequency : public UtMinRangeAttr<int> {
  public:
    AgAttrMajorIsoLineFrequency();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrIsoLineLabelAngleInterval
//----------------------------------------------------------------------
class AgAttrIsoLineLabelAngleInterval : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrIsoLineLabelAngleInterval();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrIsoLineLabelFrequency
//----------------------------------------------------------------------
class AgAttrIsoLineLabelFrequency : public UtMinRangeAttr<int> {
  public:
    AgAttrIsoLineLabelFrequency();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMinorIsoLineWidth
//----------------------------------------------------------------------
class AgAttrMinorIsoLineWidth : public UtAttr<AgDistance> {
  public:
    AgAttrMinorIsoLineWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorIsoLineWidth
//----------------------------------------------------------------------
class AgAttrMajorIsoLineWidth : public UtAttr<AgDistance> {
  public:
    AgAttrMajorIsoLineWidth();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrIsoLineLabelHeight
//----------------------------------------------------------------------
class AgAttrIsoLineLabelHeight : public UtAttr<AgDistance> {
  public:
    AgAttrIsoLineLabelHeight();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrIsoLineLabelDistance
//----------------------------------------------------------------------
class AgAttrIsoLineLabelDistance : public UtAttr<AgDistance> {
  public:
    AgAttrIsoLineLabelDistance();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrIsoLineFeatheringMinDistance
//----------------------------------------------------------------------
class AgAttrIsoLineFeatheringMinDistance : public UtAttr<AgDistance> {
  public:
    AgAttrIsoLineFeatheringMinDistance();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrIsoLineFeatheringMinLength
//----------------------------------------------------------------------
class AgAttrIsoLineFeatheringMinLength : public UtAttr<AgDistance> {
  public:
    AgAttrIsoLineFeatheringMinLength();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorIsoLineColor
//----------------------------------------------------------------------
class AgAttrMajorIsoLineColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrMajorIsoLineColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMinorIsoLineColor
//----------------------------------------------------------------------
class AgAttrMinorIsoLineColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrMinorIsoLineColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrIsoLineLabelColor
//----------------------------------------------------------------------
class AgAttrIsoLineLabelColor : public UtPtrAttr<AgColor> {
  public:
    AgAttrIsoLineLabelColor();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrIsoLineLabelFont
//----------------------------------------------------------------------
class AgAttrIsoLineLabelFont : public UtPtrAttr<AgFont> {
  public:
    AgAttrIsoLineLabelFont();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrTitleFont
//----------------------------------------------------------------------
class AgAttrTitleFont : public UtPtrAttr<AgFont> {
  public:
    AgAttrTitleFont();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMijorIsoLineStyle
//----------------------------------------------------------------------
class AgAttrMinorIsoLineStyle : public UtPtrAttr<AgLineStyle> {
  public:
    AgAttrMinorIsoLineStyle();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrMajorIsoLineStyle
//----------------------------------------------------------------------
class AgAttrMajorIsoLineStyle : public UtPtrAttr<AgLineStyle> {
  public:
    AgAttrMajorIsoLineStyle();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrField
//----------------------------------------------------------------------
class AgAttrField : public UtPtrAttr<AgField> {
  public:
    AgAttrField();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMinClass
//----------------------------------------------------------------------
class AgAttrMinClass : public UtAttr<float> {
  public:
    AgAttrMinClass();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrMaxClass
//----------------------------------------------------------------------
class AgAttrMaxClass : public UtAttr<float> {
  public:
    AgAttrMaxClass();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// AgAttrContourType
//----------------------------------------------------------------------
class AgAttrContourType : public UtEnumAttr<ContourTypeEnum> {
  public:
    AgAttrContourType();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrDataMapper
//----------------------------------------------------------------------
class AgAttrDataMapper : public UtPtrAttr<AgDataMapper> {
  public:
    AgAttrDataMapper();
    virtual UtBaseAttr *newOf();
};

//----------------------------------------------------------------------
// Attributes which are return values only
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// AgAttrUsedLimitsX
//----------------------------------------------------------------------
class AgAttrUsedLimitsX : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrUsedLimitsX();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};
//----------------------------------------------------------------------
// AgAttrUsedLimitsY
//----------------------------------------------------------------------
class AgAttrUsedLimitsY : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrUsedLimitsY();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttrUsedLimitsR
//----------------------------------------------------------------------
class AgAttrUsedLimitsR : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrUsedLimitsR();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};
//----------------------------------------------------------------------
// AgAttrUsedLimitsT
//----------------------------------------------------------------------
class AgAttrUsedLimitsT : public UtArrAttr<AGFLOAT> {
  public:
    AgAttrUsedLimitsT();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// Private attributes with no user access
// All private attributes starts with an underscore
// Private attributes MUST NOT have a newOf function defined
// and they also dont need the _init function
//----------------------------------------------------------------------
// AgAttr_GraphNum
//----------------------------------------------------------------------
class AgAttr_GraphNum : public UtAttr<int> {
  public:
    AgAttr_GraphNum();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttr_BarGraphNum
//----------------------------------------------------------------------
class AgAttr_BarGraphNum : public UtAttr<int> {
  public:
    AgAttr_BarGraphNum();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttr_ScatterGraphNum
//----------------------------------------------------------------------
class AgAttr_ScatterGraphNum : public UtAttr<int> {
  public:
    AgAttr_ScatterGraphNum();
    virtual UtBaseAttr *newOf();
    virtual void _init();
};

//----------------------------------------------------------------------
// AgAttr_ScaleTypeX AgAttr_ScaleTypeY
//----------------------------------------------------------------------
class AgAttr_ScaleTypeX : public UtEnumAttr<ScaleTypeEnum> {
  public:
    AgAttr_ScaleTypeX();
};
class AgAttr_ScaleTypeY : public UtEnumAttr<ScaleTypeEnum> {
  public:
    AgAttr_ScaleTypeY();
};

#endif
