//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/color.hxx#1 $
//

// color.hxx - Header file for AgColor class

//----------------------------------------------------------------------
#ifndef AG_COLOR_HXX
#define AG_COLOR_HXX

#ifndef CXXUTIL_STRING_HXX
#include <avs/cxxutl/string.hxx>
#endif

#ifndef CXXUTIL_DEBUG_HXX
#include <avs/cxxutl/debug.hxx>
#endif

#ifndef CXXUTIL_PTRATTR_HXX
#include <avs/cxxutl/ptrattr.hxx>
#endif

//----------------------------------------------------------------------
// Class to represent a Toolmaster++ color
// AgColor is using the agX Direct color mode
//----------------------------------------------------------------------
class AgColor
//----------------------------------------------------------------------
{
    friend class AgDrawingArea;

  public:
    AgColor();

    AgColor(const char* name);

    AgColor(const float rgb[3]);

    AgColor(const double rgb[3]);

    AgColor(unsigned int rgb) {
        set(rgb/(256*256), (rgb/256)%256, rgb%256);
    }

    // since there is both an operator=(int) and an operator int() 
    // wee need a default copy constructor to avoid the above being used
    AgColor(const AgColor &from);

    // if float then assume values in range 0-1
    void set(const float rgb[3]) {
        set(rgb[0], rgb[1], rgb[2]);
    }

    // if float then assume values in range 0-1
    void set(const double rgb[3]) {
        set((float)rgb[0], (float)rgb[1], (float)rgb[2]);
    }
    // if float then assume values in range 0-1
    void set(const float red, 
             const float green, 
             const float blue);
    // if char or int then then assume values in range 0-255
    void set(unsigned int rgb[3]) {
        set(rgb[0], rgb[1], rgb[2]);
    }
    // if char or int then then assume values in range 0-255
    void set(const unsigned int red, 
             const unsigned int green, 
             const unsigned int blue);
    // string name
    void set(const char *name);
    // string name by operator=
    AgColor &operator=(const char *name) {
        set(name);
        return *this;
    }
    // int packed rgb by operator=
    const AgColor &operator=(const unsigned int rgb) {
        set (rgb/(256*256), (rgb/256)%256, rgb%256);
        return *this;
    }

    // this function is used to allow for AgColor directly in calls to agX
    operator int() const;

    // Special mechanism which will override any color to this
    // This may be used for highlight coloring
    static void setOverrideColor(AgColor &color) {
        _overrideColor = color;
    }
    static void useOverrideColor(int flag) {
        _useOverrideColor = flag;
    }

    // since there is both an operator=(int) and an operator int() 
    // wee need a default assignment constructor to avoid the above being used
    AgColor &operator=(const AgColor &from);

    // test for transparent color
    int isTransparent() {
        return _isSpecial == Ag_TRANSPARENT;
    }

    // Release all colors. This is done for AgDrawArea draw only
    static void releaseColors();

    static void shutdown();

  private:

    void _copy(const AgColor &from);

    unsigned char _validate(const float value) {
        return (value >= 1.0) ? 255 : 
            ((value <= 0.0) ? 0 : (unsigned char)(value*255.0+0.5));
    }
    unsigned char _validate(const unsigned int value) {
        return (value > 255) ? 255 : value;
    }

    // Current color value
    unsigned char _red, _green, _blue;
    // Current color name if _isSpecial is Ag_NAME
    UtString _colorName;
    // Special flag
    enum {
        Ag_NORMAL=3,
        Ag_BACKGROUND=0,     // use correct default color index
        Ag_ANTIBACKGROUND=1, // use correct default color index
        Ag_TRANSPARENT=2,    // this is the transparent index we use
        Ag_NAME=4,
        Ag_VALIDATED_NAME=5  // when name has been validated to exist
    } _isSpecial;

    // Used for special mechanism which will override any color to this
    static int _overrideColor;
    static int _useOverrideColor;

    // Toomaster color tables used
    static int _colorTable;
    static int _specialColorTable;

    // Table of color names
    static char *_nameTable;
    static int _numNames;
};

#endif
