//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/contleg.hxx#1 $
//

// contleg.hxx - Header file for AgContourLegend class

//----------------------------------------------------------------------
#ifndef AG_CONTLEG_HXX
#define AG_CONTLEG_HXX

#ifndef CXXUTIL_ATTR_HXX
#include <avs/cxxutl/attr.hxx>
#endif

#ifndef CXXUTIL_PTRLIST_HXX
#include <avs/cxxutl/ptrlist.hxx>
#endif

#ifndef AG_CONTVP_HXX
#include "contvp.hxx"
#endif

class AgContourLegend;

#ifndef AG_CONTOUR_HXX
#include "contour.hxx"
#endif

//----------------------------------------------------------------------
class AgContourLegend : public AgGeometryPrimitive 
//----------------------------------------------------------------------
{
    friend class AgContour;

  public:
    AgContourLegend ();
    ~AgContourLegend();

    virtual AgPrimitiveType primitiveType() {return AgCONTOURLEGEND;}

    virtual void print() {printf("AgContourLegend ");}

    // Which contour is used for this legend
    AgContourLegend &attachContour(AgContour *contour);
    AgContourLegend &detachContour() {
        _contour = 0;
        return *this;
    }

    virtual int isValid();

  protected:
    virtual int _hitThis();
    virtual void _updateThis(int first);
    virtual void _drawThis();

  private:
    AgContour *_contour;
    float _upperRightPoint[2];
    float _textWidth;
    int _numDecimals;
};

#endif
