//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/distance.hxx#1 $
//

// distance.hxx - Header file for AgDistance class

//----------------------------------------------------------------------
#ifndef AG_DISTANCE_HXX
#define AG_DISTANCE_HXX

//----------------------------------------------------------------------
// Class to represent a Toolmaster++ Distance
//----------------------------------------------------------------------
class AgDistance 
//----------------------------------------------------------------------
{
  public:
    AgDistance()
        : _distance(3.0), _distanceMode(AgDISTANCE_PERCENT) {}

    AgDistance(float distance) 
        : _distance(distance), _distanceMode(AgDISTANCE_PERCENT) {}

    // since there is both an operator=(int) and an operator int() 
    // wee need a default copy constructor to avoid the above being used
    AgDistance(const AgDistance &from);

    AgDistance &setMM(float mmDistance);
    AgDistance &setPercent(float percentDistance);
    AgDistance &setPixel(float pixelDistance);
    AgDistance &setWorldX(float worldXDistance);
    AgDistance &setWorldY(float worldYDistance);

    float getWorldX();
    float getWorldY();
    float getMM();
    float getPercent();
    float getPixel();
    
    // return float as getPercent
    operator float() {return getPercent();}

    // Setting = float is identical to setPercent
    AgDistance &operator=(float distance) {
        setPercent(distance);
        return *this;
    }

    // since there is both an operator=(float) and an operator float() 
    // wee need a default assignment constructor to avoid the above being used
    AgDistance &operator=(const AgDistance &from);

  private:

    void _copy(const AgDistance &from);

    float _mmToWorldX(float mm);
    float _mmToWorldY(float mm);
    float _mmToPercent(float mm);
    float _mmToPixel(float mm);

    int _isValid();

    float _distance;
    enum {
        AgDISTANCE_MM,
        AgDISTANCE_PERCENT,
        AgDISTANCE_PIXEL,
        AgDISTANCE_WORLD_X,
        AgDISTANCE_WORLD_Y}
    _distanceMode;
};
#endif
