//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/field.hxx#1 $
//

// field.hxx - Header file for AgField class

//----------------------------------------------------------------------
#ifndef AG_FIELD_HXX
#define AG_FIELD_HXX

#ifndef CXXUTIL_MISC_HXX
#include <avs/cxxutl/misc.hxx>
#endif

#ifndef CXXUTIL_ARRAY_HXX
#include <avs/cxxutl/array.hxx>
#endif

#include <avs/port.h>

#ifdef IRIX6_OBSOLETE
#define AGFLOAT double
#else
#define AGFLOAT float
#endif

//----------------------------------------------------------------------
// Define the different types of fields
//----------------------------------------------------------------------
enum AgFieldType {
    AgFIELD_UNIFORM,
    AgFIELD_RECTILINEAR,
    AgFIELD_IRREGULAR
};
//----------------------------------------------------------------------
// Class to represent a Toolmaster++ Field
//----------------------------------------------------------------------
class AgField
//----------------------------------------------------------------------
{
  public:
    AgField();

    void setData(AGFLOAT *data,
        xp_long sizeX,
        xp_long sizeY);

    void setData(UtArray<AGFLOAT> &data,
        xp_long sizeX,
        xp_long sizeY);

    void setDataRange(AGFLOAT min, AGFLOAT max) {
        if (min < max) {
            _minData = min;
            _maxData = max;
        }
    }

    void setUniformLimits(AGFLOAT minX, AGFLOAT minY, AGFLOAT maxX, AGFLOAT maxY);

    void setRectilinearGrid(AGFLOAT *gridX, AGFLOAT *gridY);

    void setIrregularGrid(UtArray<AGFLOAT> &gridX, UtArray<AGFLOAT> &gridY);

    void setIrregularGrid(AGFLOAT *gridX, AGFLOAT *gridY);

    void getLimits(AGFLOAT *minX, AGFLOAT *minY, AGFLOAT *maxX, AGFLOAT *maxY);

    UtArray<AGFLOAT> data() const {
        return _data;
    }
    UtArray<AGFLOAT> gridX() const {
        return _gridX;
    }
    UtArray<AGFLOAT> gridY() const {
        return _gridY;
    }
    AgFieldType fieldType() const {
        return _type;
    }
    xp_long sizeX() const {
        return _sizeX;
    }
    xp_long sizeY() const {
        return _sizeY;
    }
    AGFLOAT minData();
    AGFLOAT maxData();

    void setUndefinedValue(const AGFLOAT undefinedValue) {
        _undefinedValue = undefinedValue;
        _undefinedValid = 1;
    }
    AGFLOAT undefinedValue() const {return _undefinedValue;}
    int undefinedValid() const {return _undefinedValid;}
    void undefinedInvalid() {_undefinedValid = 0;}

  private:

    AgFieldType _type;
    UtArray<AGFLOAT> _data;
    UtArray<AGFLOAT> _gridX, _gridY;
    xp_long _sizeX, _sizeY;
    AGFLOAT _minData, _maxData;
    AGFLOAT _undefinedValue;
    int   _undefinedValid;
};
#endif

