//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/geometry.hxx#1 $
//

// geometry.hxx - Header file for AgGeometry class

//----------------------------------------------------------------------
#ifndef AG_GEOMETRY_HXX
#define AG_GEOMETRY_HXX

#ifndef CXXUTIL_MISC_HXX
#include <avs/cxxutl/misc.hxx>
#endif

#ifndef CXXUTIL_ARRAY_HXX
#include <avs/cxxutl/array.hxx>
#endif

#include <avs/port.h>

#ifdef IRIX6_OBSOLETE
#define AGFLOAT double
#else
#define AGFLOAT float
#endif

//----------------------------------------------------------------------
// Class to represent a Toolmaster++ Geometry
//----------------------------------------------------------------------
class AgGeometry
//----------------------------------------------------------------------
{
  public:
    AgGeometry();
    AgGeometry(AGFLOAT *geometryX,
               AGFLOAT *geometryY,
               xp_long numCoordinates);
    AgGeometry(float *geometryXY,
               xp_long numPairs) ;
    AgGeometry(double *geometryXY,
               xp_long numPairs) ;
    AgGeometry(UtArray<AGFLOAT> geometryXY);
    AgGeometry(UtArray<AGFLOAT> geometryX, UtArray<AGFLOAT> geometryY);

    void set(float *geometryXY,
             xp_long numPairs);
    void set(double *geometryXY,
             xp_long numPairs);

    void set(UtArray<AGFLOAT> &geometryXY);

    void set(UtArray<AGFLOAT> &geometryX, UtArray<AGFLOAT> &geometryY);

    void set(AGFLOAT *geometryX,
             AGFLOAT *geometryY,
             xp_long numCoordinates);

    AGFLOAT *getXData() const {
        return _geometryX.data();
    }

    AGFLOAT *getYData() const {
        return _geometryY.data();
    }

    UtArray<AGFLOAT> &getX() {
        return _geometryX;
    }

    UtArray<AGFLOAT> &getY() {
        return _geometryY;
    }

    xp_long numCoordinates() const {
        return _geometryX.size();
    }

  private:

    UtArray<AGFLOAT> _geometryX;
    UtArray<AGFLOAT> _geometryY;
};
#endif

