//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/graph.hxx#1 $
//

// graph.hxx - Header file for AgGraph class

//----------------------------------------------------------------------

#ifndef AG_GRAPH_HXX
#define AG_GRAPH_HXX

#include <avs/port.h>

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

class AgGraphLegend;

#ifndef AG_LSTYLE_HXX
#include "lstyle.hxx"
#endif

#ifndef AG_ENUMDEFS_HXX
#include "enumdefs.hxx"
#endif

//----------------------------------------------------------------------
class AgGraph : public AgPrimitive
//----------------------------------------------------------------------
{
    friend class AgGraphLegend;

  public:
    AgGraph();
    virtual ~AgGraph();

    virtual AgPrimitiveType primitiveType() {return AgGRAPH;}

    virtual void print() {printf("AgGraph ");}

    virtual int _hitThis();
    virtual void _getHitData(int hit, float &hitDataX, float &hitDataY);

    // which legend should include this graph
    AgGraph &attachLegend(AgGraphLegend *legend);

    // function to return limits for this object
    virtual int getLimits(float *xmin, float *xmax, 
                          float *ymin, float *ymax);

    // Check if this object is valid and if not then dont draw it or
    // or any children
    virtual int isValid();

  protected:
    // Special coinstructur used by AGPolarGraph
    AgGraph(int) :
      _legend(0L), _dataIs1D(0), _graphType(AgCURVE), _lineWidth(0.15f) {}

    void _changeBackpingToCtrlR(UtString &);

    AgGraphLegend *_legend;
    int _dataIs1D;

    virtual void _drawThis();
    virtual void _updateThis(int first);
    UtArray<AGFLOAT> _logOrPowerX, _logOrPowerY, _logOrPowerBaseY;
    xp_long _numValues;
    int _scatterHitIndex;

    // These are for the legend
    AgColor _color;
    AgColor _negativeColor;
    AgLineStyle _lineStyle;
    AgGraphTypes _graphType;
    float _lineWidth;
    UtString _scatterSymbol;
    float _barOffset;
    AgFont _symbolFont;
    float _referenceValue;

  private:
    AGFLOAT *_getX();
    AGFLOAT *_getY();
    AGFLOAT *_getBaseY();
};

#endif
