//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/graphics.hxx#1 $
//

// graphics.hxx - Header file for graphics primitive classes
//                AgGraphics, AgPoints, AgArrow, AgLine, AgRectangle,
//                AgEllipse, AgArc and AgPolygon

//----------------------------------------------------------------------
#ifndef AG_GRAPHICS_HXX
#define AG_GRAPHICS_HXX

#ifndef AG_GEOMPRIM_HXX
#include "geomprim.hxx"
#endif

#ifndef AG_WORLD_HXX
#include "world.hxx"
#endif

#ifndef AG_ATTRNAME_HXX
#include "attrname.hxx"
#endif

#ifndef AG_FONT_HXX
#include "font.hxx"
#endif

//----------------------------------------------------------------------
// Protected base class for graphics primitives
//----------------------------------------------------------------------
class AgGraphics : public AgGeometryPrimitive 
//----------------------------------------------------------------------
{
    
  public:
    
    virtual AgPrimitiveType primitiveType() {return AgGRAPHICS;}

  protected:
    AgGraphics() {}

};

//----------------------------------------------------------------------
class AgPoints : public AgGraphics 
//----------------------------------------------------------------------
{

  public:
    AgPoints();

//    virtual void print() {printf("AgPoints ");}

    virtual int _hitThis();

  protected:
    virtual void _drawThis();
};

//----------------------------------------------------------------------
class AgLine : public AgGraphics 
//----------------------------------------------------------------------
{

  public:
    AgLine();
    
//    virtual void print() {printf("AgLine ");}
    
    virtual int _hitThis();

  protected:
    virtual void _drawThis();
};

//----------------------------------------------------------------------
class AgArrow : public AgGraphics 
//----------------------------------------------------------------------
{

  public:
    AgArrow();
    
//    virtual void print() {printf("AgArrow ");}
    
    virtual int _hitThis();

  protected:
    virtual void _drawThis();
};

//----------------------------------------------------------------------
class AgRectangle : public AgGraphics 
//----------------------------------------------------------------------
{
    
  public:
    AgRectangle();
//    virtual void print() { printf("AgRectangle "); }
    
  protected:
    virtual void _drawThis();
    virtual int _hitThis();
};

//----------------------------------------------------------------------
class AgPolygon : public AgGraphics 
//----------------------------------------------------------------------
{
    
  public:
    AgPolygon();
//    virtual void print() {printf("AgPolygon ");}

  protected:
    virtual int _hitThis();
    virtual void _drawThis();
};

//----------------------------------------------------------------------
class AgBaseArc : public AgGraphics
//----------------------------------------------------------------------
{    

  public:

  protected:
    AgBaseArc();
    virtual void _drawThis();
    virtual int _hitThis();

    int _frameType;
};

//----------------------------------------------------------------------
class AgEllipse : public AgBaseArc
//----------------------------------------------------------------------
{    

  public:
//    virtual void print() {printf("AgEllipse ");}

  protected:
    virtual void _drawThis();
};

//----------------------------------------------------------------------
class AgArc : public AgBaseArc
//----------------------------------------------------------------------
{    

  public:
    AgArc();
//    virtual void print() {printf("AgArc ");}

  protected:
    virtual void _drawThis();
};


#endif
