//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/lstyle.hxx#1 $
//

// lstyle.hxx - Header file for AgLineStyle class

//----------------------------------------------------------------------
#ifndef AG_LSTYLE_HXX
#define AG_LSTYLE_HXX

#ifndef CXXUTIL_STRING_HXX
#include <avs/cxxutl/string.hxx>
#endif

//----------------------------------------------------------------------
// Class to represent a Toolmaster++ LineStyle
//----------------------------------------------------------------------
class AgLineStyle 
//----------------------------------------------------------------------
{
  public:
    AgLineStyle(const char* name = "solid") {
        set(name);
    }   
    
    // string name
    void set(const char *name);
    
    // string name by operator=
    AgLineStyle &operator=(const char *name) {
        set(name);
        return *this;
    }
    
    // return int for call directly to agX routines
    operator int() const;
    
  private:
    UtString _lineStyle;
};
#endif
