//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/polgraph.hxx#1 $
//

// polgraph.hxx - Header file for AgPolGraph class

//----------------------------------------------------------------------

#ifndef AG_POLGRAPH_HXX
#define AG_POLGRAPH_HXX

#ifndef AG_GRAPH_HXX
#include "graph.hxx"
#endif

//----------------------------------------------------------------------
class AgPolarGraph : public AgGraph
//----------------------------------------------------------------------
{
    friend class AgGraphLegend;

  public:
    AgPolarGraph();

    virtual AgPrimitiveType primitiveType() {return AgPOLARGRAPH;}

    virtual void print() {printf("AgPolarGraph ");}

    virtual int _hitThis();

    // which legend should include this graph
    AgPolarGraph &attachLegend(AgGraphLegend *legend);

    // function to return limits for this object
    virtual int getLimits(float *xmin, float *xmax, 
                          float *ymin, float *ymax);

    // Check if this object is valid and if not then dont draw it or
    // or any children
    virtual int isValid();

  protected:

  private:

    virtual void _drawThis();
    virtual void _updateThis(int first);

    UtArray<AGFLOAT> &_r, &_t;
};

#endif
