//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/prim.hxx#1 $
//

// prim.hxx - Header file for AgPrimitive class

//----------------------------------------------------------------------
#ifndef AG_PRIM_HXX
#define AG_PRIM_HXX

#include <stdio.h>
#include <avs/port.h>
#include <avs/hit.h>

#ifndef CXXUTIL_ENUM_HXX
#include <avs/cxxutl/enum.hxx>
#endif

#ifndef CXXUTIL_PTRLIST_HXX
#include <avs/cxxutl/ptrlist.hxx>
#endif

#ifndef CXXUTIL_ARRAY_HXX
#include <avs/cxxutl/array.hxx>
#endif

#ifndef CXXUTIL_DEBUG_HXX
#include <avs/cxxutl/debug.hxx>
#endif

#ifndef AG_COLOR_HXX
#include "color.hxx"
#endif

#ifndef AG_FONT_HXX
#include "font.hxx"
#endif

#ifndef AG_LSTYLE_HXX
#include "lstyle.hxx"
#endif

#ifndef AG_DISTANCE_HXX
#include "distance.hxx"
#endif

#ifndef AG_GEOMETRY_HXX
#include "geometry.hxx"
#endif

#ifndef CXXUTIL_ATTRMGR_HXX
#include <avs/cxxutl/attrmgr.hxx>
#endif

#ifndef CXXUTIL_TYPEATTR_HXX
#include <avs/cxxutl/typeattr.hxx>
#endif

#ifndef CXXUTIL_PTRATTR_HXX
#include <avs/cxxutl/ptrattr.hxx>
#endif

#ifdef IRIX6_OBSOLETE
#define AGINT long
#define AGFLOAT double
#else
#define AGINT int
#define AGFLOAT float
#endif

//----------------------------------------------------------------------
// Define the special grouping for AgPrimitive classes
//----------------------------------------------------------------------
enum AgPrimitiveType 
//----------------------------------------------------------------------
{
    AgUNKNOWN,
    AgDRAWINGAREA, 
    AgVIEWPORT, 
    AgWORLD, 
    AgGRAPHICS,
    AgAXIS,
    AgGRAPH,
    AgCONTOUR,
    AgGRAPHLEGEND,
    AgCONTOURLEGEND,
    AgPOLARWORLD,
    AgPOLARAXIS,
    AgPOLARGRAPH
}; 

//----------------------------------------------------------------------
class AgPrimitive : public UtAttrMgr 
//----------------------------------------------------------------------
{
    friend class AgViewport;
    friend class AgWorld;
    friend class AgDrawingArea;
    
//----------------------------------------------------------------------
  public:
//----------------------------------------------------------------------
    virtual AgPrimitiveType primitiveType() {return AgGRAPHICS;}

    virtual void print() {printf("AgPrimitive ");}

    int operator<=(const AgPrimitive &prim) {
        return _priority <= prim._priority;
    }

    int operator>(const AgPrimitive &prim) {
        return _priority > prim._priority;
    }

    AgPrimitive &setUserData (void *userData) {
        _userData = userData; 
        return *this;
    }

    void *getUserData() {return _userData;}
    
    // function to return limits for this object
    // return 0 means that no valid limits are returned
    virtual int getLimits(float*, float*, float*, float*);

    virtual AgPrimitive& clear();

    // Check if this object is valid and if not then dont draw it or
    // or any children
    virtual int isValid();

    AgPrimitive &draw();
    
    // attach to a parent
    AgPrimitive &attach(AgPrimitive *parent);

    // detach this from given parent (if at all connected)
    AgPrimitive &detach(AgPrimitive *parent);

    // remove all children from this and their parents
    AgPrimitive &removeAll();
    
    //
    // Define all the attribute access functions
    //

    // Unset attribute for this object
    AgPrimitive &unsetAttr(const char *name) {
        findAttr(name, UtDO_CHANGE)->setState(UtATTR_UNSET);
        return *this;
    }

    // Define access functions for UtAttr<int> attributes
    AgPrimitive &setIntAttr(const char *name, const int &value,
                            UtAttrSearchType search=UtDO_CHANGE) {
        ((UtAttr<int>*)findAttr(name, search))->set(value);
        return *this;
    }
    int &getIntAttr (const char *name,
                     UtAttrSearchType search=UtIS_SET) {
        return ((UtAttr<int>*)findAttr(name, search))->get();
    }

    // Define access functions for UtAttr<float> attributes
    AgPrimitive &setFloatAttr(const char *name, const float &value,
                              UtAttrSearchType search=UtDO_CHANGE) {
        ((UtAttr<float>*)findAttr(name, search))->set(value);
        return *this;
    }
    float &getFloatAttr (const char *name,
                         UtAttrSearchType search=UtIS_SET) {
        return ((UtAttr<float>*)findAttr(name, search))->get();
    }

    // Define access functions for UtFloatArrAttr attributes
    AgPrimitive &setFloatArrAttr(const char *name, 
                                 AGFLOAT array[], 
                                 const int size,
                                 UtAttrSearchType search=UtDO_CHANGE) {
        ((UtArrAttr<AGFLOAT>*)findAttr(name, search))->set(array, size);
        return *this;
    }
    AgPrimitive &setFloatArrAttr(const char *name, 
                                 const UtArray<AGFLOAT> &value,
                                 UtAttrSearchType search=UtDO_CHANGE) {
        ((UtArrAttr<AGFLOAT>*)findAttr(name, search))->set(value);
        return *this;
    }
    UtArray<AGFLOAT> &getFloatArrAttr(const char *name,
                                    UtAttrSearchType search=UtIS_SET) {
        return ((UtArrAttr<AGFLOAT>*)findAttr(name, search))->get();
    }

    // Define access functions for UtStringAttr attributes
    AgPrimitive &setStringAttr(const char *name, const char *value,
                               UtAttrSearchType search=UtDO_CHANGE) {
        ((UtStringAttr*)findAttr(name, search))->set(value);
        return *this;
    }
    UtString &getStringAttr(const char *name,
                            UtAttrSearchType search=UtIS_SET) {
        return ((UtStringAttr*)findAttr(name, search))->get();
    }

    // Define access functions for UtPtrAttr< UtArray<UtString> > attributes
    AgPrimitive &setStringArrAttr(const char *name, 
                                  const UtArray<UtString> &value,
                                  UtAttrSearchType search=UtDO_CHANGE) {
        ((UtPtrAttr< UtArray<UtString> >*)findAttr(name, search))->set(value);
        return *this;
    }
    UtArray<UtString> &getStringArrAttr(const char *name,
                                        UtAttrSearchType search=UtIS_SET) {
        return ((UtPtrAttr< UtArray<UtString> >*)
                findAttr(name, search))->get();
    }

    // Define access functions for UtEnumAttr attributes
    AgPrimitive &setEnumAttr(const char *name, const int value,
                             UtAttrSearchType search=UtDO_CHANGE) {
        ((UtBaseEnumAttr*)findAttr(name, search))->set(value);
        return *this;
    }
    AgPrimitive &setEnumAttr(const char *name, const char *value,
                             UtAttrSearchType search=UtDO_CHANGE) {
        ((UtBaseEnumAttr*)findAttr(name, search))->set(value);
        return *this;
    }
    AgPrimitive &setEnumAttr(const char *name, const UtBaseEnum &value,
                             UtAttrSearchType search=UtDO_CHANGE) {
        ((UtBaseEnumAttr*)findAttr(name, search))->set(value);
        return *this;
    }
    UtBaseEnum &getEnumAttr(const char *name,
                            UtAttrSearchType search=UtIS_SET) {
        return ((UtBaseEnumAttr*)findAttr(name, search))->get();
    }

    // Define access functions for UtPtrAttr<AgColor> attributes
    AgPrimitive &setColorAttr(const char *name, const AgColor &value,
                              UtAttrSearchType search=UtDO_CHANGE) {
        ((UtPtrAttr<AgColor>*)findAttr(name, search))->set(value);
        return *this;
    }
    AgColor &getColorAttr(const char *name,
                          UtAttrSearchType search=UtIS_SET) {
        return ((UtPtrAttr<AgColor>*)findAttr(name, search))->get();
    }

    // Define access functions for UtColorArrAttr attributes
    AgPrimitive &setColorArrAttr(const char *name, 
                                 const UtArray<AgColor> &value,
                                 UtAttrSearchType search=UtDO_CHANGE) {
        ((UtArrAttr<AgColor>*)findAttr(name, search))->set(value);
        return *this;
    }
    AgPrimitive &setColorArrAttr(const char *name, 
                                 AgColor *value,
                                 int size,
                                 UtAttrSearchType search=UtDO_CHANGE) {
        ((UtArrAttr<AgColor>*)findAttr(name, search))->set(value, size);
        return *this;
    }
    UtArray<AgColor> &getColorArrAttr(const char *name,
                                      UtAttrSearchType search=UtIS_SET) {
        return ((UtPtrAttr< UtArray<AgColor> >*)
                findAttr(name, search))->get();
    }

    // Define access functions for UtPtrAttr<AgLineStyle> attributes
    AgPrimitive &setLineStyleAttr(const char *name, const AgLineStyle &value,
                                  UtAttrSearchType search=UtDO_CHANGE) {
        ((UtPtrAttr<AgLineStyle>*)findAttr(name, search))->set(value);
        return *this;
    }
    AgLineStyle &getLineStyleAttr(const char *name,
                                  UtAttrSearchType search=UtIS_SET) {
        return ((UtPtrAttr<AgLineStyle>*)findAttr(name, search))->get();
    }

    // Define access functions for UtPtrAttr<AgFont> attributes
    AgPrimitive &setFontAttr(const char *name, const AgFont &value,
                             UtAttrSearchType search=UtDO_CHANGE) {
        ((UtPtrAttr<AgFont>*)findAttr(name, search))->set(value);
        return *this;
    }
    AgFont &getFontAttr(const char *name,
                        UtAttrSearchType search=UtIS_SET) {
        return ((UtPtrAttr<AgFont>*)findAttr(name, search))->get();
    }

    // Define access functions for UtAttr<AgDistance> attributes
    AgPrimitive &setDistanceAttr (const char *name, const AgDistance &value,
                                  UtAttrSearchType search=UtDO_CHANGE) {
        ((UtAttr<AgDistance>*)findAttr(name, search))->set(value);
        return *this;
    }
    AgDistance &getDistanceAttr(const char *name,
                                UtAttrSearchType search=UtIS_SET) {
        return ((UtAttr<AgDistance>*)findAttr(name, search))->get();
    }

    // Define access functions for UtPtrAttr<AgGeometry> attributes
    AgPrimitive &setGeometryAttr(const char *name, 
        const AgGeometry &value,
        UtAttrSearchType search=UtDO_CHANGE) {
            ((UtPtrAttr<AgGeometry>*)findAttr(name, search))->set(value);
            return *this;
    }
    AgGeometry &getGeometryAttr (const char *name,
                                 UtAttrSearchType search=UtIS_SET) {
        return ((UtPtrAttr<AgGeometry>*)findAttr(name, search))->get();
    }

    // Call user update function and reset all update flag to set flags
    AgPrimitive &updateAttr() {
        UtAttrMgr::updateAttr(); 
        return *this;
    }

    // the destructor needs to tell all parents and children about the dead
    virtual ~AgPrimitive();
    
//----------------------------------------------------------------------
  protected:
//----------------------------------------------------------------------
    AgPrimitive();

    // Called when attributes are updated
    virtual void _userUpdateAttr();

    // The _updateThis function MUST NOT be called by anybody
    // but the _drawPath and _drawDown function this assures
    // that all parents _updateThis functions are called first
    // Only exception is for class AgDrawingArea which may call it by itself
    virtual void _updateThis(int);
    // note that _drawUp is called recursively
    void _drawUp();
    // This function is only called by AgDrawingArea objects
    void _drawPath();
    // Draw this and all descendants 
    // This MUST be called from _drawDown or _drawPath (called from _drawUp)
    void _drawDown();
    // This is used by AgDrawingArea pick function
    void _pickDown(int &hit);
    // _drawThis draws this object before all it's children asuming that
    // all is set up correctly 
    virtual void _drawThis();
    virtual UtAttrMgr *_parentUtAttrMgr() const;

    // Return parent in draw path stack
    // Must NOT be called by AgDrawingArea
    AgPrimitive *_drawParent() const;

    // hit functions
    virtual int _hitThis();

    int _rectangleHit(AGFLOAT transformedX[],
                      AGFLOAT transformedY[],
                      int numCoordinates);

    // Get hit data if valid
    virtual void _getHitData(int, float&, float&);

    // Now comes all the different groups of attributes
    void _addTickAttr();
    void _addTickXAttr();
    void _addTickYAttr();
    void _addTickRAttr();
    void _addTickTAttr();
    void _addAxisAttr();
    void _addGraphAttr();
    void _addGraphsAttr();
    void _addPolarGraphAttr();
    void _addPolarGraphsAttr();
    void _addContourAttr();

    // Check graph no attributes
    void _checkGraphNum();

    // Reset text attributes to default values
    void _resetTextAttr();

    // Set up limits and update global limits
    void _setupLimits(float minX, float maxX, float minY, float maxY);

    UtPtrSortedList<AgPrimitive> _parents;
    UtPtrSortedList<AgPrimitive> _children;
    
    int _priority; // A duplicate of the priority attribute for speed reason

    // Static variables

    // The draw stack is used by the _drawUp function to build draw path
    // At any draw the _drawDownStack contains the entire drawing path
    static UtArray<AgPrimitive*> _drawDownStack;
    static int _drawDownStackDepth;
    static UtArray<AgPrimitive*> _drawUpStack;
    static int _drawUpStackDepth;
    
    // This point the the Object that last set up the scaling
    // this can now be tested so we avoid doing scaling multiple times
    // when it is not needed
    static AgPrimitive *_whoSetScaling;

    // Debug stuff
    static UtDebug debugVar;
    static int debug() {return debugVar.debug();}

//----------------------------------------------------------------------
  private:
//----------------------------------------------------------------------
    void *_userData;

    // Private copy and assignment functions to make copying illegal
    AgPrimitive (const AgPrimitive&) {
        if (debug()) printf("CREATINGass AgPrimitive\n");
    }
    AgPrimitive &operator= (const AgPrimitive&) {
        if (debug()) printf("CREATING= AgPrimitive\n");
        return *this;
    }

};

#endif
