//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/tickline.hxx#1 $
//

// tickline.hxx -- Header file for all AgTicklines classes

//----------------------------------------------------------------------
#ifndef AG_TICKLINE_HXX
#define AG_TICKLINE_HXX

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

#ifndef AG_WORLD_HXX
#include "world.hxx"
#endif

#ifndef AG_AXIS_HXX
#include "axis.hxx"
#endif

//----------------------------------------------------------------------
// Protected base class for AgXTicklines and AgYTicklines
//----------------------------------------------------------------------
class AgTicklines : public AgPrimitive
//----------------------------------------------------------------------
{
  public:

    virtual AgPrimitiveType primitiveType() {return AgAXIS;}

  protected:
    AgTicklines();
    virtual void _drawThis();
    virtual int _hitThis() {
        AgDrawingArea::usePickDevice();
        _drawThis();
        AgDrawingArea::useWindowDevice();
        return AgDrawingArea::isHit()-1;
    }

  private:
};

//----------------------------------------------------------------------
class AgXTicklines : public AgTicklines 
//----------------------------------------------------------------------
{

  public:
    AgXTicklines();
    virtual void print() {printf("AgXTicklines ");};

  protected:
    virtual void _drawThis();
};

//----------------------------------------------------------------------
class AgYTicklines : public AgTicklines 
//----------------------------------------------------------------------
{

  public:
    AgYTicklines();
    virtual void print() {printf("AgYTicklines ");};

  protected:
    virtual void _drawThis();
};

#endif
