//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/useraxis.hxx#1 $
//

// useraxis.hxx -- Header file for UserAxis, AgXUserAxis and AgYUserAxis
// classes 

//----------------------------------------------------------------------
#ifndef AG_USERAXIS_HXX
#define AG_USERAXIS_HXX

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

#ifndef AG_WORLD_HXX
#include "world.hxx"
#endif

//----------------------------------------------------------------------
// Protected base class for AgXUserAxis and AgYUserAxis
//----------------------------------------------------------------------
class AgUserAxis : public AgPrimitive 
//----------------------------------------------------------------------
{
  public:

    virtual AgPrimitiveType primitiveType() {return AgAXIS;}

    virtual int isValid();

  protected:
    AgUserAxis(int axisType);
    virtual void _drawThis();
    virtual int _hitThis();

    const int _axisType;

  private:
};

//----------------------------------------------------------------------
class AgXUserAxis : public AgUserAxis 
//----------------------------------------------------------------------
{

  public:
    AgXUserAxis();
    virtual void print() {printf("AgXUserAxis ");};

  protected:
    virtual void _updateThis(int first);
};

//----------------------------------------------------------------------
class AgYUserAxis : public AgUserAxis 
//----------------------------------------------------------------------
{

  public:
    AgYUserAxis();
    virtual void print() {printf("AgYUserAxis ");};

  protected:
    virtual void _updateThis(int first);
};

#endif
