/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/DiscCache.hxx#1 $
*/
#ifndef _GS_DISCCACHE_HXX_
#define _GS_DISCCACHE_HXX_

#include <avs/gd.h>

#include <avs/animator/GDViewTraverser.hxx>
#include <avs/animator/gfaFileWrite.hxx>
#include <avs/animator/gfaFileRead.hxx>
#include <avs/animator/GS_ListHeader.hxx>

extern "C" void ANIM_delete_disc_frame_manager(GDview *v);

class MemorySearcher : public GDViewTraverser {
private:
  enum SearchMode { FindCache, FindTexture };

public:
  MemorySearcher(GDview *view);
  GDobject *findCacheInActive(int id) ;
  GDobject *findCacheInPrevious(int id);
  GDobject *findCacheInCurrent(int id);

  GDobject *findTextureInActive(int id) ;
  GDobject *findTextureInPrevious(int id);
  GDobject *findTextureInCurrent(int id);

private:
  void setSearchMode(SearchMode searchMode) { _searchMode = searchMode;};

  GDobject *findCache(int id);
  GDobject *findTexture(int id);
  virtual void inObject(GDobject *);

  int _id;
  int _texture_id;
  GDobject *_obj;

  SearchMode _searchMode;
};


class DiscFrameManager : public GDViewTraverser {

  enum DiscFrameMode { SaveAllFrames , FindFrameData, FreeFrameData, 
                       FreeUpPrevious, SaveNewFrameData,
                       RecordMemPointer, LoadAllFrames  };

 public:
  DiscFrameManager(GDview *view);
  ~DiscFrameManager();

  //
  // functions used by GeomCap and Replay modules
  //
  int  initDiscFiles(char *dir);
  int  copyFramesToDisc();
  void freeAllDataFromMemory();
  void swapInNewFrame();
  void saveCurrentFrame();
  void loadAllDataIntoMemory();
  void setFullCache(int fullCache) { _fullCache = fullCache;};

  //
  // functions used by GFAFileWrite
  //
  GDcache_header *loadCache(int cache_id);
  GDtexture *loadTexture(int txtr_id);

  //
  // functions used by GFAFileRead
  //
  int saveNewCache(GDcache_header *cache);
  int saveNewTexture(GDtexture *texture);

 private:
  virtual void inObject(GDobject *);
  int addToList(GDobject *obj) ;

  int findObjectData(GDobject *obj);
  int findCache(GDobject *obj);
  int loadCache(GDobject *obj);
  int findTexture(GDobject *obj);
  int loadTexture(GDobject *obj);

  int freeObjectData(GDobject *obj);
  int freeCache(GDobject *obj);
  int freeTexture(GDobject *obj);

  int freeUpPrevious(GDobject *obj);
  int freeUpPreviousCache(GDobject *obj);
  int freeUpPreviousTexture(GDobject *obj);

  int saveNewObjectData(GDobject *obj);
  int saveNewCache(GDobject *obj);
  int saveNewTexture(GDobject *obj);

  int recordMemPointer(GDobject *obj);
  int recordCachePointer(GDobject *obj);
  int recordTexturePointer(GDobject *obj);

  int loadAllData(GDobject *obj);
  int loadAllCaches(GDobject *obj);
  int loadAllTextures(GDobject *obj);

  int saveCache(GS_DiscNode<GDcache_header> *node);
  int saveTexture(GS_DiscNode<GDtexture> *node);

  char *genFileName(const char *basename, const char *extra, int message = 0);
  char * genTextureFileName(const char *basename);
  char * genCacheFileName(const char *basename);

  void setDiscFrameMode(DiscFrameMode discFrameMode) { _discFrameMode = discFrameMode;};

  GS_DiscHeader<GDcache_header> _disc_cache_list;
  GS_DiscHeader<GDtexture>      _disc_texture_list;

  // cache and texture writer
  GFAFileWrite _txtr_writer, _cache_writer;
  // cache and texture reader
  GFAFileRead _txtr_reader, _cache_reader;

  // traverse mode
  DiscFrameMode _discFrameMode;

  // Memory cache and texture search engine(s)
  MemorySearcher _memSearcher;

  // Counter - for OMstatus_check
  int _count;
  int _total;

  // filename
  char *_cache_fileName;
  char *_texture_fileName;

  // for GeomRep full caching option
  int _fullCache;
};
#endif

