/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/GS_ListHeader.hxx#1 $
*/
#ifndef _GS_LISTHEADER_HXX
#define _GS_LISTHEADER_HXX

#ifndef _GS_LISTNODE_HXX
#include <avs/animator/GS_ListNode.hxx>
#endif

template <class ListItem>
class GS_ListHeader {
 public:
  GS_ListHeader();
  ~GS_ListHeader();
  GS_ListNode<ListItem> *AddToListTailAssignId(ListItem *item);
  GS_ListNode<ListItem> *AddToListTail(ListItem *item, int id);
  GS_ListNode<ListItem> *AddToListTailById(ListItem *item, int id);
  GS_ListNode<ListItem> *Search(ListItem *item);
  GS_ListNode<ListItem> *Search(int id);
  GS_ListNode<ListItem> *SetCurrentToFirst() { m_curr = m_list; return m_curr;};
  GS_ListNode<ListItem> *SetCurrentToNext();

  int GetListSize() { return m_nitems;}
  void cleanUp();

 protected:
  int m_nitems;
  GS_ListNode<ListItem> *m_list;
  GS_ListNode<ListItem> *m_last;
  GS_ListNode<ListItem> *m_curr;
};

template <class ListItem>
class GS_DiscHeader : public  GS_ListHeader<ListItem> {
public:
  GS_DiscNode<ListItem> *AddToListTail(ListItem *item);
};

#endif
