//                      Copyright (c) 1993 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may numt be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/include/avs/animator/GeomCap.h#1 $
//

#ifndef XP_ANIMATOR_GEOMCAP_H
#define XP_ANIMATOR_GEOMCAP_H

/*
	
	Object:		GeomCap, geom data

	Function:	Generic Capture Object for Geom Capture/Flipbook

*/

#include <avs/animator/DelayRep.h>
#include <avs/animator/DiscCache.hxx>

class GeomCap  
{
private:
	int m_StoreOnDisk;	// Should be storing them on disk
        int m_fullCache;
	char *m_fileName;	// file name

public:
	void RemoveFrame(GDview *v, int n);
	void PutFrame(GDview *v, int number);
	void SetFileName(char *f);
	void PutAllInMemory(GDview *v);
	int  PutAllOnDisk(GDview *v);
	int GetNumberFrames(GDview *v);
	int GetCurrentFrame(GDview *v);
	void CloseDiscFrameManager(GDview *v);
	void ResetDiscFrameManager(GDview *v);
	GeomCap();
	virtual ~GeomCap();

	DiscFrameManager *createDiscFrameManager(GDview *v); 
	int GrabFrame(GDview *v, int number, int force);
	void RemoveAll(GDview *v);
	int ReadAnimationFile(GDview *v, int reload = 0);
	void SetFullCache(int fullCache, GDview *v);
        int Reload(GDview *view, int number);

	DelayRep m_Delay;	// playback delay stuff
};

#endif 
