//                      Copyright (c) 1993 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may numt be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/include/avs/animator/ImageCap.h#1 $
//

#ifndef XP_ANIMATOR_IMAGECAP_H
#define XP_ANIMATOR_IMAGECAP_H

/*

	Object:		ImageCap, ARGB/32-bit image

	Function:	Generic Capture Object for Image Capture/Flipbook

*/

#include <avs/animator/ImagForm.h>
#include <avs/animator/DelayRep.h>
#include <avs/cxxutl/array.hxx>

typedef UtArray<ImageForm *> LImages;

class ImageCap
{
private:
	LImages m_Images;	// Images
	int m_StoreOnDisk;	// Should be storing them on disk
	char m_Directory[256];	// directory name (where to store).
	char m_Extension[16];	// image extension (e.g. .x, .bmp, .ppm)

	char *TempFilename(char *buffer, xp_long index);
	void AddImage(ImageForm *i);

public:
	ImageCap();
	virtual ~ImageCap();

	void RemoveImage(xp_long n);
	void PutFrame(GDview *v, xp_long number);
	char *ChooseCodec( int deinst = 0 );
	int GenerateAVI(const char *name, const char *DirName, int overwrite,
                        int fps,
                        int compress,
                        const char *codec_str);
	int GenerateMPEG(const char *name, const char *DirName, int overwrite,
                         int fps,
                         int version,
                         int variable_rate,
                         int bit_rate,
                         int quality,
                         int buffer_size);
	LImageForm GetImageData(int image);
	void SetDirectory(const char *d);
	void SetExtension(const char *e);
	void PutAllInMemory();
	void PutAllOnDisk();
	int GetNumberImages();
	float GetCollectionSize();	// in kilobytes
	void Playback(GDview *v, int fps, int cycle);

	xp_long GrabFrame(GDview *v);
        xp_long GrabFrame(unsigned char *idata, xp_long *dims);
	void RemoveAll();

	DelayRep m_Delay;	// playback delay stuff
};

#endif
