/*
                        Copyright (c) 1997 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/animator/LInterp.h#1 $
*/

#ifndef __LINTERPOLATOR_H
#define __LINTERPOLATOR_H

/*

	Object:			Base/Abstract Interpolator Object

	Author:			Kyle Lussier

	Description:	Implement Base/Abstract Functionality for an Interpolator

	Body:  

	This object declares base functionality for the building of an interpolator.
	All implemented interpolator objects must be derived from this object.

	Date Started:	May 29, 1997

*/

#ifdef _DEBUG
#include <afx.h>	
#define new DEBUG_NEW		// Catches Memory Leaks
#endif

const int LLinear=0;
const int LCubic=1;

class LInterpolator
{
private:
		
protected:
	double *m_Values;							// Set of Data for Interpolation Analysis
	double *m_Times;							// Time Values for Interpolator
	unsigned m_N;								// Number of Values
	int m_Bisection;							// Number of Bisections
	double m_Curvy;								// Tension Applied to Spline
	int m_IsConstant;							// Is Constant Value
	double m_ConstantValue;						// Constant Value

public:
	void SetValues(float *Values, unsigned N, unsigned start=0, unsigned skip=1);
	int Constant();
	double GetTensionCurviness();
	int GetSubDiv();
	virtual void SetTension(int bi, double c);
	double * GetTimes();
	unsigned GetNumberValues();
	void AttachTimes(double *t,unsigned N);
	// Constructor/Destructor
	LInterpolator();
	virtual ~LInterpolator();

	// Public Access
	void SetValues(double *Values, unsigned N, unsigned start=0, unsigned skip=1);// Give Values to Interpolator
	double * GetValues();						// Retrieves current values

	// Required Derivables for Interpolators
	virtual int GetType() { return -1; };
	virtual int Build();						// Abstract for build evaluator
	virtual double Evaluate(double time, double curvy=0);		// Calculates Interpolation
	virtual void Destroy();
};

#include "LLinear.h"							//	Linear Object
#include "LCubic.h"								//	Cubic Object

#endif 
