/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/gfa.h#1 $
*/
/*		@(#)gfa.h	8.3 AVS 92/10/13	*/

#ifndef _GFA_ALREADY_INCLUDED
#define _GFA_ALREADY_INCLUDED

#define MAX_OLD_PROTO 7		/* Last protocol that used native format. */
#define MIN_NEW_PROTO 10	/* First version that uses new geom format. */

/*
 * This depends on stdio.h when using ANSI function prototypes.
 */

#ifndef _NFILE
#include <stdio.h>
#endif

#ifdef WIN32
#include <winsock.h>
#include <avs/pc_xdr/types.h>
#include <avs/pc_xdr/xdr.h>
#else
#include <rpc/types.h>
#include <sys/types.h>
#include <rpc/xdr.h>
#endif

#ifndef _ZCONF_H
  typedef void * gzFile;
#endif

#include <avs/mem_defs.h>

/* should probably be in port.h?! */
#ifdef WIN32
#define TELL(fd) _tell(fd)
#define SEEK _lseek
#define RDONLY _O_RDONLY
#define CREAT _O_CREAT
#define RDWR _O_RDWR
#define TRUNC _O_TRUNC
#define TEMPORARY _O_TEMPORARY
#else
/* use lseek() equiv for tell() */
#define TELL(fd) lseek(fd, 0, SEEK_CUR)
#define SEEK lseek
#define RDONLY O_RDONLY
#define CREAT O_CREAT
#define RDWR O_RDWR
#define TRUNC O_TRUNC
#define TEMPORARY CREAT
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Constant used for NULL in fortran expressions */
#ifndef F77
#define GFA_NULL 0
#define F77_NULL_PTR 0x7fffffff   /* MUST MATCH GFA_NULL VALUE */
#define F77_PTR(a) ((F77_NULL_PTR == (*((int *)a))) ? NULL : (a))
#endif /* F77 */

#ifdef F77
#define GFA_NULL 0x7fffffff   /*_F77_s: GPNULL */
#endif /* F77 */

#ifndef F77
#include <avs/port.h>
#endif /* F77 */

#define GFA_MESH         1      /*_F77_s: GPMESH */
#define GFA_POLYHEDRON   2      /*_F77_s: GPPLYH */
#define GFA_POLYTRI      3      /*_F77_s: GPPTRI */
#define GFA_SPHERE       4      /*_F77_s: GPSPHR */
#define GFA_LABEL	 5      /*_F77_s: GPLABL */
#define GFA_VOLUME 	 6
#define GFA_IMAGE 	 7
#define GFA_POLYGON	 8
#define GFA_QUAD         9
#define GFA_TRIANGLE    10
#define GFA_IMAGE_TILED 11

/* Property types */
#define GFA_COLOR	1      /*_F77_s: GPCOL  */
#define GFA_AMBIENT	2      /*_F77_s: GPAMBI */
#define GFA_DIFFUSE	3      /*_F77_s: GPDIFF */
#define GFA_SPECULAR	4      /*_F77_s: GPSPEC */
#define GFA_PICKABLE	5      /*_F77_s: GPPICK */
#define GFA_POLYGON_TYPE 6    /*_F77_s: GPPLYT */

#define GFA_SHARED	0      /*_F77_s: GPSHAR */
#define GFA_NOT_SHARED 1      /*_F77_s: GPNSHR */

/* To the GFAgen_normals function.  If set causes facet normals */
#define GFA_FACET_NORMALS 1   /*_F77_s: GPFNRM */

/* Data associated with object */
#define GFA_NORMALS	1      /*_F77_s: GPNORM */
#define GFA_VCOLORS	2      /*_F77_s: GPVCOL */
#define GFA_UVS	4      /*_F77_s: GPUVS  */
#define GFA_UVWS	8      /*_F77_s: GPUVWS */
#define GFA_LABEL_FLAGS 0x10  /*_F77_s: GLFLAG */
#define GFA_NORADII    0x20   /* internal use only */
#define GFA_PDATA	0x40   /*_F77_s: GPPDAT */
#define GFA_VDATA	0x80   /*_F77_s: GPVDAT */
#define GFA_VTRANS	0x100  /*_F77_s: GPVTRA */
#define GFA_CCOLORS	         0x200  /* NO F77 support */
#define GFA_CNORMALS	         0x400  /* NO F77 support */
#define GFA_CELL_COLOR_SEGMENTS 0x800  /* NO F77 support */
#define GFA_CELL_COLOR_CELLS    0x0  /* NO F77 support */
/*
   polyline cell color info (added for GFA) -
   if GFA_CELL_COLOR_SEGMENTS is set assume that each segment in the polyline set has a color. If not set
   assume each segment in the polyline shares the same polyline color
 */


/* Passed to read and write routines to strip off data */
#define GFA_DO_ALL_DATA 0     /*_F77_s: GPALLD */

/* When converting objects, create these descriptions */
#define GFA_SURFACE	1      /*_F77_s: GPSURF */
#define GFA_WIREFRAME	2      /*_F77_s: GPWIRE */
/* Flags for converting polygons */
#define GFA_EXHAUSTIVE	   4   /*_F77_s: GPEXHS */
#define GFA_NO_CONNECTIVITY 8 /*_F77_s: GPNCON */

/* Flags to the alloc fields of create calls */
#define GFA_DONT_COPY_DATA 1  /*_F77_s: GPNCPY */
#define GFA_COPY_DATA	    0  /*_F77_s: GPCOPY */

/* Flags for creating polygons */
#define GFA_CONVEX	   0   /*_F77_s: GPCNVX */
#define GFA_CONCAVE	   2   /*_F77_s: GPCNCV */
#define GFA_COMPLEX	   4   /*_F77_s: GPCMPX */

/* Font flags (lflags) */
#define GFA_LABEL_FONT	 	0xff     /*_F77_s: GLFONT */
#define GFA_LABEL_STROKE	0x100    /*_F77_s: GLSTRK */
#define GFA_LABEL_STRING	0x200    /*_F77_s: GLSTRG */
#define GFA_LABEL_DROPSHADOW   0x400    /*_F77_s: GLDROP */
#define GFA_LABEL_ABSOLUTE	0x800    /*_F77_s: GLABSL */
#define GFA_LABEL_CENTER	0x1000   /*_F77_s: GLCNTR */
#define GFA_LABEL_RIGHT	0x2000   /*_F77_s: GLRGHT */
#define GFA_LABEL_LEFT		0x4000   /*_F77_s: GLLEFT */
#define GFA_LABEL_BACKGROUND	0x8000   /*_F77_s: GLBACK */
#define GFA_LABEL_HIGHLIGHT	0x10000  /*_F77_s: GLHIGH */

/* Defines for the routine GFAedit_visibility */
#define GFA_EDIT_VIS		1
#define GFA_EDIT_INVIS 	0
#define GFA_EDIT_DELETE 	-1

/* Defines for the routine GFAedit_texture_options */
#define GFA_TEXTURE_FILTER	0x1
#define GFA_TEXTURE_ALPHA	0x2
#define GFA_TEXTURE_VOLUME	0x4
#define GFA_TEXTURE_TILE	0x8

#define GFA_CLIP_INSIDE	0x1
#define GFA_CLIP_OUTSIDE	0x2
#define GFA_CLIP_IGNORE	0x3
#define GFA_CLIP_INHERIT	0x4

/* defines for image stuff */
#define GFA_IMAGE_UNKNOWN 0
#define GFA_IMAGE_RGB   1
#define GFA_IMAGE_ARGB  2
#define GFA_IMAGE_DMAP  3

/*
 * Flags for the edit_camera_proj call
 */
#define GFA_CAMERA_FRONT	0x1
#define GFA_CAMERA_BACK	0x2
#define GFA_CAMERA_WSIZE	0x4
#define GFA_CAMERA_FOV		0x8
/*
 * Flags for the edit_camera_orient call
 */
#define GFA_CAMERA_FROM	0x10
#define GFA_CAMERA_AT		0x20
#define GFA_CAMERA_UP		0x40
#define GFA_CAMERA_SCALE	0x80

/* Works for both of the above */
#define GFA_CAMERA_ALL		0xffffffff

/*
 * Flags for the edit_camera_params call
 */
#define GFA_CAMERA_DEPTH_CUE		0x1
#define GFA_CAMERA_ZBUFFER		0x2
#define GFA_CAMERA_SORT_TRANSPARENCY 	0x4
#define GFA_CAMERA_GLOBAL_ANTIALIAS 	0x8
#define GFA_CAMERA_PERSPECTIVE 	0x10
#define GFA_CAMERA_AXES		0x20
#define GFA_CAMERA_FREEZE		0x40
#define GFA_CAMERA_SHOW		0x80
#define GFA_CAMERA_DOUBLE_BUFFER	0x100
#define GFA_CAMERA_SHADOWS		0x200

/*
 * Flags for the edit_depth_cue_params call
 */
#define GFA_DEPTH_CUE_FRONT	0x1
#define GFA_DEPTH_CUE_BACK	0x2
#define GFA_DEPTH_CUE_SCALE	0x4
#define GFA_DEPTH_CUE_ALL	0xffffffff

#define GFA_BACKFACE_NORMAL	0
#define GFA_BACKFACE_CULL_BACK 1
#define GFA_BACKFACE_CULL_FRONT 2
#define GFA_BACKFACE_FLIP	3
#define GFA_BACKFACE_INHERIT	4

#define GFA_CAMERA_DEPTH_FRONT 0x100
#define GFA_CAMERA_DEPTH_BACK  0x200
#define GFA_CAMERA_DEPTH_SCALE 0x400

#ifndef F77
#define GFA_FONT_NUMBER(A)	((A) & 0xff)

#define GFAadd_int_colors(O,C,N,A)		\
  	GFA_add_colors(O,(char *)(C),N,GFAadd_to_vlist_from_int,A)
#define GFAadd_float_colors(O,C,N,A) 		\
	GFA_add_colors(O,(char *)(C),N,GFAadd_to_vlist,A)

#define GFAadd_vertex_with_data(O,V,N,C)  \
	GFAadd_vertices_with_data(O,&(V),&(N),&(C),1,0)

#define GFAadd_vertex(O,V)  GFAadd_vertices(O,&(V),1,0)

typedef struct _GFAvert_list {
   xp_long	alloced_size;
   xp_long	n;
   float *l;
} GFAvert_list, GFAscalar_list; /* These are the same. but treated differently */

typedef struct _GFAvalue_list {
   xp_long	alloced_size;
   xp_long	n;
   int type;
   xp_long size;
   char *l;
} GFAvalue_list;

typedef struct _GFAint_list {
   xp_long	alloced_size;
   xp_long	n;
   int *l;
} GFAint_list;

/* 64-bit porting. Newly Introduced */
typedef struct _GFAlong_list {
   xp_long  alloced_size;
   xp_long  n;
   xp_long  *l;
} GFAlong_list;

typedef struct _GFAchar_list {
   xp_long	alloced_size;
   xp_long	n;
   char **l;
} GFAchar_list;

typedef struct _GFAplist_list {
   xp_long	alloced_size;
   xp_long	nps, nvs;	/* Number of polygons and number of vert indicies */
   xp_long  *l;		/* Compacted array of both (zero terminated) */
} GFAp_list;

typedef struct _GFAsphere {
   GFAvert_list verts;
   GFAscalar_list radii;
   GFAvert_list colors;
   GFAvert_list normals; /* Perhaps useful later on for point clouds?*/
   GFAvalue_list vdata;
   GFAscalar_list vtrans;
} GFAsphere;


typedef struct _GFAvolume {
  int x, y, z;
  GFAvert_list  verts;
  GFAvalue_list vdata;
} GFAvolume;

typedef struct _GFAimage_tiled {
  int type;
  int x, y, z;
  int tile_start;		/* tile info: start slice in volume      */
  int tile_ntiles;		/*            number to draw from start  */
  int tile_w_format;		/*            format for width (ntiles)  */
  int tile_h_format;		/*                       height          */
  int tile_orient;		/*            orientation (see gd_def.h) */
  int tile_border;              /* width of border within container      */
  int tile_cont_mode;		/* container mode, 0 or 1 */
  int tile_xform_identity;      /* 1 if tile_xform need not be applied */
  float tile_xform[4][4];       /* the local tile xform */
  GFAvert_list  verts;
  GFAvalue_list vdata;
} GFAimage_tiled;

typedef struct _GFAimage {
  int type;
  int x, y;
  GFAvert_list  verts;
  GFAvalue_list vdata;
} GFAimage;

typedef struct _GFAmesh {
   xp_long		m,n;	/* Data is same for lines or polytriangles */
   GFAvert_list verts;
   GFAvert_list normals;
   GFAvert_list colors;
   GFAscalar_list uvs;
   GFAvalue_list vdata;
   GFAint_list pdata;
   GFAscalar_list vtrans;
} GFAmesh;

typedef struct _GFApolygon {
   GFAvert_list verts;
   GFAvert_list normals;
   GFAvert_list colors;
   GFAscalar_list uvs;
   GFAlong_list polys;  /* list size is the number of polygons */
                         /* each int value represents the number */
                         /* of verts in that particular polygon */
   GFAvert_list  cellcolors;
   GFAvalue_list vdata;
} GFApolygon;


typedef struct _GFApolytri {
   xp_long npts;		   /* Number of polytris */
   GFAvert_list *ptverts; /* Polytriangle data */
   GFAvert_list *ptcolors;
   GFAvert_list *ptnormals;
   GFAscalar_list *ptuvs;
   GFAvert_list *ptcellcolors;  /* NEW - poly cell colors added for GFA */
   GFAvert_list *ptcellnormals; /* NEW - poly cell normals added for GFA */

   xp_long npls;		    /* Number of polylines */
   GFAvert_list *plverts; /* Polyline data */
   GFAvert_list *plcolors;
   GFAvert_list *plcellcolors;  /* NEW - line cell colors added for GFA */
   GFAvert_list dlverts; /* Disjoint line data */
   GFAvert_list dlcolors;
   GFAvert_list dlcellcolors;   /* NEW - disjoint cell colors  added for GFA */

   /* User defined data for polytris, polylines, disjoint lines */
   GFAvalue_list *ptvdata;
   GFAint_list *ptpdata;
   GFAvalue_list *plvdata;
   GFAint_list *plpdata;
   GFAvalue_list dlvdata;
   GFAint_list dlpdata;
   GFAscalar_list *ptvtrans;
} GFApolytri;

typedef struct _GFAlabel {
   int align_horiz;              /* alignment in the local text x coord */
   int align_vert;               /* alignment in the local text y coord */
   unsigned int text_options;    /* bit mask of text options */
   GFAchar_list labels;	/* Character strings themselves */
   GFAvert_list verts; 	/* Locations of label strings */
   GFAvert_list offsets;	/* Offsets of label strings from point */
   GFAvert_list colors;	/* Color of string */
} GFAlabel;

typedef struct _GFApolyh {
   GFAvert_list verts;
   GFAvert_list normals;
   GFAvert_list colors;
   GFAscalar_list uvs;
   GFAp_list	ptlist;
   GFAvalue_list vdata;
   GFAint_list pdata;
   GFAscalar_list vtrans;
} GFApolyh;

typedef struct _GFAval {
   int	type;
   int  size; /* Number of bytes of extra data following this struct */
   union {
      int	i;
      float	f;
      unsigned  long c;
      int	data[1];
   } d;
} GFAval;

typedef struct _GFAobj {
   int	type; /* Object type */
   int  data; /* Vertex data that this object has (normals and vertices) */
   float extent[6];
   int	 has_extent;
   int   has_surface;
   int   has_lines;
   int   nspace;
   char	 *name, *filename;
   char  *groupname;
   GFAval *vals;	/* Pointer to a list of name/value pairs */
   int	nvals;
   union {	/* An objects internal bits */
      GFAmesh     m;
      GFApolyh   ph;
      GFApolytri pt;
      GFAsphere  sp;
      GFAlabel   la;
      GFAvolume  vo;
      GFAimage   im;
      GFAimage_tiled imt;
      GFApolygon po;
   } d;
   int	refcnt;
} GFAobj;

/* The first 4 bytes of a geom file contain a "magic" number. */
/* In AVS version 2, this number was "GEOM" on most machines and */
/* "MOEG" on the DECstation.  */
/* For AVS version 3, it was changed to "GEO3" for all machines. */
/* Data is now stored in XDR rather than native format so the same */
/* file can be used on all machine types without any converters. */

#define GFA_FILE_MAGIC  0x47454F4D  /* ascii "GFA" */
#define GFA_FILE_MAGIC_V3 0x47454F33 /* ascii "GEO3" */
#define GFA_FILE_MAGIC_V4 0x47454F34 /* ascii "GEO4" */
#define GFA_FILE_MAGIC_64 0x474D3634 /* ascii "GM64" */


typedef struct _GFAobj_file_header {
   int		magic;	/* magic number that indicates this is a GFA file */
   int		hdrsize; /* Size of object header data (after this header) */
   int		data;	/* Data field from above */
   int		type;	/* Object type from above */
   float	extent[6]; /* Extent from above */
   int		has_extent; /* From above if extent is valid */
   int          has_surface;
   int          has_lines;
   int          nspace;
   xp_long	bytecount; /* Number of bytes total in object */
   int		nvals;
   /*
    Val data follows. For each val structure:
	int type;
	int size;  where n >= 4
	[ n bytes of data ]

    Names follow: null terminated: object name, group name
    */
} GFAobj_file_hdr;

typedef struct _GFAsphere_file {
   xp_long nverts;
   /*
   VERTICES X Y Z
   RADII
   if (normals) NORMALS X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (vtrans) VERTTRANS
   */
} GFAsphere_file_hdr;

typedef struct _GFApolytri_file {
   xp_long		npts, npls, dls /* one or zero */;
/*
   data follows:
   PTRI data
   N verts
   VERTICES X Y Z
   if (normals) NORMALS X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (pdata) PRIMDATA
   if (vtrans) VERTTRANS
   PLINE data
   N verts
   VERTICES X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (pdata) PRIMDATA
   DLINE data
   N verts
   VERTICES X Y Z
   if (colors) COLORS R G B
   if (vdata) VERTDATA
   if (pdata) PRIMDATA
*/
} GFAptri_file_hdr;

typedef struct _GFAmesh_file {
   xp_long		n, m;
/*
   data follows:
   verts
   if (normals) normals
   if (colors) colors
   if (uvs) uvs;
   if (vdata) vertdata
   if (pdata) primdata
   if (vtrans) VERTTRANS
*/
} GFAmesh_file_hdr;

typedef struct _GFAvolume_file {
   int		x,y,z;
/*
   data follows:
   verts
   if (vdata) vertdata
*/
} GFAvolume_file_hdr;

typedef struct _GFAimage_file {
   int          type;
   int		x,y;
/*
   data follows:
   verts
   if (vdata) vertdata
*/
} GFAimage_file_hdr;

typedef struct _GFApolyh_file {
   xp_long nps, nvs, nverts;
/*
   data follows:
   indicies
   verts
   if (normals) normals
   if (colors) colors
   if (uvs) uvs;
   if (vdata) vertdata
   if (pdata) primdata
   if (vtrans) VERTTRANS
*/
} GFApolyh_file_hdr;


typedef struct _GFApolygon_file {
   xp_long nverts, npolys;
/*
   data follows:
   indicies
   verts
   if (normals) normals
   if (colors) colors
   if (uvs) uvs;
*/
} GFApolygon_file_hdr;



typedef struct _GFAlabel_file {
   xp_long nlabels;
   int align_horiz;              /* alignment in the local text x coord */
   int align_vert;               /* alignment in the local text y coord */
   unsigned int text_options;    /* bit mask of text options */
/*
   data follows:
   char labels (null terminated)
   label positions
   label offsets
   if (colors) colors
*/
} GFAlabel_file_hdr;

typedef float GFApoint3[3];

typedef struct _GFAedit {
  int type;
  char *data;
  char *name;
  int size; /* If it is a generic value, this is valid */
  struct _GFAedit *next;
} GFAedit;

typedef struct _GFAedit_list {
   GFAedit *l;
} *GFAedit_list;


#define AVS_PROTO_VERSION  24

struct gfa_descriptor {
	int s;                  /* socket file number */
	char *wbuf;             /* the write buffer */
	int wf, wb;             /* front and back of the write buffer */
	char *rbuf;             /* the read buffer */
	int rf, rb;             /* front and back of the read buffer */
	xp_long (*func)();          /* function to call for select */
	int arg;                /* argument to func */
	struct gfa_descriptor *sel_next; /* next function on the select list */

	XDR read_xdrs;		/* The XDR handle for reads. */
	XDR write_xdrs;		/* The XDR handle for writes. */

	enum { TCP_LOCAL,	/* Other end is on same machine. */
		TCP_REMOTE,	/* Other end is on different machine. */
		TCP_UNKNOWN 	/* Don't know yet. */
	} other_end;
	int refcnt;		/* Number of references to this descriptor */

	int debug_level;	/* Used to record all socket reads and */
				/* writes in a file. */
				/* 1 = just the sizes of data. */
				/* 2 = all the data too. */
	FILE *debug_fp;		/* File for use with above. */

	int bypass_xdr_char;	/* May be possible to bypass XDR layer */
	int bypass_xdr_int;	/* when both sides have same data */
	int bypass_xdr_float;	/* representation. */
	int bypass_xdr_double;
	int bypass_xdr_int64_t;

	int proto_vers;		/* Highest protocol version understood */
				/* by both ends of the socket. */

	int other_host_addr;	/* Host address on other end of socket. */
	int other_pid;		/* Process id on other end of socket. */

	struct gfa_descriptor *next_open;	/* Used to maintain */
				/* linked list of all open sockets.  */
				/* AVStcp_create links new item into */
				/* existing */
				/* list. */
				/* tcp_destroy removes it when socket */
				/* is closed and this structure is freed. */

	int bypass_xdr_short;

	int compressed;
	gzFile gz_file;
	char *gzbuf;
};

#ifndef avsargs_h
#include <avs/avsargs.h>
#endif

#if 0

#if NeedFunctionPrototypes
#ifndef _COLORMAP_H_defined
#include <avs/colormap.h>
#endif

#ifndef _FIELD_H_defined
#include <avs/field.h>
#endif
#endif /* NeedFunctionPrototypes */

#endif

#ifdef __cplusplus
extern "C" {
#endif

AVS_EXTERN(void GFA_add_colors, (GFAobj *obj, char *colors, xp_long n,
				void (*cvt_func)(), int alloc));
AVS_EXTERN(void GFAadd_disjoint_line, (GFAobj *obj, float *verts,
					float *colors, float *cell_colors, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_disjoint_polygon, (GFAobj *obj, float *verts,
					   float *normals, float *colors,
					   xp_long nverts, int flag, int alloc));
AVS_EXTERN(void GFAadd_disjoint_prim_data, (GFAobj *obj, int *pdata, xp_long n,
					     int alloc));
AVS_EXTERN(void GFAadd_disjoint_vertex_data, (GFAobj *obj, char *vdata, xp_long n, int type, xp_long size,
					       int alloc));
AVS_EXTERN(void GFAadd_int_value, (GFAobj *obj, int type, int value));
AVS_EXTERN(void GFAadd_label, (GFAobj *obj, char *label, float *vert,
				float *offset, float *color));
AVS_EXTERN(void GFAadd_labels, (GFAobj *obj, char **labels, float *verts,
				float *offsets, float *colors,
				xp_long n, int alloc));
AVS_EXTERN(void GFAadd_normals, (GFAobj *obj, float *normals, xp_long n,
				  int alloc));
AVS_EXTERN(void GFAadd_polygon, (GFAobj *obj, xp_long nverts, xp_long *indicies,
				  int flags, int alloc));
AVS_EXTERN(void GFAadd_polygons, (GFAobj *obj, xp_long *plist,
				   int flags, int alloc));
AVS_EXTERN(void GFAadd_polyh, (GFAobj *obj, xp_long *plist, int flags,
				int alloc));

AVS_EXTERN(void GFAadd_polygon_cells, (GFAobj *obj, xp_long *polys, xp_long npolys, int alloc));
AVS_EXTERN(void GFAadd_cell_colors, (GFAobj *obj, float *cell_colors, xp_long n, int alloc));

AVS_EXTERN(void GFAadd_polyline, (GFAobj *obj, float *verts, float *colors,
		   float *cell_colors, int cell_color_type, xp_long n, int alloc));

AVS_EXTERN(void GFAadd_polyline_colors, (GFAobj *obj, float *colors, xp_long i,
					  xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polyline_prim_data, (GFAobj *obj, int *pdata, xp_long i,
					     xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polyline_vertex_data, (GFAobj *obj, char *vdata, xp_long i,
					       xp_long n, int type, xp_long size, int alloc));
AVS_EXTERN(void GFAadd_polytriangle, (GFAobj *obj, float *verts,
				       float *normals, float *colors,
				       float *cell_colors, float *cell_normals,
				       xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polytriangle_colors, (GFAobj *obj, float *colors,
					      xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polytriangle_cell_colors, (GFAobj *obj, float *ccolors,
					      xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polytriangle_prim_data, (GFAobj *obj, int *pdata,
						 xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polytriangle_uvs, (GFAobj *obj, float *uvs, xp_long i,
					   xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polytriangle_uvws, (GFAobj *obj, float *uvs, xp_long i,
					    xp_long n, int alloc));
AVS_EXTERN(void GFAadd_polytriangle_vertex_data, (GFAobj *obj, char *vdata,
						   xp_long i, xp_long n, int type, xp_long size,int alloc));
AVS_EXTERN(void GFAadd_polytriangle_vertex_trans, (GFAobj *obj, float *vtrans,
						    xp_long i, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_prim_data, (GFAobj *obj, int *pdata, xp_long n,
				    int alloc));
AVS_EXTERN(void GFAadd_radii, (GFAobj *obj, float *radii, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_uvs, (GFAobj *obj, float *uvs, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_uvws, (GFAobj *obj, float *uvs, xp_long n, int alloc));
AVS_EXTERN(void GFAadd_vertex_data, (GFAobj *obj, char *vdata, xp_long n, int type, xp_long size,
				      int alloc));
AVS_EXTERN(void GFAadd_vertex_trans, (GFAobj *obj, float *vtrans, xp_long n,
				       int alloc));
AVS_EXTERN(void GFAadd_vertices, (GFAobj *obj, float *verts, xp_long n,
				   int alloc));
AVS_EXTERN(void GFAadd_vertices_with_data, (GFAobj *obj, float *verts,
					     float *normals,
					     unsigned int *colors, xp_long n,
					     int alloc));
#if 0 /* GEOM functions that were never implemented for GFA. */
AVS_EXTERN(void GFAauto_transform, (GFAobj *obj));
AVS_EXTERN(void GFAauto_transform_list, (GFAobj **objs, int n));
AVS_EXTERN(void GFAauto_transform_non_uniform, (GFAobj *obj));
AVS_EXTERN(void GFAauto_transform_non_uniform_list, (GFAobj **objs, int n));
#endif
AVS_EXTERN(int GFAcheck_obj, (GFAobj *obj, int flags, int (*func)()));

AVS_EXTERN( GFAobj * GFAcreate_label, (float *extent,
				      int align_horiz,
				      int align_vert,
				      unsigned int text_options));

AVS_EXTERN( GFAobj *GFAcreate_mesh, (float *extent, float *verts, xp_long n,
				       xp_long m, int alloc));
AVS_EXTERN(void GFAcreate_mesh_uvs, (GFAobj *obj, double umin, double vmin,
				      double umax, double vmax));
AVS_EXTERN( GFAobj *GFAcreate_mesh_with_data, (float *extent, float *verts,
						 float *normals,
						 unsigned int *colors, xp_long n,
						 xp_long m, int alloc));

AVS_EXTERN( GFAobj * GFAcreate_volume, (float *extent, int x, int y, int z));
AVS_EXTERN( GFAobj * GFAcreate_image, (float *extent, int type, int x, int y));

AVS_EXTERN( GFAobj * GFAcreate_image_tiled, (float *extent, int type, int x, int y, int z,
				      int tile_start, int tile_ntiles,
				      int tile_w_format,  int tile_h_format,
				      int tile_orient,  int tile_border,
				      int tile_cont_mode, int tile_xform_identity,
				      float *tile_xform));

AVS_EXTERN( GFAobj *GFAcreate_normal_object, (GFAobj *obj, double scale));
AVS_EXTERN( GFAobj *GFAcreate_obj, (int type, float *extent));
AVS_EXTERN( GFAobj *GFAcreate_polyh, (float *extent, float *verts, xp_long n,
					xp_long *plist, int flags, int alloc));
AVS_EXTERN( GFAobj *GFAcreate_polyh_with_data, (float *extent, float *verts,
						  float *normals,
						  unsigned int *colors, xp_long n,
						  xp_long *plist, int flags,
						  int alloc));
AVS_EXTERN( GFAobj *GFAcreate_scalar_mesh, (float xmin, float xmax,
					      float ymin, float ymax,
					      float *mesh, float *colors, xp_long n,
					      xp_long m, int alloc));
AVS_EXTERN( GFAobj *GFAcreate_sphere, (float *extent, float *verts,
					 float *radii, float *normals,
					 unsigned int *colors, xp_long n,
					 int alloc));
AVS_EXTERN(void GFAcreate_sphere_uvs, (GFAobj *obj, float matrix[4][4],
					float umin, float vmin, float umax,
					float vmax));
AVS_EXTERN(void GFAcvt_mesh_to_polytri, (GFAobj *obj, int flag));
AVS_EXTERN(int GFAcvt_polyh_to_polytri, (GFAobj *obj, int flags));
AVS_EXTERN(void GFAdestroy_edit_list, (GFAedit_list list));
AVS_EXTERN(int GFAdestroy_obj, (GFAobj *obj));
AVS_EXTERN(void GFAdestroy_uvs, (GFAobj *obj));
AVS_EXTERN(void GFAedit_backface, (GFAedit_list list, char *name, int mode));
AVS_EXTERN(void GFAedit_camera_orient, (GFAedit_list list, char *name,
					 int flags, float scale, float at[3],
					 float up[3], float from[3]));
AVS_EXTERN(void GFAedit_camera_params, (GFAedit_list list, char *name,
					 int options, int val));
AVS_EXTERN(void GFAedit_camera_project, (GFAedit_list list, char *name,
					  int flags, float front, float back,
					  float fov, float wsize));
AVS_EXTERN(void GFAedit_center, (GFAedit_list list, char *name,
				  float *center));
AVS_EXTERN(void GFAedit_clip_plane, (GFAedit_list list, char *obj,
				      char *clip, int state));
AVS_EXTERN(void GFAedit_color, (GFAedit_list list, char *name, float *color));
AVS_EXTERN(void GFAedit_concat_matrix, (GFAedit_list list, char *name,
					 float *matrix));
AVS_EXTERN(void GFAedit_cycle, (GFAedit_list list, char *name, int cycle));
AVS_EXTERN(void GFAedit_depth_cue_params, (GFAedit_list list, char *name,
					    int flags, float front, float back,
					    float scale));
#if 0
AVS_EXTERN(void GFAedit_field_texture, (GFAedit_list	list, char *name,
					 AVSfield *field));
#endif
AVS_EXTERN(void GFAedit_geometry, (GFAedit_list list, char *name,
				    GFAobj *obj));
AVS_EXTERN(void GFAedit_light, (GFAedit_list list, char *name, char *type,
				 int status));
AVS_EXTERN(void GFAedit_parent, (GFAedit_list list, char *name,
				  char *parent));
AVS_EXTERN(void GFAedit_position, (GFAedit_list list, char *name,
				    float *position));
AVS_EXTERN(void GFAedit_projection, (GFAedit_list list, char *name,
				      float *projection));
AVS_EXTERN(void GFAedit_properties, (GFAedit_list list, char *name,
				      float ambient, float diffuse,
				      float specular, float spec_exp,
				      float transparency, float spec_col[3]));
AVS_EXTERN(void GFAedit_render_mode, (GFAedit_list list, char *name,
				       char *mode));
AVS_EXTERN(void GFAedit_selection_mode, (GFAedit_list list, char *name,
					  char *mode, int flags));
AVS_EXTERN(void GFAedit_set_matrix, (GFAedit_list list, char *name,
				      float *matrix));
AVS_EXTERN(void GFAedit_subdivision, (GFAedit_list list, char *name,
				       int subdiv));
#if 0
AVS_EXTERN(void GFAedit_texture, (GFAedit_list list, char *name,
				   char *texture));
AVS_EXTERN(void GFAedit_texture_colormap, (GFAedit_list list, char *name,
					    AVScolormap *colormap));
AVS_EXTERN(void GFAedit_texture_options, (GFAedit_list list, char *name,
					   int options, int val));
#endif
AVS_EXTERN(void GFAedit_transform_mode, (GFAedit_list list, char *name,
					  char *redirect, int flags));
AVS_EXTERN(void GFAedit_visibility, (GFAedit_list list, char *name, int vis));
AVS_EXTERN(void GFAedit_window, (GFAedit_list list, char *name,
				  float *window));
AVS_EXTERN(void GFAflip_normals, (GFAobj *obj));
AVS_EXTERN(int GFAfont_number, (int a));
AVS_EXTERN(void GFAgen_normals, (GFAobj *obj, int flags));
AVS_EXTERN(void GFAgen_normals_tol, (GFAobj *obj,int flags,double tol));
AVS_EXTERN( GFAedit_list GFAinit_edit_list, (GFAedit_list list));
AVS_EXTERN(void GFAnormalize_normals, (GFAobj *obj));
AVS_EXTERN(void GFAprocess_edit_list, (GFAedit_list list));
AVS_EXTERN(int GFAquery_int_value, (GFAobj *obj, int type, int *value));
AVS_EXTERN( GFAobj *GFAread_obj, (int fd, int flags));
AVS_EXTERN( GFAobj *GFAread_text, (FILE *fp, int flags));
AVS_EXTERN(void GFAset_color, (GFAobj *obj, unsigned int color));
AVS_EXTERN(void GFAset_polygon_type, (GFAobj *obj, int type));
AVS_EXTERN(void GFAset_computed_extent, (GFAobj *obj, float *extent));
AVS_EXTERN(void GFAset_extent, (GFAobj *obj));
AVS_EXTERN(void GFAset_object_group, (GFAobj *obj, char *name));

AVS_EXTERN(void GFAset_has_surface , (GFAobj *, int));
AVS_EXTERN(void GFAset_has_lines   , (GFAobj *, int));
AVS_EXTERN(void GFAset_nspace      , (GFAobj *, int));

AVS_EXTERN(void GFAset_object_name, (GFAobj *obj, char *name));
AVS_EXTERN(void GFAset_pickable, (GFAobj *obj, unsigned int pickable));
AVS_EXTERN(void GFAunion_extents, (GFAobj *obj1, GFAobj *obj2));
AVS_EXTERN(void GFAwrite_obj, (GFAobj *obj, int fd, int format, int flags));
AVS_EXTERN(void GFAwrite_text, (GFAobj *obj, FILE *fp, int flags));
AVS_EXTERN( char *GFAget_font_info, (int value, int *bold, int *italic));
AVS_EXTERN(int *GFAtriangulate_polygons,(GFAobj *obj));
AVS_EXTERN(void GFAserialize_obj, (GFAobj *obj, void *fd, int format,
				    int flags, int proto_version));
AVS_EXTERN(GFAobj * GFAunserialize_obj, (char *arg, int flags, int proto_version));

AVS_EXTERN(void GFAadd_to_ilist, (GFAint_list *ilist, int *ints,
			       xp_long n, xp_long grow, int alloc));
AVS_EXTERN(void GFAcreate_ilist, (GFAint_list *new_ilist, int *ilist, xp_long n,
			       int alloc));
AVS_EXTERN(void GFAadd_to_llist, (GFAlong_list *llist, xp_long *longs,
			       xp_long n, xp_long grow, int alloc));
AVS_EXTERN(void GFAcreate_llist, (GFAlong_list *new_llist, xp_long *llist, xp_long n,
			       int alloc));
AVS_EXTERN(void GFAadd_to_vlist_from_int, (GFAvert_list *vlist,
					unsigned int *verts, xp_long n, xp_long grow,
					int alloc));
AVS_EXTERN(void GFAcreate_vlist_from_int, (GFAvert_list *new_vlist,
					unsigned int *vlist, xp_long n,
					int alloc));
AVS_EXTERN(void GFAadd_to_vlist, (GFAvert_list *vlist, float *verts, xp_long n,
			       xp_long grow, int alloc));
AVS_EXTERN(void GFAcreate_vlist, (GFAvert_list *new_vlist, float *vlist, xp_long n,
			       int alloc));
AVS_EXTERN(void GFAadd_to_plist, (GFAobj *obj, GFAp_list *new_plist,
			       xp_long *plist, int flags, int alloc));
AVS_EXTERN(void GFAcreate_plist, (GFAp_list *new_plist,
			       xp_long *plist, int flags, int alloc));
AVS_EXTERN(void GFAadd_to_slist, (GFAscalar_list *slist,
			       float *scalars, xp_long n,
			       xp_long grow, int alloc));
AVS_EXTERN(void GFAcreate_slist, (GFAscalar_list *new_slist, float *slist, xp_long n,
			       int alloc));
AVS_EXTERN(void GFAadd_to_fvlist, (GFAvert_list *vlist,
				float *vx, float *vy,
				float *vz, xp_long n, xp_long grow,
				int alloc));
AVS_EXTERN(void GFAdestroy_plist, (GFAp_list *plist));
AVS_EXTERN(void GFAdestroy_slist, (GFAscalar_list *slist));
AVS_EXTERN(void GFAdestroy_vlist, (GFAvert_list *vlist));
AVS_EXTERN(void GFAdestroy_charlist, (GFAchar_list *charlist));
AVS_EXTERN(void GFAdestroy_ilist, (GFAint_list *ilist));
AVS_EXTERN(void GFAdestroy_llist, (GFAlong_list *llist));
AVS_EXTERN(void GFAcopy_with_stride, (float *dst, int ds,
				   float *src, int ss,
				   xp_long n));
AVS_EXTERN(void GFAcopy_with_stride_int, (int *dst, int ds,
				       int *src, int ss,
				       xp_long n));
AVS_EXTERN(void GFAcreate_charlist, (GFAchar_list *ll, char **labels, xp_long n,
				  int alloc));
AVS_EXTERN(void GFAadd_string_to_charlist, (GFAchar_list *ll, char *label));

  char *GFAunixio_create (int fd);
  char *GFAunixio_create_compressed (int fd, const char *mode);
  void GFAunixio_destroy (char *arg);
  int GFAunixio_flush (void *arg);
  xp_long GFAunixio_read (char *arg, char *buf, xp_long len);
  xp_long GFAunixio_write (char *arg, char *buf, xp_long len);
  void GFAinteger_array_read (void *arg, int **datapp, xp_long count);
  void GFAinteger_array_write (void *arg, int *datap, xp_long count);
  xp_long GFAinteger_read (void *arg, int *data);
  void GFAinteger_write (void *arg, int data);

  #ifdef WORDLENGTH_64
  xp_long GFAint64_read (void *arg, xp_long *data);
  void GFAint64_write (void *arg, xp_long data);
  void GFAint64_array_read (void *arg, xp_long **datapp, xp_long count);
  void GFAint64_array_write (void *arg, xp_long *datap, xp_long count);
  #endif

  void GFAreal_array_read (void *arg, float **datapp, xp_long count);
  void GFAreal_array_write (void *arg, float *datap, xp_long count);
  void GFAreal_read (void *arg, float **datapp);
  void GFAreal_write (void *arg, float *datap);
  void GFAbyte_array_read (void *arg, char **datapp, xp_long length);
  void GFAbyte_array_write (void *arg, char *datap, xp_long length);
  xp_long GFAstring_read(void *arrrg, char **datapp);
  void GFAstring_write(void *arrrg, char *datap);

#ifdef __cplusplus
}
#endif

#define PH(A)	((A)->d.ph)
#define PT(A)	((A)->d.pt)
#define MSH(A)	((A)->d.m)
#define SP(A)	((A)->d.sp)
#define LA(A)	((A)->d.la)
#define VO(A)	((A)->d.vo)
#define IM(A)	((A)->d.im)
#define IMT(A)	((A)->d.imt)
#define PO(A)	((A)->d.po)


#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif /* F77 */
#endif /* _GFA_ALREADY_INCLUDED */
