/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/gfaFileRead.hxx#1 $
*/

#ifndef _GFA_FILEREAD_HXX_
#define _GFA_FILEREAD_HXX_

#include <avs/util.h>
#include <avs/gd.h>
#include <avs/animator/gfaFile.hxx>
#include <avs/animator/GS_ListHeader.hxx>

class DiscFrameManager;

extern "C"  {
int GFAread_animation(GDview *view, DiscFrameManager *discCacheManager, char *fileName, int fullCache);
void GFAuse_load_status_label();
void GFAuse_cache_status_label();
}

class GFA2GeomConverter;

class GFAFileRead : public GFAFile {
  friend class GFA2GeomConverter;
public:
  GFAFileRead(GDview *view, DiscFrameManager *discCacheManager = NULL);
  ~GFAFileRead();

  int ReadFlipbook(int fullCache);

private:
  inline void GFAread_floats(float *where, xp_long count) {
    float *pf = where;
    GFAreal_array_read (_GFAunixio, &pf, count);
  }

  inline void GFAread_float(float *where) {
    float *pf = where;
    GFAreal_read       (_GFAunixio, &pf);
  }

  inline void GFAread_integers(int *where, xp_long count) {
    int *pi = where;
    GFAinteger_array_read (_GFAunixio, &pi, count);
  }

  inline void GFAread_integer(int *where) {
    GFAinteger_read (_GFAunixio, where);
  }

  inline void GFAread_bytes(char *where, xp_long count) {
    char *bf = where;
    GFAbyte_array_read (_GFAunixio, &bf, count);
  }

  inline void GFAread_unsigned_bytes(unsigned char *where, xp_long count) {
    char *bf = (char *) where;
    GFAbyte_array_read (_GFAunixio, &bf, count);
  }


  int ReadHeader(GFABlockType *type, int *data) {
    int check = 1;
    if (GFAinteger_read (_GFAunixio, (int *)type) == FALSE)
      check = 0;
    if (GFAinteger_read (_GFAunixio, data) == FALSE)
      check = 0;
    return check;
  }

  inline void copyXform(GDxform *dst, GDxform *src) {
    // copy the OM stuff
    GDxform_set_xlate(dst->xform_id , src->xlate);
    GDxform_set_center(dst->xform_id, src->center);
    GDxform_set_matrix(dst->xform_id, src->xform);
    GDset_int_val(dst->xform_id, "rspace", src->rspace);
    GDset_float_array(dst->xform_id, "dcenter", 3, src->dcenter);
    GDset_float_array(dst->xform_id, "ocenter", 3, src->center);
    // make sure local values are updated
    memcpy(dst->xform, src->xform, sizeof(dst->xform));
    memcpy(dst->xlate, src->xlate, sizeof(dst->xlate));
    memcpy(dst->center,src->center,sizeof(dst->center));
    memcpy(dst->matrix,src->matrix,sizeof(dst->matrix));
    dst->rspace = src->rspace;
    memcpy(dst->dcenter,src->dcenter,sizeof(dst->dcenter));

#if 0
				/* moving when center is changed */
  int is_rolling;		/* 1 if "track rolling", means concat... */
  float roll_xform[4][4];	/* ...this stuff on each render */
  float roll_xlate[3];
#endif

#if 0
    GDxform_update(dst->xform_id, dst);
#endif
  }

  inline void copyProps(GDprops *dst, GDprops *src) {
    // first reset dst props need to do this in case the
    // src props wants default values
    GDprops_reset(dst->props_id);

    // now update any changed properties
    if (src->changed & GD_CHANGE_PROP_COL)
      GDprops_set_color(dst->props_id, src->col);
    if (src->changed & GD_CHANGE_PROP_HI_COL) {
      GDprops_set_hi1_col(dst->props_id, src->hi1_col);
      GDprops_set_hi2_col(dst->props_id, src->hi2_col);
    }
    if (src->changed & GD_CHANGE_PROP_MAT)
      GDprops_set_material(dst->props_id, src->material);
    if (src->changed & GD_CHANGE_PROP_SCOL)
      GDprops_set_specular_color(dst->props_id, src->spec_col);
    if (src->changed & GD_CHANGE_PROP_TRANS)
      GDprops_set_transparency(dst->props_id, src->trans);
    if (src->changed & GD_CHANGE_PROP_DRAW_MODE)
      GDprops_set_draw_mode(dst->props_id, src->draw_mode);
    if (src->changed & GD_CHANGE_PROP_LINE_WIDTH)
      GDprops_set_line_width(dst->props_id, src->line_width);
    if (src->changed & GD_CHANGE_PROP_LINE_STYLE)
      GDprops_set_line_style(dst->props_id, src->line_style);
    if (src->changed & GD_CHANGE_PROP_LINE_AA)
      GDprops_set_line_aa(dst->props_id, src->line_aa);
    if (src->changed & GD_CHANGE_PROP_DIR_PT_SIZE)
      GDprops_set_dir_pt_size(dst->props_id, src->dir_pt_size);
    if (src->changed & GD_CHANGE_PROP_SUBDIV)
      GDprops_set_subdiv(dst->props_id, src->subdiv);
    if (src->changed & GD_CHANGE_PROP_CULL)
      GDprops_set_cull(dst->props_id, src->cull);
    if (src->changed & GD_CHANGE_PROP_JITTER)
      GDprops_set_jitter(dst->props_id, src->jitter);
    if (src->changed & GD_CHANGE_PROP_VOX_INTERP)
      GDprops_set_vox_interp(dst->props_id, src->vox_interp);
    if (src->changed & GD_CHANGE_PROP_RAY_ALGO)
      GDprops_set_ray_algo(dst->props_id, src->ray_algo);
    if (src->changed & GD_CHANGE_PROP_RAY_NORM)
      GDprops_set_ray_norm(dst->props_id, src->ray_norm);
    if (src->changed & GD_CHANGE_PROP_FAT_RAY)
      GDprops_set_fat_ray(dst->props_id, src->fat_ray);
    if (src->changed & GD_CHANGE_PROP_SFP_ABSORB)
      GDprops_set_sfp_absorb(dst->props_id, src->sfp_absorb);
    if (src->changed & GD_CHANGE_PROP_SFP_EMIT)
      GDprops_set_sfp_emit(dst->props_id, src->sfp_emit);
    if (src->changed & GD_CHANGE_PROP_FONT)
      GDprops_set_font(dst->props_id, src->font);

    GDprops_set_inherit(dst->props_id, src->inherit);
    if (src->changed)
      GDprops_update(dst->props_id);

    dst->saved_changed = src->saved_changed;
    dst->cache_valid = src->cache_valid;
  }

  inline void copyModes(GDmodes *dst, GDmodes *src) {
    if (src->changed & GD_CHANGE_MODE)
      GDset_int_array(dst->modes_id, "mode", GD_MODE_SIZE, src->mode);
    if (src->changed & GD_CHANGE_NORMALS)
      GDmodes_set_normals(dst->modes_id, src->normals);
    if (src->changed & GD_CHANGE_OUTLINE)
      GDmodes_set_outline(dst->modes_id, src->outline);
    // GDmodes_set_colors(dst->modes_id, src->colors);
    if (src->changed)
      GDmodes_update(dst->modes_id);
  }

  int ReadFileHeader();
  int ReadXform(int id, GFABlockType type);
  int ReadProps(int id);
  int ReadModes(int id);
  int ReadTxtr(int id);
public:
  GDtexture *ReadTxtrEx(int id);
private:
  GDtexture *ReadTexture(int id);

  int ReadCameraList(int nCameras);

  int AlreadyUsed(GDcamera *camera);
  int AttachNewFlipbook(GDcamera *camera);

  int ReadCamera(int type);
  int ReadFrame(int nobjs);
  int ReadObject(GDobject*, int isTopLevel);
  int ReadGeometry(int id, int fullCache);
public:
  GDcache_header * ReadGeometryEx(int id, int fullCache);
private:
  GDcache_header * ReadCacheHeader(int id, int fullCache);
  int ReadCache(GDcache_header *, int fullCache);


  GS_ListHeader<GDcache_header> m_geometry_cache_list;
  GS_ListHeader<GDxform> m_xformList;
  GS_ListHeader<GDprops> m_propsList;
  GS_ListHeader<GDmodes> m_modesList;
  GS_ListHeader<GDtexture> m_textureList;
  GS_ListHeader<GDxform> m_txtrXformList;

  int _nFrames;
  int _file_frame;
  int _nCameras;
  int _cCameraIndex;
  int _copyCache;

  GDcamera   **_cameras;
  GDcamera   *_cCamera;
  GDflipbook *_flipbook;
  GDview     *_view;
  GDobject   *_activeTopObj;

  inline int updateStatus() {
    int Interrupt;
    if (_status_max)
      OMstatus_check((_status_count++ * 100)/_status_max , NULL, &Interrupt);
    return Interrupt;
  }

  int _status_max;
  int _status_count;

  DiscFrameManager *_discFrameManager;

  int _cache_id;
  int _txtr_id;
};


//
// GeomData to GFAObj converter classes
//

class GFA2GeomConverter {
public:
  static GDgeom_data *ReadAndConvert(GFAFileRead *reader,
                                     GDcache_header *cache, int fullCache);
  GFA2GeomConverter(GDcache_header *cache, int malloc_flag);
  virtual ~GFA2GeomConverter() {}

  // create the geometry type
  virtual int Convert(GFAobj * _obj);
  GDgeom_data    *GetGeomData() { return _data;};
protected:

  inline void set_alloced_flag(int &flag) { flag = _malloc_flag; };
  inline char *cache_malloc(xp_long size) {
    char *data;
    if (_malloc_flag == GD_CACHE_FLAG_MALLOC) {
      UALLOCN( data, char, size, "cannot alloc GFA data" );
    } else
      data = GDflipbook_cache_malloc(_cache, size);
    return data;
  }

  inline float * copy_verts(GFAvert_list &vert_list) {
    float *array;
    xp_long n = vert_list.n ;

    if (n > 0) {
      array = (float *) cache_malloc(sizeof(float) * n * 3);
      memcpy(array , vert_list.l , sizeof(float) * n * 3);
    } else
      array = NULL;

    return array;
  }

  inline float * copy_scalars(GFAvert_list &vert_list) {
    float *array;
    xp_long n = vert_list.n ;

    if (n > 0) {
      array = (float *) cache_malloc(sizeof(float) * n);
      memcpy(array , vert_list.l , sizeof(float) * n);
    } else
      array = NULL;

    return array;
  }


  inline int * copy_ints(GFAint_list &int_list) {
    int *array;
    xp_long n = int_list.n;

    if (n > 0) {
      array = (int *) cache_malloc(sizeof(int) * n);
      memcpy(array , int_list.l , sizeof(int) * n);
    } else
      array = NULL;

    return array;
  }

  inline xp_long * copy_longs(GFAlong_list &long_list) {
    xp_long *array;
    xp_long n = long_list.n;

    if (n > 0) {
      array = (xp_long *) cache_malloc(sizeof(xp_long) * n);
      memcpy(array , long_list.l , sizeof(xp_long) * n);
    } else
      array = NULL;

    return array;
  }

  inline void * copy_values(GFAvalue_list &valist) {
    void *array;
    xp_long n = valist.n ;

    if (n > 0) {
      array = (void *) cache_malloc(valist.size * n);
      memcpy(array , valist.l , valist.size * n);
    } else
      array = NULL;

    return array;
  }


  xp_long         _ngeoms;
  int            _malloc_flag; // GD_CACHE_FLAG_CACHE  (1) - from cache, 
                               // GD_CACHE_FLAG_MALLOC (3) - normal malloc
  GDcache_header *_cache;
  GDgeom_data    *_data;
};

//
// drawing primitives
//
class GeomSphere : public GFA2GeomConverter {
public:
  GeomSphere(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomPolyLine : public GFA2GeomConverter {
public:
  GeomPolyLine(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};


class GeomDisjointLine : public GFA2GeomConverter {
public:
  GeomDisjointLine(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomTriStrip : public GFA2GeomConverter {
public:
  GeomTriStrip(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomLabel : public GFA2GeomConverter {
public:
  GeomLabel(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomVolume : public GFA2GeomConverter {
public:
  GeomVolume(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomImage : public GFA2GeomConverter {
public:
  GeomImage(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomImageTiled : public GFA2GeomConverter {
public:
  GeomImageTiled(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomPoint : public GFA2GeomConverter {
public:
  GeomPoint(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomPolygon : public GFA2GeomConverter {
public:
  GeomPolygon(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) {};
  int Convert(GFAobj * _obj);
};

class GeomQuad : public GFA2GeomConverter {
public:
  GeomQuad(GDcache_header *cache, int malloc_flag) :GFA2GeomConverter(cache, malloc_flag) { _cell_size = 4;};
  int Convert(GFAobj * _obj);

  int _cell_size;
};

class GeomTriangle : public GeomQuad {
public:
  GeomTriangle(GDcache_header *cache, int malloc_flag) : GeomQuad(cache, malloc_flag) { _cell_size = 3;};
};
#endif
