/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/gfaFileWrite.hxx#1 $
*/
#ifndef _GFA_FILEWRITE_HXX_
#define _GFA_FILEWRITE_HXX_

#include <avs/animator/gfaFile.hxx>

class GFAGeomData;

class GFAFileWrite : public GFAFile {
public:
  GFAFileWrite();
  int OpenFile(char *filename, int format = 1, int mode = 0, int compress = 0) { _format = format;return GFAFile::OpenFile(filename, mode | CREAT  | RDWR | TRUNC, compress);}

  int WriteFileHeader(int nframes, int frameno, int status_max);
  int WriteHeader(GFABlockType type, int nitems) {
    GFAinteger_write (_GFAunixio, type);
    GFAinteger_write (_GFAunixio, nitems);
    return 1;
  }
  int WriteGeometryHeader(int ngeoms) {return WriteHeader(GFA_GEOM_HEADER, ngeoms);}
  int WriteGeometry(int id, int ncaches);
  int WriteCache(GDcache *cache);
  int WriteXformHeader(int nxforms){ return WriteHeader(GFA_XFORM_HEADER, nxforms);}
  int WriteXform(int id, GDxform *xform, GFABlockType type = GFA_XFORM);
  int WritePropsHeader(int nprops) { return WriteHeader(GFA_PROPS_HEADER, nprops);}
  int WriteProps(int id, GDprops *props);
  int WriteModesHeader(int nmodes) { return WriteHeader(GFA_MODES_HEADER, nmodes);}
  int WriteModes(int id, GDmodes *modes);
  int WriteTxtrXformHeader(int ntxtrxforms)  { return WriteHeader(GFA_TXTRXFORM_HEADER, ntxtrxforms);}
  int WriteTxtrXform(int id, GDxform *txtrxform) { return WriteXform(id, txtrxform, GFA_TXTRXFORM);}
  int WriteTxtrHeader(int ntextures) {  return WriteHeader(GFA_TXTR_HEADER, ntextures);}
  int WriteTxtr(int id, GDtexture *texture);
  int WriteCameraHeader(int nCameras) {  return WriteHeader(GFA_CAMERA_HEADER, nCameras);}
  int WriteCamera(GDcamera *cameras);
  int WriteFrameHeader(int nFrames) {  return WriteHeader(GFA_FRAME_HEADER, nFrames);}
  int WriteFrame(GDframe *frame);
  int WriteObject(int obj_id, int geom_id, int xform_id, int props_id, int modes_id,
		  int txtr_id, int txtr_xform_id, GDobject *obj);


private:
  //
  // frame number
  //
  int _frameno;

  //
  // format specifier
  //  
  int _format;
};


//
// GeomData to GFAObj converter classes
//

class Geom2GFAConverter {
public:
  Geom2GFAConverter();
  virtual ~Geom2GFAConverter();

  static Geom2GFAConverter *Convert(GDgeom_data *geom_data);

  // create the geometry type
  virtual int CreateConverter(float *extent, GDgeom_data *geom_data);

  // add another GeomData array element to the GFAObj
  virtual int AddGeomData(GDgeom_data *geom_data) = 0;

  // write GFAobj to file
  void ObjToFile(char *arg, int format, int proto_version);


protected:
  GFAobj * _obj;
};

//
// drawing primitives 
//
class GFASphere : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};

class GFAPolyLine : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};


class GFADisjointLine : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};

class GFATriStrip : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};

class GFALabel : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};

class GFAVolume : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};

class GFAImage : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};

class GFAImageTiled : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};



class GFAPoint : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};


/* now for the dead parrot */
class GFAPolygon : public Geom2GFAConverter {
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
};

class GFAQuad : public Geom2GFAConverter {
public:
  GFAQuad() {_cell_size = 4;};
  int CreateConverter(float *extent, GDgeom_data *geom_data);
  int AddGeomData(GDgeom_data *geom_data);
protected:
  int _cell_size;
};

class GFATriangle : public GFAQuad {
public:
  GFATriangle() {_cell_size = 3;};
  int CreateConverter(float *extent, GDgeom_data *geom_data);
};

#endif
