/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/interp.h#1 $
*/

/* Interpolator header file for the animator subsystem */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef _INTERPOLATOR_H_INCLUDED
#define _INTERPOLATOR_H_INCLUDED
#include  <math.h>

/* min/max macros */
#define  VX_MAX(a,b) ( (a) > (b) ? (a) : (b) )
#define  VX_MIN(a,b) ( (a) < (b) ? (a) : (b) )
#define  VX_MINMAX(a,b,c) VX_MIN(VX_MAX(a,b),c)


class InterpolatorClass {

private:

protected:
    double *m_Values;							// Set of Data for Interpolation Analysis
	double *m_Times;							// Time Values for Interpolator
	unsigned m_N;								// Number of Values
	double m_quat_euler;				        // quaternion or euler rotation interp

public:

    // Interpolation functions

	int  interpolateMatrix(float *keysArr, float *valuesArr, xp_long size, xp_long TotalElements, float loopCount, int quatOrEuler, int interpType, int *reverseDirection, float framesPerSecond, float *interpMatrixArray);
    int  interpolateArray(float *keysArr, double *valuesArr,xp_long numKeys,xp_long totalElements, float loopCount, int interpType, double *interpMatrixArray);
    int  interpolateArray(float *keysArr, float *valuesArr,xp_long numKeys,xp_long totalElements, float loopCount, int interpType, float *interpMatrixArray);
    int  interpolateArray(float *keysArr, int *valuesArr,xp_long numKeys,xp_long totalElements, float loopCount, int interpType, int *interpMatrixArray);
#ifdef WORDLENGTH_64
    int  interpolateArray(float *keysArr, xp_long *valuesArr,xp_long numKeys,xp_long totalElements, float loopCount, int interpType, xp_long *interpMatrixArray);
#endif
    int  interpolateScalar(float *keysArr, double *valuesArr,xp_long numKeys, float loopCount, int interpType, double *result);
    int  interpolateScalar(float *keysArr, float *valuesArr,xp_long numKeys, float loopCount, int interpType, float *result);
    int  interpolateScalar(float *keysArr, int *valuesArr,xp_long numKeys, float loopCount, int interpType, int *result);
#ifdef WORDLENGTH_64
    int  interpolateScalar(float *keysArr, xp_long *valuesArr,xp_long numKeys, float loopCount, int interpType, xp_long *result);
#endif
    int  interpolateString(float *keysArr, OMobj_id valuesId,xp_long numKeys, float loopCount, OMobj_id resultId);

    // Functions used in quat and euler calculations
	void affineMult(double mat1[4][4], double mat2[4][4], double mat3[4][4] );
    void affineMultDouble(double mat1[4][4], double mat2[4][4], double mat3[4][4]);
    void angleScalesToMatrix(double radians[3],double scales[3],double RS_matrix[4][4]);
    void arrayToMatrix( float *array, double matrix [4][4]);
    void buildTransMatrix(double trans_mat[4][4], double radians[3], double scales[3],
			            double translations[3]);
    int  decomposeAffine(double transformation_matrix[4][4],double radians[3],
                        double scales[3],double positions[3]);
    void determinate(double mat0[3][3], double *determinate);
    void doubleMatrixMult(double mat1[3][3], double mat2[3][3], double mat3[3][3]);
	void eulerAnglesToMatrix(double radians[3],double rot_matrix[4][4]);
	void matrixToArray( double matrix [4][4], float *array);
    void matrixToEulerAngles(double rot_matrix[4][4], double radians[3]);
    void matrixToQuat( double mat[4][4], double q[4]);
    int  ptrSet( OMobj_id top_id, void *pointer, char *name);
    void quatDot( double p[4], double q[4], double *dot);
    void quatToMatrix( double q[4], double mat[4][4]);
    void rangeFixer(double *value);
    void reCalcWeight ( float *weight, int interpType );
	void removeScalesTrans(double trans_mat[4][4], double new_mat[4][4],double scales[3]);
	void scalarInterpolation( double *val, int order);
    void slerp( double p[4],double q[4],double t,double qt[4]);



};
/*--------------------------------------------------------------------*/
/*                       Function prototypes                          */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/

#endif /* _INTERPOLATOR_H_INCLUDED */

