/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/avs.h#1 $
*/

/* 
 * This header file defines the data constants needed by AVS modules.
 * Note that the data type specific constants and structures are included 
 * in various header files named for the data types themselves (e.g., field.h).
 */

#ifndef _AVS_H_defined
#define _AVS_H_defined

#include <avs/mem_defs.h>

#ifndef F77
typedef int ((*FNCP)());
typedef int ((*AVS_FNCP)());
#endif /* F77 */

/* types for a module's type field - also used by the AVSset_module_name function */

#define MODULE_DATA     1       /*_F77_s: AMDATA */
#define MODULE_FILTER   2       /*_F77_s: AMFLTR */
#define MODULE_MAPPER   3       /*_F77_s: AMMAPR */
#define MODULE_RENDER   4       /*_F77_s: AMREND */

/* Definitions for the flags field of Port, used in AVSadd_input_port 
   The third argument to AVScreate_input_port indicates whether a connection 
   is required on that port before the module can be fired.
   NOTE: Some of these flags overlap
*/

#define OPTIONAL 0              /*_F77_s: AIOPTL */
#define REQUIRED 1              /*_F77_s: AIREQD - input must be connected */

#define MULTIPLE 2       	/*_F77_s: AIMULT - accept multiple inputs */
#define AUTOFREE 4       	/*_F77_s: AOFREE - automatically free data on this port */
#define INVISIBLE 8	        /*_F77_s: APINVS - port is invisible */
#define CLASSSET  0x10  	/* Internal flag - if a port has a class set */

#define DEFAULTINVISIBLE 0x20   /* Internal flag - default state of vis flag */

#define MODIFY_IN 0x40     	/*_F77_s: AMODIN - module wishes to modify */
				/* 	input port data so be sure it is */
				/*	not in read-only shared memory. */
				/*      This actually allocates storage */
				/*	and copies the data if it is in */
				/* 	read-only shared memory. */
				/*	Use next option to modify in-place. */

#define READ_WRITE_IN 0x100	/*_F77_s: AIRWIN - map shared memory input */
				/*	ports as read/write rather than */
				/* 	read-only.  This is dangerous because */
				/*	other modules with inputs connected */
				/* 	to the same place might be run */
				/*	before or after data is modified. */
				/*	This is most useful when used in */
				/* 	conjunction with		*/
				/*	AVSfield_equiv_to_input. 	*/

/* Flags for parameters */
#define ONE_SHOT 0x80     	/*_F77_s: APONES - valuep should be reset to 0 after exec */

/* Flags for modules (user_flags field) */
/* The module writer sets these with AVSset_module_flags. */

#define COOPERATIVE 2        /* Module can run with others in the executable */
#define REENTRANT   4        /* Module can run with itself in the executable */
#define SERVER_MOD  8	     /* Invisible server module.  e.g. remote */
			     /* directory lister used when file browser is */
			     /* attached to a remote module. */
#define SINGLE_ARG_DATA 16   /* Pass pointers instead of bursting structs */
#define SINGLE_ARG_FIELD 32  /* Pass field ptrs instead of bursting structs */
#define COROUT_UNPACK_ARGS 64 /* Deference strings, reals in corout in-output */
#define UNSAVED_MOD 128      /* Module is not saved during netwrites */

/* Possible events that coroutines can wait for */
#define COROUT_WAIT		1
#define COROUT_EXEC		2

#ifndef F77
/* PARM_CHANGED_EXEC must be 1 for compatibility with avs2 modules otherwise
   the kernel and modules will not agree as to when parameters are being
   transmitted */
#define PARM_CHANGED_EXEC    1      /* Parameter changed since execution     */
#define PARM_CHANGED_INIT    0x200  /* Parameter changed since initialiation */
#define PARM_CHANGED_CHECK   0x400  /* Parameter changed since checkpoint   */
#define PARM_CHANGED_RANGE   0x800  /* Parameter changed range since init   */
#define UI_PARM_SAVE         0x1000 /* Value changed by user or file, so save */
#endif /* F77 */

/* Flags for AVSmodify_parameter bit flag field
   AVSmodify_parameter allows the caller to modify any combination of the
   parameter's value, min value and max value fields. It takes a bit flag
   which is a combination of these three bit values OR'd together */

#define AVS_VALUE       1       /*_F77_s: APVAL - Replace existing parameter value   */
#define AVS_MINVAL      2       /*_F77_s: APMINV - Replace existing parameter minval */
#define AVS_MAXVAL      4       /*_F77_s: APMAXV - Replace existing parameter maxval */
#define AVS_RECORD_VALUE 8      /*_F77_s: APRECV - Record parm change to script */
/* Definitions for AVSmessage 
   AVSmessage requires a code indicating the severity of the message it is
   handling. Lower priority messages (AVS_Debug,AVS_Information) are usually
   directed to stdout, while higher priority messages are usually presented
   in popup dialog boxes requiring user confirmation. */

#define AVS_Information  0     /*_F77_s: AEINFO */
#define AVS_Debug        1     /*_F77_s: AEDEBG */
#define AVS_Warning      2     /*_F77_s: AEWARN */
#define AVS_Error        3     /*_F77_s: AEERR  */
#define AVS_Fatal        4     /*_F77_s: AEFATL */

#ifndef F77
#define AVS_MESSAGE_SEVERITY int
#endif /* F77 */

/* Primitive data types for AVS 
   These are the definitions for primitive data types that the general 
   aggregates like fields and scatters understand as components. */

#define AVS_TYPE_BYTE		0  /*_F77_s: ATBYTE */
#define AVS_TYPE_INTEGER	1  /*_F77_s: ATINT  */
#define AVS_TYPE_REAL		2  /*_F77_s: ATREAL */
#define AVS_TYPE_DOUBLE		3  /*_F77_s: ATDUBL */
#define AVS_TYPE_SHORT		4  /*_F77_s: ATSHRT */

/* This is the magic number to give AVSadd_parameter to indicate that a 
   real or integer value is unbounded. */

#define FLOAT_UNBOUND 11.1	        /*_F77_s: AUNBND */
#define INT_UNBOUND   0x7ffffffa	/*_F77_s: AIUNBD */

/* These are the flag values for the routine AVSset_options */
#define AVS_NEW_FIELD_INFO	1  /*_F77_s: ANFINF */


#ifndef F77
#define AVS_NULL_STR "$NULL"

/* Server acknowledgement leader strings */
#define AVS_SERVER_ACK       "- Server Acknowledge"
#define AVS_SERVER_CMD_OK    "- Server Command Successful" 
#define AVS_SERVER_CMD_FAIL  "- Server Command Failed" 

#ifndef avsargs_h
#include <avs/avsargs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

AVS_EXTERN( int AVSadd_float_parameter, (char *name, double init, double minval, double maxval));
AVS_EXTERN( int AVSadd_parameter, (char *name, char *type, ...));
AVS_EXTERN( int AVSadd_parameter_prop, (int pnum,char *prop_name,char *prop_type,...));
AVS_EXTERN( int AVSautofree_output, (int port_num));
AVS_EXTERN( int AVSchoice_number, (char *name, char *str));
AVS_EXTERN( int AVScommand, (char *destination, char *command_buffer, char **output_buffer, char **error_buffer));
AVS_EXTERN( int AVSconnect_widget, (int pnum, char *name));

/* NOTE: ****************************************************************
   In order to use AVScorout_X_wait you must first include <X11/Xlib.h>
   to define the Display structure type
 ***********************************************************************/
#ifdef _XLIB_H_
   AVS_EXTERN( int AVScorout_X_wait, (Display *dpy, ...));
#else
#ifndef NeedFunctionPrototypes
   extern int AVScorout_X_wait()
#endif
#endif

AVS_EXTERN( int AVScorout_event_wait, (int nfds, ...));
AVS_EXTERN( int AVScorout_exec, (void));
AVS_EXTERN( int AVScorout_init, (int argc, char *argv[], AVS_FNCP desc));

/* NOTE: ******************************************************************
   ANSI-C and C++ do not allow varargs to be used without a typed first
   argument, even though C does. AVScorout_input and _output expect a pointer
   of some type as their first argument. You can either cast the first
   argument as (void *) or predefine AVS_COROUT_INPUT/OUTPUT_ARG1 to the
   type that you will be providing.
***********************************************************************/

#ifdef AVS_COROUT_INPUT_ARG1
   AVS_EXTERN( int AVScorout_input, (AVS_COROUT_INPUT_ARG1, ...));
#else
   AVS_EXTERN( int AVScorout_input, (void *, ...));
#endif

#ifdef AVS_COROUT_OUTPUT_ARG1
   AVS_EXTERN( int AVScorout_output, (AVS_COROUT_OUTPUT_ARG1, ...));
#else
   AVS_EXTERN( int AVScorout_output, (void *, ...));
#endif

AVS_EXTERN( int AVScorout_mark_changed, (void));
AVS_EXTERN( int AVScorout_set_sync, (int value));
AVS_EXTERN( int AVScorout_wait, (void));

AVS_EXTERN( int AVScreate_input_port, (char *name, char *type, int flags));
AVS_EXTERN( int AVScreate_output_port, (char *name, char *type));
AVS_EXTERN( char *AVSdata_alloc, (char *desc, void *init));
AVS_EXTERN( void AVSdata_free, (char *type, char *item));
AVS_EXTERN( int AVSdebug, (char *format, ...));
AVS_EXTERN( int AVSerror, (char *format, ...));
AVS_EXTERN( int AVSfatal, (char *format, ...));

AVS_EXTERN( int AVSget_unique_id, (void));
AVS_EXTERN( int AVSinformation, (char *format, ...));
AVS_EXTERN( int AVSinfo, (char *format, ...));
AVS_EXTERN( int AVSinit_from_module_list, (AVS_FNCP *AVSmodule_list, int count));

AVS_EXTERN( int AVSinitialize_output, (int in_port, int out_port));
AVS_EXTERN( int AVSinput_changed, (char *iname, int inumber));

AVS_EXTERN( int AVSload_byte, (unsigned char *base, int offset));
AVS_EXTERN( int AVSload_user_data_types, (char *filename));

AVS_EXTERN( int AVSmark_output_unchanged, (char *oname));
AVS_EXTERN( char *AVSmessage, (char *version, int severity, void *sender, char *function_name, char *choices, char *message_format, ...));
AVS_EXTERN( int AVSmodify_float_parameter, (char *name, int flags, double init, double minval, double maxval));
AVS_EXTERN( int AVSmodify_parameter, (char *name, int flags, ...));
AVS_EXTERN( int AVSmodify_parameter_prop, (char *parm_name, char *prop_name, char *prop_type, ...));
AVS_EXTERN( int AVSmodule_from_desc, (AVS_FNCP desc));
AVS_EXTERN( int AVSmodule_status, (char *comment, int percent));
AVS_EXTERN( int AVSparameter_changed, (char *pname));
AVS_EXTERN( int AVSparameter_visible, (char *param, int stat));
AVS_EXTERN( int AVSport_field, (char *port_name));
AVS_EXTERN( int AVSset_compute_proc, (AVS_FNCP comp_func));
AVS_EXTERN( int AVSset_destroy_proc, (AVS_FNCP destroy_func));
AVS_EXTERN( int AVSset_init_proc, (AVS_FNCP init_func));
AVS_EXTERN( int AVSset_input_class, (int port, char *myclass));
AVS_EXTERN( int AVSset_module_flags, (int flags));
AVS_EXTERN( int AVSset_module_name, (char *name, int type));
AVS_EXTERN( int AVSset_output_class, (int port, char *myclass));
AVS_EXTERN( int AVSset_output_flags, (int out_port, int flags));
AVS_EXTERN( int AVSset_parameter_class, (int port, char *myclass));
AVS_EXTERN( void AVSstore_byte, (unsigned char *base, int offset, int value));

AVS_EXTERN( int AVSwarning, (char *format, ...));

#ifdef __cplusplus
}
#endif

#endif /* F77 */

#endif /* _AVS_H_defined */
