/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/avs_data.h#1 $
*/
/*		@(#)avs_data.h	8.1 AVS 92/10/11	*/

#ifndef AVS_DATA_H
#define AVS_DATA_H

#ifdef __cplusplus
extern "C" {
#endif

#include <avs/port.h>
/* Add boolean values, trying to avoid multiple declarations */

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

/* A description block used by each defined type. */

typedef char *((*CHAR_FNCP)());

struct AVSdata_desc {
   char *data_name;	    /* the name of the data type */
   char *(*data_create)();  /* build a template using an argc/argv description */
   char *(*data_alloc)();   /* allocate a new instance based on a template */
   void (*data_free)();	    /* free data, if not defined we use free()! */
   int (*data_argsetup)();  /* setup fortran args */
   int (*data_getresult)(); /* re-assemble fortran results */
   int (*data_setparam)();  /* set a parameter */
   int (*data_setbounds)(); /* set a given boundary field ptr */
   int (*data_match)();	    /* match based on templates */
   xp_long (*data_read)();	    /* read this data type */
   xp_long (*data_write)();     /* write this data type */
   int (*data_parse)();	    /* read data type from string buffer */
   int (*data_print)();     /* write data type to file descriptor */
};

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif /* AVS_DATA_H */
