/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/avs_math.h#1 $
*/

#ifndef MATH_HEADER_IS_INCLUDED
#define MATH_HEADER_IS_INCLUDED

/*---------------------------------------------------------------------------
 * Use special fast (perhaps inline) versions of math functions if available.
 *--------------------------------------------------------------------------*/

#include <math.h>

/*---------------------------------------------------------------------------
 * Single precision versions.
 *--------------------------------------------------------------------------*/

#include <avs/port.h>
#if defined(__sgi)

#ifdef __cplusplus
extern "C" {
#endif

/* They have different names on this machine. */

#define ssin(x) 	sinf((x))
#define scos(x)  	cosf((x))
#define stan(x) 	tanf((x))
#define satan(x) 	atanf((x))
#define sacos(x) 	acosf((x))
#define sasin(x) 	asinf((x))
#define sexp(x) 	expf((x))
#define slog(x) 	logf((x))
#define slog10(x) 	log10f((x))
#define ssqrt(x) 	sqrtf((x))
#define satan2(x,y) 	atan2f((x),(y))
#define ssinh(x) 	sinhf((x))
#define scosh(x) 	coshf((x))
#define stanh(x) 	tanhf((x))
#define sfabs(x) 	fabsf((x))
#define spow(x,y) 	powf((x),(y))

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#else

#ifdef __cplusplus
extern "C" {
#endif

/* No single precision versions available. */

#ifndef AVS_SINGLE_PREC_MATH
#define ssin(x) 	sin((x))
#define scos(x)  	cos((x))
#define stan(x) 	tan((x))
#define satan(x) 	atan((x))
#define sacos(x) 	acos((x))
#define sasin(x) 	asin((x))
#define sexp(x) 	exp((x))
#define slog(x) 	log((x))
#define slog10(x) 	log10((x))
#define ssqrt(x) 	sqrt((x))
#define satan2(x,y) 	atan2((x),(y))
#define ssinh(x) 	sinh((x))
#define scosh(x) 	cosh((x))
#define stanh(x) 	tanh((x))
#define sfabs(x) 	fabs((x))
#define spow(x,y) 	pow((x),(y))
#endif /* AVS_SINGLE_PREC_MATH */

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif

#endif /* PORT_HEADER_IS_INCLUDED */
