/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/colormap.h#1 $
*/
/*		@(#)colormap.h	8.2 AVS 92/10/11	*/

#ifndef _COLORMAP_H_defined
#define _COLORMAP_H_defined

#ifdef __cplusplus
extern "C" {
#endif

#ifndef  _BYTE_TABLE_defined

#define  _BYTE_TABLE_defined
/* this is the new, preferred way of defining the length of a byte table */
#define  BYTE_TABLE      256
/* this is the old (vex.h) way kept around for compatability */
#define  DATA_RESOLUTION 256

#endif /*  _BYTE_TABLE_defined */

typedef struct  {
   int size;			/* number of entries in each array */
   float lower;			/* 0th entry maps to this value */
   float upper;			/* size-th entry maps to this value */
   float 	*hue;
   float 	*saturation;
   float 	*value;
   float 	*alpha;
} AVScolormap;

#define AVScmap_index(cmap, val)			\
   ((val) <= (cmap)->lower ? 0 :				\
    ((val) >= (cmap)->upper ? (cmap)->size-1 :		\
     (int) ((((val) - (cmap)->lower) /			\
	     ((cmap)->upper - (cmap)->lower)) * (((cmap)->size)-1))))
   
typedef struct COLOR_MAP {
  float 	hue[DATA_RESOLUTION];
  float 	saturation[DATA_RESOLUTION];
  float 	value[DATA_RESOLUTION];
  float 	alpha[DATA_RESOLUTION];
} COLOR_MAP;

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif /* _COLORMAP_H_defined */
