/*

                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/cstring.h#1 $
*/

/*---------------------------------------------------------------------*
 *
 * cstring.h - composite string header file
 *
 *---------------------------------------------------------------------*/

#ifndef XP_CSTRING_INCLUDED
#define XP_CSTRING_INCLUDED

/*---------------------------------------------------------------------*/

/* This test is to insure that there are no Motif dependencies
   when building `base'.  This is needed because this header file
   declares functions from both tool/cstring.c and wtool/cstring.c.
*/
#ifndef XP_NO_MOTIF
#ifndef MSDOS
#include <Xm/Xm.h>
#endif
#endif

/*---------------------------------------------------------------------*/
/*                         Datatypes                                   */
/*---------------------------------------------------------------------*/

typedef struct _CSsubstr
{
   char      *str;      /* null-terminated substring (ASCII or raw JIS) */
   int       bpc;       /* number of bytes-per-character in str: 1 or 2 */
}  CSsubstr;

typedef struct _CScomstr
{
   int       nsubstr;   /* number of substrings */
   CSsubstr  *substr;   /* array of substrings */
}  CScomstr;

/*---------------------------------------------------------------------*/
/*                          Function prototypes                        */
/*---------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

CScomstr* CSstr_to_com  ( const char * );
char*     CScom_to_str  ( CScomstr * );
char*     CSstr_to_euc  ( const char * );

void      CScom_free    ( CScomstr ** );

#ifndef XP_NO_MOTIF
#ifndef MSDOS
XmString  CSstr_to_Xm   ( const char * );
XmString  CScom_to_Xm   ( CScomstr * );
CScomstr* CSxm_to_com   ( XmString );
char*     CSxm_to_str   ( XmString );
#endif
#endif

#ifdef __cplusplus
}
#endif

/*---------------------------------------------------------------------*/

#endif /* XP_CSTRING_INCLUDED */
